/*
 * Decompiled with CFR 0.152.
 */
package org.das2.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.das2.util.LoggerManager;
import test.components.TearoffTabbedPaneDemo;

public class TearoffTabbedPane
extends JTabbedPane {
    int selectedTab;
    Point dragStart;
    Point dragOffset;
    JFrame draggingFrame;
    JPopupMenu tearOffMenu = new JPopupMenu();
    JPopupMenu dockMenu = new JPopupMenu();
    private TearoffTabbedPane parentPane;
    private TearoffTabbedPane rightPane = null;
    private TearoffTabbedPane dropDirty = null;
    private JFrame rightFrame = null;
    private ComponentListener rightFrameListener;
    private int rightOffset = 0;
    private static final Logger logger = Logger.getLogger("das2.gui");
    private static int TOP_DROP_MARGIN = 200;
    LinkedHashMap<Component, TabDesc> tabs = new LinkedHashMap();
    int lastSelected;
    private boolean dropDecorate;
    private static final Object STICK_RIGHT = "right";

    private static void copyInputMap(JFrame parent, JFrame babySitter) {
        Container c = parent.getContentPane();
        if (!(c instanceof JComponent)) {
            return;
        }
        JComponent parentc = (JComponent)c;
        c = babySitter.getContentPane();
        if (!(c instanceof JComponent)) {
            return;
        }
        JComponent babySitterC = (JComponent)c;
        InputMap m = parentc.getInputMap(2);
        if (m == null) {
            return;
        }
        babySitterC.setInputMap(2, m);
        ActionMap am = parentc.getActionMap();
        if (am == null) {
            return;
        }
        babySitterC.setActionMap(am);
    }

    private void setDropDecorate(boolean b) {
        this.dropDecorate = b;
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.dropDecorate) {
            Graphics2D g2 = (Graphics2D)g;
            int h = g.getFontMetrics().getHeight();
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            Color c = this.getBackground();
            c = new Color(c.getRed(), c.getGreen(), c.getBlue(), 220);
            g2.setColor(c);
            g2.fill(g.getClip());
            g2.setColor(this.getForeground());
            g2.drawString("(dock)", h * 3, h);
        }
    }

    public TearoffTabbedPane() {
        this(null);
    }

    private TearoffTabbedPane(TearoffTabbedPane parent) {
        if (parent == null) {
            ParentMouseAdapter ma = new ParentMouseAdapter();
            this.addMouseListener(ma);
            this.addMouseMotionListener(this.getMouseMotionListener());
        } else {
            this.parentPane = parent;
            this.addMouseListener(this.getChildMouseAdapter());
            this.addMouseMotionListener(this.getChildMouseMotionListener());
        }
        super.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                try {
                    LoggerManager.logGuiEvent(e);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public void hideMouseAdapter() {
        MouseListener[] mls = this.getMouseListeners();
        if (mls.length > 0) {
            MouseListener ml = mls[mls.length - 1];
            this.removeMouseListener(ml);
        }
        MouseMotionListener[] mmls = this.getMouseMotionListeners();
        if (this.getMouseMotionListeners().length > 0) {
            MouseMotionListener ml = mmls[mmls.length - 1];
            this.removeMouseMotionListener(ml);
        }
    }

    private MouseMotionListener getMouseMotionListener() {
        return new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (TearoffTabbedPane.this.selectedTab == -1) {
                    return;
                }
                if (TearoffTabbedPane.this.dragStart == null) {
                    TearoffTabbedPane.this.dragStart = e.getPoint();
                } else if (TearoffTabbedPane.this.dragStart.distance(e.getPoint()) > 10.0) {
                    if (TearoffTabbedPane.this.draggingFrame == null) {
                        TearoffTabbedPane.this.setSelectedIndex(TearoffTabbedPane.this.selectedTab);
                        TearoffTabbedPane.this.getComponentAt(TearoffTabbedPane.this.selectedTab).setVisible(true);
                        TearoffTabbedPane.this.dragOffset = TearoffTabbedPane.this.getComponentAt(TearoffTabbedPane.this.selectedTab).getLocationOnScreen();
                        Point ds = new Point(TearoffTabbedPane.this.dragStart);
                        SwingUtilities.convertPointToScreen(ds, e.getComponent());
                        int tabAndWindowHeight = 40;
                        TearoffTabbedPane.this.dragOffset.translate(-ds.x, -ds.y - tabAndWindowHeight);
                        TearoffTabbedPane.this.draggingFrame = TearoffTabbedPane.this.tearOffIntoFrame(TearoffTabbedPane.this.selectedTab);
                        if (TearoffTabbedPane.this.draggingFrame == null) {
                            return;
                        }
                        TearoffTabbedPane.this.setCursor(new Cursor(13));
                        if (TearoffTabbedPane.this.draggingFrame.getWidth() < -1 * TearoffTabbedPane.this.dragOffset.x) {
                            int borderWidth = 5;
                            TearoffTabbedPane.this.dragOffset.x = -1 * (TearoffTabbedPane.this.draggingFrame.getWidth() - borderWidth);
                        }
                    }
                    Point p = e.getPoint();
                    SwingUtilities.convertPointToScreen(p, (Component)e.getSource());
                    p.translate(TearoffTabbedPane.this.dragOffset.x, TearoffTabbedPane.this.dragOffset.y);
                    TearoffTabbedPane.this.draggingFrame.setLocation(p);
                    TearoffTabbedPane drop = TearoffTabbedPane.this.getHoverTP(e.getComponent(), e.getPoint());
                    if (TearoffTabbedPane.this.dropDirty != null) {
                        TearoffTabbedPane.this.dropDirty.setDropDecorate(false);
                        TearoffTabbedPane.this.dropDirty.repaint();
                    }
                    if (drop != null) {
                        drop.setDropDecorate(true);
                        drop.repaint();
                        TearoffTabbedPane.this.dropDirty = drop;
                    } else {
                        TearoffTabbedPane.this.dropDirty = null;
                    }
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        };
    }

    private void showPopupMenu(MouseEvent event) {
        this.selectedTab = this.indexAtLocation(event.getX(), event.getY());
        if (this.selectedTab != -1) {
            Component selectedComponent = this.getComponentAt(this.selectedTab);
            if (this.parentPane == null && this.tabs.get(selectedComponent) != null) {
                this.tearOffMenu.show(this, event.getX(), event.getY());
            } else {
                this.dockMenu.show(this, event.getX(), event.getY());
            }
        }
    }

    private MouseAdapter getChildMouseAdapter() {
        return new MouseAdapter(){
            Component selectedComponent;
            {
                TearoffTabbedPane.this.dockMenu.add(new JMenuItem(new AbstractAction("return undocked tab"){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        if (TearoffTabbedPane.this.parentPane != null) {
                            selectedComponent = TearoffTabbedPane.this.getComponent(TearoffTabbedPane.this.selectedTab);
                            TearoffTabbedPane.this.remove(selectedComponent);
                            TearoffTabbedPane.this.parentPane.dock(selectedComponent);
                            if (TearoffTabbedPane.this.getTabCount() == 0) {
                                SwingUtilities.getWindowAncestor(TearoffTabbedPane.this).dispose();
                            } else {
                                TearoffTabbedPane.this.resetTearOffBabysitterName();
                            }
                        } else {
                            throw new IllegalArgumentException("parentPane must not be null");
                        }
                    }
                }));
            }

            @Override
            public void mousePressed(MouseEvent event) {
                TearoffTabbedPane.this.selectedTab = TearoffTabbedPane.this.indexAtLocation(event.getX(), event.getY());
                if (event.isPopupTrigger()) {
                    TearoffTabbedPane.this.showPopupMenu(event);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (TearoffTabbedPane.this.draggingFrame != null) {
                    TearoffTabbedPane draggingTearOff = TearoffTabbedPane.this.getTabbedPane(TearoffTabbedPane.this.draggingFrame);
                    if (draggingTearOff != null && TearoffTabbedPane.this.parentPane.contains(SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), TearoffTabbedPane.this.parentPane))) {
                        logger.fine("docking into ...");
                        TearoffTabbedPane.this.parentPane.dock(draggingTearOff.getComponentAt(0));
                        TearoffTabbedPane.this.parentPane.setDropDecorate(false);
                        TearoffTabbedPane.this.draggingFrame.dispose();
                    } else if (draggingTearOff != null) {
                        draggingTearOff.resetTearOffBabysitterName();
                    }
                    TearoffTabbedPane oldChildParent = TearoffTabbedPane.this.getTabbedPane(e.getComponent());
                    if (oldChildParent.getTabCount() == 1) {
                        SwingUtilities.getWindowAncestor(oldChildParent).dispose();
                    }
                }
                if (TearoffTabbedPane.this.dragStart != null && TearoffTabbedPane.this.selectedTab != -1) {
                    TearoffTabbedPane.this.setCursor(null);
                    TearoffTabbedPane.this.draggingFrame = null;
                }
                TearoffTabbedPane.this.dragStart = null;
                if (e.isPopupTrigger()) {
                    TearoffTabbedPane.this.showPopupMenu(e);
                }
            }
        };
    }

    private MouseMotionListener getChildMouseMotionListener() {
        return new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (TearoffTabbedPane.this.selectedTab == -1) {
                    return;
                }
                if (TearoffTabbedPane.this.dragStart == null) {
                    TearoffTabbedPane.this.dragStart = e.getPoint();
                } else if (TearoffTabbedPane.this.dragStart.distance(e.getPoint()) > 10.0) {
                    if (TearoffTabbedPane.this.draggingFrame == null) {
                        TearoffTabbedPane.this.setSelectedIndex(TearoffTabbedPane.this.selectedTab);
                        TearoffTabbedPane.this.getComponentAt(TearoffTabbedPane.this.selectedTab).setVisible(true);
                        TearoffTabbedPane.this.dragOffset = TearoffTabbedPane.this.getComponentAt(TearoffTabbedPane.this.selectedTab).getLocationOnScreen();
                        Point ds = new Point(TearoffTabbedPane.this.dragStart);
                        SwingUtilities.convertPointToScreen(ds, e.getComponent());
                        int tabAndWindowHeight = 40;
                        TearoffTabbedPane.this.dragOffset.translate(-ds.x, -ds.y - tabAndWindowHeight);
                        Component c = TearoffTabbedPane.this.getComponentAt(TearoffTabbedPane.this.selectedTab);
                        TearoffTabbedPane.this.draggingFrame = TearoffTabbedPane.this.tearOffIntoFrame(TearoffTabbedPane.this.selectedTab);
                        TearoffTabbedPane carry = TearoffTabbedPane.this.getTabbedPane(TearoffTabbedPane.this.draggingFrame);
                        carry.resetTearOffBabysitterName();
                        carry.parentPane = TearoffTabbedPane.this.parentPane;
                        TabDesc tabDesc = carry.parentPane.getTabDescByComponent(c);
                        tabDesc.babysitter = carry;
                        if (TearoffTabbedPane.this.draggingFrame == null) {
                            return;
                        }
                        TearoffTabbedPane.this.setCursor(new Cursor(13));
                        if (TearoffTabbedPane.this.draggingFrame.getWidth() < -1 * TearoffTabbedPane.this.dragOffset.x) {
                            int borderWidth = 5;
                            TearoffTabbedPane.this.dragOffset.x = -1 * (TearoffTabbedPane.this.draggingFrame.getWidth() - borderWidth);
                        }
                    }
                    Point p = e.getPoint();
                    SwingUtilities.convertPointToScreen(p, (Component)e.getSource());
                    p.translate(TearoffTabbedPane.this.dragOffset.x, TearoffTabbedPane.this.dragOffset.y);
                    TearoffTabbedPane.this.draggingFrame.setLocation(p);
                    Component drop = null;
                    Point o1 = SwingUtilities.convertPoint(e.getComponent(), e.getPoint(), TearoffTabbedPane.this.parentPane);
                    if (TearoffTabbedPane.this.parentPane.contains(o1) && Math.abs(o1.getY() - (double)TearoffTabbedPane.this.parentPane.getY()) < (double)TOP_DROP_MARGIN) {
                        drop = TearoffTabbedPane.this.parentPane;
                    }
                    if (TearoffTabbedPane.this.dropDirty != null) {
                        TearoffTabbedPane.this.dropDirty.setDropDecorate(false);
                        TearoffTabbedPane.this.dropDirty.repaint();
                    }
                    if (drop != null) {
                        ((TearoffTabbedPane)drop).setDropDecorate(true);
                        drop.repaint();
                        TearoffTabbedPane.this.dropDirty = (TearoffTabbedPane)drop;
                    } else {
                        TearoffTabbedPane.this.dropDirty = null;
                    }
                }
                TearoffTabbedPane.this.resetTearOffBabysitterName();
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        };
    }

    public void peek() {
        System.err.println("--");
        for (Map.Entry<Component, TabDesc> entry : this.tabs.entrySet()) {
            TabDesc d = entry.getValue();
            System.err.println(d);
        }
    }

    private void showIt() {
        TabDesc desc = null;
        Component babyComponent = null;
        for (Map.Entry<Component, TabDesc> entry : this.tabs.entrySet()) {
            TabDesc d = entry.getValue();
            if (d.index != this.selectedTab) continue;
            desc = d;
            babyComponent = entry.getKey();
            break;
        }
        if (desc == null) {
            return;
        }
        if (desc.babysitter instanceof Window) {
            Window babySitter = (Window)desc.babysitter;
            TearoffTabbedPane.raiseApplicationWindow(babySitter);
            this.getTabbedPane(babyComponent).setSelectedComponent(babyComponent);
        } else if (desc.babysitter instanceof TearoffTabbedPane) {
            Window parent = SwingUtilities.getWindowAncestor(babyComponent);
            ((TearoffTabbedPane)desc.babysitter).setSelectedComponent(babyComponent);
            TearoffTabbedPane.raiseApplicationWindow(parent);
        }
    }

    private static void raiseApplicationWindow(Window window) {
        window.setVisible(true);
        if (window instanceof Frame) {
            Frame frame = (Frame)window;
            int state = frame.getExtendedState();
            frame.setExtendedState(state &= 0xFFFFFFFE);
        }
        window.setAlwaysOnTop(true);
        window.toFront();
        window.requestFocus();
        window.setAlwaysOnTop(false);
    }

    private void tearoffIntoTearoffTabbedPane(TearoffTabbedPane target, int selectedTab) {
        if (target != null) {
            TabDesc desc = this.getTabDesc(selectedTab);
            Component selectedComponent = this.getComponentAt(desc.index);
            this.tearOff(selectedTab, target);
            target.add(desc.title, selectedComponent);
            target.setSelectedIndex(target.getTabCount() - 1);
            target.resetTearOffBabysitterName();
            Window w = SwingUtilities.getWindowAncestor(target);
            if (!target.isShowing()) {
                w.setVisible(true);
            }
            TearoffTabbedPane.raiseApplicationWindow(w);
        } else {
            this.tearOffIntoFrame(selectedTab);
        }
    }

    private TabDesc getTabDesc(int tabNumber) {
        for (TabDesc td : this.tabs.values()) {
            if (td.index != tabNumber) continue;
            return td;
        }
        throw new IllegalArgumentException("no tab at index: " + tabNumber);
    }

    private TearoffTabbedPane getHoverTP(Component myFrame, Point myPosition) {
        TearoffTabbedPane last = null;
        TearoffTabbedPane me = this.getTabbedPane(this.draggingFrame);
        for (Map.Entry<Component, TabDesc> entry : this.tabs.entrySet()) {
            TearoffTabbedPane maybe;
            TabDesc d = entry.getValue();
            if (d.babysitter == null || (maybe = this.getTabbedPane(d.babysitter)) == null || maybe == me) continue;
            Point p = SwingUtilities.convertPoint(myFrame, myPosition, maybe);
            if (!maybe.getBounds().contains(p) || !(p.getY() - (double)((Component)maybe).getY() < (double)TOP_DROP_MARGIN)) continue;
            last = maybe;
        }
        return last;
    }

    private TearoffTabbedPane getTabbedPane(Component comp) {
        if (comp instanceof JFrame && ((JFrame)comp).getContentPane().getComponent(0) instanceof TearoffTabbedPane) {
            return (TearoffTabbedPane)((JFrame)comp).getContentPane().getComponent(0);
        }
        if (comp instanceof TearoffTabbedPane) {
            return (TearoffTabbedPane)comp;
        }
        if (comp.getParent() != null && comp.getParent() instanceof TearoffTabbedPane) {
            return (TearoffTabbedPane)comp.getParent();
        }
        return null;
    }

    static Component getTornOffComponent() {
        JPanel tornOffComponent = new JPanel();
        tornOffComponent.setLayout(new BorderLayout());
        tornOffComponent.add((Component)new JLabel("<html><i>This tab is undocked.  Right-click on the tab name and select dock.</i></html>"), "North");
        return tornOffComponent;
    }

    public void tearOff(int tabIndex, Container newContainer) {
        logger.log(Level.FINE, "tearOff({0},{1})", new Object[]{tabIndex, newContainer});
        int lastSelected1 = this.lastSelected;
        Component c = this.getComponentAt(tabIndex);
        String title = super.getTitleAt(tabIndex);
        super.removeTabAt(tabIndex);
        super.insertTab("(" + title + ")", null, TearoffTabbedPane.getTornOffComponent(), null, tabIndex);
        super.setEnabledAt(tabIndex, false);
        TabDesc td = this.tabs.get(c);
        if (td != null) {
            td.babysitter = newContainer;
        }
        if (newContainer instanceof TearoffTabbedPane) {
            TearoffTabbedPane tt = (TearoffTabbedPane)newContainer;
            Window ttp = SwingUtilities.getWindowAncestor(tt);
            int dx = ttp.getWidth() - (tt.getWidth() - 20);
            int dy = ttp.getHeight() - (tt.getHeight() - 40);
            if (tt.getTabCount() == 0) {
                ttp.setSize(c.getPreferredSize().width + dx, c.getPreferredSize().height + dy);
            }
        }
        if (this.parentPane == null) {
            this.setSelectedIndex(lastSelected1);
        }
    }

    public ComponentListener getFrameComponentListener(final Component panel1, final Component frame1, final Component panel2, final Component frame2, final Object direction) {
        return new ComponentListener(){
            Component activeComponent;
            long activeComponentTime = 0L;

            @Override
            public void componentResized(ComponentEvent e) {
                long t = System.currentTimeMillis();
                if (t - this.activeComponentTime > 100L) {
                    this.activeComponent = e.getComponent();
                }
                if (e.getComponent() == this.activeComponent) {
                    this.activeComponentTime = t;
                    TearoffTabbedPane.this.updateAttached(this.activeComponent, panel1, frame1, panel2, frame2, direction, true);
                }
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                long t = System.currentTimeMillis();
                if (t - this.activeComponentTime > 100L) {
                    this.activeComponent = e.getComponent();
                }
                if (e.getComponent() == this.activeComponent) {
                    this.activeComponentTime = t;
                    TearoffTabbedPane.this.updateAttached(this.activeComponent, panel1, frame1, panel2, frame2, direction, false);
                }
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        };
    }

    private void updateAttached(Component active, Component panel1, Component frame1, Component panel2, Component frame2, Object direction, boolean updateSize) {
        Point p = SwingUtilities.convertPoint(panel1, 0, 0, frame1);
        Point p2 = SwingUtilities.convertPoint(panel2, 0, 0, frame2);
        Dimension s1 = panel1.getSize();
        Dimension frameSize1 = frame1.getSize();
        Dimension s2 = panel2.getSize();
        if (direction == STICK_RIGHT) {
            if (active == frame1) {
                int delta = frame2.getWidth() - (int)s2.getWidth();
                if (updateSize) {
                    frame2.setSize(new Dimension(s2.width + delta, s1.height + p2.y));
                }
                frame2.setLocation(frame1.getX() + frame1.getWidth() - p2.x + this.rightOffset, frame1.getY() + p.y - p2.y);
            } else {
                int x = Math.max(frame1.getX(), frame2.getX() - frameSize1.width + p2.x);
                this.rightOffset = frame2.getX() - s1.width - frame1.getX();
                if (this.rightOffset > 0) {
                    this.rightOffset = 0;
                }
                if (this.rightOffset < -1 * s1.width) {
                    x += s1.width + this.rightOffset;
                    this.rightOffset = -1 * s1.width;
                }
                frame1.setLocation(x, frame2.getY() - p.y + p2.y);
            }
        }
    }

    private synchronized TearoffTabbedPane getRightTabbedPane() {
        if (this.rightPane == null) {
            final JFrame parent = (JFrame)SwingUtilities.getWindowAncestor(this);
            this.rightPane = new TearoffTabbedPane(this);
            this.rightPane.setName("rightTearoffTabbedPane");
            this.rightFrame = new JFrame();
            this.rightFrame.add(this.rightPane);
            this.rightFrame.setIconImage(parent.getIconImage());
            this.rightFrame.setTitle(parent.getTitle().toLowerCase());
            final WindowStateListener listener = new WindowStateListener(){

                @Override
                public void windowStateChanged(WindowEvent e) {
                    TearoffTabbedPane.this.rightFrame.setExtendedState(parent.getExtendedState());
                }
            };
            parent.addWindowStateListener(listener);
            this.rightFrame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    parent.removeWindowStateListener(listener);
                    parent.removeComponentListener(TearoffTabbedPane.this.rightFrameListener);
                    if (TearoffTabbedPane.this.rightPane != null) {
                        for (Component c : new ArrayList<Component>(((TearoffTabbedPane)TearoffTabbedPane.this).rightPane.tabs.keySet())) {
                            TearoffTabbedPane.this.dock(c);
                        }
                    }
                    TearoffTabbedPane.this.rightFrame = null;
                    TearoffTabbedPane.this.rightPane = null;
                }
            });
            TearoffTabbedPane.copyInputMap(parent, this.rightFrame);
            this.rightFrameListener = this.getFrameComponentListener(this, parent, this.rightPane, this.rightFrame, STICK_RIGHT);
            parent.addComponentListener(this.rightFrameListener);
            this.rightFrame.addComponentListener(this.rightFrameListener);
            this.rightPane.setPreferredSize(this.getSize());
            this.rightFrame.pack();
            this.updateAttached(parent, this, parent, this.rightPane, this.rightFrame, STICK_RIGHT, true);
            this.rightFrame.setVisible(true);
            parent.toFront();
        }
        return this.rightPane;
    }

    public void slideRight(int tabIndex) {
        Component c = this.getComponentAt(tabIndex);
        logger.log(Level.FINEST, "slideRight {0}", c);
        this.setSelectedIndex(tabIndex);
        c.setVisible(true);
        TabDesc td = this.tabs.get(c);
        if (td == null) {
            return;
        }
        TearoffTabbedPane right = this.getRightTabbedPane();
        this.tearOff(tabIndex, right);
        right.add(td.title, c);
        right.setSelectedIndex(right.getTabCount() - 1);
        if (!right.isShowing()) {
            Window w = SwingUtilities.getWindowAncestor(right);
            w.setVisible(false);
            w.setVisible(true);
        }
    }

    protected JFrame tearOffIntoFrame(int tabIndex) {
        Component c = this.getComponentAt(tabIndex);
        logger.log(Level.FINEST, "tearOffInfoFrame {0}", c);
        this.setSelectedIndex(tabIndex);
        c.setVisible(true);
        Point p = c.getLocationOnScreen();
        TabDesc td = this.tabs.get(c);
        if (td == null) {
            return null;
        }
        final JFrame parent = (JFrame)SwingUtilities.getWindowAncestor(this);
        final JFrame newParent = new JFrame(td.title);
        newParent.setIconImage(parent.getIconImage());
        final WindowStateListener listener = new WindowStateListener(){

            @Override
            public void windowStateChanged(WindowEvent e) {
                newParent.setExtendedState(parent.getExtendedState());
            }
        };
        parent.addWindowStateListener(listener);
        final TearoffTabbedPane pane = new TearoffTabbedPane(this);
        final TearoffTabbedPane dockParent = this.parentPane != null ? this.parentPane : this;
        p.translate(20, 20);
        newParent.setLocation(p);
        newParent.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Component[] cc = pane.getComponents();
                parent.removeWindowStateListener(listener);
                for (Component c : cc) {
                    dockParent.dock(c);
                }
            }
        });
        TearoffTabbedPane.copyInputMap(parent, newParent);
        newParent.getContentPane().add(pane);
        this.tearOff(tabIndex, pane);
        td.babysitter = pane;
        pane.add(td.title, c);
        pane.setName(td.title);
        newParent.pack();
        newParent.setVisible(true);
        return newParent;
    }

    private void resetTearOffBabysitterName() {
        Window wparent = SwingUtilities.getWindowAncestor(this);
        if (wparent == null) {
            return;
        }
        if (!(wparent instanceof JFrame)) {
            throw new RuntimeException("internal error, parent was not instance of JFrame");
        }
        JFrame parent = (JFrame)wparent;
        if (this.parentPane == null) {
            throw new IllegalStateException("name should not be set for parent, only babysitters");
        }
        Container p = parent.getContentPane();
        Component tp = p.getComponent(0);
        if (tp instanceof TearoffTabbedPane) {
            TearoffTabbedPane tt = (TearoffTabbedPane)tp;
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < tt.getTabCount(); ++i) {
                try {
                    TabDesc td = tt.getTabDesc(i);
                    b.append(",").append(td.title);
                    continue;
                }
                catch (IllegalArgumentException ex) {
                    System.err.println("invalid");
                }
            }
            if (b.length() > 0) {
                parent.setTitle(b.toString().substring(1));
                parent.setName(b.toString().substring(1).replaceAll(",", "_"));
                tp.setName(b.toString().substring(1).replaceAll(",", "_"));
            }
        }
    }

    public void dock(Component c) {
        logger.log(Level.FINEST, "dock {0}", c);
        int selectedIndex = this.getSelectedIndex();
        TabDesc td = this.tabs.get(c);
        if (td == null) {
            logger.log(Level.WARNING, "I thought this might happen.  td==null in dock...");
            return;
        }
        int index = td.index;
        if (index >= super.getTabCount()) {
            System.err.println("something has gone wrong.  We haven't accounted for a tab which was removed.");
        } else {
            super.removeTabAt(index);
        }
        super.insertTab(td.title, td.icon, c, td.tip, index);
        super.setEnabledAt(index, true);
        Container babysitter = td.babysitter;
        td.babysitter = null;
        if (babysitter != null) {
            if (babysitter instanceof TearoffTabbedPane) {
                TearoffTabbedPane tbabysitter = (TearoffTabbedPane)babysitter;
                if (tbabysitter.getTabCount() == 0) {
                    Window w = SwingUtilities.getWindowAncestor(tbabysitter);
                    if (w.getComponentCount() == 1) {
                        w.dispose();
                    } else {
                        tbabysitter.resetTearOffBabysitterName();
                    }
                }
            } else {
                babysitter.setVisible(false);
            }
        }
        if (this.parentPane != null) {
            this.resetTearOffBabysitterName();
        }
        TearoffTabbedPane.raiseApplicationWindow(SwingUtilities.getWindowAncestor(this));
        this.setSelectedIndex(selectedIndex);
    }

    @Override
    public void addTab(String title, Icon icon, Component component) {
        super.addTab(title, icon, component);
        TabDesc td = new TabDesc(title, icon, null, this.indexOfComponent(component));
        this.tabs.put(component, td);
    }

    @Override
    public void addTab(String title, Component component) {
        super.addTab(title, component);
        TabDesc td = new TabDesc(title, null, null, this.indexOfComponent(component));
        this.tabs.put(component, td);
    }

    @Override
    public void insertTab(String title, Icon icon, Component component, String tip, int index) {
        super.insertTab(title, icon, component, tip, index);
        TabDesc td = new TabDesc(title, icon, tip, index);
        this.tabs.put(component, td);
    }

    @Override
    public void addTab(String title, Icon icon, Component component, String tip) {
        super.addTab(title, icon, component, tip);
        TabDesc td = new TabDesc(title, icon, tip, this.indexOfComponent(component));
        this.tabs.put(component, td);
    }

    @Override
    public void remove(Component c) {
        logger.log(Level.FINE, "remove({0})", c);
        TabDesc desc = this.tabs.get(c);
        if (desc == null) {
            throw new IllegalArgumentException("Component does not appear to be associated with this TearoffTabbedPane");
        }
        if (desc.babysitter != null) {
            this.dock(c);
        }
        super.remove(c);
    }

    private Component getTabComponentByIndex(int index) {
        for (Map.Entry<Component, TabDesc> entry : this.tabs.entrySet()) {
            TabDesc td = entry.getValue();
            if (td.index != index) continue;
            return entry.getKey();
        }
        return null;
    }

    private TabDesc getTabDescByComponent(Component c) {
        return this.tabs.get(c);
    }

    @Override
    public void removeTabAt(int index) {
        this.removeTabAt(index, true);
    }

    private void removeTabAt(int index, boolean dock) {
        TabDesc tab;
        logger.log(Level.FINE, "removeTabAt({0})", index);
        Component c = this.getTabComponentByIndex(index);
        if (c == null) {
            System.err.println("no tab at index: " + index);
        }
        if ((tab = this.tabs.get(c)) != null) {
            if (dock && tab.babysitter != null) {
                this.dock(c);
            }
            this.tabs.remove(c);
        } else {
            logger.fine("tabs didn't contain c, someone else removed it.");
        }
        for (TabDesc t : this.tabs.values()) {
            if (t.index < index) continue;
            --t.index;
        }
        super.removeTabAt(index);
    }

    @Override
    public void setSelectedIndex(int index) {
        logger.log(Level.FINER, "setSelectedIndex({0})", index);
        if (index != this.getSelectedIndex()) {
            this.lastSelected = this.getSelectedIndex();
        }
        super.setSelectedIndex(index);
    }

    public void setSelectedTab(String title) {
        int sel = -1;
        for (int i = 0; i < this.getTabCount(); ++i) {
            if (!this.getTitleAt(i).equals(title)) continue;
            sel = i;
        }
        if (sel > -1) {
            this.setSelectedIndex(sel);
        }
    }

    public static void main(String[] args) {
        TearoffTabbedPaneDemo.main(args);
    }

    private class ParentMouseAdapter
    extends MouseAdapter {
        private ParentMouseAdapter() {
            TearoffTabbedPane.this.tearOffMenu.add(new JMenuItem(new AbstractAction("undock"){

                @Override
                public void actionPerformed(ActionEvent event) {
                    TearoffTabbedPane.this.tearOffIntoFrame(TearoffTabbedPane.this.selectedTab);
                }
            }));
            TearoffTabbedPane.this.tearOffMenu.add(new JMenuItem(new AbstractAction("slide right"){

                @Override
                public void actionPerformed(ActionEvent event) {
                    TearoffTabbedPane.this.slideRight(TearoffTabbedPane.this.selectedTab);
                }
            }));
            TearoffTabbedPane.this.dockMenu.add(new JMenuItem(new AbstractAction("show"){

                @Override
                public void actionPerformed(ActionEvent event) {
                    TearoffTabbedPane.this.showIt();
                }
            }));
            TearoffTabbedPane.this.dockMenu.add(new JMenuItem(new AbstractAction("dock"){

                @Override
                public void actionPerformed(ActionEvent event) {
                    TabDesc desc = null;
                    Component babyComponent = null;
                    for (Component key : TearoffTabbedPane.this.tabs.keySet()) {
                        TabDesc d = TearoffTabbedPane.this.tabs.get(key);
                        if (d.index != TearoffTabbedPane.this.selectedTab) continue;
                        desc = d;
                        babyComponent = key;
                        break;
                    }
                    TearoffTabbedPane babySitterToUpdate = null;
                    if (desc == null) {
                        return;
                    }
                    if (desc.babysitter instanceof Window) {
                        ((Window)desc.babysitter).dispose();
                    } else if (desc.babysitter instanceof TearoffTabbedPane) {
                        TearoffTabbedPane bb = (TearoffTabbedPane)desc.babysitter;
                        if (bb.getTabCount() == 1) {
                            SwingUtilities.getWindowAncestor(bb).dispose();
                        } else {
                            babySitterToUpdate = bb;
                        }
                    }
                    TearoffTabbedPane.this.dock(babyComponent);
                    if (babySitterToUpdate != null) {
                        babySitterToUpdate.resetTearOffBabysitterName();
                    }
                }
            }));
        }

        @Override
        public void mousePressed(MouseEvent event) {
            TearoffTabbedPane.this.selectedTab = TearoffTabbedPane.this.indexAtLocation(event.getX(), event.getY());
            if (event.isPopupTrigger()) {
                TearoffTabbedPane.this.showPopupMenu(event);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                TearoffTabbedPane.this.showIt();
                e.consume();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (TearoffTabbedPane.this.dragStart != null && TearoffTabbedPane.this.selectedTab != -1) {
                TearoffTabbedPane babyComponent;
                TearoffTabbedPane.this.setCursor(null);
                TearoffTabbedPane last = null;
                if (TearoffTabbedPane.this.draggingFrame != null) {
                    last = TearoffTabbedPane.this.getHoverTP(e.getComponent(), e.getPoint());
                }
                if (last != null && last != (babyComponent = TearoffTabbedPane.this.getTabbedPane(TearoffTabbedPane.this.draggingFrame)) && babyComponent.getTabCount() == 1) {
                    int i = TearoffTabbedPane.this.getSelectedIndex();
                    if (i > -1) {
                        TearoffTabbedPane.this.lastSelected = i;
                    }
                    TearoffTabbedPane.this.dock(babyComponent.getComponentAt(0));
                    if (i > -1) {
                        TearoffTabbedPane.this.setSelectedIndex(i);
                    }
                    TearoffTabbedPane.this.tearoffIntoTearoffTabbedPane(last, TearoffTabbedPane.this.selectedTab);
                    TearoffTabbedPane.this.draggingFrame.dispose();
                }
                if (TearoffTabbedPane.this.dropDirty != null) {
                    TearoffTabbedPane.this.dropDirty.setDropDecorate(false);
                    TearoffTabbedPane.this.dropDirty.repaint();
                }
                TearoffTabbedPane.this.draggingFrame = null;
            }
            TearoffTabbedPane.this.dragStart = null;
            if (e.isPopupTrigger()) {
                TearoffTabbedPane.this.showPopupMenu(e);
            }
        }
    }

    private static class TabDesc {
        Icon icon;
        String title;
        String tip;
        int index;
        Container babysitter;

        TabDesc(String title, Icon icon, String tip, int index) {
            this.title = title;
            this.icon = icon;
            this.tip = tip;
            this.index = index;
            this.babysitter = null;
        }

        public String toString() {
            if (this.babysitter == null) {
                return this.title + "@" + this.index + ": (docked)";
            }
            return this.title + "@" + this.index + ": " + this.babysitter.getName();
        }
    }
}

