/*
 * Decompiled with CFR 0.152.
 */
package org.das2.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.das2.components.SliceSettings;
import org.das2.components.propertyeditor.PropertyEditor;
import org.das2.dataset.TableDataSetConsumer;
import org.das2.datum.Datum;
import org.das2.datum.InconvertibleUnitsException;
import org.das2.datum.TimeLocationUnits;
import org.das2.datum.format.DatumFormatter;
import org.das2.datum.format.TimeDatumFormatter;
import org.das2.event.DataPointSelectionEvent;
import org.das2.event.DataPointSelectionListener;
import org.das2.event.MouseModule;
import org.das2.event.PointSlopeDragRenderer;
import org.das2.graph.DasAxis;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasColumn;
import org.das2.graph.DasPlot;
import org.das2.graph.DasRow;
import org.das2.graph.Painter;
import org.das2.graph.Renderer;
import org.das2.graph.SpectrogramRenderer;
import org.das2.graph.SymbolLineRenderer;
import org.das2.qds.DDataSet;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.IDataSet;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.util.DataSetBuilder;
import org.das2.system.DasLogger;

public class HorizontalSpectrogramSlicer
implements DataPointSelectionListener {
    private JDialog popupWindow;
    private final DasPlot parentPlot;
    private DasPlot myPlot;
    private final DasAxis sourceZAxis;
    private final DasAxis sourceXAxis;
    protected Datum xValue;
    protected Datum yValue;
    protected Datum ySlice;
    JPanel buttonPanel;
    List<Action> additionalActions = new ArrayList<Action>();
    private SymbolLineRenderer renderer;
    private Color markColor = new Color(230, 230, 230);

    private HorizontalSpectrogramSlicer(DasPlot parent, DasAxis sourceXAxis, DasAxis sourceZAxis) {
        this.sourceZAxis = sourceZAxis;
        this.sourceXAxis = sourceXAxis;
        this.parentPlot = parent;
    }

    private void initPlot(DasCanvas canvas) {
        DasAxis xAxis = this.sourceXAxis.createAttachedAxis(2);
        DasAxis yAxis = this.sourceZAxis.createAttachedAxis(3);
        this.myPlot = new DasPlot(xAxis, yAxis);
        this.renderer = new SymbolLineRenderer();
        this.renderer.setAntiAliased(true);
        this.myPlot.addRenderer(this.renderer);
        canvas.addTopDecorator(new Painter(){

            @Override
            public void paint(Graphics2D g) {
                int ix = (int)HorizontalSpectrogramSlicer.this.myPlot.getXAxis().transform(HorizontalSpectrogramSlicer.this.xValue);
                DasRow row = HorizontalSpectrogramSlicer.this.myPlot.getRow();
                int iy0 = row.getDMinimum();
                int iy1 = row.getDMaximum();
                g.drawLine(ix + 3, iy0, ix, iy0 + 3);
                g.drawLine(ix - 3, iy0, ix, iy0 + 3);
                g.drawLine(ix + 3, iy1, ix, iy1 - 3);
                g.drawLine(ix - 3, iy1, ix, iy1 - 3);
                g.setColor(HorizontalSpectrogramSlicer.this.markColor);
                g.drawLine(ix, iy0 + 4, ix, iy1 - 4);
            }
        });
        this.myPlot.getDasMouseInputAdapter().addMouseModule(new MouseModule(this.myPlot, new PointSlopeDragRenderer(this.myPlot, this.myPlot.getXAxis(), this.myPlot.getYAxis()), "Slope"));
    }

    public void addAction(Action a) {
        this.additionalActions.add(a);
        if (this.buttonPanel != null) {
            JButton b = new JButton(a);
            this.buttonPanel.add((Component)b, 0);
        }
    }

    protected void setDataSet(QDataSet ds) {
        this.renderer.setDataSet(ds);
    }

    public QDataSet getDataSet() {
        return this.renderer.getDataSet();
    }

    public Datum getSliceY() {
        return this.ySlice;
    }

    public static HorizontalSpectrogramSlicer createSlicer(DasPlot plot, TableDataSetConsumer dataSetConsumer) {
        DasAxis sourceXAxis = plot.getXAxis();
        DasAxis sourceZAxis = dataSetConsumer.getZAxis();
        return new HorizontalSpectrogramSlicer(plot, sourceXAxis, sourceZAxis);
    }

    public void showPopup() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.showPopupImpl();
        } else {
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    HorizontalSpectrogramSlicer.this.showPopupImpl();
                }
            };
            SwingUtilities.invokeLater(r);
        }
    }

    private void showPopupImpl() {
        if (this.popupWindow == null) {
            this.createPopup();
        }
        this.popupWindow.setVisible(true);
    }

    public void dispose() {
        if (this.popupWindow != null) {
            this.popupWindow.setVisible(false);
            this.popupWindow.dispose();
        }
    }

    public void clear(QDataSet tds) {
        if (this.renderer != null) {
            if (tds == null) {
                this.renderer.setDataSet(null);
            } else {
                try {
                    if (this.isPopupVisible()) {
                        this.showSlice(tds, this.xValue, this.yValue);
                    }
                }
                catch (InconvertibleUnitsException ex) {
                    this.renderer.setDataSet(null);
                }
            }
        }
    }

    private void createPopup() {
        int width = this.parentPlot.getCanvas().getWidth() / 2;
        int height = this.parentPlot.getCanvas().getHeight() / 2;
        final DasCanvas canvas = new DasCanvas(width, height);
        if (this.myPlot == null) {
            this.initPlot(canvas);
        }
        DasRow row = new DasRow(canvas, null, 0.0, 1.0, 3.0, -5.0, 0, 0);
        DasColumn column = new DasColumn(canvas, null, 0.0, 1.0, 7.0, -3.0, 0, 0);
        canvas.add(this.myPlot, row, column);
        JPanel content = new JPanel(new BorderLayout());
        this.buttonPanel = new JPanel();
        BoxLayout buttonLayout = new BoxLayout(this.buttonPanel, 0);
        this.buttonPanel.setLayout(buttonLayout);
        if (this.additionalActions != null && this.additionalActions.size() > 0) {
            for (Action a : this.additionalActions) {
                this.buttonPanel.add(new JButton(a));
            }
        }
        this.buttonPanel.add(Box.createHorizontalGlue());
        JButton printButton = new JButton(new AbstractAction("Print..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                canvas.makeCurrent();
                DasCanvas.PRINT_ACTION.actionPerformed(e);
            }
        });
        this.buttonPanel.add(printButton);
        JButton settingsButton = new JButton(new AbstractAction("Settings..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpectrogramRenderer rend = null;
                for (Renderer r : HorizontalSpectrogramSlicer.this.parentPlot.getRenderers()) {
                    if (!(r instanceof SpectrogramRenderer)) continue;
                    rend = (SpectrogramRenderer)r;
                    break;
                }
                if (rend == null) {
                    JOptionPane.showMessageDialog(null, "Unable to find associated Spectrogram");
                    return;
                }
                SliceSettings settings = new SliceSettings();
                settings.setSliceRebinnedData(rend.isSliceRebinnedData());
                new PropertyEditor(settings).showModalDialog(canvas);
                rend.setSliceRebinnedData(settings.isSliceRebinnedData());
                QDataSet ds = rend.getConsumedDataSet();
                HorizontalSpectrogramSlicer.this.showSlice(ds, HorizontalSpectrogramSlicer.this.xValue, HorizontalSpectrogramSlicer.this.yValue);
            }
        });
        this.buttonPanel.add(settingsButton);
        JButton close = new JButton("Close");
        close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HorizontalSpectrogramSlicer.this.popupWindow.setVisible(false);
            }
        });
        this.buttonPanel.add(close);
        content.add((Component)canvas, "Center");
        content.add((Component)this.buttonPanel, "South");
        Window parentWindow = SwingUtilities.getWindowAncestor(this.parentPlot);
        this.popupWindow = new JDialog(parentWindow);
        this.popupWindow.setTitle("Horizontal Slicer");
        this.popupWindow.setDefaultCloseOperation(2);
        this.popupWindow.setContentPane(content);
        this.popupWindow.pack();
        Point parentLocation = new Point(0, this.parentPlot.getY());
        parentLocation.translate(this.parentPlot.getX() / 20, -1 * this.myPlot.getRow().getDMinimum());
        SwingUtilities.convertPointToScreen(parentLocation, this.parentPlot.getCanvas());
        int xx = parentLocation.x + this.parentPlot.getCanvas().getWidth();
        int yy = parentLocation.y;
        GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        int totalwidth = gd.getDisplayMode().getWidth();
        int totalheight = gd.getDisplayMode().getHeight();
        if (xx > totalwidth - 100) {
            xx = totalwidth - 100;
        }
        if (yy > totalheight - 100) {
            yy = totalheight - 100;
        }
        this.popupWindow.setLocation(xx, yy);
    }

    protected boolean isPopupVisible() {
        return this.popupWindow != null && this.popupWindow.isVisible() && this.myPlot.getCanvas() != null;
    }

    @Override
    public void dataPointSelected(DataPointSelectionEvent e) {
        this.yValue = e.getY();
        this.xValue = e.getX();
        QDataSet ds = e.getDataSet();
        if (ds == null || !SemanticOps.isTableDataSet(ds)) {
            return;
        }
        QDataSet tds = ds;
        this.showSlice(tds, this.xValue, this.yValue);
    }

    private boolean showSlice(QDataSet tds, Datum xValue, Datum yValue) {
        MutablePropertyDataSet sliceDataSet;
        Datum yy;
        QDataSet tds1 = null;
        if (tds.rank() == 3) {
            for (int i = 0; i < tds.length(); ++i) {
                QDataSet bounds = DataSetOps.dependBounds(tds.slice(i));
                if (!DataSetOps.boundsContains(bounds, xValue, yValue)) continue;
                tds1 = tds.slice(i);
                break;
            }
        } else {
            QDataSet bounds = DataSetOps.dependBounds(tds);
            if (DataSetOps.boundsContains(bounds, xValue, yValue)) {
                tds1 = tds;
            }
        }
        if (tds1 == null) {
            return false;
        }
        QDataSet yds = SemanticOps.ytagsDataSet(tds1);
        if (yds.rank() == 2) {
            QDataSet xds = SemanticOps.xtagsDataSet(tds1);
            int ix = DataSetUtil.closestIndex(xds, xValue);
            QDataSet yds1 = yds.slice(ix);
            int iy = DataSetUtil.closestIndex(yds1, yValue);
            yy = DataSetUtil.asDatum(yds.slice(ix).slice(iy));
            IDataSet eqdep1 = IDataSet.createRank1(yds.length());
            eqdep1.putValue(ix, 1.0);
            DataSetBuilder bz = new DataSetBuilder(1, yds.length());
            bz.putProperty("UNITS", tds1.property("UNITS"));
            DataSetBuilder bx = new DataSetBuilder(1, yds.length());
            int lastIndex = iy;
            for (int i = 0; i < yds.length(); ++i) {
                if (yds.value(i, lastIndex) == yy.value()) {
                    bz.putValue(-1, tds1.value(i, lastIndex));
                    bx.putValue(-1, xds.value(i));
                    bx.nextRecord();
                    bz.nextRecord();
                    continue;
                }
                try {
                    int j = DataSetUtil.closestIndex(yds.slice(i), yValue);
                    if (yds.value(i, j) != yy.value()) continue;
                    lastIndex = j;
                    bz.putValue(-1, tds1.value(i, lastIndex));
                    bx.putValue(-1, xds.value(i));
                    bx.nextRecord();
                    bz.nextRecord();
                    continue;
                }
                catch (IllegalArgumentException j) {
                    // empty catch block
                }
            }
            DDataSet s1 = bz.getDataSet();
            DDataSet sx = bx.getDataSet();
            sx.putProperty("UNITS", xds.property("UNITS"));
            s1.putProperty("DEPEND_0", sx);
            sliceDataSet = s1;
        } else {
            int iy = DataSetUtil.closestIndex(yds, yValue);
            yy = DataSetUtil.asDatum(yds.slice(iy));
            sliceDataSet = DataSetOps.slice1(tds1, iy);
        }
        DasLogger.getLogger(DasLogger.GUI_LOG).finest("setDataSet sliceDataSet");
        if (!this.isPopupVisible()) {
            this.showPopup();
        }
        this.renderer.setDataSet(sliceDataSet);
        DatumFormatter formatter = xValue.getUnits() instanceof TimeLocationUnits ? TimeDatumFormatter.DEFAULT : xValue.getFormatter();
        DatumFormatter yformatter = yy.getFormatter();
        String title = this.parentPlot.getTitle().trim();
        if (title.length() > 0) {
            title = title + "!c";
        }
        this.myPlot.setTitle(title + "x: " + formatter.format(xValue) + " y: " + yformatter.format(yy));
        this.ySlice = yy;
        if (!this.myPlot.getXAxis().getLabel().equals(this.sourceXAxis.getLabel())) {
            this.myPlot.getXAxis().setLabel(this.sourceXAxis.getLabel());
        }
        if (!this.myPlot.getYAxis().getLabel().equals(this.sourceZAxis.getLabel())) {
            this.myPlot.getYAxis().setLabel(this.sourceZAxis.getLabel());
        }
        return true;
    }

    public Color getMarkColor() {
        return this.markColor;
    }

    public void setMarkColor(Color markColor) {
        this.markColor = markColor;
    }
}

