/*
 * Decompiled with CFR 0.152.
 */
package org.das2.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import org.das2.DasApplication;
import org.das2.components.DasProgressPanel;
import org.das2.components.propertyeditor.PropertyEditor;
import org.das2.dataset.DataSetUpdateEvent;
import org.das2.dataset.DataSetUpdateListener;
import org.das2.dataset.VectorDataSet;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumUtil;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.InconvertibleUnitsException;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.datum.format.DatumFormatter;
import org.das2.event.DataPointSelectionEvent;
import org.das2.event.DataPointSelectionListener;
import org.das2.qds.AbstractDataSet;
import org.das2.qds.DDataSet;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.SparseDataSet;
import org.das2.qds.SparseDataSetBuilder;
import org.das2.qds.ops.Ops;
import org.das2.qds.util.DataSetBuilder;
import org.das2.system.DasLogger;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;

public class DataPointRecorderNew
extends JPanel {
    private static final int TIME_WIDTH = 180;
    protected JTable table;
    protected JScrollPane scrollPane;
    protected JButton updateButton;
    protected final transient List<QDataSet> dataPoints;
    private int selectRow;
    protected transient Units[] unitsArray;
    protected transient Units[] defaultUnitsArray;
    protected transient String[] namesArray;
    protected transient String[] defaultNamesArray;
    private double[] defaultsArray;
    private transient QDataSet bundleDescriptor;
    protected AbstractTableModel myTableModel;
    private File saveFile;
    private boolean modified;
    private final JLabel messageLabel;
    private boolean active = true;
    private transient Preferences prefs = Preferences.userNodeForPackage(this.getClass());
    private static final Logger logger = DasLogger.getLogger(DasLogger.GUI_LOG);
    private final JButton clearSelectionButton;
    private final Object namesArrayLock;
    private transient Comparator comparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            if (o1 instanceof QDataSet && o2 instanceof QDataSet) {
                QDataSet qds1 = (QDataSet)o1;
                QDataSet qds2 = (QDataSet)o2;
                return DataSetUtil.asDatum(qds1.slice(0)).gt(DataSetUtil.asDatum(qds2.slice(0))) ? 1 : -1;
            }
            throw new IllegalArgumentException("expected qdatasets");
        }
    };
    private EventListenerList listenerList1 = new EventListenerList();
    private EventListenerList selectedListenerList = new EventListenerList();
    private boolean sorted = true;
    private Datum xTagWidth = Datum.create(0);
    private boolean snapToGrid = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteInterval(DatumRange range) {
        if (!this.sorted) {
            throw new IllegalArgumentException("data must be sorted");
        }
        List<QDataSet> list = this.dataPoints;
        synchronized (list) {
            int index2;
            Comparator comp = new Comparator(){

                public int compare(Object o1, Object o2) {
                    Datum d2;
                    Datum d1;
                    if (o1 instanceof QDataSet) {
                        d1 = DataSetUtil.asDatum(((QDataSet)o1).slice(0));
                    } else if (o1 instanceof Datum) {
                        d1 = (Datum)o1;
                    } else {
                        throw new IllegalArgumentException("expected Datum or QDataSet");
                    }
                    if (o2 instanceof QDataSet) {
                        d2 = DataSetUtil.asDatum(((QDataSet)o2).slice(0));
                    } else if (o2 instanceof Datum) {
                        d2 = (Datum)o2;
                    } else {
                        throw new IllegalArgumentException("expected Datum or QDataSet");
                    }
                    return d1.compareTo(d2);
                }
            };
            int index1 = Collections.binarySearch(this.dataPoints, range.min(), comp);
            if (index1 < 0) {
                index1 ^= 0xFFFFFFFF;
            }
            if ((index2 = Collections.binarySearch(this.dataPoints, range.max(), comp)) < 0) {
                index2 ^= 0xFFFFFFFF;
            }
            if (index1 == index2) {
                return;
            }
            int[] arr = new int[index2 - index1];
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = index1 + i;
            }
            this.deleteRows(arr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRow(int row) {
        List<QDataSet> list = this.dataPoints;
        synchronized (list) {
            this.dataPoints.remove(row);
            this.modified = true;
            this.updateClients();
            this.updateStatus();
        }
        if (this.active) {
            this.fireDataSetUpdateListenerDataSetUpdated(new DataSetUpdateEvent((Object)this, this.getDataSet()));
        }
        this.myTableModel.fireTableDataChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRows(int[] selectedRows) {
        List<QDataSet> list = this.dataPoints;
        synchronized (list) {
            for (int i = selectedRows.length - 1; i >= 0; --i) {
                this.dataPoints.remove(selectedRows[i]);
            }
            this.modified = true;
        }
        this.updateClients();
        this.updateStatus();
        if (this.active) {
            this.fireDataSetUpdateListenerDataSetUpdated(new DataSetUpdateEvent((Object)this, this.getDataSet()));
        }
        this.myTableModel.fireTableDataChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QDataSet getDataSet() {
        DataSetBuilder b;
        List<QDataSet> list = this.dataPoints;
        synchronized (list) {
            if (this.dataPoints.isEmpty()) {
                return null;
            }
            b = new DataSetBuilder(2, this.dataPoints.size(), this.bundleDescriptor.length());
            b.putProperty("BUNDLE_1", this.bundleDescriptor);
            for (int irow = 0; irow < this.dataPoints.size(); ++irow) {
                QDataSet dp = this.dataPoints.get(irow);
                b.putValues(-1, dp, dp.length());
                b.nextRecord();
            }
        }
        return b.getDataSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QDataSet getSelectedDataSet() {
        QDataSet lbundleDescriptor;
        ArrayList<QDataSet> ldataPoints;
        int[] selectedRows;
        DataPointRecorderNew dataPointRecorderNew = this;
        synchronized (dataPointRecorderNew) {
            selectedRows = this.getSelectedRowsInModel();
            ldataPoints = new ArrayList<QDataSet>(this.dataPoints);
            lbundleDescriptor = this.bundleDescriptor;
        }
        if (selectedRows.length == 0) {
            return null;
        }
        DataSetBuilder b = new DataSetBuilder(2, selectedRows.length, lbundleDescriptor.length());
        b.putProperty("BUNDLE_1", lbundleDescriptor);
        for (int i = 0; i < selectedRows.length; ++i) {
            int irow = selectedRows[i];
            if (irow >= ldataPoints.size()) continue;
            QDataSet dp = (QDataSet)ldataPoints.get(irow);
            b.putValues(-1, dp, dp.length());
            b.nextRecord();
        }
        return b.getDataSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void select(DatumRange xrange, DatumRange yrange) {
        Datum mid = xrange.rescale(0.5, 0.5).min();
        List<QDataSet> list = this.dataPoints;
        synchronized (list) {
            int i;
            List<Object> selectMe = new ArrayList();
            int iclosest = -1;
            Datum closestDist = null;
            for (i = 0; i < this.dataPoints.size(); ++i) {
                QDataSet p = this.dataPoints.get(i);
                if (xrange.contains(DataSetUtil.asDatum(p.slice(0))) && yrange.contains(DataSetUtil.asDatum(p.slice(1)))) {
                    selectMe.add(i);
                }
                if (closestDist != null && !DataSetUtil.asDatum(p.slice(0)).subtract(mid).abs().lt(closestDist)) continue;
                iclosest = i;
                closestDist = DataSetUtil.asDatum(p.slice(0)).subtract(mid).abs();
            }
            if (iclosest != -1 && selectMe.isEmpty()) {
                selectMe = Collections.singletonList(iclosest);
            }
            this.table.getSelectionModel().clearSelection();
            for (i = 0; i < selectMe.size(); ++i) {
                int iselect = (Integer)selectMe.get(i);
                this.table.getSelectionModel().addSelectionInterval(iselect, iselect);
            }
            if (selectMe.size() > 0) {
                int iselect = (Integer)selectMe.get(0);
                this.table.scrollRectToVisible(new Rectangle(this.table.getCellRect(iselect, 0, true)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToFile(File file) throws IOException {
        ArrayList<QDataSet> dataPoints1;
        Units[] lunitsArray;
        String[] lnamesArray;
        DataPointRecorderNew dataPointRecorderNew = this;
        synchronized (dataPointRecorderNew) {
            lnamesArray = Arrays.copyOf(this.namesArray, this.namesArray.length);
            lunitsArray = Arrays.copyOf(this.unitsArray, this.unitsArray.length);
            dataPoints1 = new ArrayList<QDataSet>(this.dataPoints);
        }
        FileOutputStream out = new FileOutputStream(file);
        try (BufferedWriter r = new BufferedWriter(new OutputStreamWriter(out));){
            StringBuilder header = new StringBuilder();
            for (int j = 0; j < lnamesArray.length; ++j) {
                Units units = lunitsArray[j];
                String sunits = UnitsUtil.isTimeLocation(units) ? "(UTC)" : (UnitsUtil.isOrdinalMeasurement(units) ? "(ordinal)" : (units == Units.dimensionless ? "" : "(" + units + ")"));
                header.append(lnamesArray[j]).append(sunits);
                if (j >= lnamesArray.length - 1) continue;
                header.append("\t");
            }
            r.write(header.toString());
            r.newLine();
            for (int i = 0; i < dataPoints1.size(); ++i) {
                QDataSet x = (QDataSet)dataPoints1.get(i);
                StringBuilder s = new StringBuilder();
                for (int j = 0; j < x.length(); ++j) {
                    Datum d = DataSetUtil.asDatum(x.slice(j));
                    DatumFormatter formatter = d.getFormatter();
                    s.append(formatter.format(d, lunitsArray[j]).trim());
                    if (j >= x.length() - 1) continue;
                    s.append("\t");
                }
                r.write(s.toString());
                r.newLine();
                this.prefs.put("components.DataPointRecorder.lastFileSave", file.toString());
                this.prefs.put("components.DataPointRecorder.lastFileLoad", file.toString());
            }
        }
        this.modified = false;
        this.updateStatus();
    }

    private int lineCount(File file) throws IOException {
        int lineCount = 0;
        try (BufferedReader r = null;){
            FileInputStream in = new FileInputStream(file);
            r = new BufferedReader(new InputStreamReader(in));
            String line = r.readLine();
            while (line != null) {
                ++lineCount;
                line = r.readLine();
            }
        }
        return lineCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFromFile(File file) throws IOException {
        ProgressMonitor mon = new NullProgressMonitor();
        BufferedReader r = null;
        boolean active0 = this.active;
        try {
            this.active = false;
            int lineCount = this.lineCount(file);
            r = new BufferedReader(new FileReader(file));
            this.dataPoints.clear();
            Units[] unitsArray1 = null;
            SparseDataSet bundleDescriptor1 = null;
            SparseDataSetBuilder bdsb = new SparseDataSetBuilder(2);
            if (lineCount > 500) {
                mon = DasProgressPanel.createFramed("reading file");
            }
            String delim = ",";
            mon.setTaskSize(lineCount);
            mon.started();
            int linenum = 0;
            final ArrayList<DDataSet> records = new ArrayList<DDataSet>(1440);
            String line = r.readLine();
            while (line != null) {
                ++linenum;
                if (mon.isCancelled()) break;
                if ((line = line.trim()).length() != 0) {
                    int i;
                    String[] s;
                    mon.setTaskProgress(linenum);
                    if (line.startsWith("## ") || line.length() > 0 && Character.isJavaIdentifierStart(line.charAt(0))) {
                        if (unitsArray1 == null) {
                            while (line.startsWith("#")) {
                                line = line.substring(1);
                            }
                            if (!line.contains(delim)) {
                                delim = "\t";
                            }
                            if (!line.contains(delim)) {
                                delim = "\\s+";
                            }
                            s = line.split(delim);
                            for (int i2 = 0; i2 < s.length; ++i2) {
                                s[i2] = s[i2].trim();
                            }
                            Pattern p = Pattern.compile("(.+)\\((.*)\\)");
                            String[] namesArray1 = new String[s.length];
                            unitsArray1 = new Units[s.length];
                            for (i = 0; i < s.length; ++i) {
                                Matcher m = p.matcher(s[i]);
                                if (m.matches()) {
                                    namesArray1[i] = m.group(1).trim();
                                    if (m.group(2).trim().equals("UTC")) {
                                        unitsArray1[i] = Units.cdfTT2000;
                                    }
                                    if (m.group(2).trim().equals("ordinal")) {
                                        unitsArray1[i] = EnumerationUnits.create("default");
                                    }
                                    unitsArray1[i] = Units.lookupUnits(m.group(2).trim());
                                } else {
                                    namesArray1[i] = s[i].trim();
                                    unitsArray1[i] = Units.dimensionless;
                                }
                                bdsb.putProperty("NAME", i, namesArray1[i]);
                                bdsb.putProperty("UNITS", i, unitsArray1[i]);
                            }
                            bdsb.setLength(s.length);
                        }
                    } else {
                        int i3;
                        s = line.split(delim);
                        for (i3 = 0; i3 < s.length; ++i3) {
                            String s1 = s[i3];
                            if ((s1 = s1.trim()).startsWith("\"") && s1.endsWith("\"")) {
                                s1 = s1.substring(1, s1.length() - 1);
                            }
                            s[i3] = s1;
                        }
                        if (unitsArray1 == null) {
                            unitsArray1 = new Units[s.length];
                            for (i3 = 0; i3 < s.length; ++i3) {
                                unitsArray1[i3] = s[i3].charAt(0) == '\"' ? null : (TimeUtil.isValidTime(s[i3]) ? Units.us2000 : (s[i3].startsWith("0x") ? Units.dimensionless : DatumUtil.parseValid(s[i3]).getUnits()));
                            }
                        }
                        try {
                            DDataSet rec = DDataSet.createRank1(s.length);
                            for (i = 0; i < s.length; ++i) {
                                if (unitsArray1[i] == null) {
                                    Pattern p = Pattern.compile("\"(.*)\".*");
                                    Matcher m = p.matcher(s[i]);
                                    if (m.matches()) {
                                        EnumerationUnits eu = EnumerationUnits.create("default");
                                        unitsArray1[i] = eu;
                                        rec.putValue(i, eu.createDatum(m.group(1)).doubleValue(eu));
                                        continue;
                                    }
                                    throw new ParseException("parse error, expected \"\"", 0);
                                }
                                try {
                                    if (unitsArray1[i] instanceof EnumerationUnits) {
                                        EnumerationUnits eu = (EnumerationUnits)unitsArray1[i];
                                        rec.putValue(i, eu.createDatum(s[i]).doubleValue(eu));
                                        continue;
                                    }
                                    rec.putValue(i, unitsArray1[i].parse(s[i]).doubleValue(unitsArray1[i]));
                                    continue;
                                }
                                catch (ParseException e) {
                                    throw new RuntimeException(e);
                                }
                            }
                            if (bundleDescriptor1 == null) {
                                bundleDescriptor1 = bdsb.getDataSet();
                            }
                            rec.putProperty("BUNDLE_0", bundleDescriptor1);
                            records.add(rec);
                        }
                        catch (ParseException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
                line = r.readLine();
            }
            r.close();
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    for (QDataSet rec : records) {
                        DataPointRecorderNew.this.addDataPoint(rec);
                    }
                    DataPointRecorderNew.this.updateStatus();
                    DataPointRecorderNew.this.updateClients();
                    DataPointRecorderNew.this.fireDataSetUpdateListenerDataSetUpdated(new DataSetUpdateEvent(this));
                }
            };
            this.saveFile = file;
            this.prefs.put("components.DataPointRecorder.lastFileLoad", file.toString());
            if (SwingUtilities.isEventDispatchThread()) {
                run.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(run);
                }
                catch (InterruptedException | InvocationTargetException ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
            }
        }
        finally {
            mon.finished();
            if (r != null) {
                r.close();
            }
            this.active = active0;
            this.modified = false;
            this.myTableModel.fireTableStructureChanged();
            this.table.repaint();
        }
        if (this.active) {
            DataSetUpdateEvent ev = new DataSetUpdateEvent((Object)this, this.getDataSet());
            this.fireDataSetUpdateListenerDataSetUpdated(ev);
        }
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    private int[] getSelectedRowsInModel() {
        int[] selectedRows = this.table.getSelectedRows();
        for (int i = 0; i < selectedRows.length; ++i) {
            selectedRows[i] = this.table.convertRowIndexToModel(selectedRows[i]);
        }
        return selectedRows;
    }

    private Action getSaveAsAction() {
        return new AbstractAction("Save As..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataPointRecorderNew.this.saveAs();
            }
        };
    }

    private Action getSaveAction() {
        return new AbstractAction("Save"){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataPointRecorderNew.this.save();
            }
        };
    }

    private Action getClearSelectionAction() {
        return new AbstractAction("Clear Selection"){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataPointRecorderNew.this.table.getSelectionModel().clearSelection();
                DataPointRecorderNew.this.fireSelectedDataSetUpdateListenerDataSetUpdated(new DataSetUpdateEvent(this));
            }
        };
    }

    public boolean saveAs() {
        final JFileChooser jj = new JFileChooser();
        final HashMap statusHolder = new HashMap();
        Runnable run = new Runnable(){

            @Override
            public void run() {
                jj.setFileFilter(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        if (pathname == null) {
                            return false;
                        }
                        if (pathname.isDirectory()) {
                            return true;
                        }
                        String fn = pathname.toString();
                        if (fn == null) {
                            return false;
                        }
                        return fn.endsWith(".dat") || fn.endsWith(".txt");
                    }

                    @Override
                    public String getDescription() {
                        return "Flat Ascii Tables";
                    }
                });
                String lastFileString = DataPointRecorderNew.this.prefs.get("components.DataPointRecorder.lastFileSave", "");
                if (lastFileString.length() > 0) {
                    File lastFile = new File(lastFileString);
                    jj.setSelectedFile(lastFile);
                }
                statusHolder.put("status", jj.showSaveDialog(DataPointRecorderNew.this));
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(run);
            }
            catch (InterruptedException | InvocationTargetException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }
        int status = (Integer)statusHolder.get("status");
        if (status == 0) {
            try {
                File pathname = jj.getSelectedFile();
                if (!pathname.toString().endsWith(".dat") && !pathname.toString().endsWith(".txt")) {
                    pathname = new File(pathname.getAbsolutePath() + ".dat");
                }
                this.saveFile = pathname;
                this.saveToFile(this.saveFile);
            }
            catch (IOException e1) {
                DasApplication.getDefaultApplication().getExceptionHandler().handle(e1);
                return false;
            }
        } else if (status == 1) {
            return false;
        }
        return true;
    }

    public boolean save() {
        if (this.saveFile == null) {
            return this.saveAs();
        }
        try {
            this.saveToFile(this.saveFile);
            return true;
        }
        catch (IOException ex) {
            DasApplication.getDefaultApplication().getExceptionHandler().handle(ex);
            return false;
        }
    }

    public File getCurrentFile() {
        return this.saveFile;
    }

    public boolean saveBeforeExit() {
        if (this.modified) {
            int i = JOptionPane.showConfirmDialog(this, "Save changes before exiting?");
            if (i == 0) {
                return this.save();
            }
            return i != 2;
        }
        return true;
    }

    private Action getLoadAction() {
        return new AbstractAction("Open..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DataPointRecorderNew.this.checkModified(e)) {
                    int status;
                    JFileChooser jj = new JFileChooser();
                    String lastFileString = DataPointRecorderNew.this.prefs.get("components.DataPointRecorder.lastFileLoad", "");
                    if (lastFileString.length() > 0) {
                        File lastFile = new File(lastFileString);
                        jj.setSelectedFile(lastFile);
                    }
                    if ((status = jj.showOpenDialog(DataPointRecorderNew.this)) == 0) {
                        final File loadFile = jj.getSelectedFile();
                        DataPointRecorderNew.this.prefs.put("components.DataPointRecorder.lastFileLoad", loadFile.toString());
                        Runnable run = new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    DataPointRecorderNew.this.loadFromFile(loadFile);
                                    DataPointRecorderNew.this.updateStatus();
                                }
                                catch (IOException e) {
                                    DasApplication.getDefaultApplication().getExceptionHandler().handle(e);
                                }
                            }
                        };
                        new Thread(run).start();
                    }
                }
            }
        };
    }

    private boolean checkModified(ActionEvent e) {
        if (this.modified) {
            int n = JOptionPane.showConfirmDialog(this, "Current work has not been saved.\n  Save first?", "Save work first", 1);
            if (n == 0) {
                this.getSaveAction().actionPerformed(e);
            }
            return n != 2;
        }
        return true;
    }

    private Action getNewAction() {
        return new AbstractAction("New"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DataPointRecorderNew.this.checkModified(e)) {
                    DataPointRecorderNew.this.dataPoints.clear();
                    DataPointRecorderNew.this.saveFile = null;
                    DataPointRecorderNew.this.updateStatus();
                    DataPointRecorderNew.this.updateClients();
                    DataPointRecorderNew.this.table.repaint();
                }
            }
        };
    }

    private Action getPropertiesAction() {
        return new AbstractAction("Properties"){

            @Override
            public void actionPerformed(ActionEvent e) {
                new PropertyEditor(DataPointRecorderNew.this).showDialog(DataPointRecorderNew.this);
            }
        };
    }

    private Action getUpdateAction() {
        return new AbstractAction("Update"){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataPointRecorderNew.this.update();
            }
        };
    }

    public void update() {
        this.fireDataSetUpdateListenerDataSetUpdated(new DataSetUpdateEvent(this));
        this.fireSelectedDataSetUpdateListenerDataSetUpdated(new DataSetUpdateEvent(this));
    }

    public DataPointRecorderNew() {
        this.namesArrayLock = new Object();
        this.dataPoints = new ArrayList<QDataSet>();
        this.myTableModel = new MyTableModel();
        this.setLayout(new BorderLayout());
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.add(new JMenuItem(this.getNewAction()));
        fileMenu.add(new JMenuItem(this.getLoadAction()));
        fileMenu.add(new JMenuItem(this.getSaveAction()));
        fileMenu.add(new JMenuItem(this.getSaveAsAction()));
        menuBar.add(fileMenu);
        JMenu editMenu = new JMenu("Edit");
        editMenu.add(new JMenuItem(this.getPropertiesAction()));
        editMenu.add(new JMenuItem(new AbstractAction("Clear Table Sorting"){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataPointRecorderNew.this.table.setAutoCreateRowSorter(false);
                DataPointRecorderNew.this.table.setAutoCreateRowSorter(true);
            }
        }));
        JMenuItem mi = new JMenuItem(new AbstractAction("Delete Selected Items"){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selectedRows = DataPointRecorderNew.this.getSelectedRowsInModel();
                DataPointRecorderNew.this.deleteRows(selectedRows);
            }
        });
        editMenu.add(mi);
        menuBar.add(editMenu);
        this.add((Component)menuBar, "North");
        this.table = new JTable(this.myTableModel);
        this.table.setAutoCreateRowSorter(true);
        this.table.getTableHeader().setReorderingAllowed(true);
        this.table.setColumnModel(new DefaultTableColumnModel(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getColumnCount() {
                Object object = DataPointRecorderNew.this.namesArrayLock;
                synchronized (object) {
                    return super.getColumnCount();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public TableColumn getColumn(int columnIndex) {
                Object object = DataPointRecorderNew.this.namesArrayLock;
                synchronized (object) {
                    return super.getColumn(columnIndex);
                }
            }
        });
        this.table.setRowSelectionAllowed(true);
        this.table.addMouseListener(new MyMouseAdapter(this.table));
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DataPointRecorderNew.this.fireSelectedDataSetUpdateListenerDataSetUpdated(new DataSetUpdateEvent(DataPointRecorderNew.this));
                int selected = DataPointRecorderNew.this.table.getSelectedRow();
                if (selected > -1) {
                    QDataSet dp = DataPointRecorderNew.this.dataPoints.get(selected);
                    Datum x = DataSetUtil.asDatum(dp.slice(0));
                    Datum y = DataSetUtil.asDatum(dp.slice(1));
                    DataPointSelectionEvent e2 = new DataPointSelectionEvent(DataPointRecorderNew.this, x, y);
                    e2.setDataSet(dp);
                    DataPointRecorderNew.this.fireDataPointSelectionListenerDataPointSelected(e2);
                }
            }
        });
        this.scrollPane = new JScrollPane(this.table);
        this.add((Component)this.scrollPane, "Center");
        JPanel controlStatusPanel = new JPanel();
        controlStatusPanel.setLayout(new BoxLayout(controlStatusPanel, 1));
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new BoxLayout(controlPanel, 0));
        this.updateButton = new JButton(this.getUpdateAction());
        this.updateButton.setVisible(false);
        this.updateButton.setEnabled(false);
        controlPanel.add(this.updateButton);
        this.clearSelectionButton = new JButton(this.getClearSelectionAction());
        controlPanel.add(this.clearSelectionButton);
        this.messageLabel = new JLabel("ready");
        this.messageLabel.setAlignmentX(0.0f);
        controlStatusPanel.add(this.messageLabel);
        controlPanel.setAlignmentX(0.0f);
        controlStatusPanel.add(controlPanel);
        this.add((Component)controlStatusPanel, "South");
    }

    public static DataPointRecorderNew createFramed() {
        JFrame frame = new JFrame("Data Point Recorder");
        DataPointRecorderNew result = new DataPointRecorderNew();
        frame.getContentPane().add(result);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(1);
        return result;
    }

    private void updateClients() {
        if (this.active) {
            this.myTableModel.fireTableDataChanged();
            if (this.selectRow != -1 && this.table.getRowCount() > this.selectRow) {
                this.table.setRowSelectionInterval(this.selectRow, this.selectRow);
                this.table.scrollRectToVisible(this.table.getCellRect(this.selectRow, 0, true));
                this.selectRow = -1;
            }
            this.table.repaint();
        }
    }

    private void updateStatus() {
        String t;
        String statusString = (this.saveFile == null ? "" : String.valueOf(this.saveFile) + " ") + (this.modified ? "(modified)" : "");
        if (!statusString.equals(t = this.messageLabel.getText())) {
            this.messageLabel.setText(statusString);
        }
    }

    public void setColumnCount(int count) {
        this.namesArray = new String[count];
        this.unitsArray = new Units[count];
        this.defaultsArray = new double[count];
        for (int i = 0; i < count; ++i) {
            this.namesArray[i] = "field" + i;
            this.unitsArray[i] = Units.dimensionless;
        }
    }

    public void setColumn(int i, String name, Units units, Datum deft) {
        if (units == null) {
            units = Units.dimensionless;
        }
        if (this.namesArray == null) {
            throw new IllegalArgumentException("call setColumnCount first.");
        }
        if (i >= this.namesArray.length) {
            throw new IndexOutOfBoundsException("column index is out of bounds (and 0 is the first column)");
        }
        this.namesArray[i] = name;
        this.unitsArray[i] = units;
        this.defaultsArray[i] = deft.doubleValue(units);
    }

    public void setColumn(int i, String name, Units units, String deft) throws ParseException {
        if (units == null) {
            units = Units.dimensionless;
        }
        if (units instanceof EnumerationUnits) {
            this.setColumn(i, name, units, ((EnumerationUnits)units).createDatum(deft));
        } else {
            this.setColumn(i, name, units, units.parse(deft));
        }
    }

    public void setColumn(int i, String name, Units units, double deft) throws ParseException {
        if (units == null) {
            units = Units.dimensionless;
        }
        this.setColumn(i, name, units, units.createDatum(deft));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertInternal(QDataSet newPoint) {
        if (newPoint.rank() == 2 && newPoint.length() == 1) {
            newPoint = newPoint.slice(0);
        }
        DDataSet mnp = this.defaultsArray != null ? DDataSet.wrap(Arrays.copyOf(this.defaultsArray, this.defaultsArray.length)) : DDataSet.createRank1(this.namesArray.length);
        QDataSet bds = (QDataSet)newPoint.property("BUNDLE_0");
        for (int i = 0; i < newPoint.length(); ++i) {
            Datum d = DataSetUtil.asDatum(newPoint.slice(i));
            int idx = -1;
            if (i < bds.length() && i < this.namesArray.length && bds.property("NAME", i).equals(this.namesArray[i])) {
                idx = i;
            } else {
                for (int j = 0; j < this.namesArray.length; ++j) {
                    if (!bds.property("NAME", i).equals(this.namesArray[j])) continue;
                    idx = j;
                }
            }
            if (idx == -1) {
                logger.log(Level.FINEST, "unable to find column for {0}", bds.property("NAME", i));
                continue;
            }
            if (this.unitsArray[idx].isConvertibleTo(d.getUnits())) {
                mnp.putValue(idx, d.doubleValue(this.unitsArray[idx]));
            } else if (UnitsUtil.isOrdinalMeasurement(this.unitsArray[idx])) {
                mnp.putValue(idx, ((EnumerationUnits)this.unitsArray[idx]).createDatum(d.toString()).doubleValue(this.unitsArray[idx]));
            } else {
                throw new InconvertibleUnitsException(d.getUnits(), this.unitsArray[idx]);
            }
            mnp.putProperty("BUNDLE_0", this.bundleDescriptor);
        }
        newPoint = mnp;
        List<QDataSet> list = this.dataPoints;
        synchronized (list) {
            int newSelect;
            if (this.sorted) {
                int index = Collections.binarySearch(this.dataPoints, newPoint, this.comparator);
                if (index < 0) {
                    QDataSet qds1 = null;
                    if (~index < this.dataPoints.size()) {
                        String[] keys;
                        qds1 = this.dataPoints.get(~index);
                        for (String key : keys = DataSetUtil.bundleNames(newPoint)) {
                            if (DataSetOps.indexOfBundledDataSet(qds1, key) == -1) continue;
                            logger.log(Level.FINE, "no place to put key: {0}", key);
                        }
                    }
                    QDataSet dp1 = null;
                    if (~index + 1 < this.dataPoints.size()) {
                        dp1 = this.dataPoints.get(~index + 1);
                    }
                    Datum epsilon = Units.microseconds.createDatum(10000);
                    if (SemanticOps.getUnits(newPoint.slice(0)).getOffsetUnits().isConvertibleTo(Units.milliseconds)) {
                        if (qds1 != null && Ops.lt((Object)Ops.abs(Ops.subtract(qds1.slice(0), newPoint.slice(0))), epsilon).value() == 1.0) {
                            this.dataPoints.set(~index, newPoint);
                        } else if (dp1 != null && Ops.lt((Object)Ops.abs(Ops.subtract(dp1.slice(0), newPoint.slice(0))), epsilon).value() == 1.0) {
                            this.dataPoints.set(~index, newPoint);
                        } else {
                            this.dataPoints.add(~index, newPoint);
                        }
                    } else {
                        this.dataPoints.add(~index, newPoint);
                    }
                    newSelect = ~index;
                } else {
                    this.dataPoints.set(index, newPoint);
                    newSelect = index;
                }
            } else {
                this.dataPoints.add(newPoint);
                newSelect = this.dataPoints.size() - 1;
            }
            this.selectRow = newSelect;
        }
        this.modified = true;
        this.updateStatus();
        this.updateClients();
        this.table.repaint();
        this.myTableModel.fireTableDataChanged();
    }

    public void addDataPoint(Datum x, Datum y) {
        this.addDataPoint(x, y, null);
    }

    public void addDataPoint(Datum x, Datum y, Object meta) {
        this.addDataPoint(x, y, Collections.singletonMap("meta", meta));
    }

    public void addDataPoint(Datum x, Datum y, Map<String, Object> planes) {
        if (planes == null) {
            planes = Collections.emptyMap();
        }
        DDataSet rec = DDataSet.createRank1(2 + planes.size());
        SparseDataSetBuilder bdsb = new SparseDataSetBuilder(2);
        int ii = 0;
        bdsb.putProperty("NAME", ii, "x");
        bdsb.putProperty("UNITS", ii, x.getUnits());
        rec.putValue(ii, x.doubleValue(x.getUnits()));
        bdsb.putProperty("NAME", ++ii, "y");
        bdsb.putProperty("UNITS", ii, y.getUnits());
        rec.putValue(ii, y.doubleValue(y.getUnits()));
        ++ii;
        for (Map.Entry<String, Object> e : planes.entrySet()) {
            Units theu;
            bdsb.putProperty("NAME", ii, e.getKey());
            Object o = e.getValue();
            if (o instanceof String) {
                EnumerationUnits eu = EnumerationUnits.create("default");
                theu = eu;
                try {
                    rec.putValue(ii, theu.parse((String)o).doubleValue(theu));
                }
                catch (ParseException ex) {
                    rec.putValue(ii, -1.0);
                }
            } else if (o instanceof Datum) {
                theu = ((Datum)o).getUnits();
                rec.putValue(ii, ((Datum)o).doubleValue(theu));
            } else if (o instanceof Number) {
                theu = Units.dimensionless;
                rec.putValue(ii, ((Number)o).doubleValue());
            } else if (o instanceof QDataSet) {
                theu = SemanticOps.getUnits((QDataSet)o);
                rec.putValue(ii, ((QDataSet)o).value());
            } else {
                throw new IllegalArgumentException("value must be String, Datum, DataSet or Number");
            }
            bdsb.putProperty("UNITS", ii, theu);
            ++ii;
        }
        bdsb.setLength(ii);
        SparseDataSet bds = bdsb.getDataSet();
        rec.putProperty("BUNDLE_0", bds);
        this.addDataPoint(rec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDataPoint(QDataSet rec) {
        if (rec.rank() == 2 && rec.length() == 1) {
            rec = rec.slice(0);
        }
        List<QDataSet> list = this.dataPoints;
        synchronized (list) {
            if (this.dataPoints.isEmpty()) {
                QDataSet bds = (QDataSet)rec.property("BUNDLE_0");
                if (bds == null) {
                    SparseDataSetBuilder bdsb = new SparseDataSetBuilder(2);
                    Units u = SemanticOps.getUnits(rec);
                    for (int i = 0; i < rec.length(); ++i) {
                        bdsb.putProperty("NAME", i, "ch_" + i);
                        bdsb.putProperty("UNITS", i, u);
                    }
                    bdsb.setLength(rec.length());
                    bds = bdsb.getDataSet();
                }
                if (this.namesArray == null) {
                    logger.fine("first record defines columns");
                    Units[] lunitsArray = new Units[rec.length()];
                    String[] lnamesArray = new String[rec.length()];
                    for (int index = 0; index < bds.length(); ++index) {
                        lnamesArray[index] = (String)bds.property("NAME", index);
                        Units u = (Units)bds.property("UNITS", index);
                        lunitsArray[index] = u != null ? u : Units.dimensionless;
                    }
                    this.unitsArray = lunitsArray;
                    this.namesArray = lnamesArray;
                }
                this.bundleDescriptor = new AbstractDataSet(){

                    @Override
                    public int rank() {
                        return 2;
                    }

                    @Override
                    public Object property(String name, int i) {
                        if (name.equals("NAME")) {
                            return DataPointRecorderNew.this.namesArray[i];
                        }
                        if (name.equals("UNITS")) {
                            return DataPointRecorderNew.this.unitsArray[i];
                        }
                        return null;
                    }

                    @Override
                    public int length() {
                        return DataPointRecorderNew.this.namesArray.length;
                    }

                    @Override
                    public int length(int i) {
                        return 0;
                    }
                };
                this.myTableModel.fireTableStructureChanged();
                for (int i = 0; i < 1; ++i) {
                    if (!UnitsUtil.isTimeLocation(this.unitsArray[i])) continue;
                    this.table.getTableHeader().getColumnModel().getColumn(i).setMinWidth(180);
                }
            }
            this.insertInternal(rec);
        }
        if (this.active) {
            DataSetUpdateEvent ev = new DataSetUpdateEvent((Object)this, this.getDataSet());
            this.fireDataSetUpdateListenerDataSetUpdated(ev);
        }
    }

    public void appendDataSet(VectorDataSet ds) {
        LinkedHashMap<String, Object> planesMap = new LinkedHashMap<String, Object>();
        if (ds.getProperty("comment") != null) {
            planesMap.put("comment", ds.getProperty("comment"));
        }
        this.xTagWidth = ds.getProperty("xTagWidth") != null ? (Datum)ds.getProperty("xTagWidth") : Datum.create(0);
        String[] planes = ds.getPlaneIds();
        for (int i = 0; i < ds.getXLength(); ++i) {
            for (int j = 0; j < planes.length; ++j) {
                if (planes[j].equals("")) continue;
                planesMap.put(planes[j], ((VectorDataSet)ds.getPlanarView(planes[j])).getDatum(i));
            }
            this.addDataPoint(ds.getXTagDatum(i), ds.getDatum(i), planesMap);
        }
        this.updateClients();
    }

    public DataSetUpdateListener getAppendDataSetUpListener() {
        return new DataSetUpdateListener(){

            @Override
            public void dataSetUpdated(DataSetUpdateEvent e) {
                VectorDataSet ds = (VectorDataSet)((Object)e.getDataSet());
                if (ds == null) {
                    throw new RuntimeException("not supported, I need the DataSet in the update event");
                }
                DataPointRecorderNew.this.appendDataSet((VectorDataSet)((Object)e.getDataSet()));
            }
        };
    }

    private boolean checkUpdateEnable() {
        int listenerList1Count = this.listenerList1.getListenerCount();
        if (listenerList1Count > 0) {
            this.updateButton.setEnabled(true);
            this.updateButton.setVisible(true);
            this.updateButton.setToolTipText(null);
            return true;
        }
        this.updateButton.setEnabled(false);
        this.updateButton.setToolTipText("no listeners. See File->Save to save table.");
        this.updateButton.setVisible(false);
        return false;
    }

    public void addDataSetUpdateListener(DataSetUpdateListener listener) {
        this.listenerList1.add(DataSetUpdateListener.class, listener);
        this.checkUpdateEnable();
    }

    public void removeDataSetUpdateListener(DataSetUpdateListener listener) {
        this.listenerList1.remove(DataSetUpdateListener.class, listener);
        this.checkUpdateEnable();
    }

    private void fireDataSetUpdateListenerDataSetUpdated(DataSetUpdateEvent event) {
        Object[] listeners = this.listenerList1.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DataSetUpdateListener.class) continue;
            ((DataSetUpdateListener)listeners[i + 1]).dataSetUpdated(event);
        }
    }

    public void addSelectedDataSetUpdateListener(DataSetUpdateListener listener) {
        this.selectedListenerList.add(DataSetUpdateListener.class, listener);
        this.checkUpdateEnable();
    }

    public void removeSelectedDataSetUpdateListener(DataSetUpdateListener listener) {
        this.selectedListenerList.remove(DataSetUpdateListener.class, listener);
        this.checkUpdateEnable();
    }

    private void fireSelectedDataSetUpdateListenerDataSetUpdated(DataSetUpdateEvent event) {
        Object[] listeners = this.selectedListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DataSetUpdateListener.class) continue;
            ((DataSetUpdateListener)listeners[i + 1]).dataSetUpdated(event);
        }
    }

    public boolean isSorted() {
        return this.sorted;
    }

    public void setSorted(boolean sorted) {
        this.sorted = sorted;
    }

    public synchronized void addDataPointSelectionListener(DataPointSelectionListener listener) {
        if (this.listenerList1 == null) {
            this.listenerList1 = new EventListenerList();
        }
        this.listenerList1.add(DataPointSelectionListener.class, listener);
    }

    public synchronized void removeDataPointSelectionListener(DataPointSelectionListener listener) {
        this.listenerList1.remove(DataPointSelectionListener.class, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireDataPointSelectionListenerDataPointSelected(DataPointSelectionEvent event) {
        Object[] listeners;
        DataPointRecorderNew dataPointRecorderNew = this;
        synchronized (dataPointRecorderNew) {
            if (this.listenerList1 == null) {
                return;
            }
            listeners = this.listenerList1.getListenerList();
        }
        logger.fine("firing data point selection event");
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DataPointSelectionListener.class) continue;
            ((DataPointSelectionListener)listeners[i + 1]).dataPointSelected(event);
        }
    }

    public Datum getXTagWidth() {
        return this.xTagWidth;
    }

    public void setXTagWidth(Datum xTagWidth) {
        this.xTagWidth = xTagWidth;
    }

    public boolean isSnapToGrid() {
        return this.snapToGrid;
    }

    public void setSnapToGrid(boolean snapToGrid) {
        this.snapToGrid = snapToGrid;
    }

    public boolean isModified() {
        return this.modified;
    }

    private class MyMouseAdapter
    extends MouseAdapter {
        JPopupMenu popup;
        JMenuItem menuItem;
        final JTable parent;

        MyMouseAdapter(JTable parent) {
            this.parent = parent;
            this.popup = new JPopupMenu("Options");
            this.menuItem = new JMenuItem("Delete Row(s)");
            this.menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int[] selectedRows = DataPointRecorderNew.this.getSelectedRowsInModel();
                    DataPointRecorderNew.this.deleteRows(selectedRows);
                }
            });
            this.popup.add(this.menuItem);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 3) {
                int rowCount = this.parent.getSelectedRows().length;
                this.menuItem.setText("Delete " + rowCount + " Row" + (rowCount != 1 ? "s" : ""));
                this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }

    private class MyTableModel
    extends AbstractTableModel {
        private MyTableModel() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getColumnCount() {
            Object object = DataPointRecorderNew.this.namesArrayLock;
            synchronized (object) {
                return DataPointRecorderNew.this.namesArray == null ? 0 : DataPointRecorderNew.this.namesArray.length;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getColumnName(int j) {
            Object object = DataPointRecorderNew.this.namesArrayLock;
            synchronized (object) {
                String result = DataPointRecorderNew.this.namesArray[j];
                if (DataPointRecorderNew.this.unitsArray[j] != null) {
                    if (DataPointRecorderNew.this.unitsArray[j] instanceof EnumerationUnits) {
                        result = result + "(ordinal)";
                    } else if (UnitsUtil.isTimeLocation(DataPointRecorderNew.this.unitsArray[j])) {
                        result = result + "(UTC)";
                    } else if (DataPointRecorderNew.this.unitsArray[j] != Units.dimensionless) {
                        result = result + "(" + DataPointRecorderNew.this.unitsArray[j] + ")";
                    }
                }
                return result;
            }
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return Datum.class;
        }

        @Override
        public int getRowCount() {
            int nrow = DataPointRecorderNew.this.dataPoints.size();
            return nrow;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getValueAt(int i, int j) {
            QDataSet x;
            List<QDataSet> list = DataPointRecorderNew.this.dataPoints;
            synchronized (list) {
                x = DataPointRecorderNew.this.dataPoints.get(i);
            }
            if (j < x.length()) {
                Datum d = DataPointRecorderNew.this.unitsArray[j].createDatum(x.value(j));
                DatumFormatter format = d.getFormatter();
                return format.format(d, DataPointRecorderNew.this.unitsArray[j]);
            }
            throw new IndexOutOfBoundsException("no such column");
        }
    }
}

