/*
 * Decompiled with CFR 0.152.
 */
package org.das2.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import org.das2.DasApplication;
import org.das2.DasException;
import org.das2.components.DasProgressPanel;
import org.das2.components.propertyeditor.PropertyEditor;
import org.das2.dataset.DataSet;
import org.das2.dataset.DataSetAdapter;
import org.das2.dataset.DataSetDescriptor;
import org.das2.dataset.DataSetUpdateEvent;
import org.das2.dataset.DataSetUpdateListener;
import org.das2.dataset.VectorDataSet;
import org.das2.dataset.VectorDataSetBuilder;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumUtil;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.TimeLocationUnits;
import org.das2.datum.TimeParser;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.datum.format.DatumFormatter;
import org.das2.event.CommentDataPointSelectionEvent;
import org.das2.event.DataPointSelectionEvent;
import org.das2.event.DataPointSelectionListener;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.WritableDataSet;
import org.das2.qds.ops.Ops;
import org.das2.qds.util.DataSetBuilder;
import org.das2.system.DasLogger;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;

public class DataPointRecorder
extends JPanel
implements DataPointSelectionListener {
    private static final int TIME_WIDTH = 180;
    protected JTable table;
    protected JScrollPane scrollPane;
    protected JButton updateButton;
    protected final List dataPoints;
    private int selectRow;
    protected Units[] unitsArray;
    protected String[] planesArray;
    protected AbstractTableModel myTableModel;
    private File saveFile;
    private boolean modified;
    private JLabel messageLabel;
    private boolean active = true;
    Preferences prefs = Preferences.userNodeForPackage(this.getClass());
    private static final Logger logger = DasLogger.getLogger(DasLogger.GUI_LOG);
    private final JButton clearSelectionButton;
    private final JButton deleteSelectionButton;
    private final JPanel accessoryPanel;
    private final Object planesArrayLock;
    private MyDataSetDescriptor dataSetDescriptor;
    private EventListenerList listenerList1 = new EventListenerList();
    private EventListenerList selectedListenerList = new EventListenerList();
    private boolean sorted = true;
    private Datum xTagWidth = Datum.create(0);
    private boolean snapToGrid = false;
    private String timeFormat = "$Y-$m-$dT$H:$M:$S.$(subsec,places=3)Z";
    private TimeParser timeFormatter = TimeParser.create(this.timeFormat);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteInterval(DatumRange range) {
        if (!this.sorted) {
            throw new IllegalArgumentException("data must be sorted");
        }
        List list = this.dataPoints;
        synchronized (list) {
            int index2;
            Comparator comp = new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((DataPoint)o1).get(0).compareTo((Datum)o2);
                }
            };
            int index1 = Collections.binarySearch(this.dataPoints, range.min(), comp);
            if (index1 < 0) {
                index1 ^= 0xFFFFFFFF;
            }
            if ((index2 = Collections.binarySearch(this.dataPoints, range.max(), comp)) < 0) {
                index2 ^= 0xFFFFFFFF;
            }
            if (index1 == index2) {
                return;
            }
            int[] arr = new int[index2 - index1];
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = index1 + i;
            }
            this.deleteRows(arr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRow(int row) {
        List list = this.dataPoints;
        synchronized (list) {
            this.dataPoints.remove(row);
            this.modified = true;
            this.updateClients();
            this.updateStatus();
        }
        if (this.active) {
            this.fireDataSetUpdateListenerDataSetUpdated(new DataSetUpdateEvent(this));
        }
        this.myTableModel.fireTableDataChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRows(int[] selectedRows) {
        List list = this.dataPoints;
        synchronized (list) {
            for (int i = selectedRows.length - 1; i >= 0; --i) {
                int j = selectedRows[i];
                if (j >= this.dataPoints.size()) {
                    j = this.dataPoints.size() - 1;
                    logger.fine("heres a bug to fix, having to do with synchronization.");
                }
                this.dataPoints.remove(j);
            }
            logger.log(Level.FINER, "dataPoints.size()={0}", this.dataPoints.size());
            this.modified = true;
        }
        this.updateClients();
        this.updateStatus();
        if (this.active) {
            this.fireDataSetUpdateListenerDataSetUpdated(new DataSetUpdateEvent(this));
        }
        this.myTableModel.fireTableDataChanged();
    }

    public QDataSet getDataSet() {
        if (this.unitsArray[0] == null) {
            return null;
        }
        QDataSet bds = this.getBundleDataSet();
        QDataSet xds = Ops.unbundle(bds, 0);
        if (this.xTagWidth != null && this.xTagWidth.value() > 0.0 && !this.xTagWidth.isFill()) {
            xds = Ops.putProperty(xds, "CADENCE", (Object)DataSetUtil.asDataSet(this.xTagWidth));
        }
        if (bds.length(0) == 2) {
            return Ops.link(xds, Ops.unbundle(bds, 1));
        }
        WritableDataSet ds = Ops.copy(Ops.trim1(bds, 1, bds.length(0)));
        return Ops.link(xds, ds);
    }

    public QDataSet getDataPoints() {
        return this.getBundleDataSet();
    }

    public QDataSet getSelectedDataPoints() {
        if (this.unitsArray[0] == null) {
            return null;
        }
        DataSetBuilder builder = new DataSetBuilder(2, this.dataPoints.size(), this.planesArray.length);
        builder.setName(0, "x");
        builder.setName(1, "y");
        builder.setFillValue(-1.0E31);
        for (int i = 2; i < this.planesArray.length; ++i) {
            builder.setName(i, this.planesArray[i]);
        }
        int[] selectedRows = this.getSelectedRowsInModel();
        for (int isrow = 0; isrow < selectedRows.length; ++isrow) {
            int irow = selectedRows[isrow];
            DataPoint dp = (DataPoint)this.dataPoints.get(irow);
            builder.putValue(-1, 0, dp.get(0));
            builder.putValue(-1, 1, dp.get(1));
            for (int i = 2; i < this.planesArray.length; ++i) {
                if (this.unitsArray[i] instanceof EnumerationUnits) {
                    EnumerationUnits eu = (EnumerationUnits)this.unitsArray[i];
                    if (eu == this.unitsArray[i]) {
                        builder.putValue(-1, i, eu.createDatum(((Datum)dp.getPlane(this.planesArray[i])).toString()));
                        continue;
                    }
                    builder.putValue(-1, i, (Datum)dp.getPlane(this.planesArray[i]));
                    continue;
                }
                builder.putValue(-1, i, (Datum)dp.getPlane(this.planesArray[i]));
            }
            builder.nextRecord();
        }
        return builder.getDataSet();
    }

    public QDataSet getBundleDataSet() {
        if (this.unitsArray[0] == null) {
            return null;
        }
        DataSetBuilder builder = new DataSetBuilder(2, this.dataPoints.size(), this.planesArray.length);
        builder.setName(0, "x");
        builder.setName(1, "y");
        builder.setFillValue(-1.0E31);
        for (int i = 2; i < this.planesArray.length; ++i) {
            builder.setName(i, this.planesArray[i]);
        }
        for (int irow = 0; irow < this.dataPoints.size(); ++irow) {
            DataPoint dp = (DataPoint)this.dataPoints.get(irow);
            builder.putValue(-1, 0, dp.get(0));
            builder.putValue(-1, 1, dp.get(1));
            for (int i = 2; i < this.planesArray.length; ++i) {
                builder.putValue(-1, i, (Datum)dp.getPlane(this.planesArray[i]));
            }
            builder.nextRecord();
        }
        return builder.getDataSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized QDataSet getSelectedDataSet() {
        int[] selectedRows = this.getSelectedRowsInModel();
        if (selectedRows.length == 0) {
            return null;
        }
        VectorDataSetBuilder builder = new VectorDataSetBuilder(this.unitsArray[0], this.unitsArray[1]);
        List list = this.dataPoints;
        synchronized (list) {
            for (int j = 2; j < this.planesArray.length; ++j) {
                builder.addPlane(this.planesArray[j], this.unitsArray[j]);
            }
            for (int i = 0; i < selectedRows.length; ++i) {
                int irow = selectedRows[i];
                if (irow >= this.dataPoints.size()) continue;
                DataPoint dp = (DataPoint)this.dataPoints.get(irow);
                builder.insertY(dp.get(0), dp.get(1));
                for (int j = 2; j < this.planesArray.length; ++j) {
                    builder.insertY(dp.get(0).doubleValue(this.unitsArray[0]), ((Datum)dp.getPlane(this.planesArray[j])).doubleValue(this.unitsArray[j]), this.planesArray[j]);
                }
            }
            if (this.xTagWidth != null && this.xTagWidth.value() > 0.0 && !this.xTagWidth.isFill()) {
                builder.setProperty("xTagWidth", this.xTagWidth);
            }
        }
        return DataSetAdapter.create(builder.toVectorDataSet());
    }

    public int select(DatumRange xrange, DatumRange yrange) {
        return this.select(xrange, yrange, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int select(DatumRange xrange, DatumRange yrange, boolean xOrY) {
        if (xOrY && yrange == null) {
            throw new IllegalArgumentException("yrange is null with or condition--this would select all points.");
        }
        Datum mid = xrange.rescale(0.5, 0.5).min();
        List list = this.dataPoints;
        synchronized (list) {
            List<Integer> selectMe = new ArrayList<Integer>();
            int iclosest = -1;
            Datum closestDist = null;
            for (int i = 0; i < this.dataPoints.size(); ++i) {
                DataPoint p = (DataPoint)this.dataPoints.get(i);
                if (xOrY) {
                    assert (yrange != null);
                    if (xrange.contains(p.data[0]) || yrange.contains(p.data[1])) {
                        selectMe.add(i);
                    }
                } else if (xrange.contains(p.data[0]) && (yrange == null || yrange.contains(p.data[1]))) {
                    selectMe.add(i);
                }
                if (closestDist != null && !p.data[0].subtract(mid).abs().lt(closestDist)) continue;
                iclosest = i;
                closestDist = p.data[0].subtract(mid).abs();
            }
            if (iclosest != -1 && selectMe.isEmpty()) {
                assert (closestDist != null);
                if (closestDist.gt(xrange.width())) {
                    return -1;
                }
                if (this.sorted) {
                    selectMe = Collections.singletonList(iclosest);
                } else {
                    return -1;
                }
            }
            this.table.getSelectionModel().clearSelection();
            for (Integer selectMe1 : selectMe) {
                int iselect = selectMe1;
                this.table.getSelectionModel().addSelectionInterval(iselect, iselect);
            }
            if (selectMe.size() > 0) {
                int iselect = (Integer)selectMe.get(0);
                this.table.scrollRectToVisible(new Rectangle(this.table.getCellRect(iselect, 0, true)));
                return iselect;
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToFile(File file) throws IOException {
        ArrayList dataPoints1;
        List list = this.dataPoints;
        synchronized (list) {
            dataPoints1 = new ArrayList(this.dataPoints);
        }
        FileOutputStream out = new FileOutputStream(file);
        try (BufferedWriter r = new BufferedWriter(new OutputStreamWriter(out));){
            StringBuilder header = new StringBuilder();
            for (int j = 0; j < this.planesArray.length; ++j) {
                String s = this.myTableModel.getColumnName(j);
                if (!s.endsWith(")")) {
                    s = s + "()";
                }
                header.append(s).append("\t");
            }
            r.write(header.toString());
            r.newLine();
            if (dataPoints1.size() > 0) {
                TimeParser ltimeFormatter = this.getTimeFormat().length() > 0 ? TimeParser.create(this.timeFormat) : null;
                for (int i = 0; i < dataPoints1.size(); ++i) {
                    int j;
                    DataPoint x = (DataPoint)dataPoints1.get(i);
                    if (ltimeFormatter != null && !UnitsUtil.isTimeLocation(x.get(0).getUnits())) {
                        ltimeFormatter = null;
                    }
                    StringBuilder s = new StringBuilder();
                    for (j = 0; j < 2; ++j) {
                        if (j == 0 && ltimeFormatter != null) {
                            s.append(ltimeFormatter.format(x.get(j))).append("\t");
                            continue;
                        }
                        DatumFormatter formatter = x.get(j).getFormatter();
                        s.append(formatter.format(x.get(j), this.unitsArray[j])).append("\t");
                    }
                    for (j = 2; j < this.planesArray.length; ++j) {
                        Object o = x.getPlane(this.planesArray[j]);
                        if (o == null) {
                            throw new IllegalArgumentException("unable to find plane: " + this.planesArray[j]);
                        }
                        if (this.unitsArray[j] == null) {
                            s.append("\"").append(o).append("\"\t");
                            continue;
                        }
                        Datum d = (Datum)o;
                        DatumFormatter f = d.getFormatter();
                        s.append(f.format(d, this.unitsArray[j])).append("\t");
                    }
                    r.write(s.toString());
                    r.newLine();
                    this.prefs.put("components.DataPointRecorder.lastFileSave", file.toString());
                    this.prefs.put("components.DataPointRecorder.lastFileLoad", file.toString());
                }
            }
        }
        this.modified = false;
        this.updateStatus();
    }

    private int lineCount(File file) throws IOException {
        int lineCount = 0;
        try (BufferedReader r = null;){
            FileInputStream in = new FileInputStream(file);
            r = new BufferedReader(new InputStreamReader(in));
            String line = r.readLine();
            while (line != null) {
                ++lineCount;
                line = r.readLine();
            }
        }
        return lineCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadFromFile(File file) throws IOException {
        boolean sorted0;
        boolean active0;
        block32: {
            ProgressMonitor mon = new NullProgressMonitor();
            BufferedReader r = null;
            active0 = this.active;
            sorted0 = this.sorted;
            try {
                this.active = false;
                this.sorted = false;
                int lineCount = this.lineCount(file);
                r = new BufferedReader(new FileReader(file));
                this.dataPoints.clear();
                String[] planesArray1 = null;
                Units[] unitsArray1 = null;
                if (lineCount > 500) {
                    mon = DasProgressPanel.createFramed("reading file");
                }
                String delim = "\t";
                boolean delimCheck = true;
                mon.setTaskSize(lineCount);
                mon.started();
                int linenum = 0;
                String line = r.readLine();
                while (line != null) {
                    block33: {
                        int i;
                        Matcher m;
                        String[] s;
                        block34: {
                            Pattern p;
                            Matcher m2;
                            ++linenum;
                            if (mon.isCancelled()) break;
                            String tline = line.trim();
                            if (tline.length() == 0) break block33;
                            if (delimCheck && !line.contains("\t") && (m2 = (p = Pattern.compile("([\\s\\,\\;])")).matcher(line)).find()) {
                                char cdelim = m2.group(1).charAt(0);
                                delim = Character.isWhitespace(cdelim) ? "\\s+" : m2.group(1);
                            }
                            delimCheck = false;
                            mon.setTaskProgress(linenum);
                            if (!line.startsWith("## ") && (line.length() <= 0 || !Character.isJavaIdentifierStart(line.charAt(0)))) break block34;
                            if (unitsArray1 == null) {
                                while (line.startsWith("#")) {
                                    line = line.substring(1);
                                }
                                s = line.split(delim, -2);
                                for (int i2 = 0; i2 < s.length; ++i2) {
                                    s[i2] = s[i2].trim();
                                }
                                if (s[s.length - 1].length() == 0) {
                                    s = Arrays.copyOf(s, s.length - 1);
                                }
                                Pattern p2 = Pattern.compile("([^\\(]+)\\((.*)\\)");
                                planesArray1 = new String[s.length];
                                unitsArray1 = new Units[s.length];
                                for (int i3 = 0; i3 < s.length; ++i3) {
                                    m = p2.matcher(s[i3]);
                                    if (m.matches()) {
                                        planesArray1[i3] = m.group(1).trim();
                                        switch (m.group(2).trim()) {
                                            case "UTC": {
                                                unitsArray1[i3] = Units.cdfTT2000;
                                                break;
                                            }
                                            case "ordinal": 
                                            case "class java.lang.StringUnit(ordinal)": {
                                                unitsArray1[i3] = EnumerationUnits.create("default");
                                                break;
                                            }
                                            default: {
                                                unitsArray1[i3] = Units.lookupUnits(m.group(2).trim());
                                                break;
                                            }
                                        }
                                        continue;
                                    }
                                    planesArray1[i3] = s[i3].trim();
                                    unitsArray1[i3] = Units.dimensionless;
                                }
                            }
                            break block33;
                        }
                        s = line.split(delim, -2);
                        for (i = 0; i < s.length; ++i) {
                            s[i] = s[i].trim();
                        }
                        if (unitsArray1 == null) {
                            unitsArray1 = new Units[s.length];
                            for (i = 0; i < s.length; ++i) {
                                unitsArray1[i] = s[i].charAt(0) == '\"' ? null : (TimeUtil.isValidTime(s[i]) ? Units.us2000 : DatumUtil.parseValid(s[i]).getUnits());
                            }
                            planesArray1 = new String[s.length];
                            System.arraycopy(new String[]{"X", "Y", "comment"}, 0, planesArray1, 0, planesArray1.length);
                            for (i = 3; i < planesArray1.length; ++i) {
                                planesArray1[i] = "comment" + i;
                            }
                        }
                        try {
                            LinkedHashMap<String, Datum> planes = new LinkedHashMap<String, Datum>();
                            for (i = 2; i < unitsArray1.length; ++i) {
                                if (unitsArray1[i] == null) {
                                    Pattern p = Pattern.compile("\"(.*)\".*");
                                    m = p.matcher(s[i]);
                                    if (!m.matches()) throw new ParseException("parse error, expected \"\"", 0);
                                    EnumerationUnits eu = EnumerationUnits.create("ordinal");
                                    unitsArray1[i] = eu;
                                    planes.put(planesArray1[i], eu.createDatum(m.group(1)));
                                    continue;
                                }
                                try {
                                    if (unitsArray1[i] instanceof EnumerationUnits) {
                                        EnumerationUnits eu = (EnumerationUnits)unitsArray1[i];
                                        planes.put(planesArray1[i], eu.createDatum(s[i]));
                                        continue;
                                    }
                                    planes.put(planesArray1[i], unitsArray1[i].parse(s[i]));
                                    continue;
                                }
                                catch (ParseException e) {
                                    throw new RuntimeException(e);
                                }
                            }
                            Datum x = unitsArray1[0].parse(s[0]);
                            Datum y = unitsArray1[1].parse(s[1]);
                            DataPointSelectionEvent e = new DataPointSelectionEvent(this, x, y, planes);
                            this.dataPointSelected(e);
                        }
                        catch (ParseException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    line = r.readLine();
                }
                r.close();
                this.saveFile = file;
                Runnable run = new Runnable(){

                    @Override
                    public void run() {
                        DataPointRecorder.this.updateStatus();
                        DataPointRecorder.this.updateClients();
                        DataPointRecorder.this.fireDataSetUpdateListenerDataSetUpdated(new DataSetUpdateEvent(this));
                    }
                };
                SwingUtilities.invokeLater(run);
                this.prefs.put("components.DataPointRecorder.lastFileLoad", file.toString());
                mon.finished();
                if (r == null) break block32;
            }
            catch (Throwable throwable) {
                mon.finished();
                if (r != null) {
                    r.close();
                }
                this.active = active0;
                this.sorted = sorted0;
                this.modified = false;
                Runnable run = new Runnable(){

                    @Override
                    public void run() {
                        DataPointRecorder.this.myTableModel.fireTableStructureChanged();
                        DataPointRecorder.this.table.repaint();
                    }
                };
                SwingUtilities.invokeLater(run);
                throw throwable;
            }
            r.close();
        }
        this.active = active0;
        this.sorted = sorted0;
        this.modified = false;
        Runnable run = new /* invalid duplicate definition of identical inner class */;
        SwingUtilities.invokeLater(run);
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    private int[] getSelectedRowsInModel() {
        int[] selectedRows = this.table.getSelectedRows();
        for (int i = 0; i < selectedRows.length; ++i) {
            selectedRows[i] = this.table.convertRowIndexToModel(selectedRows[i]);
        }
        return selectedRows;
    }

    private Action getSaveAsAction() {
        return new AbstractAction("Save As..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataPointRecorder.this.saveAs();
            }
        };
    }

    private Action getSaveAction() {
        return new AbstractAction("Save"){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataPointRecorder.this.save();
            }
        };
    }

    private Action getClearSelectionAction() {
        return new AbstractAction("Clear Selection"){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataPointRecorder.this.table.getSelectionModel().clearSelection();
                DataPointRecorder.this.fireSelectedDataSetUpdateListenerDataSetUpdated(new DataSetUpdateEvent(this));
            }
        };
    }

    public boolean saveAs() {
        int status;
        JFileChooser jj = new JFileChooser();
        jj.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (pathname == null) {
                    return false;
                }
                if (pathname.isDirectory()) {
                    return true;
                }
                String fn = pathname.toString();
                if (fn == null) {
                    return false;
                }
                return fn.endsWith(".dat") || fn.endsWith(".txt");
            }

            @Override
            public String getDescription() {
                return "Flat Ascii Tables";
            }
        });
        String lastFileString = this.prefs.get("components.DataPointRecorder.lastFileSave", "");
        if (lastFileString.length() > 0) {
            File lastFile = new File(lastFileString);
            jj.setSelectedFile(lastFile);
        }
        if ((status = jj.showSaveDialog(this)) == 0) {
            try {
                File pathname = jj.getSelectedFile();
                if (!pathname.toString().endsWith(".dat") && !pathname.toString().endsWith(".txt")) {
                    pathname = new File(pathname.getAbsolutePath() + ".dat");
                }
                this.saveFile = pathname;
                this.saveToFile(this.saveFile);
            }
            catch (IOException e1) {
                DasApplication.getDefaultApplication().getExceptionHandler().handle(e1);
                return false;
            }
        } else if (status == 1) {
            return false;
        }
        return true;
    }

    public boolean save() {
        if (this.saveFile == null) {
            return this.saveAs();
        }
        try {
            this.saveToFile(this.saveFile);
            return true;
        }
        catch (IOException ex) {
            DasApplication.getDefaultApplication().getExceptionHandler().handle(ex);
            return false;
        }
    }

    public File getCurrentFile() {
        return this.saveFile;
    }

    public boolean saveBeforeExit() {
        if (this.modified) {
            int i = JOptionPane.showConfirmDialog(this, "Save changes before exiting?");
            switch (i) {
                case 0: {
                    return this.save();
                }
                case 2: {
                    return false;
                }
            }
            return true;
        }
        return true;
    }

    private Action getLoadAction() {
        return new AbstractAction("Open..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DataPointRecorder.this.checkModified(e)) {
                    int status;
                    JFileChooser jj = new JFileChooser();
                    String lastFileString = DataPointRecorder.this.prefs.get("components.DataPointRecorder.lastFileLoad", "");
                    if (lastFileString.length() > 0) {
                        File lastFile = new File(lastFileString);
                        jj.setSelectedFile(lastFile);
                    }
                    if ((status = jj.showOpenDialog(DataPointRecorder.this)) == 0) {
                        final File loadFile = jj.getSelectedFile();
                        DataPointRecorder.this.prefs.put("components.DataPointRecorder.lastFileLoad", loadFile.toString());
                        Runnable run = new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    DataPointRecorder.this.loadFromFile(loadFile);
                                    DataPointRecorder.this.updateStatus();
                                }
                                catch (IOException e) {
                                    DasApplication.getDefaultApplication().getExceptionHandler().handle(e);
                                }
                            }
                        };
                        new Thread(run).start();
                    }
                }
            }
        };
    }

    private boolean checkModified(ActionEvent e) {
        if (this.modified) {
            int n = JOptionPane.showConfirmDialog(this, "Current work has not been saved.\n  Save first?", "Save work first", 1);
            if (n == 0) {
                this.getSaveAction().actionPerformed(e);
            }
            return n != 2;
        }
        return true;
    }

    private Action getNewAction() {
        return new AbstractAction("New"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DataPointRecorder.this.checkModified(e)) {
                    DataPointRecorder.this.dataPoints.clear();
                    DataPointRecorder.this.saveFile = null;
                    DataPointRecorder.this.updateStatus();
                    DataPointRecorder.this.updateClients();
                    DataPointRecorder.this.fireDataSetUpdateListenerDataSetUpdated(new DataSetUpdateEvent(DataPointRecorder.this));
                    DataPointRecorder.this.table.repaint();
                }
            }
        };
    }

    private Action getPropertiesAction() {
        return new AbstractAction("Properties"){

            @Override
            public void actionPerformed(ActionEvent e) {
                new PropertyEditor(DataPointRecorder.this).showDialog(DataPointRecorder.this);
            }
        };
    }

    private Action getUpdateAction() {
        return new AbstractAction("Update"){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataPointRecorder.this.update();
            }
        };
    }

    private Action getDeleteSelectedAction() {
        return new AbstractAction("Delete Selected"){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selectedRows = DataPointRecorder.this.getSelectedRowsInModel();
                DataPointRecorder.this.deleteRows(selectedRows);
            }
        };
    }

    private Action getSetUnitsAction() {
        return new AbstractAction("Reset Units"){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataPointRecorder.this.editUnits();
            }
        };
    }

    private void editUnits() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        int i = 0;
        JComboBox[] cbs = new JComboBox[this.unitsArray.length];
        for (Units u : this.unitsArray) {
            JLabel l = new JLabel("column " + this.planesArray[i] + ": " + u);
            p.add(l);
            JComboBox<String> c = new JComboBox<String>();
            c.setEditable(false);
            Units[] uu = u.getConvertibleUnits();
            String[] ss = new String[uu.length];
            for (int j = 0; j < uu.length; ++j) {
                ss[j] = uu[j].toString();
            }
            DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>(ss);
            c.setModel(model);
            c.setSelectedItem(u);
            cbs[i] = c;
            p.add(c);
            ++i;
        }
        if (JOptionPane.showConfirmDialog(this, p, "Reset Units", 2) == 0) {
            for (i = 0; i < this.unitsArray.length; ++i) {
                this.unitsArray[i] = Units.lookupUnits(cbs[i].getSelectedItem().toString());
            }
            this.myTableModel.fireTableDataChanged();
            this.myTableModel.fireTableStructureChanged();
        }
    }

    private Action getInsertFillAction() {
        return new AbstractAction("Insert Fill..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                if ((e.getModifiers() & 1) == 1) {
                    DataPointRecorder.this.insertFill(true);
                } else {
                    int index = DataPointRecorder.this.table.getSelectedRow();
                    if (index == -1) {
                        JOptionPane.showMessageDialog(DataPointRecorder.this, "Row must be selected");
                        return;
                    }
                    if (0 == JOptionPane.showConfirmDialog(DataPointRecorder.this, "Insert a fill record into in data?", "Insert Fill", 2)) {
                        DataPointRecorder.this.insertFill(false);
                    }
                }
            }
        };
    }

    private void insertFill(boolean appendToEnd) {
        int index;
        LinkedHashMap<String, Datum> planes = new LinkedHashMap<String, Datum>();
        int icol = 0;
        for (String p : this.planesArray) {
            planes.put(p, this.unitsArray[icol].getFillDatum());
            ++icol;
        }
        DataPoint fill = new DataPoint(this.unitsArray[0].getFillDatum(), this.unitsArray[1].getFillDatum(), planes);
        if (appendToEnd) {
            index = this.table.getRowCount();
        } else {
            index = this.table.getSelectedRow();
            if (index == -1) {
                throw new IllegalArgumentException("Row must be selected");
            }
            index = this.table.convertRowIndexToModel(index);
        }
        this.dataPoints.add(index, fill);
        this.modified = true;
        Runnable run = new Runnable(){

            @Override
            public void run() {
                DataPointRecorder.this.updateStatus();
                DataPointRecorder.this.updateClients();
                DataPointRecorder.this.table.repaint();
                if (DataPointRecorder.this.active) {
                    DataPointRecorder.this.fireDataSetUpdateListenerDataSetUpdated(new DataSetUpdateEvent(this));
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            SwingUtilities.invokeLater(run);
        }
    }

    public void update() {
        if (this.dataSetDescriptor != null) {
            this.dataSetDescriptor.fireUpdate();
        }
        this.fireDataSetUpdateListenerDataSetUpdated(new DataSetUpdateEvent(this));
        this.fireSelectedDataSetUpdateListenerDataSetUpdated(new DataSetUpdateEvent(this));
    }

    public DataPointRecorder() {
        this.planesArrayLock = new Object();
        this.dataPoints = new ArrayList();
        this.myTableModel = new MyTableModel();
        this.setLayout(new BorderLayout());
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.add(new JMenuItem(this.getNewAction()));
        fileMenu.add(new JMenuItem(this.getLoadAction()));
        fileMenu.add(new JMenuItem(this.getSaveAction()));
        fileMenu.add(new JMenuItem(this.getSaveAsAction()));
        menuBar.add(fileMenu);
        JMenu editMenu = new JMenu("Edit");
        editMenu.add(new JMenuItem(this.getPropertiesAction()));
        editMenu.add(new JMenuItem(this.getSetUnitsAction()));
        JMenuItem i = new JMenuItem(this.getInsertFillAction());
        i.setToolTipText("insert a fill record (interrupts data cadence) at the selected row, or hold shift to append a fill record.");
        editMenu.add(i);
        editMenu.add(new JMenuItem(new AbstractAction("Clear Table Sorting"){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataPointRecorder.this.table.setAutoCreateRowSorter(false);
                DataPointRecorder.this.table.setAutoCreateRowSorter(true);
            }
        }));
        menuBar.add(editMenu);
        this.add((Component)menuBar, "North");
        this.planesArray = new String[]{"X", "Y"};
        this.unitsArray = new Units[]{null, null};
        this.table = new JTable(this.myTableModel);
        this.table.setAutoCreateRowSorter(true);
        this.table.getTableHeader().setReorderingAllowed(true);
        this.table.setColumnModel(new DefaultTableColumnModel(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getColumnCount() {
                Object object = DataPointRecorder.this.planesArrayLock;
                synchronized (object) {
                    return super.getColumnCount();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public TableColumn getColumn(int columnIndex) {
                Object object = DataPointRecorder.this.planesArrayLock;
                synchronized (object) {
                    return super.getColumn(columnIndex);
                }
            }
        });
        this.table.setRowSelectionAllowed(true);
        this.table.addMouseListener(new MyMouseAdapter(this.table));
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DataPointRecorder.this.fireSelectedDataSetUpdateListenerDataSetUpdated(new DataSetUpdateEvent(DataPointRecorder.this));
                int selected = DataPointRecorder.this.table.getSelectedRow();
                if (selected > -1) {
                    selected = DataPointRecorder.this.table.convertRowIndexToModel(selected);
                    DataPoint dp = (DataPoint)DataPointRecorder.this.dataPoints.get(selected);
                    HashMap<String, Object> planes = new HashMap<String, Object>();
                    for (int i = 2; i < DataPointRecorder.this.planesArray.length; ++i) {
                        planes.put(DataPointRecorder.this.planesArray[i], dp.getPlane(DataPointRecorder.this.planesArray[i]));
                    }
                    DataPointSelectionEvent e2 = new DataPointSelectionEvent(DataPointRecorder.this, dp.get(0), dp.get(1), planes);
                    DataPointRecorder.this.fireDataPointSelectionListenerDataPointSelected(e2);
                }
                Runnable run = new Runnable(){

                    @Override
                    public void run() {
                        DataPointRecorder.this.deleteSelectionButton.setEnabled(DataPointRecorder.this.table.getSelectedRowCount() > 0);
                        DataPointRecorder.this.clearSelectionButton.setEnabled(DataPointRecorder.this.table.getSelectedRowCount() > 0);
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    run.run();
                } else {
                    SwingUtilities.invokeLater(run);
                }
            }
        });
        this.scrollPane = new JScrollPane(this.table);
        this.add((Component)this.scrollPane, "Center");
        JPanel controlStatusPanel = new JPanel();
        controlStatusPanel.setLayout(new BoxLayout(controlStatusPanel, 1));
        JPanel controlPanel = new JPanel();
        controlPanel.setLayout(new BoxLayout(controlPanel, 0));
        this.updateButton = new JButton(this.getUpdateAction());
        this.updateButton.setVisible(false);
        this.updateButton.setEnabled(false);
        controlPanel.add(this.updateButton);
        this.clearSelectionButton = new JButton(this.getClearSelectionAction());
        controlPanel.add(this.clearSelectionButton);
        this.deleteSelectionButton = new JButton(this.getDeleteSelectedAction());
        controlPanel.add(this.deleteSelectionButton);
        controlPanel.add(Box.createGlue());
        this.accessoryPanel = new JPanel(new BorderLayout());
        controlPanel.add(this.accessoryPanel);
        this.messageLabel = new JLabel("ready");
        this.messageLabel.setAlignmentX(0.0f);
        controlStatusPanel.add(this.messageLabel);
        controlPanel.setAlignmentX(0.0f);
        controlStatusPanel.add(controlPanel);
        this.add((Component)controlStatusPanel, "South");
    }

    public static DataPointRecorder createFramed() {
        JFrame frame = new JFrame("Data Point Recorder");
        DataPointRecorder result = new DataPointRecorder();
        frame.getContentPane().add(result);
        frame.pack();
        frame.setVisible(true);
        frame.setDefaultCloseOperation(1);
        return result;
    }

    public void addAccessory(JComponent c) {
        this.accessoryPanel.add(c);
    }

    private void updateClients() {
        if (this.active) {
            this.myTableModel.fireTableDataChanged();
            if (this.selectRow != -1 && this.table.getRowCount() > this.selectRow) {
                int i = this.table.convertRowIndexToView(this.selectRow);
                this.table.setRowSelectionInterval(i, i);
                this.table.scrollRectToVisible(this.table.getCellRect(i, 0, true));
                this.selectRow = -1;
            }
            this.table.repaint();
        }
    }

    private void updateStatus() {
        String t;
        String statusString = (this.saveFile == null ? "" : String.valueOf(this.saveFile) + " ") + (this.modified ? "(modified)" : "");
        if (!statusString.equals(t = this.messageLabel.getText())) {
            this.messageLabel.setText(statusString);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void insertInternal(DataPoint newPoint) {
        List list = this.dataPoints;
        synchronized (list) {
            int newSelect;
            Set keys = newPoint.planes.keySet();
            int ikey = 2;
            for (String key : keys) {
                Object o = newPoint.planes.get(key);
                if (o instanceof QDataSet) {
                    QDataSet qds = (QDataSet)o;
                    if (qds.rank() > 0) {
                        throw new IllegalArgumentException("QDataSet rank must be zero: " + key + "=" + o);
                    }
                    Datum d = DataSetUtil.asDatum((QDataSet)o);
                    if (!d.getUnits().isConvertibleTo(this.unitsArray[ikey])) {
                        throw new IllegalArgumentException("Units are not convertible: " + key + "=" + d + ", expected " + this.unitsArray[ikey]);
                    }
                    newPoint.planes.put(key, d);
                } else if (o instanceof Datum) {
                    Datum d = (Datum)o;
                    if (!d.getUnits().isConvertibleTo(this.unitsArray[ikey])) {
                        if (!(this.unitsArray[ikey] instanceof EnumerationUnits)) throw new IllegalArgumentException("Units are not convertible: " + key + "=" + d + ", expected " + this.unitsArray[ikey]);
                        ((EnumerationUnits)this.unitsArray[ikey]).createDatum(d.toString());
                    }
                } else if (o instanceof String) {
                    newPoint.planes.put(key, ((EnumerationUnits)this.unitsArray[ikey]).createDatum(o));
                } else if (o instanceof Number) {
                    newPoint.planes.put(key, this.unitsArray[ikey].createDatum((Number)o));
                }
                ++ikey;
            }
            if (this.sorted) {
                int index;
                if (this.dataPoints.size() > 2) {
                    Units off = ((DataPoint)this.dataPoints.get((int)0)).data[0].getUnits().getOffsetUnits();
                    Datum doff = off.createDatum(0);
                    for (int i = 1; i < this.dataPoints.size(); ++i) {
                        DataPoint p1 = (DataPoint)this.dataPoints.get(i);
                        DataPoint p0 = (DataPoint)this.dataPoints.get(i - 1);
                        if (!p1.data[0].subtract(p0.data[0]).lt(doff)) continue;
                        logger.fine("here not sorted");
                    }
                }
                if ((index = Collections.binarySearch(this.dataPoints, newPoint)) < 0) {
                    DataPoint dp0 = null;
                    if (~index < this.dataPoints.size()) {
                        dp0 = (DataPoint)this.dataPoints.get(~index);
                        keys = newPoint.planes.keySet();
                        for (String key : keys) {
                            if (dp0.planes.containsKey(key)) continue;
                            logger.log(Level.FINE, "no place to put key: {0}", key);
                        }
                    }
                    DataPoint dp1 = null;
                    if (~index + 1 < this.dataPoints.size()) {
                        dp1 = (DataPoint)this.dataPoints.get(~index + 1);
                    }
                    Datum epsilon = Units.microseconds.createDatum(100);
                    if (newPoint.data[0].getUnits().getOffsetUnits().isConvertibleTo(Units.milliseconds)) {
                        if (dp0 != null && dp0.data[0].subtract(newPoint.data[0]).abs().lt(epsilon)) {
                            this.dataPoints.set(~index, newPoint);
                        } else if (dp1 != null && dp1.data[0].subtract(newPoint.data[0]).abs().lt(epsilon)) {
                            this.dataPoints.set(~index + 1, newPoint);
                        } else {
                            this.dataPoints.add(~index, newPoint);
                        }
                    } else {
                        this.dataPoints.add(~index, newPoint);
                    }
                    newSelect = ~index;
                } else {
                    this.dataPoints.set(index, newPoint);
                    newSelect = index;
                }
                logger.log(Level.FINER, "dataPoints.size()={0}", this.dataPoints.size());
            } else {
                boolean insertCheck = false;
                if (this.table.getSelectedRows().length == 1 && insertCheck) {
                    int[] isel = this.getSelectedRowsInModel();
                    newSelect = isel[0] + 1;
                    if (newSelect == this.dataPoints.size()) {
                        this.dataPoints.add(newPoint);
                    } else {
                        this.dataPoints.add(newSelect, newPoint);
                    }
                } else {
                    this.dataPoints.add(newPoint);
                    newSelect = this.dataPoints.size() - 1;
                }
                logger.log(Level.FINER, "dataPoints.size()={0}", this.dataPoints.size());
            }
            this.selectRow = newSelect;
        }
        this.modified = true;
        if (!SwingUtilities.isEventDispatchThread()) return;
        this.updateStatus();
        this.updateClients();
        this.table.repaint();
    }

    public void addDataPoint(QDataSet ds) {
        Datum x = DataSetUtil.asDatum(ds.slice(0));
        Datum y = DataSetUtil.asDatum(ds.slice(1));
        LinkedHashMap<String, Datum> planes = new LinkedHashMap<String, Datum>();
        String[] planeNames = DataSetUtil.bundleNames(ds);
        for (int i = 2; i < ds.length(); ++i) {
            QDataSet d = ds.slice(i);
            planes.put(planeNames[i], DataSetUtil.asDatum(d));
        }
        this.addDataPoint(x, y, planes);
    }

    public void addDataPoint(Datum x, Datum y) {
        this.addDataPoint(x, y, null);
    }

    public void addDataPoint(double x, double y) {
        this.addDataPoint(Units.dimensionless.createDatum(x), Units.dimensionless.createDatum(y), null);
    }

    public void addDataPoint(double x, double y, Map planes) {
        this.addDataPoint(Units.dimensionless.createDatum(x), Units.dimensionless.createDatum(y), planes);
    }

    public void addDataPoint(Datum x, Datum y, Object meta) {
        this.addDataPoint(x, y, Collections.singletonMap("meta", meta));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDataPoint(Datum x, Datum y, Map planes) {
        List list = this.dataPoints;
        synchronized (list) {
            if (planes == null) {
                planes = new LinkedHashMap();
            }
            if (this.dataPoints.isEmpty()) {
                this.unitsArray = new Units[2 + planes.size()];
                this.unitsArray[0] = x.getUnits();
                this.unitsArray[1] = y.getUnits();
                this.planesArray = new String[2 + planes.size()];
                this.planesArray[0] = "x";
                this.planesArray[1] = "y";
                int index = 2;
                for (Map.Entry entry : planes.entrySet()) {
                    Object key = entry.getKey();
                    this.planesArray[index] = String.valueOf(key).trim();
                    Object value = entry.getValue();
                    if (value instanceof String) {
                        this.unitsArray[index] = EnumerationUnits.create("default");
                    } else if (value instanceof Datum) {
                        this.unitsArray[index] = ((Datum)value).getUnits();
                    } else if (value instanceof QDataSet) {
                        QDataSet qds = (QDataSet)value;
                        if (qds.rank() > 0) {
                            throw new IllegalArgumentException("qdatasets in planes must be rank 0");
                        }
                        this.unitsArray[index] = SemanticOps.getUnits((QDataSet)value);
                    } else if (value instanceof Number) {
                        this.unitsArray[index] = Units.dimensionless;
                    } else {
                        throw new IllegalArgumentException("values must be rank 0 Datum or QDataSet, not " + value);
                    }
                    ++index;
                }
                this.myTableModel.fireTableStructureChanged();
                for (int i = 0; i < 1; ++i) {
                    if (!UnitsUtil.isTimeLocation(this.unitsArray[i])) continue;
                    this.table.getTableHeader().getColumnModel().getColumn(i).setMinWidth(180);
                }
            }
            if (!x.getUnits().isConvertibleTo(this.unitsArray[0])) {
                throw new RuntimeException("inconvertible units: got \"" + x.getUnits() + "\", expected \"" + this.unitsArray[0] + "\"");
            }
            if (!y.getUnits().isConvertibleTo(this.unitsArray[1])) {
                throw new RuntimeException("inconvertible units: got \"" + y.getUnits() + "\", expected \"" + this.unitsArray[1] + "\"");
            }
            this.insertInternal(new DataPoint(x, y, new LinkedHashMap(planes)));
        }
        if (this.active) {
            this.fireDataSetUpdateListenerDataSetUpdated(new DataSetUpdateEvent(this));
        }
    }

    public void appendDataSet(QDataSet ds) {
        throw new IllegalArgumentException("not supported");
    }

    public void addDataPoints(QDataSet ds) {
        boolean active0 = this.active;
        LinkedHashMap<String, Datum> planesMap = new LinkedHashMap<String, Datum>();
        if (ds.rank() != 2) {
            throw new IllegalArgumentException("dataset should be rank 2");
        }
        QDataSet dep0 = (QDataSet)ds.property("DEPEND_0");
        if (dep0 != null) {
            throw new IllegalArgumentException("dataset should not have DEPEND_0");
        }
        dep0 = Ops.slice1(ds, 0);
        this.xTagWidth = dep0.property("CADENCE") != null ? DataSetUtil.asDatum((QDataSet)dep0.property("CADENCE")) : Datum.create(0);
        String[] planes = DataSetUtil.bundleNames(ds);
        for (int i = 0; i < ds.length(); ++i) {
            for (int j = 2; j < planes.length; ++j) {
                if (planes[j].equals("")) continue;
                planesMap.put(planes[j], DataSetUtil.asDatum(DataSetOps.unbundle(ds, planes[j]).slice(i)));
            }
            this.addDataPoint(DataSetUtil.asDatum(ds.slice(i).slice(0)), DataSetUtil.asDatum(ds.slice(i).slice(1)), planesMap);
        }
        this.active = active0;
        this.updateClients();
    }

    public void appendDataSet(VectorDataSet ds) {
        LinkedHashMap<String, Object> planesMap = new LinkedHashMap<String, Object>();
        if (ds.getProperty("comment") != null) {
            planesMap.put("comment", ds.getProperty("comment"));
        }
        this.xTagWidth = ds.getProperty("xTagWidth") != null ? (Datum)ds.getProperty("xTagWidth") : Datum.create(0);
        String[] planes = ds.getPlaneIds();
        for (int i = 0; i < ds.getXLength(); ++i) {
            for (String plane : planes) {
                if (plane.equals("")) continue;
                planesMap.put(plane, ((VectorDataSet)ds.getPlanarView(plane)).getDatum(i));
            }
            this.addDataPoint(ds.getXTagDatum(i), ds.getDatum(i), planesMap);
        }
        this.updateClients();
    }

    public DataSetUpdateListener getAppendDataSetUpListener() {
        return new DataSetUpdateListener(){

            @Override
            public void dataSetUpdated(DataSetUpdateEvent e) {
                VectorDataSet ds = (VectorDataSet)((Object)e.getDataSet());
                if (ds == null) {
                    throw new RuntimeException("not supported, I need the DataSet in the update event");
                }
                DataPointRecorder.this.appendDataSet((VectorDataSet)((Object)e.getDataSet()));
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dataPointSelected(DataPointSelectionEvent e) {
        LinkedHashMap<String, Object> planesMap;
        if (e instanceof CommentDataPointSelectionEvent) {
            String comment = ((CommentDataPointSelectionEvent)e).getComment();
            planesMap = new LinkedHashMap();
            planesMap.put("comment", comment);
        } else {
            String[] x = e.getPlaneIds();
            planesMap = new LinkedHashMap<String, Object>();
            for (String x1 : x) {
                planesMap.put(x1, e.getPlane(x1));
            }
        }
        List list = this.dataPoints;
        synchronized (list) {
            Datum x = e.getX();
            if (this.snapToGrid && this.xTagWidth != null && this.xTagWidth.value() > 0.0 && !this.xTagWidth.isFill() && this.dataPoints.size() > 0) {
                QDataSet ds = this.getDataSet();
                QDataSet xds = (QDataSet)ds.property("DEPEND_0");
                Units xunits = SemanticOps.getUnits(xds);
                int i = DataSetUtil.closestIndex(xds, x);
                Datum diff = e.getX().subtract(xunits.createDatum(xds.value(i)));
                if (Math.abs(diff.divide(this.xTagWidth).doubleValue(Units.dimensionless)) < 0.5) {
                    x = xunits.createDatum(xds.value(i));
                }
            }
            this.addDataPoint(x, e.getY(), planesMap);
        }
        this.updateClients();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkUpdateEnable() {
        int selectedListenerListCount;
        int listenerList1Count;
        DataPointRecorder dataPointRecorder = this;
        synchronized (dataPointRecorder) {
            listenerList1Count = this.listenerList1 == null ? 0 : this.listenerList1.getListenerCount();
            selectedListenerListCount = this.selectedListenerList == null ? 0 : this.selectedListenerList.getListenerCount();
        }
        if (listenerList1Count > 0 || selectedListenerListCount > 0) {
            this.updateButton.setEnabled(true);
            this.updateButton.setVisible(true);
            this.updateButton.setToolTipText(null);
            return true;
        }
        this.updateButton.setEnabled(false);
        this.updateButton.setToolTipText("no listeners. See File->Save to save table.");
        this.updateButton.setVisible(false);
        return false;
    }

    public void addDataSetUpdateListener(DataSetUpdateListener listener) {
        this.listenerList1.add(DataSetUpdateListener.class, listener);
        this.checkUpdateEnable();
    }

    public void removeDataSetUpdateListener(DataSetUpdateListener listener) {
        this.listenerList1.remove(DataSetUpdateListener.class, listener);
        this.checkUpdateEnable();
    }

    private void fireDataSetUpdateListenerDataSetUpdated(DataSetUpdateEvent event) {
        Object[] listeners = this.listenerList1.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DataSetUpdateListener.class) continue;
            ((DataSetUpdateListener)listeners[i + 1]).dataSetUpdated(event);
        }
    }

    public void addSelectedDataSetUpdateListener(DataSetUpdateListener listener) {
        this.selectedListenerList.add(DataSetUpdateListener.class, listener);
        this.checkUpdateEnable();
    }

    public void removeSelectedDataSetUpdateListener(DataSetUpdateListener listener) {
        this.selectedListenerList.remove(DataSetUpdateListener.class, listener);
        this.checkUpdateEnable();
    }

    private void fireSelectedDataSetUpdateListenerDataSetUpdated(DataSetUpdateEvent event) {
        Object[] listeners = this.selectedListenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DataSetUpdateListener.class) continue;
            ((DataSetUpdateListener)listeners[i + 1]).dataSetUpdated(event);
        }
    }

    public boolean isSorted() {
        return this.sorted;
    }

    public void setSorted(boolean sorted) {
        this.sorted = sorted;
    }

    public void addDataPointSelectionListener(DataPointSelectionListener listener) {
        if (this.listenerList1 == null) {
            this.listenerList1 = new EventListenerList();
        }
        this.listenerList1.add(DataPointSelectionListener.class, listener);
    }

    public void removeDataPointSelectionListener(DataPointSelectionListener listener) {
        this.listenerList1.remove(DataPointSelectionListener.class, listener);
    }

    private void fireDataPointSelectionListenerDataPointSelected(DataPointSelectionEvent event) {
        Object[] listeners = this.listenerList1.getListenerList();
        logger.fine("firing data point selection event");
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DataPointSelectionListener.class) continue;
            ((DataPointSelectionListener)listeners[i + 1]).dataPointSelected(event);
        }
    }

    public Datum getXTagWidth() {
        return this.xTagWidth;
    }

    public void setXTagWidth(Datum xTagWidth) {
        this.xTagWidth = xTagWidth;
    }

    public boolean isSnapToGrid() {
        return this.snapToGrid;
    }

    public void setSnapToGrid(boolean snapToGrid) {
        this.snapToGrid = snapToGrid;
    }

    public String getTimeFormat() {
        return this.timeFormat;
    }

    public void setTimeFormat(String timeFormat) {
        if (timeFormat == null) {
            timeFormat = "";
        }
        this.timeFormat = timeFormat;
        this.timeFormatter = timeFormat.length() == 0 ? null : TimeParser.create(timeFormat);
    }

    public boolean isModified() {
        return this.modified;
    }

    public static class DataPoint
    implements Comparable {
        Datum[] data;
        Map planes;

        public DataPoint(Datum x1, Datum x2, Map planes) {
            this(new Datum[]{x1, x2}, planes);
        }

        public DataPoint(Datum[] data, Map planes) {
            this.data = data;
            this.planes = planes;
        }

        Datum get(int i) {
            return this.data[i];
        }

        Object getPlane(String name) {
            return this.planes.get(name.trim());
        }

        public int compareTo(Object o) {
            DataPoint that = (DataPoint)o;
            Datum myt = this.data[0];
            Datum xt = that.data[0].convertTo(myt.getUnits());
            Datum diff = myt.subtract(xt);
            if (myt.getUnits() instanceof TimeLocationUnits) {
                double micros = diff.doubleValue(Units.microseconds);
                if (micros < -100.0) {
                    return -1;
                }
                if (micros > 100.0) {
                    return 1;
                }
                return 0;
            }
            Units u = myt.getUnits().getOffsetUnits();
            double delta = diff.doubleValue(u);
            if (delta < 0.0) {
                return -1;
            }
            if (delta > 0.0) {
                return 1;
            }
            return 0;
        }

        public int hashCode() {
            int hash = 7;
            hash = 97 * hash + Arrays.deepHashCode(this.data);
            hash = 97 * hash + (this.planes != null ? this.planes.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object o) {
            if (!(o instanceof DataPoint)) {
                return false;
            }
            return this.compareTo(o) == 0;
        }

        public String toString() {
            StringBuilder result = new StringBuilder("" + this.data[0] + " " + this.data[1]);
            if (this.planes != null) {
                for (Object key : this.planes.keySet()) {
                    result.append(" ").append(this.planes.get(key));
                }
            }
            return result.toString();
        }
    }

    private class MyDataSetDescriptor
    extends DataSetDescriptor {
        MyDataSetDescriptor() {
            super(null);
        }

        public void fireUpdate() {
            this.fireDataSetUpdateEvent(new DataSetUpdateEvent(this));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected DataSet getDataSetImpl(Datum s1, Datum s2, Datum s3, ProgressMonitor monitor) throws DasException {
            List list = DataPointRecorder.this.dataPoints;
            synchronized (list) {
                if (DataPointRecorder.this.dataPoints.isEmpty()) {
                    return null;
                }
                VectorDataSetBuilder builder = new VectorDataSetBuilder(DataPointRecorder.this.unitsArray[0], DataPointRecorder.this.unitsArray[1]);
                for (int irow = 0; irow < DataPointRecorder.this.dataPoints.size(); ++irow) {
                    DataPoint dp = (DataPoint)DataPointRecorder.this.dataPoints.get(irow);
                    builder.insertY(dp.get(0), dp.get(1));
                }
                return builder.toVectorDataSet();
            }
        }

        @Override
        public Units getXUnits() {
            return DataPointRecorder.this.unitsArray[0];
        }
    }

    private class MyMouseAdapter
    extends MouseAdapter {
        JPopupMenu popup;
        JMenuItem menuItem;
        final JTable parent;

        MyMouseAdapter(JTable parent) {
            this.parent = parent;
            this.popup = new JPopupMenu("Options");
            this.menuItem = new JMenuItem("Delete Row(s)");
            this.menuItem.setAction(DataPointRecorder.this.getDeleteSelectedAction());
            this.popup.add(this.menuItem);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 3) {
                int rowCount = this.parent.getSelectedRows().length;
                this.menuItem.setText("Delete " + rowCount + " Row" + (rowCount != 1 ? "s" : ""));
                this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }

    private class MyTableModel
    extends AbstractTableModel {
        private MyTableModel() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int getColumnCount() {
            Object object = DataPointRecorder.this.planesArrayLock;
            synchronized (object) {
                if (DataPointRecorder.this.unitsArray == null) {
                    return 2;
                }
                return DataPointRecorder.this.planesArray.length;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getColumnName(int j) {
            Object object = DataPointRecorder.this.planesArrayLock;
            synchronized (object) {
                String result = DataPointRecorder.this.planesArray[j];
                if (DataPointRecorder.this.unitsArray[j] != null) {
                    if (DataPointRecorder.this.unitsArray[j] instanceof EnumerationUnits) {
                        result = result + "(ordinal)";
                    } else if (UnitsUtil.isTimeLocation(DataPointRecorder.this.unitsArray[j])) {
                        result = result + "(UTC)";
                    } else if (DataPointRecorder.this.unitsArray[j] != Units.dimensionless) {
                        result = result + "(" + DataPointRecorder.this.unitsArray[j] + ")";
                    }
                }
                return result;
            }
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return Datum.class;
        }

        @Override
        public int getRowCount() {
            int nrow = DataPointRecorder.this.dataPoints.size();
            return nrow;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object getValueAt(int i, int j) {
            DataPoint x;
            List list = DataPointRecorder.this.dataPoints;
            synchronized (list) {
                if (i >= DataPointRecorder.this.dataPoints.size()) {
                    i = DataPointRecorder.this.dataPoints.size() - 1;
                }
                x = (DataPoint)DataPointRecorder.this.dataPoints.get(i);
            }
            if (j < x.data.length) {
                Datum d = x.get(j);
                if (j == 0 && DataPointRecorder.this.timeFormatter != null && UnitsUtil.isTimeLocation(d.getUnits())) {
                    return DataPointRecorder.this.timeFormatter.format(d);
                }
                if (d.isFill()) {
                    return "fill";
                }
                return d.getFormatter().format(d, DataPointRecorder.this.unitsArray[j]);
            }
            Object o = x.getPlane(DataPointRecorder.this.planesArray[j]);
            if (o instanceof Datum) {
                Datum d = (Datum)o;
                if (d.isFill()) {
                    return "fill";
                }
                return d.getFormatter().format(d, DataPointRecorder.this.unitsArray[j]);
            }
            return (String)o;
        }
    }
}

