/*
 * Decompiled with CFR 0.152.
 */
package org.das2.components;

import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.GeneralPath;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.das2.DasApplication;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.AbstractProgressMonitor;

public class DasProgressWheel
extends AbstractProgressMonitor {
    private static final Logger logger = LoggerManager.getLogger("das2.graphics.progress");
    private static final int SIZE = 16;
    private static final int HIDE_MS = 300;
    JComponent thePanel;
    JComponent theParent;
    int c = 0;
    Timer timer;
    long t0 = System.currentTimeMillis();

    private void init() {
        Container parentComponent = this.thePanel.getParent();
        if (parentComponent != null) {
            int x = 0;
            int y = 0;
            this.thePanel.setLocation(x, y);
        }
        this.timer = new Timer(100, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ++DasProgressWheel.this.c;
                DasProgressWheel.this.thePanel.repaint();
                logger.finest("repaint");
            }
        });
        this.timer.setRepeats(true);
        this.timer.start();
    }

    @Override
    public void finished() {
        super.finished();
        if (this.timer != null) {
            this.timer.stop();
        }
        Runnable run = new Runnable(){

            @Override
            public void run() {
                if (DasProgressWheel.this.thePanel != null) {
                    DasProgressWheel.this.thePanel.setVisible(false);
                }
                if (DasProgressWheel.this.theParent != null) {
                    DasProgressWheel.this.theParent.remove(DasProgressWheel.this.thePanel);
                    DasProgressWheel.this.theParent.repaint();
                }
            }
        };
        SwingUtilities.invokeLater(run);
    }

    @Override
    public void cancel() {
        super.cancel();
        this.timer.stop();
        this.finished();
    }

    public JComponent getPanel(JComponent parent) {
        if (this.thePanel == null && !this.isFinished() && !this.isCancelled()) {
            this.thePanel = new MyPanel();
            this.thePanel.setBounds(new Rectangle(0, 0, 16, 16));
            parent.add(this.thePanel);
            this.theParent = parent;
            this.init();
        }
        return this.thePanel;
    }

    class MyPanel
    extends JComponent {
        MyPanel() {
        }

        @Override
        protected void paintComponent(Graphics g1) {
            if (DasApplication.getDefaultApplication().isHeadless()) {
                logger.info("suppressing paintComponent because graphics is headless.");
                return;
            }
            Graphics2D g2 = (Graphics2D)g1;
            String txt = "" + DasProgressWheel.this.getTaskProgress() + " of " + DasProgressWheel.this.getTaskSize();
            g2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            logger.log(Level.FINEST, "painting {0}", txt);
            Color c = Color.BLUE;
            g2.setColor(c);
            g2.getClip();
            int r = 8;
            if (System.currentTimeMillis() - DasProgressWheel.this.t0 < 300L) {
                return;
            }
            double a = (double)(System.currentTimeMillis() - DasProgressWheel.this.t0) / 5000.0 * 2.0 * Math.PI;
            double da = 0.5235987755982988;
            GeneralPath gp = new GeneralPath();
            gp.moveTo((float)((double)r - (double)r * Math.cos(a + da)), (float)((double)r - (double)r * Math.sin(a + da)));
            gp.lineTo((float)((double)r + (double)r * Math.cos(a + da)), (float)((double)r + (double)r * Math.sin(a + da)));
            gp.lineTo((float)((double)r + (double)r * Math.cos(a - da)), (float)((double)r + (double)r * Math.sin(a - da)));
            gp.lineTo((float)((double)r - (double)r * Math.cos(a - da)), (float)((double)r - (double)r * Math.sin(a - da)));
            gp.lineTo((float)((double)r - (double)r * Math.cos(a + da)), (float)((double)r - (double)r * Math.sin(a + da)));
            g2.fill(gp);
            this.setToolTipText("<html>" + txt + "<br><b>" + DasProgressWheel.this.getLabel() + "</b><br>" + DasProgressWheel.this.getProgressMessage());
            super.paintComponent(g1);
        }
    }
}

