/*
 * Decompiled with CFR 0.152.
 */
package org.das2.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.das2.graph.DasCanvas;
import org.das2.graph.DasCanvasComponent;
import org.das2.system.DasLogger;
import org.das2.util.NumberFormatUtil;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.das2.util.monitor.SubTaskMonitor;

public class DasProgressPanel
implements ProgressMonitor {
    private static final Logger logger = DasLogger.getLogger(DasLogger.SYSTEM_LOG);
    public static final String MSG_CANCEL_TASK = "cancel task";
    public static final String MSG_TASK_CANNOT_BE_CANCELED = "task cannot be cancelled";
    private static final int PROGRESS_MESSAGE_LEN_LIMIT = 40;
    private static final int LABEL_LEN_LIMIT = 34;
    private long taskStartedTime;
    private long currentTaskPosition;
    private long maximumTaskPosition;
    private DecimalFormat transferRateFormat;
    private String transferRateString;
    private JLabel taskLabel;
    private boolean labelDirty = false;
    private JLabel progressMessageLabel;
    private String progressMessageString;
    private boolean progressMessageDirty = false;
    private JLabel kbLabel;
    private JProgressBar progressBar;
    private Window jframe = null;
    private boolean isCancelled = false;
    private JButton cancelButton;
    private int cancelCheckFailures = 2;
    private boolean cancelChecked = false;
    private String label;
    private static final int hideInitiallyMilliSeconds = 300;
    private static final int refreshPeriodMilliSeconds = 500;
    private boolean running = false;
    private boolean finished = false;
    private Thread updateThread;
    private boolean showProgressRate;
    private JPanel thePanel;
    private boolean componentsInitialized = false;
    private DasCanvasComponent parentComponent;
    private DasCanvas parentCanvas;
    private Container removeFromComponent = null;
    private static int createComponentCount = 0;
    private String currentThreadName = null;
    private String units;
    private int unitsf = 1;
    Exception source;
    Exception consumer;
    ImageIcon cancel = new ImageIcon(DasProgressPanel.class.getResource("/images/icons/cancel14.png"));
    ImageIcon cancelGrey = new ImageIcon(DasProgressPanel.class.getResource("/images/icons/cancelGrey14.png"));
    StackTraceElement[] stackTrace = null;
    public static final String PROP_STARTED = "started";
    public static final String PROP_FINISHED = "finished";
    public static final String PROP_CANCELLED = "cancelled";
    private final transient PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    @Override
    public ProgressMonitor getSubtaskMonitor(int start, int end, String label) {
        if (label != null) {
            this.setProgressMessage(label);
        }
        if (this.isFinished()) {
            logger.info("getSubtaskMonitor called after finished");
            return new NullProgressMonitor();
        }
        return SubTaskMonitor.create(this, start, end, this.cancelCheckFailures < 2);
    }

    @Override
    public ProgressMonitor getSubtaskMonitor(String label) {
        if (label != null) {
            this.setProgressMessage(label);
        }
        if (this.isFinished()) {
            logger.info("getSubtaskMonitor called after finished");
            return new NullProgressMonitor();
        }
        return SubTaskMonitor.create(this, this.cancelCheckFailures < 2);
    }

    protected DasProgressPanel(String label) {
        this.label = label = this.abbrevateStringEllipsis(label, 34);
        this.transferRateFormat = NumberFormatUtil.getDecimalFormat();
        this.transferRateFormat.setMaximumFractionDigits(2);
        this.maximumTaskPosition = -1L;
        this.showProgressRate = true;
        this.isCancelled = false;
        this.running = false;
    }

    public Component getComponent() {
        if (!this.componentsInitialized) {
            this.initComponents();
        }
        return this.thePanel;
    }

    public static DasProgressPanel createComponentPanel(DasCanvasComponent component, String initialMessage) {
        DasProgressPanel progressPanel = new DasProgressPanel(initialMessage);
        progressPanel.parentComponent = component;
        return progressPanel;
    }

    public static DasProgressPanel createComponentPanel(DasCanvas canvas, String initialMessage) {
        DasProgressPanel progressPanel = new DasProgressPanel(initialMessage);
        progressPanel.parentCanvas = canvas;
        return progressPanel;
    }

    public boolean isValidateRoot() {
        return true;
    }

    public static DasProgressPanel createFramed(String label) {
        final DasProgressPanel result = new DasProgressPanel(label);
        Runnable run = new Runnable(){

            @Override
            public void run() {
                JFrame fr = new JFrame("Progress Monitor");
                result.jframe = fr;
                result.initComponents();
                fr.getContentPane().add(result.thePanel);
                fr.pack();
                fr.setVisible(false);
                fr.setDefaultCloseOperation(2);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            SwingUtilities.invokeLater(run);
        }
        return result;
    }

    public static DasProgressPanel createFramed(final Window parent, String label) {
        final DasProgressPanel result = new DasProgressPanel(label);
        Runnable run = new Runnable(){

            @Override
            public void run() {
                result.jframe = new JDialog(parent, "Progress Monitor");
                result.initComponents();
                JPanel lthePanel = result.thePanel;
                result.jframe.add(lthePanel);
                result.jframe.pack();
                result.jframe.setLocationRelativeTo(parent);
                result.jframe.setVisible(false);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            SwingUtilities.invokeLater(run);
        }
        return result;
    }

    @Override
    public void setLabel(String label) {
        this.label = label = this.abbrevateStringEllipsis(label, 34);
        this.labelDirty = true;
        if (this.thePanel != null) {
            this.thePanel.repaint();
        }
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    private void initComponents() {
        logger.log(Level.FINER, "createComponentCount={0}", ++createComponentCount);
        this.taskLabel = new JLabel();
        this.taskLabel.setOpaque(false);
        this.taskLabel.setFont(new Font("Dialog", 1, 14));
        this.taskLabel.setHorizontalAlignment(0);
        this.taskLabel.setText(this.label);
        logger.log(Level.FINE, "taskLabel: {0}", this.label);
        this.taskLabel.setAlignmentX(0.5f);
        this.progressMessageLabel = new JLabel(){

            @Override
            public void paint(Graphics g) {
                ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                super.paint(g);
            }
        };
        this.progressMessageLabel.setOpaque(false);
        this.progressMessageLabel.setFont(new Font("Dialog", 1, 8));
        this.progressMessageLabel.setHorizontalAlignment(0);
        this.progressMessageLabel.setText(" ");
        this.progressMessageLabel.setAlignmentX(0.5f);
        this.progressBar = new JProgressBar();
        this.progressBar.setOpaque(false);
        this.progressBar.setPreferredSize(new Dimension(220, 14));
        this.progressBar.setMaximumSize(this.progressBar.getPreferredSize());
        this.progressBar.setMinimumSize(this.progressBar.getPreferredSize());
        this.progressBar.setAlignmentX(0.5f);
        this.kbLabel = new JLabel();
        this.kbLabel.setOpaque(false);
        this.kbLabel.setHorizontalAlignment(0);
        this.kbLabel.setText("0 kb");
        this.kbLabel.setAlignmentX(0.5f);
        this.kbLabel.setMaximumSize(this.progressBar.getPreferredSize());
        this.kbLabel.setMinimumSize(this.progressBar.getPreferredSize());
        this.kbLabel.setPreferredSize(this.progressBar.getPreferredSize());
        this.kbLabel.setAlignmentX(0.5f);
        JPanel progressBarPanel = new JPanel(new BorderLayout());
        this.cancelButton = new JButton(this.cancelGrey);
        Dimension cs = new Dimension(20, 20);
        this.cancelButton.setMaximumSize(cs);
        this.cancelButton.setMinimumSize(cs);
        this.cancelButton.setPreferredSize(cs);
        this.cancelButton.setMargin(new Insets(2, 2, 2, 2));
        this.cancelButton.setToolTipText(MSG_TASK_CANNOT_BE_CANCELED);
        this.cancelButton.setEnabled(false);
        this.cancelButton.setIcon(this.cancelGrey);
        this.cancelButton.setVerticalAlignment(0);
        this.cancelButton.setOpaque(false);
        this.cancelButton.setFocusPainted(false);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DasProgressPanel.this.cancel();
            }
        });
        JPanel mainPanel = new JPanel();
        mainPanel.setOpaque(false);
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add(this.taskLabel);
        mainPanel.add(this.progressMessageLabel);
        progressBarPanel.add((Component)this.progressBar, "Center");
        progressBarPanel.add((Component)this.cancelButton, "East");
        mainPanel.add(progressBarPanel);
        mainPanel.add(this.kbLabel);
        this.thePanel = new MyPanel();
        this.thePanel.setOpaque(false);
        this.thePanel.setLayout(new BorderLayout());
        this.thePanel.add((Component)mainPanel, "Center");
        if (this.parentComponent != null) {
            this.thePanel.setSize(this.thePanel.getPreferredSize());
            int x = this.parentComponent.getColumn().getDMiddle();
            int y = this.parentComponent.getRow().getDMiddle();
            this.thePanel.setLocation(x - this.thePanel.getWidth() / 2, y - this.thePanel.getHeight() / 2);
            this.removeFromComponent = (Container)this.parentComponent.getCanvas().getGlassPane();
            this.removeFromComponent.add(this.thePanel);
            this.thePanel.setVisible(false);
        } else if (this.parentCanvas != null) {
            this.thePanel.setSize(this.thePanel.getPreferredSize());
            int x = this.parentCanvas.getWidth() / 2;
            int y = this.parentCanvas.getHeight() / 2;
            this.thePanel.setLocation(x - this.thePanel.getWidth() / 2, y - this.thePanel.getHeight() / 2);
            this.removeFromComponent = (Container)this.parentCanvas.getGlassPane();
            this.removeFromComponent.add(this.thePanel);
            this.thePanel.setVisible(false);
        } else {
            this.thePanel.setSize(this.thePanel.getPreferredSize());
        }
        this.componentsInitialized = true;
    }

    private void printStackTrace(StackTraceElement[] trace) {
        PrintStream s = System.err;
        for (StackTraceElement traceElement : trace) {
            s.println("\tat " + traceElement);
        }
    }

    @Override
    public synchronized void finished() {
        if (this.finished) {
            logger.warning("monitor finished was called twice!");
            logger.warning("here was the first call:");
            this.printStackTrace(this.stackTrace);
            logger.warning("... and the second call:");
            new Exception().printStackTrace();
        } else {
            logger.fine("enter monitor finished");
            this.stackTrace = Thread.currentThread().getStackTrace();
        }
        this.running = false;
        this.finished = true;
        Runnable run = new Runnable(){

            @Override
            public void run() {
                if (DasProgressPanel.this.removeFromComponent != null) {
                    DasProgressPanel.this.removeFromComponent.remove(DasProgressPanel.this.thePanel);
                    DasProgressPanel.this.removeFromComponent.invalidate();
                    DasProgressPanel.this.removeFromComponent.validate();
                    Rectangle b = DasProgressPanel.this.thePanel.getBounds();
                    DasProgressPanel.this.removeFromComponent.repaint(b.x, b.y, b.width, b.height);
                }
                if (DasProgressPanel.this.jframe == null) {
                    DasProgressPanel.this.setVisible(false);
                } else {
                    DasProgressPanel.this.jframe.setVisible(false);
                }
            }
        };
        SwingUtilities.invokeLater(run);
        this.propertyChangeSupport.firePropertyChange(PROP_FINISHED, false, true);
    }

    @Override
    public void setTaskProgress(long position) throws IllegalStateException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "progressPosition={0}", position);
        }
        if (this.isCancelled) {
            boolean cancelEnabled;
            logger.fine("setTaskProgress called when isCancelled true. consider checking isCancelled before calling setTaskProgress.");
            boolean bl = cancelEnabled = this.cancelCheckFailures < 2;
            if (!cancelEnabled) {
                throw new IllegalStateException("Operation cancelled: developers: consider checking isCancelled before calling setTaskProgress.");
            }
            logger.fine("setTaskProgress but isCancelled, assuming its okay to ignore.");
            return;
        }
        if (!this.running) {
            if (this.finished) {
                throw new IllegalStateException("setTaskProgress called after finished");
            }
            throw new IllegalStateException("setTaskProgress called before started");
        }
        if (position != 0L && position < this.currentTaskPosition) {
            logger.finest("progress position goes backwards, this is allowed.");
        }
        if (!this.cancelChecked) {
            ++this.cancelCheckFailures;
            logger.log(Level.FINER, "cancelCheckFailures={0}", this.cancelCheckFailures);
        }
        this.cancelChecked = false;
        if (this.maximumTaskPosition == 0L) {
            logger.fine("setTaskProgress called when taskSize is 0, just letting you know.");
        }
        this.currentTaskPosition = position;
        long elapsedTimeMs = System.currentTimeMillis() - this.taskStartedTime;
        if (elapsedTimeMs > 300L && !this.isVisible()) {
            this.setVisible(true);
        }
    }

    @Override
    public boolean canBeCancelled() {
        return this.cancelChecked;
    }

    private void startUpdateThread() {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                while (!DasProgressPanel.this.finished) {
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                if (DasProgressPanel.this.progressBar != null) {
                                    DasProgressPanel.this.updateUIComponents();
                                    DasProgressPanel.this.thePanel.repaint();
                                }
                            }
                        });
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        logger.log(Level.SEVERE, ex.getMessage(), ex);
                    }
                    catch (InvocationTargetException ex) {
                        logger.log(Level.SEVERE, ex.getMessage(), ex);
                    }
                }
            }
        };
        this.updateThread = new Thread(run, "progressMonitorUpdateThread");
        this.updateThread.start();
    }

    private String abbrevateStringEllipsis(String s, int lenLimit) {
        if (s.length() > lenLimit) {
            int n = s.length();
            s = s.substring(0, 10) + "..." + s.substring(n - (lenLimit - 11), n);
        }
        return s;
    }

    private void updateUIComponents() {
        boolean cancelEnabled;
        long elapsedTimeMs = System.currentTimeMillis() - this.taskStartedTime;
        long kb = this.currentTaskPosition;
        if (this.maximumTaskPosition == -1L) {
            this.progressBar.setIndeterminate(true);
        } else {
            this.progressBar.setIndeterminate(false);
        }
        if (this.maximumTaskPosition > 0L) {
            this.progressBar.setValue((int)(kb * 100L / this.maximumTaskPosition));
        } else {
            this.progressBar.setValue((int)kb % 100);
        }
        String bytesReadLabel = this.maximumTaskPosition > 0L ? "" + kb / (long)this.unitsf + this.units + "/" + this.maximumTaskPosition / (long)this.unitsf + "" + this.units : "" + kb + "";
        if (this.progressMessageDirty) {
            this.progressMessageLabel.setToolTipText("<html><b>" + this.label + "</b><br>" + this.progressMessageString + "<br>on thread " + this.currentThreadName);
            String s = this.abbrevateStringEllipsis(this.progressMessageString, 40);
            this.progressMessageLabel.setText(s);
            this.progressMessageDirty = false;
        }
        if (this.labelDirty) {
            this.taskLabel.setText(this.label);
            this.taskLabel.setToolTipText("<html><b>" + this.label + "</b><br>" + this.progressMessageString + "<br>on thread " + this.currentThreadName);
            this.labelDirty = false;
        }
        if (this.showProgressRate && elapsedTimeMs > 1000L && this.transferRateString != null) {
            this.kbLabel.setText(bytesReadLabel + " " + this.transferRateString);
        } else {
            this.kbLabel.setText(bytesReadLabel);
        }
        this.kbLabel.setToolTipText("" + kb + "/" + this.maximumTaskPosition);
        boolean bl = cancelEnabled = this.cancelCheckFailures < 2;
        if (cancelEnabled != this.cancelButton.isEnabled()) {
            this.cancelButton.setEnabled(cancelEnabled);
            if (cancelEnabled) {
                logger.finer("cancel enabled");
                this.cancelButton.setIcon(this.cancel);
                this.cancelButton.setToolTipText(MSG_CANCEL_TASK);
            } else {
                logger.finer("cancel disabled");
                this.cancelButton.setIcon(this.cancelGrey);
                this.cancelButton.setToolTipText(MSG_TASK_CANNOT_BE_CANCELED);
            }
        }
    }

    @Override
    @Deprecated
    public void setAdditionalInfo(String s) {
        this.transferRateString = s;
    }

    @Override
    public long getTaskProgress() {
        return this.currentTaskPosition;
    }

    @Override
    public long getTaskSize() {
        return this.maximumTaskPosition;
    }

    @Override
    public void setTaskSize(long taskSize) {
        if (taskSize < -1L) {
            throw new IllegalArgumentException("taskSize must be positive, -1, or 0, not " + taskSize);
        }
        if (taskSize == 0L) {
            taskSize = -1L;
        }
        if (this.componentsInitialized) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DasProgressPanel.this.progressBar.setIndeterminate(false);
                }
            });
        }
        if (taskSize > 100000000L) {
            this.units = "M";
            this.unitsf = 1000000;
        } else if (taskSize > 100000L) {
            this.units = "K";
            this.unitsf = 1000;
        } else {
            this.units = "";
            this.unitsf = 1;
        }
        this.maximumTaskPosition = taskSize;
    }

    public synchronized void setVisible(final boolean visible) {
        if (!this.componentsInitialized && !visible) {
            return;
        }
        Runnable run = new Runnable(){

            @Override
            public void run() {
                if (!DasProgressPanel.this.componentsInitialized && !DasProgressPanel.this.finished) {
                    DasProgressPanel.this.initComponents();
                }
                if (DasProgressPanel.this.thePanel != null) {
                    DasProgressPanel.this.thePanel.setVisible(visible);
                }
                if (DasProgressPanel.this.jframe != null) {
                    DasProgressPanel.this.jframe.setVisible(visible);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            run.run();
        } else {
            SwingUtilities.invokeLater(run);
        }
        if (visible && this.updateThread == null) {
            this.startUpdateThread();
        }
    }

    public boolean isVisible() {
        return !this.componentsInitialized || this.thePanel.isVisible();
    }

    @Override
    public void started() {
        this.taskStartedTime = System.currentTimeMillis();
        this.running = true;
        this.currentThreadName = Thread.currentThread().getName();
        this.setVisible(false);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (DasProgressPanel.this.running) {
                    logger.log(Level.FINE, "hide time={0}", System.currentTimeMillis() - DasProgressPanel.this.taskStartedTime);
                    DasProgressPanel.this.setVisible(true);
                }
            }
        }, "progressPanelUpdateThread").start();
        this.propertyChangeSupport.firePropertyChange(PROP_STARTED, false, true);
        if (this.isCancelled) {
            return;
        }
        if (this.maximumTaskPosition > 0L) {
            this.setTaskProgress(0L);
        }
    }

    @Override
    public void cancel() {
        this.isCancelled = true;
        this.propertyChangeSupport.firePropertyChange(PROP_CANCELLED, false, true);
        this.finished();
    }

    @Override
    public boolean isCancelled() {
        this.cancelCheckFailures = 0;
        logger.log(Level.FINER, "cancelCheckFailures={0}", this.cancelCheckFailures);
        this.cancelChecked = true;
        return this.isCancelled;
    }

    public Exception getSource() {
        return this.source;
    }

    public Exception getConsumer() {
        return this.consumer;
    }

    public void setShowProgressRate(boolean showProgressRate) {
        this.showProgressRate = showProgressRate;
    }

    public String toString() {
        if (this.isCancelled) {
            return PROP_CANCELLED;
        }
        if (this.finished) {
            return PROP_FINISHED;
        }
        if (this.running) {
            return "" + this.currentTaskPosition + " of " + this.maximumTaskPosition;
        }
        return "waiting for start";
    }

    @Override
    public void setProgressMessage(String message) {
        logger.finest("setProgressMessage");
        this.progressMessageString = message;
        this.progressMessageDirty = true;
    }

    @Override
    public boolean isStarted() {
        return this.running;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    private static class MyPanel
    extends JPanel {
        private MyPanel() {
        }

        @Override
        protected void paintComponent(Graphics g1) {
            Graphics2D g2 = (Graphics2D)g1;
            g2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
            g2.setColor(new Color(-587202561, true));
            Rectangle rect = g2.getClipBounds();
            if (rect == null) {
                g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            } else {
                g2.fillRect(rect.x, rect.y, rect.width, rect.height);
            }
            super.paintComponent(g1);
        }

        @Override
        public void print(Graphics g) {
        }
    }
}

