/*
 * Decompiled with CFR 0.152.
 */
package org.das2.components;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.das2.util.monitor.NullProgressMonitor;

public class DasProgressLabel
extends NullProgressMonitor {
    private int ndot = 2;
    private String taskLabel = "";
    private JLabel label = null;
    Timer repaintTimer = new Timer(333, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            String p = DasProgressLabel.this.getTaskSize() == -1L ? "" : "" + DasProgressLabel.this.getTaskProgress() + "/" + DasProgressLabel.this.getTaskSize();
            DasProgressLabel.this.ndot++;
            if (DasProgressLabel.this.ndot == 4) {
                DasProgressLabel.this.ndot = 1;
            }
            if (DasProgressLabel.this.label != null) {
                if (DasProgressLabel.this.isFinished()) {
                    DasProgressLabel.this.label.setText("<html><i>&nbsp;" + DasProgressLabel.this.taskLabel + "...finished</i></html>");
                } else {
                    DasProgressLabel.this.label.setText("<html><i>&nbsp;" + DasProgressLabel.this.taskLabel + "...".substring(0, DasProgressLabel.this.ndot) + "   ".substring(DasProgressLabel.this.ndot, 3) + p + "</i></html>");
                }
            }
        }
    });

    public DasProgressLabel(String taskLabel) {
        this.repaintTimer.setRepeats(true);
        this.repaintTimer.start();
        this.taskLabel = taskLabel;
    }

    public synchronized JLabel getLabelComponent() {
        if (this.label == null) {
            this.label = new JLabel();
        }
        return this.label;
    }

    public synchronized void setLabelComponent(JLabel label) {
        this.label = label;
    }

    @Override
    public void finished() {
        super.finished();
        this.repaintTimer.setRepeats(false);
        this.repaintTimer.stop();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (DasProgressLabel.this.label != null) {
                    DasProgressLabel.this.label.setText("<html><em>&nbsp;" + DasProgressLabel.this.taskLabel + "...finished</em></html>");
                }
            }
        });
    }
}

