/*
 * Decompiled with CFR 0.152.
 */
package org.das2.client;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import org.das2.DasException;
import org.das2.DasIOException;
import org.das2.client.Authenticator;
import org.das2.client.DasServerException;
import org.das2.client.DasServerNotFoundException;
import org.das2.client.DataSetDescriptorNotAvailableException;
import org.das2.client.Key;
import org.das2.client.StandardDataStreamSource;
import org.das2.client.WebStandardDataStreamSource;
import org.das2.stream.DasStreamFormatException;
import org.das2.stream.StreamDescriptor;
import org.das2.stream.StreamException;
import org.das2.system.DasLogger;
import org.das2.util.Crypt;
import org.das2.util.URLBuddy;
import org.das2.util.filesystem.FileSystem;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DasServer {
    private String sProto;
    private String host;
    private String path;
    private int port;
    @Deprecated
    private final HashMap keys;
    private static final Logger logger = DasLogger.getLogger(DasLogger.DATA_TRANSFER_LOG);
    private static HashMap instanceHashMap = new HashMap();

    public static DasServer createPlasmaWaveGroup() {
        try {
            return DasServer.create(new URL("http://planet.physics.uiowa.edu/das/das2Server"));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private DasServer(String sProto, String host, String path) {
        String[] s = host.split(":");
        if (s.length > 1) {
            this.port = Integer.parseInt(s[1]);
            host = s[0];
        } else {
            this.port = -1;
        }
        this.sProto = sProto;
        this.host = host;
        this.path = path;
        this.keys = new HashMap();
    }

    public String getURL() {
        if (this.port == -1) {
            return this.sProto + "://" + this.host + this.path;
        }
        return this.sProto + "://" + this.host + ":" + this.port + this.path;
    }

    public static DasServer create(URL url) {
        String key;
        String proto = url.getProtocol();
        String host = url.getHost();
        int port = url.getPort();
        if (port != -1) {
            host = host + ":" + port;
        }
        if (instanceHashMap.containsKey(key = proto + "://" + host + url.getPath())) {
            logger.log(Level.FINE, "Using existing DasServer for {0}", url);
            return (DasServer)instanceHashMap.get(key);
        }
        String path = url.getPath();
        logger.log(Level.FINE, "Creating DasServer for {0}", url);
        DasServer result = new DasServer(proto, host, path);
        instanceHashMap.put(key, result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() {
        String formData = "server=id";
        InputStream in = null;
        try {
            URL server = new URL("http", this.host, this.port, this.path + "?" + formData);
            logger.log(Level.FINE, "connecting to {0}", server);
            URLConnection urlConnection = server.openConnection();
            urlConnection.connect();
            in = urlConnection.getInputStream();
            String result = new String(this.read(in));
            logger.log(Level.FINE, "response={0}", result);
            String string = result;
            return string;
        }
        catch (IOException e) {
            String string = "";
            return string;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    logger.log(Level.WARNING, ex.toString(), ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageIcon getLogo() {
        String formData = "server=logo";
        InputStream in = null;
        try {
            URL server = new URL("http", this.host, this.port, this.path + "?" + formData);
            logger.log(Level.FINE, "connecting to {0}", server);
            URLConnection urlConnection = server.openConnection();
            urlConnection.connect();
            in = urlConnection.getInputStream();
            byte[] data = this.read(in);
            logger.log(Level.FINE, "response={0} bytes", data.length);
            ImageIcon imageIcon = new ImageIcon(data);
            return imageIcon;
        }
        catch (IOException e) {
            ImageIcon imageIcon = new ImageIcon();
            return imageIcon;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    logger.log(Level.WARNING, ex.toString(), ex);
                }
            }
        }
    }

    public TreeModel getDataSetListWithDiscovery() throws DasException {
        return this.getDataSetList("?server=discovery");
    }

    public TreeModel getDataSetList() throws DasException {
        return this.getDataSetList("?server=list");
    }

    protected TreeModel getDataSetList(String sSuffix) throws DasIOException {
        InputStream in = null;
        try {
            HttpURLConnection httpConn;
            int nStatus;
            URL server = new URL(this.sProto, this.host, this.port, this.path + sSuffix);
            logger.log(Level.FINE, "connecting to {0}", server);
            URLConnection conn = server.openConnection();
            conn.setConnectTimeout(FileSystem.settings().getConnectTimeoutMs());
            if (conn instanceof HttpURLConnection && (nStatus = (httpConn = (HttpURLConnection)conn).getResponseCode()) >= 400) {
                throw new IOException("Server returned HTTP response code:" + nStatus + " for URL: " + server);
            }
            in = conn.getInputStream();
            TreeModel result = this.createModel(in);
            logger.log(Level.FINE, "response->{0}", result);
            TreeModel treeModel = result;
            return treeModel;
        }
        catch (IOException e) {
            throw new DasIOException(e.getMessage());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    logger.log(Level.WARNING, ex.toString(), ex);
                }
            }
        }
    }

    private void sortDirectories(DefaultMutableTreeNode tn) {
        int i;
        int i2;
        DefaultMutableTreeNode[] children = new DefaultMutableTreeNode[tn.getChildCount()];
        int ichild = 0;
        for (i2 = 0; i2 < tn.getChildCount(); ++i2) {
            if (!tn.getChildAt(i2).getAllowsChildren()) continue;
            DefaultMutableTreeNode childWithKids = (DefaultMutableTreeNode)tn.getChildAt(i2);
            this.sortDirectories(childWithKids);
            children[ichild] = childWithKids;
            ++ichild;
        }
        for (i2 = 0; i2 < tn.getChildCount(); ++i2) {
            if (tn.getChildAt(i2).getAllowsChildren()) continue;
            children[ichild] = (DefaultMutableTreeNode)tn.getChildAt(i2);
            ++ichild;
        }
        int kidCount = tn.getChildCount();
        for (i = 0; i < kidCount; ++i) {
            tn.remove(0);
        }
        for (i = 0; i < kidCount; ++i) {
            tn.insert(children[i], i);
        }
    }

    private TreeModel createModel(InputStream uin) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(uin));
        DataSrcListItem rootData = new DataSrcListItem(true, this.getURL(), null);
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(rootData, true);
        DefaultTreeModel model = new DefaultTreeModel(root, true);
        String line = in.readLine();
        while (line != null) {
            String sDesc = null;
            int ipipe = line.indexOf(124);
            if (ipipe > -1) {
                sDesc = line.substring(ipipe + 1).trim();
                if (sDesc.isEmpty()) {
                    sDesc = null;
                }
                line = line.substring(0, ipipe).trim();
            }
            DefaultMutableTreeNode current = root;
            StringTokenizer tokenizer = new StringTokenizer(line, "/");
            block1: while (tokenizer.hasMoreTokens()) {
                String tok = tokenizer.nextToken();
                for (int index = 0; index < current.getChildCount(); ++index) {
                    String str = current.getChildAt(index).toString();
                    if (!str.equals(tok)) continue;
                    current = (DefaultMutableTreeNode)current.getChildAt(index);
                    continue block1;
                }
                boolean bDir = tokenizer.hasMoreElements() ? true : line.endsWith("/");
                DataSrcListItem dsItem = new DataSrcListItem(bDir, tok, sDesc);
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(dsItem, bDir);
                current.add(node);
                current = node;
            }
            line = in.readLine();
        }
        this.sortDirectories(root);
        return model;
    }

    public StandardDataStreamSource getStandardDataStreamSource(URL url) {
        return new WebStandardDataStreamSource(this, url);
    }

    public StreamDescriptor getStreamDescriptor(URL dataSetID) throws DasException {
        try {
            HttpURLConnection httpConn;
            int nStatus;
            String dsdf = dataSetID.getQuery().split("&")[0];
            URL url = new URL(this.sProto, this.host, this.port, this.path + "?server=dsdf&dataset=" + dsdf);
            logger.log(Level.FINE, "connecting to {0}", url);
            URLConnection connection = url.openConnection();
            connection.connect();
            String contentType = connection.getContentType();
            String[] s1 = contentType.split(";");
            contentType = s1[0];
            InputStream inStream = null;
            if (connection instanceof HttpURLConnection && (nStatus = (httpConn = (HttpURLConnection)connection).getResponseCode()) >= 400) {
                inStream = httpConn.getErrorStream();
            }
            if (inStream == null) {
                inStream = connection.getInputStream();
            }
            if (contentType.equalsIgnoreCase("text/plain") || contentType.equalsIgnoreCase("text/vnd.das2.das2stream")) {
                PushbackReader reader = new PushbackReader(new InputStreamReader(inStream), 4);
                char[] four = new char[4];
                int count = reader.read(four);
                if (count != 4) {
                    throw new IllegalArgumentException("failed to read four characters");
                }
                if (new String(four).equals("[00]")) {
                    logger.fine("response is a das2Stream");
                    if (reader.skip(6L) != 6L) {
                        throw new IllegalArgumentException("expected to skip six characters");
                    }
                    Document header = StreamDescriptor.parseHeader(reader);
                    Element root = header.getDocumentElement();
                    if (root.getTagName().equals("stream")) {
                        return new StreamDescriptor(root);
                    }
                    if (root.getTagName().equals("exception")) {
                        logger.info("response is an exception");
                        String type = root.getAttribute("type");
                        StreamException se = new StreamException("stream exception: " + type);
                        throw new DasException("stream exception: " + type, se);
                    }
                    if (root.getTagName().equals("")) {
                        throw new DasStreamFormatException();
                    }
                    throw new DasStreamFormatException();
                }
                logger.info("response is a legacy descriptor");
                reader.unread(four);
                BufferedReader in = new BufferedReader(reader);
                StreamDescriptor result = StreamDescriptor.createLegacyDescriptor(in);
                return result;
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            StringBuilder message = new StringBuilder();
            String line = in.readLine();
            while (line != null) {
                message.append(line).append('\n');
                line = in.readLine();
            }
            throw new IOException(message.toString());
        }
        catch (MalformedURLException e) {
            throw new DataSetDescriptorNotAvailableException("malformed URL");
        }
        catch (FileNotFoundException e) {
            throw new DasServerNotFoundException(e.getMessage());
        }
        catch (IOException e) {
            throw new DasIOException(e.toString());
        }
    }

    @Deprecated
    public Key authenticate(String user, String passCrypt) {
        try {
            Key result = null;
            String formData = "server=authenticator";
            formData = formData + "&user=" + URLBuddy.encodeUTF8(user);
            formData = formData + "&passwd=" + URLBuddy.encodeUTF8(passCrypt);
            URL server = new URL("http", this.host, this.port, this.path + "?" + formData);
            logger.log(Level.FINE, "connecting to {0}", server);
            InputStream in = server.openStream();
            BufferedInputStream bin = new BufferedInputStream(in);
            String serverResponse = this.readServerResponse(bin);
            String errTag = "error";
            String keyTag = "key";
            if (serverResponse.substring(0, keyTag.length() + 2).equals("<" + keyTag + ">")) {
                int index = serverResponse.indexOf("</" + keyTag + ">");
                String keyString = serverResponse.substring(keyTag.length() + 2, index);
                result = new Key(keyString);
            } else {
                result = null;
            }
            return result;
        }
        catch (UnsupportedEncodingException uee) {
            throw new AssertionError((Object)"UTF-8 not supported");
        }
        catch (IOException e) {
            return null;
        }
    }

    public List groups(Key key) {
        try {
            String formData = "server=groups";
            formData = formData + "&key=" + URLBuddy.encodeUTF8(key.toString());
            URL server = new URL("http", this.host, this.port, this.path + "?" + formData);
            logger.log(Level.FINE, "connecting to {0}", server);
            InputStream in = server.openStream();
            BufferedInputStream bin = new BufferedInputStream(in);
            String serverResponse = this.readServerResponse(bin);
            String[] groups = serverResponse.split(",");
            ArrayList<String> result = new ArrayList<String>();
            for (int i = 0; i < groups.length; ++i) {
                groups[i] = groups[i].trim();
                if ("".equals(groups[i])) continue;
                result.add(groups[i]);
            }
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void changePassword(String user, String oldPass, String newPass) throws DasServerException {
        try {
            String formData = "server=changePassword";
            formData = formData + "&user=" + URLBuddy.encodeUTF8(user);
            String cryptPass = Crypt.crypt(oldPass);
            formData = formData + "&passwd=" + URLBuddy.encodeUTF8(cryptPass);
            String cryptNewPass = Crypt.crypt(newPass);
            formData = formData + "&newPasswd=" + URLBuddy.encodeUTF8(cryptNewPass);
            URL server = new URL("http", this.host, this.port, this.path + "?" + formData);
            logger.log(Level.FINE, "connecting to {0}", server);
            InputStream in = server.openStream();
            BufferedInputStream bin = new BufferedInputStream(in);
            String serverResponse = this.readServerResponse(bin);
            String errTag = "error";
            String keyTag = "key";
            if (serverResponse.substring(0, errTag.length() + 2).equals("<" + errTag + ">")) {
                int index = serverResponse.indexOf("</" + errTag + ">");
                String errString = serverResponse.substring(errTag.length() + 2, index);
                if (errString.equals("<badAuthentication/>")) {
                    throw new DasServerException("Bad User/Pass");
                }
            }
        }
        catch (UnsupportedEncodingException uee) {
            throw new AssertionError((Object)"UTF-8 not supported");
        }
        catch (IOException e) {
            throw new DasServerException("Failed Connection");
        }
    }

    public String readServerResponse(BufferedInputStream in) {
        String das2Response;
        in.mark(Integer.MAX_VALUE);
        byte[] data = new byte[4096];
        int offset = 0;
        try {
            int bytesRead = in.read(data, offset, 4096 - offset);
            String das2ResponseTag = "das2Response";
            if (bytesRead < das2ResponseTag.length() + 2) {
                offset += bytesRead;
                bytesRead = in.read(data, offset, 4096 - offset);
            }
            if (new String(data, 0, 14, "UTF-8").equals("<" + das2ResponseTag + ">")) {
                long k;
                while (!new String(data, 0, offset, "UTF-8").contains("</" + das2ResponseTag + ">") && offset < 4096) {
                    bytesRead = in.read(data, offset += bytesRead, 4096 - offset);
                }
                int index = new String(data, 0, offset, "UTF-8").indexOf("</" + das2ResponseTag + ">");
                das2Response = new String(data, 14, index - 14);
                logger.log(Level.FINER, "das2Response={0}", das2Response);
                in.reset();
                for (long n = (long)(das2Response.length() + 2 * das2ResponseTag.length() + 5); n > 0L; n -= k) {
                    k = in.skip(n);
                }
            } else {
                in.reset();
                das2Response = "";
            }
        }
        catch (IOException e) {
            das2Response = "";
        }
        logger.log(Level.FINE, "response={0}", das2Response);
        return das2Response;
    }

    private byte[] read(InputStream uin) throws IOException {
        int i;
        LinkedList<byte[]> list = new LinkedList<byte[]>();
        int bytesRead = 0;
        InputStream in = uin;
        byte[] data = new byte[4096];
        int lastBytesRead = -1;
        int offset = 0;
        bytesRead = in.read(data, offset, 4096 - offset);
        while (bytesRead != -1) {
            lastBytesRead = offset += bytesRead;
            if (offset == 4096) {
                list.addLast(data);
                data = new byte[4096];
                offset = 0;
            }
            bytesRead = in.read(data, offset, 4096 - offset);
        }
        if (lastBytesRead < 4096) {
            list.addLast(data);
        }
        if (list.size() == 0) {
            return new byte[0];
        }
        int dataLength = (list.size() - 1) * 4096 + lastBytesRead;
        data = new byte[dataLength];
        Iterator iterator = list.iterator();
        for (i = 0; i < list.size() - 1; ++i) {
            System.arraycopy(iterator.next(), 0, data, i * 4096, 4096);
        }
        System.arraycopy(iterator.next(), 0, data, i * 4096, lastBytesRead);
        return data;
    }

    public String getProto() {
        return this.sProto;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getPath() {
        return this.path;
    }

    public URL getURL(String formData) throws MalformedURLException {
        return new URL(this.sProto, this.host, this.port, this.path + "?" + formData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Key getKey(String resource) {
        DasServer dasServer = this;
        synchronized (dasServer) {
            Authenticator authenticator;
            Key key1;
            if (this.keys.get(resource) == null && (key1 = (authenticator = new Authenticator(this, resource)).authenticate()) != null) {
                this.keys.put(resource, key1);
            }
        }
        return (Key)this.keys.get(resource);
    }

    public void setKey(Key key) {
        logger.info("this key is ignored");
    }

    public String toString() {
        return this.getURL();
    }

    public static class DataSrcListItem {
        private boolean bDirectory;
        private String sName;
        private String sDesc;

        public DataSrcListItem(boolean bDirectory, String sName, String sDesc) {
            this.bDirectory = bDirectory;
            this.sName = sName;
            this.sDesc = sDesc;
        }

        public boolean isDirectory() {
            return this.bDirectory;
        }

        public boolean isDataSource() {
            return !this.bDirectory;
        }

        public String name() {
            return this.sName;
        }

        public String description() {
            return this.sDesc;
        }

        public String toString() {
            return this.sName;
        }
    }
}

