/*
 * Decompiled with CFR 0.152.
 */
package org.das2.beans;

import java.awt.Color;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.DasApplication;
import org.das2.beans.AccessLevelBeanInfo;
import org.das2.beans.ImplicitAccessLevelBeanInfo;
import org.das2.beans.UnitsEditor;
import org.das2.components.DatumEditor;
import org.das2.components.DatumRangeEditor;
import org.das2.components.propertyeditor.BooleanEditor;
import org.das2.components.propertyeditor.ColorEditor;
import org.das2.components.propertyeditor.EnumerationEditor;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.NumberUnits;
import org.das2.datum.Units;
import org.das2.graph.AnchorPosition;
import org.das2.graph.AnchorType;
import org.das2.graph.BorderType;
import org.das2.graph.DasColorBar;
import org.das2.graph.DigitalRenderer;
import org.das2.graph.FillStyle;
import org.das2.graph.LegendPosition;
import org.das2.graph.PlotSymbol;
import org.das2.graph.Psym;
import org.das2.graph.PsymConnector;
import org.das2.graph.SpectrogramRenderer;
import org.das2.util.ClassMap;
import org.das2.util.LoggerManager;

public class BeansUtil {
    private static final Logger logger = LoggerManager.getLogger("das2.system");
    static ClassMap editorRegistry;
    private static final HashSet nullPropertyEditors;

    public static void registerEditor(Class beanClass, Class editorClass) {
        if (DasApplication.hasAllPermission()) {
            PropertyEditorManager.registerEditor(beanClass, editorClass);
            editorRegistry.put(beanClass, editorClass);
        }
    }

    public static PropertyEditor findEditor(Class propertyClass) {
        PropertyEditor result;
        if (nullPropertyEditors.contains(propertyClass)) {
            result = null;
        } else {
            Class resultClass;
            result = PropertyEditorManager.findEditor(propertyClass);
            if (result == null && (resultClass = (Class)editorRegistry.get(propertyClass)) != null) {
                try {
                    result = (PropertyEditor)resultClass.newInstance();
                }
                catch (InstantiationException ex) {
                    logger.log(Level.WARNING, ex.getMessage(), ex);
                }
                catch (IllegalAccessException ex) {
                    logger.log(Level.WARNING, ex.getMessage(), ex);
                }
            }
            if (result == null) {
                nullPropertyEditors.add(propertyClass);
            } else if (DasApplication.hasAllPermission()) {
                PropertyEditorManager.registerEditor(propertyClass, result.getClass());
            }
        }
        return result;
    }

    public static PropertyEditor getEditor(PropertyDescriptor pd) {
        PropertyEditor editor = null;
        try {
            Class<?> editorClass = pd.getPropertyEditorClass();
            if (editorClass != null) {
                editor = (PropertyEditor)editorClass.newInstance();
            }
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        if (editor == null) {
            editor = BeansUtil.findEditor(pd.getPropertyType());
        }
        return editor;
    }

    public static PropertyDescriptor[] getPropertyDescriptors(Class c) {
        HashSet<String> excludePropertyNames = new HashSet<String>();
        excludePropertyNames.add("class");
        excludePropertyNames.add("listLabel");
        excludePropertyNames.add("listIcon");
        if (!Modifier.isPublic(c.getModifiers())) {
            System.err.println("cannot use class: " + c);
            return new PropertyDescriptor[0];
        }
        try {
            PropertyDescriptor[] pdthis;
            BeanInfo beanInfo = BeansUtil.getBeanInfo(c);
            ArrayList<PropertyDescriptor> propertyList = new ArrayList<PropertyDescriptor>();
            try {
                pdthis = beanInfo.getPropertyDescriptors();
            }
            catch (IllegalStateException e) {
                throw new RuntimeException(e);
            }
            for (PropertyDescriptor pdthi : pdthis) {
                boolean isUseable;
                boolean bl = isUseable = pdthi.getReadMethod() != null && !excludePropertyNames.contains(pdthi.getName());
                if (!isUseable) continue;
                propertyList.add(pdthi);
            }
            if (beanInfo.getAdditionalBeanInfo() != null) {
                ArrayList<BeanInfo> additionalBeanInfo = new ArrayList<BeanInfo>(Arrays.asList(beanInfo.getAdditionalBeanInfo()));
                while (additionalBeanInfo.size() > 0) {
                    BeanInfo aBeanInfo = (BeanInfo)additionalBeanInfo.remove(0);
                    for (PropertyDescriptor pdthi : pdthis = aBeanInfo.getPropertyDescriptors()) {
                        boolean isUseable;
                        String name = pdthi.getName();
                        boolean bl = isUseable = pdthi.getReadMethod() != null && !excludePropertyNames.contains(name);
                        if (!isUseable) continue;
                        propertyList.add(pdthi);
                    }
                }
            }
            return propertyList.toArray(new PropertyDescriptor[propertyList.size()]);
        }
        catch (IntrospectionException e) {
            return null;
        }
    }

    public static BeanInfo getBeanInfo(Class c) throws IntrospectionException {
        long t0 = System.currentTimeMillis();
        BeanInfo beanInfo = null;
        if (c.getPackage() == null) {
            beanInfo = Introspector.getBeanInfo(c);
            logger.log(Level.FINER, "using BeanInfo {0} for {1}", new Object[]{beanInfo.getClass().getName(), c.getName()});
        } else {
            String beanInfoClassName;
            String s;
            try {
                s = c.getName().substring(c.getPackage().getName().length() + 1);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            Class<?> maybeClass = null;
            try {
                beanInfoClassName = c.getPackage() + "." + s + "BeanInfo";
                maybeClass = Class.forName(beanInfoClassName);
                logger.log(Level.FINER, "class found in {0} millis", System.currentTimeMillis() - t0);
            }
            catch (ClassNotFoundException e) {
                try {
                    beanInfoClassName = "org.das2.beans." + s + "BeanInfo";
                    maybeClass = Class.forName(beanInfoClassName);
                    logger.log(Level.FINER, "org.das2.beans class found in {0} millis", System.currentTimeMillis() - t0);
                }
                catch (ClassNotFoundException e2) {
                    beanInfo = Introspector.getBeanInfo(c);
                    beanInfoClassName = beanInfo.getClass().getName();
                    logger.log(Level.FINER, "introspector found class {0} found in {1} millis", new Object[]{c.getName(), System.currentTimeMillis() - t0});
                }
            }
            long dt = System.currentTimeMillis() - t0;
            if (dt > 100L) {
                logger.log(Level.INFO, "class {0} found in {1} millis", new Object[]{c.getName(), dt});
            }
            logger.log(Level.FINER, "using BeanInfo {0} for {1}", new Object[]{beanInfoClassName, c.getName()});
            if (beanInfo == null) {
                try {
                    beanInfo = (BeanInfo)maybeClass.newInstance();
                }
                catch (IllegalAccessException ex) {
                    throw new RuntimeException(ex);
                }
                catch (InstantiationException ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
        return beanInfo;
    }

    public static String[] getPropertyNames(PropertyDescriptor[] propertyList) {
        String[] result = new String[propertyList.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = propertyList[i].getName();
        }
        return result;
    }

    public static String[] getPropertyNames(Class c) {
        PropertyDescriptor[] propertyList = BeansUtil.getPropertyDescriptors(c);
        return BeansUtil.getPropertyNames(propertyList);
    }

    public static AccessLevelBeanInfo asAccessLevelBeanInfo(BeanInfo beanInfo, Class beanClass) {
        if (beanInfo instanceof AccessLevelBeanInfo) {
            return (AccessLevelBeanInfo)beanInfo;
        }
        return ImplicitAccessLevelBeanInfo.create(beanInfo, beanClass);
    }

    static {
        String[] beanInfoSearchPath = new String[]{"org.das2.beans", "sun.beans.infos"};
        if (DasApplication.hasAllPermission()) {
            Introspector.setBeanInfoSearchPath(beanInfoSearchPath);
        }
        editorRegistry = new ClassMap();
        if (DasApplication.hasAllPermission()) {
            BeansUtil.registerEditor(Datum.class, DatumEditor.class);
            BeansUtil.registerEditor(DatumRange.class, DatumRangeEditor.class);
            BeansUtil.registerEditor(Color.class, ColorEditor.class);
            BeansUtil.registerEditor(Units.class, UnitsEditor.class);
            BeansUtil.registerEditor(NumberUnits.class, UnitsEditor.class);
            BeansUtil.registerEditor(Boolean.TYPE, BooleanEditor.class);
            BeansUtil.registerEditor(Boolean.class, BooleanEditor.class);
            BeansUtil.registerEditor(PsymConnector.class, EnumerationEditor.class);
            BeansUtil.registerEditor(Psym.class, EnumerationEditor.class);
            BeansUtil.registerEditor(PlotSymbol.class, EnumerationEditor.class);
            BeansUtil.registerEditor(FillStyle.class, EnumerationEditor.class);
            BeansUtil.registerEditor(DigitalRenderer.Align.class, EnumerationEditor.class);
            BeansUtil.registerEditor(DasColorBar.Type.class, EnumerationEditor.class);
            BeansUtil.registerEditor(SpectrogramRenderer.RebinnerEnum.class, EnumerationEditor.class);
            BeansUtil.registerEditor(LegendPosition.class, EnumerationEditor.class);
            BeansUtil.registerEditor(AnchorPosition.class, EnumerationEditor.class);
            BeansUtil.registerEditor(AnchorType.class, EnumerationEditor.class);
            BeansUtil.registerEditor(BorderType.class, EnumerationEditor.class);
            BeansUtil.registerEditor(Level.class, EnumerationEditor.class);
        }
        nullPropertyEditors = new HashSet();
    }
}

