/*
 * Decompiled with CFR 0.152.
 */
package org.das2.beans;

import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.beans.SimpleBeanInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.DasApplication;
import org.das2.util.LoggerManager;

public abstract class AccessLevelBeanInfo
extends SimpleBeanInfo {
    private static final Logger logger = LoggerManager.getLogger("das2.system");
    private Property[] properties;
    private Class beanClass;
    private static AccessLevel accessLevel;
    private static final Object lockObject;

    public static AccessLevel getAccessLevel() {
        return accessLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setAccessLevel(AccessLevel level) {
        Object object = lockObject;
        synchronized (object) {
            accessLevel = level;
        }
    }

    public static Object getLock() {
        return lockObject;
    }

    protected AccessLevelBeanInfo(Property[] properties, Class beanClass) {
        this.properties = properties;
        this.beanClass = beanClass;
    }

    public PropertyDescriptor[] getPropertyDescriptors(PersistenceLevel persistenceLevel) {
        Object object = lockObject;
        synchronized (object) {
            try {
                ArrayList<PropertyDescriptor> result = new ArrayList<PropertyDescriptor>();
                for (int index = 0; index < this.properties.length; ++index) {
                    if (persistenceLevel.compareTo(this.properties[index].getPersistenceLevel()) > 0) continue;
                    result.add(this.properties[index].getPropertyDescriptor(this.beanClass));
                }
                BeanInfo[] moreBeanInfos = this.getAdditionalBeanInfo();
                if (moreBeanInfos != null) {
                    for (int i = 0; i < moreBeanInfos.length; ++i) {
                        result.addAll(Arrays.asList(moreBeanInfos[i].getPropertyDescriptors()));
                    }
                }
                return result.toArray(new PropertyDescriptor[result.size()]);
            }
            catch (IntrospectionException ie) {
                throw new IllegalStateException(ie.getMessage());
            }
        }
    }

    @Override
    public PropertyDescriptor[] getPropertyDescriptors() {
        Object object = lockObject;
        synchronized (object) {
            try {
                int count = 0;
                for (int index = 0; index < this.properties.length; ++index) {
                    if (accessLevel.compareTo(this.properties[index].getLevel()) > 0) continue;
                    ++count;
                }
                PropertyDescriptor[] descriptors = new PropertyDescriptor[count];
                int propertyIndex = 0;
                for (int index = 0; index < this.properties.length; ++index) {
                    if (accessLevel.compareTo(this.properties[index].getLevel()) > 0) continue;
                    logger.log(Level.FINE, "property: {0}", this.properties[index].getPropertyDescriptor(this.beanClass).getDisplayName());
                    descriptors[propertyIndex] = this.properties[index].getPropertyDescriptor(this.beanClass);
                    ++propertyIndex;
                }
                return descriptors;
            }
            catch (IntrospectionException ie) {
                throw new IllegalStateException(ie.getMessage());
            }
        }
    }

    public Property getProperty(PropertyDescriptor pd) {
        String name = pd.getName();
        for (int i = 0; i < this.properties.length; ++i) {
            if (!this.properties[i].name.equals(name)) continue;
            return this.properties[i];
        }
        BeanInfo[] additional = this.getAdditionalBeanInfo();
        if (additional != null && additional.length > 0) {
            for (int i = 0; i < additional.length; ++i) {
                Property p;
                BeanInfo b = additional[i];
                if (!(b instanceof AccessLevelBeanInfo) || (p = ((AccessLevelBeanInfo)b).getProperty(pd)) == null) continue;
                return p;
            }
        }
        return null;
    }

    @Override
    public BeanDescriptor getBeanDescriptor() {
        return new BeanDescriptor(this.beanClass);
    }

    static {
        lockObject = new Object();
        String level = DasApplication.getProperty("edu.uiowa.physics.das.beans.AccessLevelBeanInfo.AccessLevel", null);
        accessLevel = level == null ? AccessLevel.ALL : (level.equals("ALL") ? AccessLevel.ALL : (level.equals("DASML") ? AccessLevel.DASML : (level.equals("END_USER") ? AccessLevel.END_USER : AccessLevel.ALL)));
    }

    public static class AccessLevel
    implements Comparable {
        public static final AccessLevel ALL = new AccessLevel("ALL", 0);
        public static final AccessLevel DASML = new AccessLevel("DASML", 1000);
        public static final AccessLevel END_USER = new AccessLevel("END_USER", 0x7FFF0000);
        private String str;
        private int order;

        private AccessLevel(String str, int order) {
            this.str = str;
            this.order = order;
        }

        public int compareTo(Object o) {
            return this.order - ((AccessLevel)o).order;
        }

        public boolean equals(Object o) {
            if (!(o instanceof AccessLevel)) {
                return false;
            }
            return this.order == ((AccessLevel)o).order;
        }

        public int hashCode() {
            return this.order;
        }

        public String toString() {
            return this.str;
        }
    }

    public static class PersistenceLevel
    implements Comparable {
        public static final PersistenceLevel NONE = new PersistenceLevel("NONE", 0);
        public static final PersistenceLevel TRANSIENT = new PersistenceLevel("TRANSIENT", 1000);
        public static final PersistenceLevel PERSISTENT = new PersistenceLevel("PERSISTENT", 2000);
        private String str;
        private int order;

        private PersistenceLevel(String str, int order) {
            this.str = str;
            this.order = order;
        }

        public int compareTo(Object o) {
            return this.order - ((PersistenceLevel)o).order;
        }

        public boolean equals(Object o) {
            if (!(o instanceof PersistenceLevel)) {
                return false;
            }
            return this.order == ((PersistenceLevel)o).order;
        }

        public int hashCode() {
            return this.order;
        }

        public String toString() {
            return this.str;
        }
    }

    protected static class Property {
        private final String name;
        private final AccessLevel level;
        private final PersistenceLevel persistenceLevel;
        private final String getter;
        private final String setter;
        private final String igetter;
        private final String isetter;
        private final Class editor;
        private final boolean indexed;

        public Property(String name, AccessLevel level, PersistenceLevel persistenceLevel, String getter, String setter, Class editor) {
            this.name = name;
            this.level = level;
            this.persistenceLevel = persistenceLevel;
            this.getter = getter;
            this.setter = setter;
            this.igetter = null;
            this.isetter = null;
            this.editor = editor;
            this.indexed = false;
        }

        public Property(String name, AccessLevel level, String getter, String setter, Class editor) {
            this(name, level, PersistenceLevel.TRANSIENT, getter, setter, editor);
        }

        public Property(String name, AccessLevel level, PersistenceLevel persistenceLevel, String getter, String setter, String igetter, String isetter, Class editor) {
            this.name = name;
            this.level = level;
            this.persistenceLevel = persistenceLevel;
            this.getter = getter;
            this.setter = setter;
            this.igetter = igetter;
            this.isetter = isetter;
            this.editor = editor;
            this.indexed = true;
        }

        public Property(String name, AccessLevel level, String getter, String setter, String igetter, String isetter, Class editor) {
            this(name, level, PersistenceLevel.TRANSIENT, getter, setter, igetter, isetter, editor);
        }

        public AccessLevel getLevel() {
            return this.level;
        }

        public PropertyDescriptor getPropertyDescriptor(Class beanClass) throws IntrospectionException {
            PropertyDescriptor pd = this.indexed ? new IndexedPropertyDescriptor(this.name, beanClass, this.getter, this.setter, this.igetter, this.isetter) : new PropertyDescriptor(this.name, beanClass, this.getter, this.setter);
            if (this.editor != null) {
                pd.setPropertyEditorClass(this.editor);
            }
            return pd;
        }

        public PersistenceLevel getPersistenceLevel() {
            return this.persistenceLevel;
        }
    }
}

