/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.wav;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import org.autoplot.datasource.DataSourceFormat;
import org.autoplot.datasource.URISplit;
import org.das2.datum.LoggerManager;
import org.das2.datum.Units;
import org.das2.datum.UnitsConverter;
import org.das2.datum.UnitsUtil;
import org.das2.datum.format.DatumFormatter;
import org.das2.qds.DDataSet;
import org.das2.qds.DRank0DataSet;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.QDataSet;
import org.das2.qds.QubeDataSetIterator;
import org.das2.qds.SemanticOps;
import org.das2.qds.buffer.BufferDataSet;
import org.das2.qds.ops.Ops;
import org.das2.qds.util.DataSetBuilder;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;

public class WavDataSourceFormat
implements DataSourceFormat {
    private static final Logger logger = LoggerManager.getLogger("apdss.wav");

    private ByteBuffer formatRank1(QDataSet data, ProgressMonitor mon, Map<String, String> params) {
        String type = params.get("type");
        boolean doscale = !"F".equals(params.get("scale"));
        QDataSet extent = Ops.extent(data);
        int dep0Len = 0;
        int typeSize = BufferDataSet.byteCount(type);
        int recSize = typeSize * (dep0Len + 1);
        int size = data.length() * recSize;
        ByteBuffer result = ByteBuffer.allocate(size);
        result.order("big".equals(params.get("byteOrder")) ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
        BufferDataSet ddata = BufferDataSet.makeDataSet(1, recSize, dep0Len * typeSize, data.length(), 1, 1, 1, result, type);
        double shift = 0.0;
        boolean unsigned = type.startsWith("u");
        long typeOrdinals = (int)Math.pow(2.0, 8 * typeSize);
        int limit = (int)(typeOrdinals / (long)(unsigned ? 1 : 2));
        if (extent.value(1) > (double)limit) {
            if (extent.value(1) - extent.value(0) < (double)typeOrdinals) {
                shift = extent.value(0) > 0.0 ? (double)(typeOrdinals / 2L) : (extent.value(1) + extent.value(0)) / 2.0;
            } else if (!doscale) {
                throw new IllegalArgumentException("data extent is too great: " + extent);
            }
        }
        double scale = 1.0;
        if (doscale) {
            shift = (extent.value(1) + extent.value(0)) / 2.0;
            if (extent.value(1) - extent.value(0) > 0.0) {
                scale = (double)(typeOrdinals - 1L) / (extent.value(1) - extent.value(0));
            }
        }
        QubeDataSetIterator it = new QubeDataSetIterator(data);
        while (it.hasNext()) {
            it.next();
            it.putValue(ddata, scale * (it.getValue(data) - shift));
        }
        return result;
    }

    private ByteBuffer formatRank2Waveform(QDataSet data, ProgressMonitor mon, Map<String, String> params) {
        boolean doscale;
        String type = params.get("type");
        boolean bl = doscale = !"F".equals(params.get("scale"));
        if (!DataSetUtil.isQube(data)) {
            throw new IllegalArgumentException("data must be qube");
        }
        QDataSet dep0 = (QDataSet)data.property("DEPEND_0");
        if (dep0 != null) {
            DataSetBuilder b = new DataSetBuilder(1, dep0.length());
            double t0 = dep0.value(0);
            b.putValue(b.getLength(), 0.0);
            for (int i = 1; i < dep0.length(); ++i) {
                if (!(dep0.value(i) > t0)) continue;
                b.putValue(b.getLength(), i);
                t0 = dep0.value(i);
            }
            DDataSet r = b.getDataSet();
            if (r.length() < dep0.length()) {
                logger.warning("timetags are not monotonic");
                data = DataSetOps.applyIndex(data, 0, r, false);
            }
        }
        QDataSet extent = Ops.extent(data);
        int dep0Len = 0;
        int typeSize = BufferDataSet.byteCount(type);
        int recSize = typeSize * (dep0Len + 1);
        int size = data.length() * data.length(0) * recSize;
        ByteBuffer result = ByteBuffer.allocate(size);
        result.order("big".equals(params.get("byteOrder")) ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
        BufferDataSet ddata = BufferDataSet.makeDataSet(1, recSize, dep0Len * typeSize, data.length() * data.length(0), 1, 1, 1, result, type);
        double shift = 0.0;
        boolean unsigned = type.startsWith("u");
        long typeOrdinals = (int)Math.pow(2.0, 8 * typeSize);
        int limit = (int)(typeOrdinals / (long)(unsigned ? 1 : 2));
        if (extent.value(1) > (double)limit) {
            if (extent.value(1) - extent.value(0) < (double)typeOrdinals) {
                shift = extent.value(0) > 0.0 ? (double)(typeOrdinals / 2L) : (extent.value(1) + extent.value(0)) / 2.0;
            } else if (!doscale) {
                throw new IllegalArgumentException("data extent is too great: " + extent);
            }
        }
        double scale = 1.0;
        if (doscale) {
            shift = (extent.value(1) + extent.value(0)) / 2.0;
            if (extent.value(1) - extent.value(0) > 0.0) {
                scale = (double)(typeOrdinals - 1L) / (extent.value(1) - extent.value(0));
            }
        }
        QubeDataSetIterator it = new QubeDataSetIterator(data);
        QubeDataSetIterator it2 = new QubeDataSetIterator(ddata);
        while (it.hasNext()) {
            it.next();
            it2.next();
            it2.putValue(ddata, scale * (it.getValue(data) - shift));
        }
        return result;
    }

    private ByteBuffer formatRank2(QDataSet data, ProgressMonitor mon, Map<String, String> params) {
        String type = params.get("type");
        boolean doscale = !"F".equals(params.get("scale"));
        boolean timetags = "T".equals("timetags");
        QDataSet extent = Ops.extent(data);
        int dep0Len = 0;
        int typeSize = BufferDataSet.byteCount(type);
        int channels = data.length(0);
        int recSize = typeSize * channels;
        int size = data.length() * recSize;
        ByteBuffer result = ByteBuffer.allocate(size);
        result.order("big".equals(params.get("byteOrder")) ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
        BufferDataSet ddata = BufferDataSet.makeDataSet(2, recSize, dep0Len * typeSize, data.length(), data.length(0), 1, 1, result, type);
        QubeDataSetIterator it = new QubeDataSetIterator(data);
        double shift = 0.0;
        boolean unsigned = type.startsWith("u");
        long typeOrdinals = (int)Math.pow(2.0, 8 * typeSize);
        int limit = (int)(typeOrdinals / (long)(unsigned ? 1 : 2));
        if (extent.value(1) > (double)limit) {
            if (extent.value(1) - extent.value(0) < (double)typeOrdinals) {
                shift = extent.value(0) > 0.0 ? (double)(typeOrdinals / 2L) : (extent.value(1) + extent.value(0)) / 2.0;
            } else if (!doscale) {
                throw new IllegalArgumentException("data extent is too great: " + extent);
            }
        }
        double scale = 1.0;
        if (doscale) {
            shift = 0.0;
            if (extent.value(1) - extent.value(0) > 0.0) {
                scale = (double)(typeOrdinals - 1L) / (extent.value(1) - extent.value(0));
            }
        }
        while (it.hasNext()) {
            it.next();
            it.putValue(ddata, scale * (it.getValue(data) - shift));
        }
        return result;
    }

    private static InputStream newInputStream(final ByteBuffer buf) {
        return new InputStream(){

            @Override
            public synchronized int read() throws IOException {
                if (!buf.hasRemaining()) {
                    return -1;
                }
                return buf.get();
            }

            @Override
            public synchronized int read(byte[] bytes, int off, int len) throws IOException {
                len = Math.min(len, buf.remaining());
                buf.get(bytes, off, len);
                return len;
            }
        };
    }

    private static boolean aboutEqual(QDataSet d0, QDataSet d1) {
        double d = Ops.divide(d0, d1).value();
        return d > 0.99 && d < 1.01;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void formatData(String uri, QDataSet data, ProgressMonitor mon) throws IOException {
        ByteBuffer buf;
        double periodSeconds;
        Units u;
        QDataSet dep1;
        URISplit split = URISplit.parse(uri);
        QDataSet dep0 = (QDataSet)data.property("DEPEND_0");
        if (dep0 != null && !DataSetUtil.isMonotonicAndIncreasing(dep0)) {
            QDataSet r = Ops.where(Ops.le((Object)Ops.diff(dep0), 0));
            if (r.length() > 0) {
                data = data.trim(0, 1 + (int)r.value(0));
                dep0 = (QDataSet)data.property("DEPEND_0");
                logger.warning("data is not monotonic, dropping records to make monotonic.");
            } else {
                logger.warning("data is not monotonic, can't fix, proceding with problem with timetags.");
            }
        }
        float samplesPerSecond = 8000.0f;
        String SCHEME_ERROR = "data must be rank 1, rank 2 bundle, rank 2 waveform, or rank 3 join of waveforms.";
        if (SemanticOps.isRank2Waveform(data)) {
            dep1 = (QDataSet)data.property("DEPEND_1");
            if (dep1 == null || dep1.length() < 2) {
                throw new IllegalArgumentException("dep1 length must be at least 2");
            }
            u = (Units)dep1.property("UNITS");
            if (u == null) {
                u = Units.dimensionless;
            }
            UnitsConverter uc = u.getConverter(Units.seconds);
            periodSeconds = uc.convert(dep1.value(1) - dep1.value(0));
            samplesPerSecond = Math.round(1.0 / periodSeconds);
        } else if (SemanticOps.isRank3JoinOfRank2Waveform(data)) {
            dep1 = (QDataSet)data.slice(0).property("DEPEND_1");
            if (dep1 == null || dep1.length() < 2) {
                throw new IllegalArgumentException("dep1 length must be at least 2");
            }
            u = (Units)dep1.property("UNITS");
            if (u == null) {
                u = Units.dimensionless;
            }
            UnitsConverter uc = u.getConverter(Units.seconds);
            periodSeconds = uc.convert(dep1.value(1) - dep1.value(0));
            samplesPerSecond = Math.round(1.0 / periodSeconds);
        } else {
            if (data.rank() != 1 && (data.rank() != 2 || !SemanticOps.isBundle(data))) throw new IllegalArgumentException("data must be rank 1, rank 2 bundle, rank 2 waveform, or rank 3 join of waveforms.");
            if (dep0 == null || dep0.length() <= 1) throw new IllegalArgumentException("dep0 length must be at least 2");
            Units u2 = (Units)dep0.property("UNITS");
            u2 = u2 == null ? Units.dimensionless : u2.getOffsetUnits();
            UnitsConverter uc = u2.getConverter(Units.seconds);
            double periodSeconds2 = uc.convert(dep0.value(1) - dep0.value(0));
            samplesPerSecond = Math.round(1.0 / periodSeconds2);
        }
        int channels = 1;
        switch (data.rank()) {
            case 1: {
                break;
            }
            case 2: {
                if (SemanticOps.isRank2Waveform(data)) break;
                channels = data.length(0);
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException("data must be rank 1, rank 2 bundle, rank 2 waveform, or rank 3 join of waveforms.");
            }
        }
        HashMap<String, String> params2 = new HashMap<String, String>();
        params2.put("type", "short");
        params2.put("byteOrder", "little");
        params2.putAll(URISplit.parseParams(split.params));
        HashSet<String> allowedTypes = new HashSet<String>();
        allowedTypes.add("ushort");
        allowedTypes.add("short");
        allowedTypes.add("int");
        allowedTypes.add("int24");
        String type = (String)params2.get("type");
        if (!allowedTypes.contains(type)) {
            throw new IllegalArgumentException("type must be one of: " + allowedTypes);
        }
        int bytesPerField = BufferDataSet.byteCount(type);
        boolean signed = !type.startsWith("u");
        boolean bigEndian = ((String)params2.get("byteOrder")).equals("big");
        String stimeScale = (String)params2.get("timeScale");
        if (stimeScale != null) {
            double timeScale = Double.parseDouble(stimeScale);
            samplesPerSecond = (float)((double)samplesPerSecond * timeScale);
        }
        AudioFormat outDataFormat = new AudioFormat(samplesPerSecond, bytesPerField * 8, channels, signed, bigEndian);
        switch (data.rank()) {
            case 1: {
                buf = this.formatRank1(data, new NullProgressMonitor(), params2);
                break;
            }
            case 2: {
                if (SemanticOps.isRank2Waveform(data)) {
                    buf = this.formatRank2Waveform(data, new NullProgressMonitor(), params2);
                    break;
                }
                buf = this.formatRank2(data, new NullProgressMonitor(), params2);
                break;
            }
            case 3: {
                int j;
                int nbuf = data.length();
                ArrayList<ByteBuffer> bufs = new ArrayList<ByteBuffer>(nbuf);
                int cap = 0;
                for (j = 0; j < data.length(); ++j) {
                    ByteBuffer buf1 = this.formatRank2Waveform(data.slice(j), new NullProgressMonitor(), params2);
                    bufs.add(j, buf1);
                    cap += buf1.limit();
                }
                buf = ByteBuffer.allocate(cap);
                for (j = 0; j < nbuf; ++j) {
                    buf.put((ByteBuffer)bufs.get(j));
                }
                buf.flip();
                break;
            }
            default: {
                throw new IllegalArgumentException("data must be rank 1, rank 2 bundle, rank 2 waveform, or rank 3 join of waveforms.");
            }
        }
        String timetags = (String)params2.get("timetags");
        if (timetags != null && timetags.equals("T")) {
            String timetagFilename = split.resourceUri.getPath();
            timetagFilename = timetagFilename.substring(0, timetagFilename.length() - 4) + ".ttag.txt";
            File timetagFile = new File(timetagFilename);
            try (PrintWriter out = new PrintWriter(new FileWriter(timetagFile));){
                QDataSet ttag = data.rank() < 3 ? SemanticOps.xtagsDataSet(data) : SemanticOps.xtagsDataSet(data.slice(0));
                if (ttag == null) {
                    throw new IllegalArgumentException("timetags requested, but data does not have timetags.");
                }
                QDataSet t0 = ttag.slice(0);
                Units tu = SemanticOps.getUnits(t0);
                int i0 = 0;
                DRank0DataSet dRank0DataSet = DataSetUtil.asDataSet(Units.seconds.createDatum(1).divide(samplesPerSecond));
                if (UnitsUtil.isTimeLocation(tu)) {
                    out.println("UTC,index");
                } else {
                    out.println(String.format("time(%s),index", SemanticOps.getUnits(t0)));
                }
                DatumFormatter df = tu.getDatumFormatterFactory().defaultFormatter();
                out.println(String.format("%s,%d", df.format(tu.createDatum(t0.value()), tu), i0));
                switch (data.rank()) {
                    case 1: {
                        for (int i = 1; i < data.length(); ++i) {
                            QDataSet t1 = ttag.slice(i);
                            if (!WavDataSourceFormat.aboutEqual(Ops.subtract(t1, t0), dRank0DataSet)) {
                                out.println(String.format("%s,%d", df.format(tu.createDatum(t1.value()), tu), i));
                            }
                            t0 = t1;
                        }
                        break;
                    }
                    case 2: {
                        if (SemanticOps.isRank2Waveform(data)) {
                            QDataSet qDataSet = Ops.multiply((Object)dRank0DataSet, data.length(0));
                            int recSize = data.length(0);
                            for (int i = 1; i < data.length(); ++i) {
                                QDataSet t1 = ttag.slice(i);
                                if (!WavDataSourceFormat.aboutEqual(Ops.subtract(t1, t0), qDataSet)) {
                                    out.println(String.format("%s,%d", df.format(tu.createDatum(t1.value()), tu), i * recSize));
                                }
                                t0 = t1;
                            }
                        } else {
                            for (int i = 1; i < data.length(); ++i) {
                                QDataSet t1 = ttag.slice(i);
                                if (!WavDataSourceFormat.aboutEqual(Ops.subtract(t1, t0), dRank0DataSet)) {
                                    out.println(String.format("%s,%d", df.format(tu.createDatum(t1.value()), tu), i));
                                }
                                t0 = t1;
                            }
                        }
                        break;
                    }
                    case 3: {
                        if (!SemanticOps.isRank3JoinOfRank2Waveform(data)) throw new IllegalArgumentException("cannot get here, something has gone horribly wrong.");
                        int iwaveRec = 1;
                        for (int k = 0; k < data.length(); ++k) {
                            int i;
                            void var29_42;
                            QDataSet r2data = data.slice(k);
                            ttag = SemanticOps.xtagsDataSet(r2data);
                            QDataSet qDataSet = Ops.multiply(var29_42, r2data.length(0));
                            int recSize = r2data.length(0);
                            int n = i = k == 0 ? 1 : 0;
                            while (i < r2data.length()) {
                                QDataSet t1 = ttag.slice(i);
                                if (!WavDataSourceFormat.aboutEqual(Ops.subtract(t1, t0), qDataSet)) {
                                    out.println(String.format("%s,%d", df.format(tu.createDatum(t1.value()), tu), iwaveRec * recSize));
                                }
                                t0 = t1;
                                ++iwaveRec;
                                ++i;
                            }
                        }
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("data must be rank 1, rank 2 bundle, rank 2 waveform, or rank 3 join of waveforms.");
                    }
                }
            }
        }
        AudioInputStream inFileAIS = new AudioInputStream(WavDataSourceFormat.newInputStream(buf), outDataFormat, buf.capacity() / (bytesPerField * channels));
        File outFile = new File(split.resourceUri);
        if (!AudioSystem.isFileTypeSupported(AudioFileFormat.Type.WAVE, inFileAIS)) {
            throw new IllegalArgumentException("System doesn't support format to WAVE");
        }
        int i = AudioSystem.write(inFileAIS, AudioFileFormat.Type.WAVE, outFile);
        logger.log(Level.FINE, "{0} bytes written to file.", i);
        inFileAIS.close();
    }

    @Override
    public boolean canFormat(QDataSet ds) {
        return ds.rank() == 1 || ds.rank() == 2 && (SemanticOps.isRank2Waveform(ds) || ds.length(0) < 16);
    }

    @Override
    public String getDescription() {
        return "WAVE audio";
    }
}

