/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.wav;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import org.autoplot.binarydatasource.BinaryDataSource;
import org.autoplot.datasource.AbstractDataSource;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.URISplit;
import org.das2.datum.Units;
import org.das2.qds.QDataSet;
import org.das2.qds.TagGenDataSet;
import org.das2.qds.buffer.BufferDataSet;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;

public class WavDataSource2
extends AbstractDataSource {
    public WavDataSource2(URI uri) {
        super(uri);
    }

    @Override
    public QDataSet getDataSet(ProgressMonitor mon) throws Exception {
        File wavFile = DataSetURI.getFile(this.resourceURI, mon);
        AudioFileFormat fileFormat = AudioSystem.getAudioFileFormat(wavFile);
        AudioFormat audioFormat = fileFormat.getFormat();
        int headerLength = 44;
        int frameSize = audioFormat.getFrameSize();
        int frameCount = (int)((wavFile.length() - (long)headerLength) / (long)frameSize);
        int bits = audioFormat.getSampleSizeInBits();
        int frameOffset = 0;
        if (this.params.get("offset") != null) {
            double offsetSeconds = Double.parseDouble((String)this.params.get("offset"));
            frameOffset = (int)Math.floor(offsetSeconds * (double)audioFormat.getSampleRate());
            frameCount -= frameOffset;
        }
        if (this.params.get("length") != null) {
            double lengthSeconds = Double.parseDouble((String)this.params.get("length"));
            int frameCountLimit = (int)Math.floor(lengthSeconds * (double)audioFormat.getSampleRate());
            frameCount = Math.min(frameCount, frameCountLimit);
        }
        int channel = this.params.get("channel") != null ? Integer.parseInt((String)this.params.get("channel")) : 0;
        int byteOffset = headerLength + frameOffset * frameSize;
        int byteLength = frameCount * frameSize;
        String byteOrder = audioFormat.isBigEndian() ? "big" : "little";
        String type = null;
        switch (bits) {
            case 32: {
                type = "int";
                break;
            }
            case 24: {
                type = "int24";
                break;
            }
            case 16: {
                type = "short";
                break;
            }
            case 8: {
                type = "byte";
                break;
            }
            default: {
                throw new IllegalArgumentException("number of bits not supported: " + bits);
            }
        }
        if (audioFormat.getEncoding() == AudioFormat.Encoding.PCM_UNSIGNED) {
            type = "u" + type;
        }
        HashMap<String, String> lparams = new HashMap<String, String>();
        lparams.put("byteOffset", "" + byteOffset);
        lparams.put("byteLength", "" + byteLength);
        lparams.put("recLength", "" + frameSize);
        lparams.put("recOffset", "" + channel * bits / 8);
        lparams.put("type", type);
        lparams.put("byteOrder", byteOrder);
        URL lurl = new URL("" + wavFile.toURI().toURL() + "?" + URISplit.formatParams(lparams));
        BinaryDataSource bds = new BinaryDataSource(lurl.toURI());
        BufferDataSet result = (BufferDataSet)bds.getDataSet(new NullProgressMonitor());
        TagGenDataSet timeTags = new TagGenDataSet(frameCount, 1.0 / (double)audioFormat.getSampleRate(), 0.0, Units.seconds);
        result.putProperty("DEPEND_0", timeTags);
        return result;
    }

    @Override
    public Map<String, Object> getMetadata(ProgressMonitor mon) throws Exception {
        File f = this.getFile(this.resourceURI, mon);
        AudioFileFormat fileFormat = AudioSystem.getAudioFileFormat(f);
        AudioFormat audioFormat = fileFormat.getFormat();
        HashMap<String, Object> properties = new HashMap<String, Object>(audioFormat.properties());
        properties.put("encoding", audioFormat.getEncoding());
        properties.put("endianness", audioFormat.isBigEndian() ? "bigEndian" : "littleEndian");
        properties.put("channels", audioFormat.getChannels());
        properties.put("frame rate", Float.valueOf(audioFormat.getFrameRate()));
        properties.put("bits", audioFormat.getSampleSizeInBits());
        return properties;
    }
}

