/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.util;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.util.LoggerManager;

public class TickleTimer {
    long tickleTime;
    long delay;
    boolean running;
    List<String> messages;
    static final Logger log = LoggerManager.getLogger("autoplot");
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public TickleTimer(long delay, PropertyChangeListener listener) {
        this.tickleTime = System.currentTimeMillis();
        this.delay = delay;
        this.addPropertyChangeListener(listener);
        this.running = false;
        this.messages = new ArrayList<String>();
    }

    private void startTimer() {
        this.running = true;
        if (this.delay <= 0L) {
            this.newRunnable().run();
        } else {
            new Thread(this.newRunnable(), "tickleTimerThread").start();
            this.messages.clear();
        }
    }

    private Runnable newRunnable() {
        return new Runnable(){

            @Override
            public void run() {
                long d = System.currentTimeMillis() - TickleTimer.this.tickleTime;
                while (d < TickleTimer.this.delay) {
                    try {
                        log.log(Level.FINER, "tickleTimer sleep {0}", TickleTimer.this.delay - d);
                        Thread.sleep(TickleTimer.this.delay - d);
                    }
                    catch (InterruptedException ex) {
                        throw new RuntimeException(ex);
                    }
                    d = System.currentTimeMillis() - TickleTimer.this.tickleTime;
                }
                log.log(Level.FINER, "tickleTimer fire after {0}", d);
                TickleTimer.this.running = false;
                TickleTimer.this.propertyChangeSupport.firePropertyChange("running", true, false);
                TickleTimer.this.messages = new ArrayList<String>();
            }
        };
    }

    public synchronized void tickle() {
        this.tickle(null);
    }

    public synchronized void tickle(String message) {
        this.tickleTime = System.currentTimeMillis();
        if (!this.running) {
            this.startTimer();
        }
        if (message != null) {
            this.messages.add(message);
        }
    }

    public final void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public final void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    public boolean isRunning() {
        return this.running;
    }

    private void setRunning(boolean running) {
        boolean oldRunning = this.running;
        this.running = running;
        this.propertyChangeSupport.firePropertyChange("running", (Object)oldRunning, (Object)running);
    }

    public List<String> getMessages() {
        return Collections.unmodifiableList(this.messages);
    }
}

