/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.tca;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSource;
import org.autoplot.datasource.capability.TimeSeriesBrowse;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.Units;
import org.das2.qds.AbstractQFunction;
import org.das2.qds.BundleDataSet;
import org.das2.qds.DDataSet;
import org.das2.qds.DRank0DataSet;
import org.das2.qds.DataSetUtil;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.WritableDataSet;
import org.das2.qds.ops.Ops;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.NullProgressMonitor;

public class UriTcaSource
extends AbstractQFunction {
    TimeSeriesBrowse tsb;
    boolean needToRead;
    QDataSet ds;
    QDataSet tlim;
    QDataSet bundleDs;
    DataSource dss;
    QDataSet error;
    QDataSet errorNoDs;
    QDataSet nonValueDs;
    QDataSet initialError;
    static final Logger logger = LoggerManager.getLogger("autoplot.tca.uritcasource");

    public UriTcaSource(String uri) throws Exception {
        logger.log(Level.FINE, "new tca source: {0}", uri);
        if (uri.startsWith("class:org.autoplot.tca.UriTcaSource:")) {
            throw new IllegalArgumentException("pass a URI to this, not class:org.autoplot.tca.UriTcaSource");
        }
        EnumerationUnits eu = new EnumerationUnits("UriTcaSource");
        this.error = DataSetUtil.asDataSet(eu.createDatum("Error"));
        this.errorNoDs = DataSetUtil.asDataSet(eu.createDatum("No Data"));
        this.nonValueDs = DataSetUtil.asDataSet(eu.createDatum(" "));
        try {
            DataSource dss1 = DataSetURI.getDataSource(uri);
            this.initialError = null;
            this.tsb = dss1.getCapability(TimeSeriesBrowse.class);
            this.dss = dss1;
            this.needToRead = true;
        }
        catch (Exception lex) {
            logger.log(Level.WARNING, lex.getMessage(), lex);
            this.initialError = DataSetUtil.asDataSet(eu.createDatum(lex.toString()));
        }
    }

    private void doRead() throws Exception {
        NullProgressMonitor mon = new NullProgressMonitor();
        if (this.tsb != null) {
            logger.log(Level.INFO, "reading TCAs from TSB {0}", this.tsb.getURI());
        } else {
            logger.log(Level.INFO, "reading TCAs from {0}", this.dss);
        }
        this.needToRead = false;
        this.ds = this.dss.getDataSet(mon);
        if (this.ds == null) {
            logger.log(Level.FINE, "doRead getDataSet got null ");
        } else {
            logger.log(Level.FINE, "doRead got: {0}", this.ds);
            QDataSet dep0 = SemanticOps.xtagsDataSet(this.ds);
            if (!DataSetUtil.isMonotonicAndIncreasing(dep0)) {
                this.ds = Ops.ensureMonotonicAndIncreasingWithFill(this.ds);
            }
            this.tlim = DataSetUtil.guessCadenceNew(SemanticOps.xtagsDataSet(this.ds), this.ds);
            if (this.tsb != null) {
                DatumRange dr = this.tsb.getTimeRange();
                QDataSet ext = Ops.extent(SemanticOps.xtagsDataSet(this.ds), null);
                double d0 = DatumRangeUtil.normalize(dr, DataSetUtil.asDatum(ext.slice(0)));
                double d1 = DatumRangeUtil.normalize(dr, DataSetUtil.asDatum(ext.slice(1)));
                logger.log(Level.FINE, "normalized after load: {0}-{1}", new Object[]{d0, d1});
            }
            this.bundleDs = (QDataSet)this.ds.property("BUNDLE_1");
            if (this.bundleDs == null) {
                DDataSet bds1;
                if (this.ds.rank() == 1) {
                    bds1 = DDataSet.createRank2(1, 0);
                    String name = (String)this.ds.property("NAME");
                    String label = (String)this.ds.property("LABEL");
                    bds1.putProperty("NAME", 0, name == null ? "ds0" : name);
                    bds1.putProperty("LABEL", 0, label == null ? (name == null ? "" : name) : label);
                    if (this.ds.property("VALID_MIN") != null) {
                        bds1.putProperty("VALID_MIN", 0, this.ds.property("VALID_MIN"));
                    }
                    if (this.ds.property("VALID_MAX") != null) {
                        bds1.putProperty("VALID_MAX", 0, this.ds.property("VALID_MAX"));
                    }
                    if (this.ds.property("FILL_VALUE") != null) {
                        bds1.putProperty("FILL_VALUE", 0, this.ds.property("FILL_VALUE"));
                    }
                    this.bundleDs = bds1;
                } else {
                    bds1 = DDataSet.createRank2(this.ds.length(0), 0);
                    QDataSet dep1 = (QDataSet)this.ds.property("DEPEND_1");
                    Units u = dep1 == null ? Units.dimensionless : SemanticOps.getUnits(dep1);
                    for (int i = 0; i < this.ds.length(0); ++i) {
                        String name = dep1 != null ? u.createDatum(dep1.value(i)).toString() : (String)this.ds.property("NAME");
                        String label = (String)this.ds.property("LABEL");
                        bds1.putProperty("NAME", i, "ds" + i);
                        bds1.putProperty("LABEL", i, label == null ? (name == null ? "" : name) : label);
                    }
                    this.bundleDs = bds1;
                }
            }
        }
        if (this.tsb == null) {
            this.tsb = this.dss.getCapability(TimeSeriesBrowse.class);
        }
    }

    private boolean isValid(QDataSet result) {
        QDataSet wds = DataSetUtil.weightsDataSet(result);
        if (wds.rank() == 0) {
            return wds.value() > 0.0;
        }
        boolean valid = true;
        for (int i = 0; i < wds.length(); ++i) {
            valid = valid && wds.value(i) > 0.0;
        }
        return valid;
    }

    @Override
    public synchronized QDataSet values(QDataSet parms) {
        QDataSet gcd;
        if (this.initialError != null && this.ds == null) {
            return new BundleDataSet(this.error);
        }
        WritableDataSet tt = Ops.copy(Ops.unbundle(parms, 0));
        QDataSet dtt = Ops.diff(tt);
        try {
            gcd = DataSetUtil.gcd(dtt, Ops.divide((Object)dtt.slice(0), 100));
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
            gcd = Ops.reduceMin(dtt, 0);
        }
        DatumRange dr = null;
        for (int i = 0; i < parms.length(); ++i) {
            Datum d = DataSetUtil.asDatum(parms.slice(i).slice(0));
            dr = DatumRangeUtil.union(dr, d);
        }
        Datum neededResolution = DataSetUtil.asDatum(gcd).divide(24.0);
        if (this.tsb != null) {
            DatumRange timeRange = this.tsb.getTimeRange();
            Datum resolution = this.tsb.getTimeResolution();
            this.tsb.setTimeRange(dr);
            if (timeRange == null || !timeRange.contains(dr) || resolution != null && neededResolution.lt(resolution)) {
                this.tsb.setTimeResolution(neededResolution);
                this.needToRead = true;
            }
        }
        return super.values(parms);
    }

    @Override
    public synchronized QDataSet value(QDataSet parm) {
        DatumRange dr;
        if (this.initialError != null && this.ds == null) {
            return new BundleDataSet(this.error);
        }
        Datum d = DataSetUtil.asDatum(parm.slice(0));
        QDataSet context = (QDataSet)parm.property("CONTEXT_0", 0);
        QDataSet deltaMinus = (QDataSet)parm.property("DELTA_MINUS", 0);
        QDataSet deltaPlus = (QDataSet)parm.property("DELTA_PLUS", 0);
        boolean read = this.needToRead;
        if (this.tsb != null && !DatumRangeUtil.sloppyContains(dr = this.tsb.getTimeRange(), d)) {
            while (d.ge(dr.max())) {
                dr = dr.next();
                read = true;
            }
            while (d.lt(dr.min())) {
                dr = dr.previous();
                read = true;
            }
            if (read) {
                double check;
                if (context != null && ((check = DatumRangeUtil.normalize(dr, DataSetUtil.asDatumRange(context).min())) < -100.0 || check > 200.0)) {
                    System.err.println("check suppressed bad read...");
                    context = null;
                }
                if (context != null) {
                    dr = DatumRangeUtil.union(dr, DataSetUtil.asDatumRange(context, true));
                }
                this.tsb.setTimeRange(dr);
            }
        }
        try {
            QDataSet result;
            if (read) {
                this.doRead();
                logger.log(Level.FINER, "loaded dataset: {0} {1} ", new Object[]{this.tsb != null ? this.tsb.getTimeRange() : "", this.ds});
            }
            if (this.ds == null) {
                BundleDataSet result2 = new BundleDataSet(this.errorNoDs);
                result2.putProperty("UNITS", this.errorNoDs.property("UNITS"));
                return result2;
            }
            QDataSet dep0 = SemanticOps.xtagsDataSet(this.ds);
            QDataSet d0 = parm.slice(0);
            QDataSet findex = dep0.length() == 1 ? Ops.dataset(0) : Ops.findex(dep0, d0);
            if (findex.value() >= -0.5 && findex.value() < (double)dep0.length() - 0.5) {
                int ii = (int)(findex.value() + 0.5);
                result = this.ds.slice(ii);
                if (!this.isValid(result)) {
                    int imax;
                    int imin;
                    if (deltaPlus == null) {
                        deltaPlus = DataSetUtil.asDataSet(SemanticOps.getUnits(dep0).getOffsetUnits().createDatum(0));
                    }
                    if (deltaMinus == null) {
                        deltaMinus = deltaPlus;
                    }
                    if ((imin = (int)((findex = Ops.findex(dep0, Ops.subtract(d0, deltaMinus))).value() + 0.5)) < 0) {
                        imin = 0;
                    }
                    if ((imax = (int)((findex = Ops.findex(dep0, Ops.add(d0, deltaPlus))).value() + 0.5)) >= dep0.length()) {
                        imax = dep0.length() - 1;
                    }
                    int irad = Math.max(ii - imin, imax - ii);
                    for (int iiii = 1; !(iiii >= irad || ii - iiii >= imin && this.isValid(result = this.ds.slice(ii - iiii)) || ii + iiii <= imax && this.isValid(result = this.ds.slice(ii + iiii))); ++iiii) {
                    }
                } else {
                    QDataSet delta;
                    logger.log(Level.FINER, "findex={0} for {1} {2}", new Object[]{findex, d0, result});
                    if (deltaPlus != null && Ops.gt(delta = Ops.magnitude(Ops.subtract(d0, dep0.slice(ii))), this.tlim).value() == 1.0) {
                        BundleDataSet result1 = new BundleDataSet(this.nonValueDs);
                        for (int i = 1; i < this.ds.length(0); ++i) {
                            result1.bundle(this.nonValueDs);
                        }
                        result = result1;
                    }
                }
            } else {
                QDataSet result3;
                if (deltaPlus == null) {
                    deltaPlus = DataSetUtil.asDataSet(SemanticOps.getUnits(dep0).getOffsetUnits().createDatum(0));
                }
                if (deltaMinus == null) {
                    deltaMinus = deltaPlus;
                }
                if (findex.value() > (double)(dep0.length() - 1) && Ops.ge(Ops.add(dep0.slice(dep0.length() - 1), deltaMinus), d0).value() == 1.0) {
                    result3 = this.ds.slice(dep0.length() - 1);
                } else if (findex.value() < 0.0 && Ops.le(Ops.subtract(dep0.slice(0), deltaPlus), d0).value() == 1.0) {
                    result3 = this.ds.slice(0);
                } else if (this.tsb == null) {
                    BundleDataSet result1 = new BundleDataSet(this.nonValueDs);
                    for (int i = 1; i < this.ds.length(0); ++i) {
                        result1.bundle(this.nonValueDs);
                    }
                    result3 = result1;
                    ((MutablePropertyDataSet)result3).putProperty("UNITS", this.nonValueDs.property("UNITS"));
                } else if (this.tsb.getTimeRange().contains(DataSetUtil.asDatum(d0))) {
                    BundleDataSet result1 = new BundleDataSet(this.nonValueDs);
                    for (int i = 1; i < this.ds.length(0); ++i) {
                        result1.bundle(this.nonValueDs);
                    }
                    result3 = result1;
                    ((MutablePropertyDataSet)result3).putProperty("UNITS", this.nonValueDs.property("UNITS"));
                } else {
                    logger.log(Level.INFO, "tick {0} is outside bounds of loaded data ({1}) {2}", new Object[]{DataSetUtil.asDatum(d0), this.tsb.getTimeRange(), this.ds});
                    BundleDataSet result1 = new BundleDataSet(this.error);
                    for (int i = 1; i < this.ds.length(0); ++i) {
                        result1.bundle(this.error);
                    }
                    result3 = result1;
                    ((MutablePropertyDataSet)result3).putProperty("UNITS", this.error.property("UNITS"));
                }
                return result3;
            }
            if (result.rank() == 0) {
                result = new BundleDataSet(result);
            }
            ((MutablePropertyDataSet)result).putProperty("BUNDLE_0", this.bundleDs);
            return result;
        }
        catch (Exception lex) {
            logger.log(Level.WARNING, lex.getMessage(), lex);
            lex.printStackTrace();
            return new BundleDataSet(this.error);
        }
    }

    @Override
    public synchronized QDataSet exampleInput() {
        Datum t0;
        Units tu;
        String label;
        if (this.initialError != null) {
            label = "???";
            tu = Units.us2000;
            t0 = ((Units)tu).createDatum(0);
        } else if (this.tsb != null) {
            t0 = this.tsb.getTimeRange().min();
            tu = t0.getUnits();
            label = "Time";
        } else {
            try {
                QDataSet dep0;
                if (this.needToRead) {
                    this.doRead();
                }
                if ((dep0 = (QDataSet)this.ds.property("DEPEND_0")) == null) {
                    throw new RuntimeException("Unable to locate independent variable, expecting to find DEPEND_0");
                }
                t0 = DataSetUtil.asDatum(dep0.slice(0));
                tu = t0.getUnits();
                label = "???";
            }
            catch (Exception ex) {
                if (ex instanceof RuntimeException) {
                    throw (RuntimeException)ex;
                }
                throw new RuntimeException(ex);
            }
        }
        DDataSet inputDescriptor = DDataSet.createRank2(1, 0);
        inputDescriptor.putProperty("LABEL", 0, label);
        inputDescriptor.putProperty("UNITS", 0, tu);
        DRank0DataSet q = DataSetUtil.asDataSet(t0);
        MutablePropertyDataSet ret = (MutablePropertyDataSet)Ops.bundle(null, q);
        inputDescriptor.putProperty("CADENCE", DataSetUtil.asDataSet(Units.seconds.createDatum(1)));
        ret.putProperty("BUNDLE_0", inputDescriptor);
        return ret;
    }
}

