/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.state;

import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.autoplot.ApplicationModel;
import org.autoplot.AutoplotUtil;
import org.autoplot.datasource.AutoplotSettings;
import org.autoplot.dom.Application;
import org.autoplot.dom.BindingModel;
import org.autoplot.dom.Diff;
import org.autoplot.dom.DomUtil;
import org.autoplot.dom.Plot;
import org.autoplot.state.StatePersistence;
import org.das2.datum.TimeParser;
import org.das2.datum.TimeUtil;
import org.das2.system.RequestProcessor;
import org.das2.util.LoggerManager;

public class UndoRedoSupport {
    private static final Logger logger = LoggerManager.getLogger("autoplot.dom.vap");
    ApplicationModel applicationModel;
    LinkedList<StateStackElement> stateStack = new LinkedList();
    int stateStackPos = 0;
    private String redoLabel = null;
    public static final String PROP_REDOLABEL = "redoLabel";
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    public static final String PROP_SIZE_LIMIT = "sizeLimit";
    private int sizeLimit = 50;
    private boolean ignoringUpdates;
    public static final String PROP_DEPTH = "depth";
    public static final String PROP_SAVE_STATE_DEPTH = "saveStateDepth";
    private int saveStateDepth = 0;

    public UndoRedoSupport(ApplicationModel applicationModel) {
        this.applicationModel = applicationModel;
        applicationModel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent ev) {
                if (ev.getPropertyName().equals("vapFile")) {
                    UndoRedoSupport.this.resetHistory();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshUndoMultipleMenu(JMenu undoMultipleMenu) {
        ArrayList<StateStackElement> lstateStack;
        int lstateStackPos;
        undoMultipleMenu.removeAll();
        UndoRedoSupport undoRedoSupport = this;
        synchronized (undoRedoSupport) {
            lstateStackPos = this.stateStackPos;
            lstateStack = new ArrayList<StateStackElement>(this.stateStack);
        }
        for (int i = lstateStackPos - 1; i > Math.max(0, lstateStackPos - 10); --i) {
            StateStackElement prevState = (StateStackElement)lstateStack.get(i);
            String label = prevState.deltaDesc;
            final int ii = lstateStackPos - i;
            JMenuItem item = new JMenuItem(new AbstractAction(label){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LoggerManager.logGuiEvent(e);
                    UndoRedoSupport.this.undo(ii);
                }
            });
            item.setToolTipText(prevState.docString);
            if (((StateStackElement)lstateStack.get((int)(i - 1))).thumb != null) {
                item.setIcon(new ImageIcon(((StateStackElement)lstateStack.get((int)(i - 1))).thumb));
            }
            undoMultipleMenu.add(item);
        }
    }

    public synchronized void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public Action getUndoAction() {
        return new AbstractAction("Undo"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                Runnable run = new Runnable(){

                    @Override
                    public void run() {
                        UndoRedoSupport.this.undo();
                    }
                };
                new Thread(run, "undoLaterThread").start();
            }
        };
    }

    public void undo() {
        this.undo(1);
    }

    public synchronized void undo(int level) {
        logger.log(Level.FINE, "undo {0}", level);
        String oldRedoLabel = this.getRedoLabel();
        int oldDepth = this.stateStackPos;
        this.stateStackPos -= level;
        if (this.stateStackPos < 0) {
            this.stateStackPos = 0;
        }
        if (this.stateStackPos > 0) {
            StateStackElement elephant = this.stateStack.get(this.stateStackPos - 1);
            this.ignoringUpdates = true;
            this.applicationModel.setRestoringState(true);
            this.applicationModel.restoreState(elephant.state);
            this.applicationModel.setRestoringState(false);
            this.ignoringUpdates = false;
            RequestProcessor.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AutoplotUtil.reloadAll(UndoRedoSupport.this.applicationModel.getDocumentModel());
                }
            });
        }
        this.redoLabel = this.getRedoLabel();
        this.propertyChangeSupport.firePropertyChange(PROP_REDOLABEL, oldRedoLabel, this.redoLabel);
        this.propertyChangeSupport.firePropertyChange(PROP_DEPTH, oldDepth, this.stateStackPos);
    }

    public Action getRedoAction() {
        return new AbstractAction("redo"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                Runnable run = new Runnable(){

                    @Override
                    public void run() {
                        UndoRedoSupport.this.redo();
                    }
                };
                new Thread(run, "redoLaterThread").start();
            }
        };
    }

    public synchronized void redo() {
        logger.fine("redo");
        String oldRedoLabel = this.getRedoLabel();
        int oldDepth = this.stateStackPos;
        if (this.stateStackPos >= this.stateStack.size()) {
            this.stateStackPos = this.stateStack.size() - 1;
        }
        if (this.stateStackPos < this.stateStack.size()) {
            StateStackElement elephant = this.stateStack.get(this.stateStackPos);
            this.ignoringUpdates = true;
            this.applicationModel.setRestoringState(true);
            this.applicationModel.restoreState(elephant.state);
            this.applicationModel.setRestoringState(false);
            this.ignoringUpdates = false;
            ++this.stateStackPos;
        }
        this.redoLabel = this.getRedoLabel();
        this.propertyChangeSupport.firePropertyChange(PROP_REDOLABEL, oldRedoLabel, this.redoLabel);
        this.propertyChangeSupport.firePropertyChange(PROP_DEPTH, oldDepth, this.stateStackPos);
    }

    public void pushState(PropertyChangeEvent ev) {
        this.pushState(ev, null);
    }

    private static List<Diff> removeTimeRangeBindings(Application dom, List<Diff> diffs) {
        dom = (Application)dom.copy();
        diffs = new ArrayList<Diff>(diffs);
        ArrayList<Diff> timeRangeBound = new ArrayList<Diff>();
        for (Diff s : diffs) {
            Pattern pattern = Pattern.compile("plots\\[(\\d+)\\].xaxis.range");
            Matcher m = pattern.matcher(s.propertyName());
            if (!m.matches()) continue;
            try {
                Plot p = dom.getPlots(Integer.parseInt(m.group(1)));
                BindingModel bm = DomUtil.findBinding(dom, p.getXaxis(), "range", dom, "timeRange");
                if (bm == null) continue;
                timeRangeBound.add(s);
            }
            catch (IndexOutOfBoundsException ex) {
                logger.severe("IndexOutOfBounds error that needs to be fixed because needs synchronization");
            }
        }
        diffs.removeAll(timeRangeBound);
        return diffs;
    }

    private StateStackElement describeChanges(List<Diff> diffs, StateStackElement element) {
        String labelStr;
        StringBuilder docBuf = new StringBuilder();
        int count = 0;
        boolean axisRangeOnly = true;
        boolean zaxisRangeOnly = true;
        boolean axisAuto = false;
        boolean timeRange = false;
        String focus = null;
        diffs = UndoRedoSupport.removeTimeRangeBindings(this.applicationModel.getDocumentModel(), diffs);
        for (Diff diff : diffs) {
            if (diff.getDescription().contains("plotDefaults")) continue;
            String thisDiffFocus = null;
            int i = diff.propertyName().indexOf(46);
            if (i > -1) {
                thisDiffFocus = diff.propertyName().substring(0, i);
            }
            if (focus == null) {
                focus = thisDiffFocus;
            } else if (!focus.equals(thisDiffFocus) && !diff.propertyName().equals("timeRange")) {
                focus = "";
            } else if (diff.propertyName().equals("timeRange")) {
                timeRange = true;
            }
            ++count;
            docBuf.append("<br>");
            docBuf.append(diff.getDescription());
            if (diff.propertyName().endsWith("axis.range") || diff.propertyName().equals("timeRange")) {
                if (diff.propertyName().endsWith("zaxis.range")) {
                    axisRangeOnly = false;
                    continue;
                }
                zaxisRangeOnly = false;
                continue;
            }
            if (diff.propertyName().endsWith("autoRange")) {
                axisAuto = true;
                continue;
            }
            axisRangeOnly = false;
            zaxisRangeOnly = false;
        }
        if (focus == null) {
            focus = "";
        }
        String docString = docBuf.length() > 4 ? docBuf.substring(4) : "";
        docString = "<html>" + docString + "</html>";
        if (diffs.isEmpty()) {
            element.deltaDesc = "unidentified change";
            element.docString = "change was detected but could not be identified.";
            return element;
        }
        if (zaxisRangeOnly && focus.length() > 0 && count > 1) {
            labelStr = axisAuto ? focus + " first Z range change" : focus + " Z range change";
        } else if (axisRangeOnly && focus.length() > 0 && count > 1) {
            labelStr = axisAuto ? focus + " first range change" : focus + " range changes";
        } else if (count > 3) {
            labelStr = "" + count + " changes";
        } else {
            StringBuilder buf = new StringBuilder();
            for (Diff s : diffs) {
                if (s.getDescription().contains("plotDefaults")) continue;
                buf.append(", ").append(s.getLabel());
            }
            String string = labelStr = buf.length() > 2 ? buf.substring(2) : "";
        }
        if (labelStr.length() > 30) {
            StringTokenizer tok = new StringTokenizer(labelStr, ".,[", true);
            StringBuilder stringBuilder = new StringBuilder();
            while (tok.hasMoreTokens()) {
                String ss = tok.nextToken();
                stringBuilder.append(ss.substring(0, Math.min(ss.length(), 12)));
            }
            labelStr = stringBuilder.toString();
        }
        element.deltaDesc = labelStr;
        element.docString = docString;
        return element;
    }

    public int getSizeLimit() {
        return this.sizeLimit;
    }

    public void setSizeLimit(int size) {
        int oldSize = this.sizeLimit;
        this.sizeLimit = size;
        this.removeOldStates();
        this.propertyChangeSupport.firePropertyChange(PROP_SIZE_LIMIT, oldSize, size);
    }

    private synchronized void removeOldStates() {
        int len = this.sizeLimit;
        while (this.stateStack.size() > len) {
            this.stateStack.remove(0);
            --this.stateStackPos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushState(PropertyChangeEvent ev, String label) {
        int oldDepth;
        logger.log(Level.FINE, "pushState: {0}", label);
        UndoRedoSupport undoRedoSupport = this;
        synchronized (undoRedoSupport) {
            if (this.ignoringUpdates) {
                return;
            }
        }
        Application state = this.applicationModel.createState(false);
        BufferedImage thumb = this.applicationModel.getThumbnail(50);
        UndoRedoSupport undoRedoSupport2 = this;
        synchronized (undoRedoSupport2) {
            StateStackElement elephant = this.stateStackPos > 0 ? this.stateStack.get(this.stateStackPos - 1) : null;
            if (elephant != null && state.equals(elephant.state)) {
                return;
            }
            String labelStr = "initial";
            String docString = "initial state of application";
            StateStackElement element = new StateStackElement(state, labelStr, docString);
            if (elephant != null) {
                List<Diff> diffss = elephant.state.diffs(state);
                if (diffss.isEmpty()) {
                    return;
                }
                element = this.describeChanges(diffss, element);
                if (label != null && element.deltaDesc.endsWith(" changes")) {
                    element.deltaDesc = label;
                }
            }
            oldDepth = this.stateStackPos;
            element.thumb = thumb;
            this.stateStack.add(this.stateStackPos, element);
            while (this.stateStack.size() > 1 + this.stateStackPos) {
                this.stateStack.removeLast();
            }
            ++this.stateStackPos;
            this.removeOldStates();
        }
        if (this.saveStateDepth > 0) {
            boolean ok;
            long t0 = System.currentTimeMillis();
            File f2 = new File(AutoplotSettings.settings().resolveProperty("autoplotData"), "state/");
            if (!f2.exists() && !(ok = f2.mkdirs())) {
                throw new RuntimeException("unable to create folder " + f2);
            }
            File f3 = new File(f2, TimeParser.create("state_$Y$m$d_$H$M$S.vap.gz").format(TimeUtil.now(), null));
            try (GZIPOutputStream out = new GZIPOutputStream(new FileOutputStream(f3));){
                StatePersistence.saveState(out, (Object)state, "");
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
            logger.fine(String.format("saved state file in %d ms", System.currentTimeMillis() - t0));
        }
        this.propertyChangeSupport.firePropertyChange(PROP_DEPTH, oldDepth, this.stateStackPos);
    }

    public String getUndoDescription() {
        if (this.stateStackPos > 1) {
            return this.stateStack.get((int)(this.stateStackPos - 1)).docString;
        }
        return null;
    }

    public String getUndoLabel() {
        if (this.stateStackPos > 1) {
            return "Undo " + this.stateStack.get((int)(this.stateStackPos - 1)).deltaDesc;
        }
        return null;
    }

    public String getRedoDescription() {
        if (this.stateStackPos < this.stateStack.size()) {
            return this.stateStack.get((int)this.stateStackPos).docString;
        }
        return null;
    }

    public String getRedoLabel() {
        if (this.stateStackPos < this.stateStack.size()) {
            return "Redo " + this.stateStack.get((int)this.stateStackPos).deltaDesc;
        }
        return null;
    }

    public void resetHistory() {
        int oldDepth = this.stateStackPos;
        this.stateStack = new LinkedList();
        this.stateStackPos = 0;
        this.propertyChangeSupport.firePropertyChange(PROP_DEPTH, oldDepth, this.stateStackPos);
    }

    public synchronized boolean isIgnoringUpdates() {
        return this.ignoringUpdates;
    }

    public synchronized void setIgnoringUpdates(boolean ignoringUpdates) {
        this.ignoringUpdates = ignoringUpdates;
    }

    public int getDepth() {
        return this.stateStackPos;
    }

    public int getSaveStateDepth() {
        return this.saveStateDepth;
    }

    public void setSaveStateDepth(int depth) {
        this.saveStateDepth = depth;
    }

    public StateStackElement peekAt(int pos) {
        return this.stateStack.get(pos);
    }

    public String getLongUndoDescription(int i) {
        List<Diff> diffss = this.stateStack.get((int)i).state.diffs(this.stateStack.get((int)(i - 1)).state);
        diffss = UndoRedoSupport.removeTimeRangeBindings(this.stateStack.get((int)(i - 1)).state, diffss);
        StringBuilder docBuf = new StringBuilder();
        for (int j = 0; j < diffss.size(); ++j) {
            Diff s = diffss.get(j);
            if (s.getDescription().contains("plotDefaults")) continue;
            if (j > 0) {
                docBuf.append(";\n");
            }
            docBuf.append(s.getDescription());
        }
        return docBuf.toString();
    }

    public static class StateStackElement {
        Application state;
        String deltaDesc;
        String docString;
        BufferedImage thumb;

        public StateStackElement(Application state, String deltaDesc, String docString) {
            this.state = state;
            this.deltaDesc = deltaDesc;
            this.docString = docString;
        }

        public String toString() {
            return this.deltaDesc;
        }
    }
}

