/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.state;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.URISplit;
import org.autoplot.dom.Application;
import org.autoplot.dom.DataSourceFilter;
import org.autoplot.state.StatePersistence;
import org.das2.qds.QDataSet;
import org.das2.qstream.SimpleStreamFormatter;
import org.das2.qstream.StreamException;
import org.das2.util.LoggerManager;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;

public class EmbedDataExperiment {
    private static final Logger logger = LoggerManager.getLogger("autoplot");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeToZip(ZipOutputStream out, String name, File f) throws FileNotFoundException, IOException {
        ZipEntry e = new ZipEntry(name);
        try (FileChannel ic = null;){
            int c;
            ic = new FileInputStream(f).getChannel();
            out.putNextEntry(e);
            byte[] bbuf = new byte[2048];
            ByteBuffer buf = ByteBuffer.wrap(bbuf);
            while ((c = ic.read(buf)) > 0) {
                out.write(bbuf, 0, c);
                buf.flip();
            }
            out.closeEntry();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeToZip(ZipOutputStream out, String name, InputStream in) throws FileNotFoundException, IOException {
        ZipEntry e = new ZipEntry(name);
        try (ReadableByteChannel ic = null;){
            int c;
            ic = Channels.newChannel(in);
            out.putNextEntry(e);
            byte[] bbuf = new byte[2048];
            ByteBuffer buf = ByteBuffer.wrap(bbuf);
            while ((c = ic.read(buf)) > 0) {
                out.write(bbuf, 0, c);
                buf.flip();
            }
            out.closeEntry();
        }
    }

    private static URI makeCanonical(URI uri) {
        try {
            String path = uri.getPath();
            String[] pp = path.split("/");
            StringBuilder np = new StringBuilder();
            for (String p : pp) {
                if (p.length() <= 0) continue;
                np.append("/");
                np.append(p);
            }
            path = np.toString();
            return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), path, uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(EmbedDataExperiment.class.getName()).log(Level.SEVERE, null, ex);
            return uri;
        }
    }

    private static boolean hasNoResource(URISplit split) {
        return split.resourceUri == null || "vap+das2server".equalsIgnoreCase(split.vapScheme);
    }

    private static Set<URI> getResources(Application dom) {
        HashSet<URI> result = new HashSet<URI>();
        for (DataSourceFilter dsf : dom.getDataSourceFilters()) {
            String suri = dsf.getUri();
            if (suri.trim().length() == 0) continue;
            URISplit split = URISplit.parse(suri);
            if (split.resourceUri == null) continue;
            URI uri = EmbedDataExperiment.makeCanonical(split.resourceUri);
            if (EmbedDataExperiment.hasNoResource(split)) continue;
            if (DataSetURI.isAggregating(uri.toString())) {
                try {
                    String[] rr;
                    for (String r : rr = DataSetURI.unaggregate(uri.toString(), dom.getTimeRange())) {
                        try {
                            result.add(new URI(r));
                        }
                        catch (URISyntaxException ex) {
                            logger.log(Level.SEVERE, ex.getMessage(), ex);
                        }
                    }
                    continue;
                }
                catch (FileSystem.FileSystemOfflineException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                    continue;
                }
                catch (UnknownHostException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                    continue;
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                    continue;
                }
            }
            result.add(uri);
        }
        return result;
    }

    private static String makeRelativeName(String commonPath, URI uri) {
        String name;
        if (uri.getScheme().equals("file")) {
            name = uri.getPath();
            if (name.startsWith(commonPath)) {
                name = uri.getScheme() + "/" + name.substring(commonPath.length());
            } else {
                name = uri.toString().replaceAll(":///", "/");
                name = name.replaceAll(":/", "/");
            }
        } else {
            name = uri.toString().replaceAll("://", "/");
        }
        name = name.replaceAll("//", "/");
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(Application dom3, File f) throws FileNotFoundException, IOException {
        int i;
        Application dom = dom3.getController().getApplicationModel().createState(false);
        QDataSet[] datasets = new QDataSet[dom.getDataSourceFilters().length];
        for (int i2 = 0; i2 < datasets.length; ++i2) {
            if (!dom3.getDataSourceFilters(i2).getUri().equals("vap+internal:")) continue;
            datasets[i2] = dom3.getDataSourceFilters(i2).getController().getDataSet();
        }
        Set<URI> uris = EmbedDataExperiment.getResources(dom);
        String commonPath = null;
        for (URI uri : uris) {
            int i3;
            if (!uri.getScheme().equals("file")) continue;
            if (commonPath == null) {
                commonPath = uri.getPath();
                continue;
            }
            String path = uri.getPath();
            for (i3 = 0; i3 < Math.min(commonPath.length(), path.length()) && path.charAt(i3) == commonPath.charAt(i3); ++i3) {
            }
            commonPath = commonPath.substring(0, i3);
        }
        if (commonPath != null && !commonPath.endsWith("/") && (i = commonPath.lastIndexOf(47)) > -1) {
            commonPath = commonPath.substring(0, i + 1);
        }
        FileOutputStream fout = new FileOutputStream(f);
        ZipOutputStream out = null;
        try {
            out = new ZipOutputStream(fout);
            for (URI uri : EmbedDataExperiment.getResources(dom)) {
                String string = EmbedDataExperiment.makeRelativeName(commonPath, uri);
                File file1 = DataSetURI.getFile(uri, (ProgressMonitor)new NullProgressMonitor());
                EmbedDataExperiment.writeToZip(out, string, file1);
            }
            int nameGenCount = 0;
            int dsfCount = 0;
            for (DataSourceFilter dsf : dom.getDataSourceFilters()) {
                String uri = dsf.getUri();
                URISplit split = URISplit.parse(uri);
                if (uri.trim().length() > 0 && !EmbedDataExperiment.hasNoResource(split)) {
                    String name = EmbedDataExperiment.makeRelativeName(commonPath, split.resourceUri);
                    split.file = "%{PWD}/" + name;
                    dsf.setUri(URISplit.format(split));
                } else if (uri.equals("vap+internal:")) {
                    QDataSet ds = datasets[dsfCount];
                    logger.log(Level.FINE, "automatically embedding internal data as qds: {0}", ds);
                    File tmpFile = File.createTempFile("autoplot", ".qds");
                    String fname = "internal/data" + nameGenCount + ".qds";
                    SimpleStreamFormatter ff = new SimpleStreamFormatter();
                    FileOutputStream pout = new FileOutputStream(tmpFile);
                    InputStream pin = null;
                    try {
                        ff.format(ds, pout, false);
                        ((OutputStream)pout).close();
                        pin = new FileInputStream(tmpFile);
                        EmbedDataExperiment.writeToZip(out, fname, pin);
                        if (!tmpFile.delete()) {
                            logger.log(Level.WARNING, "unable to delete temp file: {0}", tmpFile);
                        }
                        dsf.setUri("%{PWD}/" + fname);
                    }
                    catch (StreamException ex) {
                        logger.log(Level.WARNING, null, ex);
                    }
                    finally {
                        ((OutputStream)pout).close();
                        if (pin != null) {
                            pin.close();
                        }
                    }
                    ++nameGenCount;
                }
                ++dsfCount;
            }
            ZipEntry zipEntry = new ZipEntry("default.vap");
            out.putNextEntry(zipEntry);
            StatePersistence.saveState(new NoCloseOutputStream(out), (Object)dom, "");
        }
        finally {
            if (out != null) {
                try {
                    out.closeEntry();
                }
                finally {
                    out.close();
                }
            }
            fout.close();
        }
    }

    private static class NoCloseOutputStream
    extends OutputStream {
        OutputStream out;

        NoCloseOutputStream(OutputStream out) {
            this.out = out;
        }

        @Override
        public void write(int b) throws IOException {
            this.out.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.out.write(b, off, len);
        }
    }
}

