/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.spase;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.das2.datum.Datum;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.Units;
import org.das2.qds.DDataSet;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.SparseDataSetBuilder;
import org.das2.qds.ops.Ops;
import org.das2.qds.util.DataSetBuilder;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class VOTableReader {
    private static final Logger logger = LoggerManager.getLogger("apdss.votable");
    DefaultHandler sax;
    String state;
    private final String STATE_OPEN = "open";
    private final String STATE_HEADER = "header";
    private final String STATE_DATA = "data";
    private final String STATE_RECORD = "record";
    private final String STATE_DESCRIPTION = "description";
    private final String STATE_FIELD = "field";
    private ProgressMonitor monitor;
    int ncolumn;
    QDataSet bds;
    List<String> ids = new ArrayList<String>();
    List<String> descriptions = new ArrayList<String>();
    List<Integer> dep0s = new ArrayList<Integer>();
    List<String> datatypes = new ArrayList<String>();
    List<Integer> arraysizes = new ArrayList<Integer>();
    List<String> names = new ArrayList<String>();
    List<String> sunits = new ArrayList<String>();
    List<Units> units = new ArrayList<Units>();
    List<String> fillValues = new ArrayList<String>();
    List<String> minValues = new ArrayList<String>();
    List<String> maxValues = new ArrayList<String>();
    List<Boolean> stopEnumerations = new ArrayList<Boolean>();
    DataSetBuilder dataSetBuilder;
    private static final int UNIQUE_ENUMERATION_VALUES_LIMIT = 20000;
    int index;
    int nelements;
    int ielement;
    private final String UNIT_UTC = "time.epoch";
    private final String UNIT_ENUM = "UNIT_ENUM";
    private final String DATATYPE_UTC = "time.epoch";
    private final double FILL_VALUE = -1.0E31;
    private final int ARRAYSIZE_ANY = -2;
    private final int ARRAYSIZE_SCALAR = -1;
    private boolean justHeader = false;
    int currentDep0 = -1;
    boolean lookForCurrentDep0 = true;
    private StringBuilder valueBuilder = new StringBuilder();
    private HashSet<String> warnings = new HashSet();

    public VOTableReader() {
        this.sax = new DefaultHandler(){

            @Override
            public void startDocument() throws SAXException {
                VOTableReader.this.state = "open";
                VOTableReader.this.monitor.started();
            }

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                if (localName.equals("TABLE") && VOTableReader.this.state.equals("open")) {
                    VOTableReader.this.state = "header";
                    VOTableReader.this.nelements = 0;
                } else if (localName.equals("FIELD") && VOTableReader.this.state.equals("header")) {
                    String id = attributes.getValue("ID");
                    String name = attributes.getValue("name");
                    if (id == null) {
                        id = Ops.safeName(name);
                    }
                    VOTableReader.this.ids.add(id);
                    VOTableReader.this.names.add(name);
                    String dt = attributes.getValue("datatype");
                    if (dt == null) {
                        throw new IllegalArgumentException("expected to see datatype in FIELD");
                    }
                    String ucd = attributes.getValue("ucd");
                    String sunit = attributes.getValue("unit");
                    String arraysize = attributes.getValue("arraysize");
                    if (dt.equals("char")) {
                        if (ucd != null && ucd.equals("time.epoch") || sunit != null && sunit.equals("DateTime")) {
                            sunit = "time.epoch";
                            VOTableReader.this.datatypes.add("time.epoch");
                        } else if (ucd != null && ucd.equals("time.start")) {
                            sunit = "time.epoch";
                            VOTableReader.this.datatypes.add("time.epoch");
                        } else if (ucd != null && ucd.equals("time.stop")) {
                            sunit = "time.epoch";
                            VOTableReader.this.datatypes.add("time.epoch");
                        } else if (name.equalsIgnoreCase("UTC")) {
                            sunit = "time.epoch";
                            VOTableReader.this.datatypes.add("time.epoch");
                        } else {
                            sunit = "UNIT_ENUM";
                            VOTableReader.this.datatypes.add(dt);
                        }
                    } else {
                        VOTableReader.this.datatypes.add(dt);
                    }
                    if (arraysize != null) {
                        if (arraysize.equals("*")) {
                            VOTableReader.this.arraysizes.add(-2);
                            if (!dt.equals("char")) {
                                logger.warning("only char can have variable length");
                                ++VOTableReader.this.nelements;
                            } else {
                                ++VOTableReader.this.nelements;
                            }
                        } else if (dt.equals("char")) {
                            VOTableReader.this.arraysizes.add(-1);
                            ++VOTableReader.this.nelements;
                        } else {
                            VOTableReader.this.arraysizes.add(Integer.parseInt(arraysize));
                            VOTableReader.this.nelements += Integer.parseInt(arraysize);
                        }
                    } else {
                        VOTableReader.this.arraysizes.add(-1);
                        ++VOTableReader.this.nelements;
                    }
                    if (null == sunit) {
                        VOTableReader.this.units.add(Units.dimensionless);
                        VOTableReader.this.lookForCurrentDep0 = true;
                    } else {
                        switch (sunit) {
                            case "time.epoch": {
                                VOTableReader.this.units.add(Units.cdfTT2000);
                                if (!VOTableReader.this.lookForCurrentDep0) break;
                                VOTableReader.this.currentDep0 = VOTableReader.this.descriptions.size();
                                VOTableReader.this.lookForCurrentDep0 = false;
                                break;
                            }
                            case "UNIT_ENUM": {
                                VOTableReader.this.units.add(EnumerationUnits.create(id));
                                VOTableReader.this.lookForCurrentDep0 = true;
                                break;
                            }
                            default: {
                                VOTableReader.this.units.add(Units.lookupUnits(sunit));
                                VOTableReader.this.lookForCurrentDep0 = true;
                            }
                        }
                    }
                    VOTableReader.this.dep0s.add(VOTableReader.this.currentDep0);
                    VOTableReader.this.descriptions.add(null);
                    VOTableReader.this.fillValues.add(null);
                    VOTableReader.this.minValues.add(null);
                    VOTableReader.this.maxValues.add(null);
                    VOTableReader.this.stopEnumerations.add(Boolean.FALSE);
                } else if (localName.equals("DESCRIPTION")) {
                    VOTableReader.this.state = "description";
                    VOTableReader.this.valueBuilder.delete(0, VOTableReader.this.valueBuilder.length());
                } else if (localName.equals("VALUES")) {
                    String fill = attributes.getValue("null");
                    if (fill != null) {
                        VOTableReader.this.fillValues.set(VOTableReader.this.index, fill);
                    }
                } else if (localName.equals("MIN")) {
                    String x = attributes.getValue("value");
                    if (x == null) {
                        logger.info("MIN is missing value attribute");
                    } else {
                        VOTableReader.this.minValues.set(VOTableReader.this.index, x);
                    }
                } else if (localName.equals("MAX")) {
                    String x = attributes.getValue("value");
                    if (x == null) {
                        logger.info("MAX is missing value attribute");
                    } else {
                        VOTableReader.this.maxValues.set(VOTableReader.this.index, x);
                    }
                } else if (localName.equals("DATA")) {
                    if (VOTableReader.this.justHeader) {
                        throw new RuntimeException("we're all done reading the header and dont need the data.");
                    }
                    VOTableReader.this.monitor.setProgressMessage("reading data");
                    VOTableReader.this.state = "data";
                    VOTableReader.this.dataSetBuilder = new DataSetBuilder(2, 100, VOTableReader.this.nelements);
                } else if (localName.equalsIgnoreCase("TR") && VOTableReader.this.state.equals("data")) {
                    VOTableReader.this.state = "record";
                    VOTableReader.this.index = 0;
                } else if (localName.equalsIgnoreCase("TD") && VOTableReader.this.state.equals("record")) {
                    VOTableReader.this.state = "field";
                    VOTableReader.this.valueBuilder.delete(0, VOTableReader.this.valueBuilder.length());
                }
            }

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                if (localName.equalsIgnoreCase("TD")) {
                    Units u;
                    int arraysize;
                    assert (VOTableReader.this.state.equals("field"));
                    String s = VOTableReader.this.valueBuilder.toString();
                    int slen = s.length();
                    if (slen > 1 && s.charAt(0) == '\"' && s.charAt(slen - 1) == '\"') {
                        s = s.substring(1, slen - 1);
                    }
                    if ((arraysize = VOTableReader.this.arraysizes.get(VOTableReader.this.index).intValue()) > 0) {
                        u = VOTableReader.this.units.get(VOTableReader.this.index);
                        String[] ss = s.trim().split("\\s+");
                        if (ss.length != arraysize) {
                            throw new IllegalArgumentException("values in votable don't match arraysize");
                        }
                        for (int jj = 0; jj < arraysize; ++jj) {
                            try {
                                VOTableReader.this.dataSetBuilder.putValue(-1, VOTableReader.this.ielement, u.parse(ss[jj]).doubleValue(u));
                                ++VOTableReader.this.ielement;
                                continue;
                            }
                            catch (ParseException ex) {
                                throw new IllegalArgumentException("unable to parse: " + ss[jj]);
                            }
                        }
                    } else {
                        if (s.equals(VOTableReader.this.fillValues.get(VOTableReader.this.index))) {
                            VOTableReader.this.dataSetBuilder.putValue(-1, VOTableReader.this.ielement, -1.0E31);
                        } else {
                            try {
                                Datum d;
                                u = VOTableReader.this.units.get(VOTableReader.this.index);
                                if (u instanceof EnumerationUnits) {
                                    if (VOTableReader.this.stopEnumerations.get(VOTableReader.this.index).booleanValue()) {
                                        d = u.createDatum(1);
                                    } else {
                                        d = ((EnumerationUnits)u).createDatum(s);
                                        if (d.doubleValue(u) > 20000.0) {
                                            VOTableReader.this.stopEnumerations.set(VOTableReader.this.index, true);
                                        }
                                    }
                                } else {
                                    d = u.parse(s);
                                }
                                VOTableReader.this.dataSetBuilder.putValue(-1, VOTableReader.this.ielement, d.doubleValue(u));
                            }
                            catch (ParseException ex) {
                                if (!VOTableReader.this.warnings.contains(ex.getMessage())) {
                                    Logger.getLogger(VOTableReader.class.getName()).log(Level.SEVERE, null, ex);
                                    VOTableReader.this.warnings.add(ex.getMessage());
                                }
                                VOTableReader.this.dataSetBuilder.putValue(-1, VOTableReader.this.ielement, -1.0E31);
                            }
                        }
                        ++VOTableReader.this.ielement;
                    }
                    VOTableReader.this.state = "record";
                    ++VOTableReader.this.index;
                    int nrec = VOTableReader.this.dataSetBuilder.getLength();
                    if (nrec % 1000 == 0) {
                        VOTableReader.this.monitor.setProgressMessage("reading data, " + nrec + " records");
                    }
                } else if (localName.equalsIgnoreCase("TR")) {
                    assert (VOTableReader.this.state.equals("record"));
                    VOTableReader.this.dataSetBuilder.nextRecord();
                    VOTableReader.this.state = "data";
                    VOTableReader.this.index = 0;
                    VOTableReader.this.ielement = 0;
                    if (VOTableReader.this.monitor.isCancelled()) {
                        throw new RuntimeException("reading is interrupted");
                    }
                } else if (localName.equals("FIELD")) {
                    assert (VOTableReader.this.state.equals("header"));
                    ++VOTableReader.this.index;
                } else if (localName.equals("DATA")) {
                    assert (VOTableReader.this.state.equals("header"));
                } else if (localName.equals("DESCRIPTION")) {
                    assert (VOTableReader.this.state.equals("description"));
                    VOTableReader.this.state = "header";
                    VOTableReader.this.descriptions.set(VOTableReader.this.index, VOTableReader.this.valueBuilder.toString());
                }
            }

            @Override
            public void characters(char[] ch, int start, int length) throws SAXException {
                if ("field".equals(VOTableReader.this.state)) {
                    VOTableReader.this.valueBuilder.append(ch, start, length);
                } else if ("description".equals(VOTableReader.this.state)) {
                    VOTableReader.this.valueBuilder.append(ch, start, length);
                }
            }
        };
    }

    public QDataSet getDataSet() {
        if (this.dataSetBuilder == null) {
            throw new IllegalArgumentException("table has not been read!");
        }
        this.dataSetBuilder.putProperty("BUNDLE_1", this.formBundleDescriptor());
        if (this.dataSetBuilder.getLength() > 0) {
            DDataSet result = this.dataSetBuilder.getDataSet();
            for (int jj = 0; jj < this.ids.size(); ++jj) {
                if (!Boolean.TRUE.equals(this.stopEnumerations.get(jj))) continue;
                logger.log(Level.INFO, "clear out enumeration at {0}, too many different values.", jj);
                for (int ii = 0; ii < result.length(); ++ii) {
                    result.putValue(ii, jj, -1.0E31);
                    ((MutablePropertyDataSet)result.property("BUNDLE_1")).putProperty("UNITS", jj, null);
                }
            }
            return result;
        }
        return DDataSet.createRank2(0, 10);
    }

    private QDataSet formBundleDescriptor() {
        SparseDataSetBuilder head = new SparseDataSetBuilder(2);
        head.setLength(this.nelements);
        int ielement1 = 0;
        for (int ii = 0; ii < this.ids.size(); ++ii) {
            if (this.arraysizes.get(ii) > 0) {
                int first = ielement1;
                for (int jj = 0; jj < this.arraysizes.get(ii); ++jj) {
                    head.putProperty("NAME", ielement1, this.ids.get(ii) + "_" + ielement1);
                    head.putProperty("LABEL", ielement1, this.names.get(ii));
                    head.putProperty("UNITS", ielement1, this.units.get(ii));
                    head.putProperty("TITLE", ielement1, this.descriptions.get(ii));
                    if (jj == 0) {
                        head.putValue(ielement1, 0, this.arraysizes.get(ii).intValue());
                        head.putProperty("ELEMENT_LABEL", ielement1, this.names.get(ii));
                        head.putProperty("ELEMENT_NAME", ielement1, this.ids.get(ii));
                        head.putProperty("DEPEND_1", ielement1, Ops.findgen(this.arraysizes.get(ii)));
                    }
                    head.putProperty("START_INDEX", ielement1, first);
                    if (this.fillValues.get(ii) != null) {
                        head.putProperty("FILL_VALUE", ielement1, -1.0E31);
                    }
                    if (this.minValues.get(ii) != null) {
                        try {
                            head.putProperty("VALID_MIN", ielement1, this.units.get(ii).parse(this.minValues.get(ii)).doubleValue(this.units.get(ii)));
                        }
                        catch (ParseException ex) {
                            logger.log(Level.INFO, "unable to parse MIN for {0}", this.ids.get(ii));
                        }
                    }
                    if (this.maxValues.get(ii) != null) {
                        try {
                            head.putProperty("VALID_MAX", ielement1, this.units.get(ii).parse(this.maxValues.get(ii)).doubleValue(this.units.get(ii)));
                        }
                        catch (ParseException ex) {
                            logger.log(Level.INFO, "unable to parse MAX for {0}", this.ids.get(ii));
                        }
                    }
                    ++ielement1;
                }
                continue;
            }
            head.putProperty("NAME", ielement1, this.ids.get(ii));
            if (this.dep0s.get(ii) > -1 && this.dep0s.get(ii) < ii) {
                head.putProperty("DEPENDNAME_0", ielement1, this.ids.get(this.dep0s.get(ii)));
            }
            head.putProperty("LABEL", ielement1, this.names.get(ii));
            head.putProperty("UNITS", ielement1, this.units.get(ii));
            head.putProperty("TITLE", ielement1, this.descriptions.get(ii));
            if (this.fillValues.get(ii) != null) {
                head.putProperty("FILL_VALUE", ielement1, -1.0E31);
            }
            if (this.minValues.get(ii) != null) {
                try {
                    head.putProperty("VALID_MIN", ielement1, this.units.get(ii).parse(this.minValues.get(ii)).doubleValue(this.units.get(ii)));
                }
                catch (ParseException ex) {
                    logger.log(Level.INFO, "unable to parse MIN for {0}", this.ids.get(ii));
                }
            }
            if (this.maxValues.get(ii) != null) {
                try {
                    head.putProperty("VALID_MAX", ielement1, this.units.get(ii).parse(this.maxValues.get(ii)).doubleValue(this.units.get(ii)));
                }
                catch (ParseException ex) {
                    logger.log(Level.INFO, "unable to parse MAX for {0}", this.ids.get(ii));
                }
            }
            ++ielement1;
        }
        return head.getDataSet();
    }

    public QDataSet readHeader(String s, ProgressMonitor monitor) throws IOException, SAXException, ParserConfigurationException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        SAXParser saxParser = spf.newSAXParser();
        XMLReader xmlReader = saxParser.getXMLReader();
        this.monitor = monitor;
        xmlReader.setContentHandler(this.sax);
        this.justHeader = true;
        try {
            xmlReader.parse(s);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        QDataSet lbds = this.formBundleDescriptor();
        monitor.finished();
        return lbds;
    }

    public QDataSet readTable(String s, ProgressMonitor monitor) throws IOException, SAXException, ParserConfigurationException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        SAXParser saxParser = spf.newSAXParser();
        XMLReader xmlReader = saxParser.getXMLReader();
        this.monitor = monitor;
        xmlReader.setContentHandler(this.sax);
        xmlReader.parse(s);
        QDataSet ds = this.getDataSet();
        monitor.finished();
        return ds;
    }

    public QDataSet readTable(String s) throws IOException, SAXException, ParserConfigurationException {
        return this.readTable(s, new NullProgressMonitor());
    }
}

