/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.spase;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.autoplot.datasource.AbstractDataSource;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSource;
import org.autoplot.datasource.MetadataModel;
import org.autoplot.datasource.URISplit;
import org.autoplot.metatree.SpaseMetadataModel;
import org.autoplot.spase.DOMWalker;
import org.autoplot.spase.VOTableReader;
import org.autoplot.spase.XMLTypeCheck;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.qds.DDataSet;
import org.das2.qds.DataSetOps;
import org.das2.qds.QDataSet;
import org.das2.qds.WritableDataSet;
import org.das2.qds.ops.Ops;
import org.das2.qds.util.DataSetBuilder;
import org.das2.util.monitor.CancelledOperationException;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.TreeWalker;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SpaseRecordDataSource
extends AbstractDataSource {
    private static final Logger logger = Logger.getLogger("apdss.spase");
    URL url;
    Document document;
    DataSource delegate;
    Object type;

    public SpaseRecordDataSource(URI uri) throws IllegalArgumentException, IOException, SAXException, Exception {
        super(uri);
        try {
            this.url = new URL(uri.getSchemeSpecificPart());
        }
        catch (MalformedURLException ex) {
            logger.warning("Failed to convert URI to URL");
            throw new RuntimeException(ex);
        }
    }

    private String findSurl() {
        String[] lookFor = new String[]{"Spase", "NumericalData", "AccessInformation", "AccessURL", "URL"};
        NodeList list = this.document.getElementsByTagName(lookFor[0]);
        Element pos = (Element)list.item(0);
        if (pos == null) {
            throw new IllegalArgumentException("Unable to find node Space/NumericalData/AccessInformation/AccessURL/URL in " + this.url);
        }
        for (int i = 1; i < lookFor.length; ++i) {
            list = pos.getElementsByTagName(lookFor[i]);
            pos = (Element)list.item(0);
        }
        String result = null;
        list = pos.getChildNodes();
        for (int k = 0; k < list.getLength(); ++k) {
            Node child = list.item(k);
            if (child.getNodeType() != 3) continue;
            result = child.getNodeValue();
        }
        return result;
    }

    @Override
    public QDataSet getDataSet(ProgressMonitor mon) throws Exception {
        mon.started();
        mon.setProgressMessage("parse xml file");
        File f = DataSetURI.getFile(this.uri, mon.getSubtaskMonitor("get file"));
        this.type = new XMLTypeCheck().calculateType(f);
        if (this.type != XMLTypeCheck.TYPE_VOTABLE) {
            this.readXML(mon.getSubtaskMonitor("readXML"));
        } else {
            this.document = null;
        }
        String surl = null;
        try {
            XPathFactory factory = XPathFactory.newInstance();
            XPath xpath = factory.newXPath();
            if (this.type == XMLTypeCheck.TYPE_SPASE) {
                QDataSet result;
                surl = xpath.evaluate("//Spase/NumericalData/AccessInformation/AccessURL/URL/text()", this.document);
                if (surl.trim().length() == 0) {
                    surl = xpath.evaluate("//Spase/Granule/Source/URL/text()", this.document);
                    if (surl.trim().length() == 0) {
                        throw new IllegalArgumentException("Expected to find URI in //Spase/Granule/Source/URL/text()");
                    }
                    throw new IllegalArgumentException("Granule is found at: " + surl + ", unable to read");
                }
                this.delegate = DataSetURI.getDataSource(DataSetURI.getURIValid(surl));
                mon.setProgressMessage("reading " + this.delegate.getURI());
                QDataSet qDataSet = result = this.delegate.getDataSet(mon.getSubtaskMonitor("get delegate"));
                return qDataSet;
            }
            if (this.type == XMLTypeCheck.TYPE_HELM) {
                Object desc;
                NodeList nl = (NodeList)xpath.evaluate("//Eventlist/Event", this.document, XPathConstants.NODESET);
                DataSetBuilder timespans = new DataSetBuilder(2, 100, 2);
                DataSetBuilder description = new DataSetBuilder(1, 100);
                EnumerationUnits eu = EnumerationUnits.create("eventDesc");
                description.putProperty("UNITS", eu);
                timespans.putProperty("UNITS", Units.us2000);
                timespans.putProperty("BINS_1", "min,max");
                mon.setTaskSize(nl.getLength());
                mon.setProgressMessage("reading events");
                for (int j = 0; j < nl.getLength(); ++j) {
                    String stopDate;
                    Node item = nl.item(j);
                    mon.setTaskProgress(j);
                    if (mon.isCancelled()) {
                        throw new CancelledOperationException("User pressed cancel");
                    }
                    desc = (String)xpath.evaluate("Description/text()", item, XPathConstants.STRING);
                    String startDate = (String)xpath.evaluate("TimeSpan/StartDate/text()", item, XPathConstants.STRING);
                    if (startDate.compareTo(stopDate = (String)xpath.evaluate("TimeSpan/StopDate/text()", item, XPathConstants.STRING)) > 0) {
                        IllegalArgumentException e = new IllegalArgumentException("StartDate is after StopDate: " + startDate);
                        e.printStackTrace();
                        timespans.putValue(j, 0, Units.us2000.parse(startDate).doubleValue(Units.us2000));
                        timespans.putValue(j, 1, Units.us2000.parse(startDate).doubleValue(Units.us2000));
                        description.putValue(j, eu.createDatum(e.getMessage()).doubleValue(eu));
                        continue;
                    }
                    description.putValue(j, eu.createDatum(desc).doubleValue(eu));
                    timespans.putValue(j, 0, Units.us2000.parse(startDate).doubleValue(Units.us2000));
                    timespans.putValue(j, 1, Units.us2000.parse(stopDate).doubleValue(Units.us2000));
                }
                DDataSet dd = description.getDataSet();
                dd.putProperty("DEPEND_0", timespans.getDataSet());
                String title = (String)xpath.evaluate("//Eventlist/ResourceHeader/Description", this.document, XPathConstants.STRING);
                dd.putProperty("TITLE", title);
                desc = dd;
                return desc;
            }
            if (this.type == XMLTypeCheck.TYPE_VOTABLE) {
                QDataSet ttag;
                VOTableReader r = new VOTableReader();
                QDataSet result = r.readTable(f.toString(), mon.getSubtaskMonitor("read votable"));
                QDataSet bds = (QDataSet)result.property("BUNDLE_1");
                QDataSet data = null;
                Units u0 = (Units)bds.property("UNITS", 0);
                Units u1 = null;
                if (bds.length() > 0) {
                    u1 = (Units)bds.property("UNITS", 1);
                }
                int ii = 0;
                if ((u0 == null || !UnitsUtil.isTimeLocation(u0)) && u1 != null && UnitsUtil.isTimeLocation(u1) && bds.length() > 1) {
                    ii = 1;
                    u0 = u1;
                    if (bds.length() > 2) {
                        u1 = (Units)bds.property("UNITS", 2);
                    }
                }
                if (bds.length() > 1) {
                    if (u0 != null && u1 != null && UnitsUtil.isTimeLocation(u0) && UnitsUtil.isTimeLocation(u1)) {
                        WritableDataSet wttag = DataSetOps.applyIndex(result, 1, Ops.linspace(ii, ii + 1, 2), false);
                        wttag.putProperty("BINS_1", "min,max");
                        wttag.putProperty("BUNDLE_1", null);
                        wttag.putProperty("UNITS", u0);
                        ttag = wttag;
                        if (bds.length() == ii + 2) {
                            EnumerationUnits eu = EnumerationUnits.create("eventDesc");
                            WritableDataSet mdata = Ops.replicate(eu.createDatum("").doubleValue(eu), ttag.length());
                            mdata.putProperty("UNITS", eu);
                            data = mdata;
                        }
                    } else {
                        ttag = DataSetOps.unbundle(result, 0);
                    }
                } else {
                    ttag = DataSetOps.unbundle(result, 0);
                }
                if (data == null) {
                    URISplit split = URISplit.parse(this.uri);
                    LinkedHashMap<String, String> args = URISplit.parseParams(split.params);
                    String arg0 = (String)args.get("arg_0");
                    data = arg0 == null ? DataSetOps.unbundle(result, result.length(0) - 1) : DataSetOps.unbundle(result, (String)args.get("arg_0"));
                }
                QDataSet qDataSet = Ops.link(ttag, data);
                return qDataSet;
            }
            try {
                throw new IllegalArgumentException("Unsupported XML type, root node should be Spase or Eventlist");
            }
            catch (XPathExpressionException ex) {
                throw new IllegalArgumentException("unable to get /Spase/NumericalData/AccessInformation/AccessURL/URL(): " + ex.getMessage());
            }
            catch (MalformedURLException ex) {
                throw new IllegalArgumentException("Spase record AccessURL is malformed: " + surl);
            }
            catch (Exception ex) {
                throw ex;
            }
        }
        finally {
            mon.finished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readXML(ProgressMonitor mon) throws IOException, SAXException {
        DocumentBuilder builder = null;
        try {
            builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException(ex);
        }
        File f = DataSetURI.getFile(this.uri, mon);
        try (FileInputStream in = new FileInputStream(f);){
            InputSource source = new InputSource(in);
            this.document = builder.parse(source);
        }
    }

    @Override
    public Map<String, Object> getMetadata(ProgressMonitor mon) throws Exception {
        if (this.type.equals(XMLTypeCheck.TYPE_VOTABLE)) {
            return new HashMap<String, Object>();
        }
        if (this.document == null) {
            this.readXML(mon);
        }
        DocumentTraversal traversal = (DocumentTraversal)((Object)this.document);
        NodeFilter filter = new NodeFilter(){

            @Override
            public short acceptNode(Node n) {
                if (n.getNodeType() == 3 && ((Text)n).getData().trim().length() == 0) {
                    return 2;
                }
                return 1;
            }
        };
        int whatToShow = -129;
        Node root = this.document.getFirstChild();
        TreeWalker walker = traversal.createTreeWalker(root, whatToShow, filter, false);
        DOMWalker walk = new DOMWalker(walker);
        return walk.getAttributes(walk.getRoot());
    }

    @Override
    public Map<String, Object> getProperties() {
        try {
            return new SpaseMetadataModel().properties(this.getMetadata(new NullProgressMonitor()));
        }
        catch (Exception ex) {
            return Collections.singletonMap("Exception", ex);
        }
    }

    @Override
    public MetadataModel getMetadataModel() {
        if (this.type == XMLTypeCheck.TYPE_SPASE) {
            return new SpaseMetadataModel();
        }
        return null;
    }
}

