/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.server;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.das2.util.LoggerManager;

public class RequestListener {
    private static final Logger logger = LoggerManager.getLogger("autoplot.server");
    private boolean readData = false;
    public static final String PROP_READDATA = "readData";
    private Runnable run = new Runnable(){

        @Override
        public void run() {
            while (RequestListener.this.listening) {
                try {
                    ServerSocket listen = new ServerSocket(RequestListener.this.port, 1000);
                    RequestListener.this.setPort(listen.getLocalPort());
                    System.err.println("Autoplot is listening on port " + RequestListener.this.port + ".");
                    logger.log(Level.FINE, "Autoplot is listening on port {0}.", RequestListener.this.port);
                    while (RequestListener.this.listening) {
                        Socket socket = listen.accept();
                        logger.log(Level.INFO, "connect @ {0}", new Date(System.currentTimeMillis()));
                        RequestListener.this.setSocket(socket);
                        if (RequestListener.this.readData) {
                            try {
                                InputStream in = socket.getInputStream();
                                StringBuilder buf = new StringBuilder();
                                int i = in.read();
                                while (i != -1) {
                                    buf.append((char)i);
                                    i = in.read();
                                }
                                RequestListener.this.setData(buf.toString());
                            }
                            catch (IOException ex) {
                                logger.log(Level.SEVERE, ex.getMessage(), ex);
                            }
                        }
                        RequestListener.this.setRequestCount(RequestListener.this.getRequestCount() + 1);
                    }
                }
                catch (IOException ex) {
                    RequestListener.this.listening = false;
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                }
            }
        }
    };
    private Socket socket = null;
    public static final String PROP_SOCKET = "socket";
    public static final String PROP_PORT = "port";
    private int port = 1234;
    private String data = null;
    public static final String PROP_DATA = "data";
    private boolean listening = false;
    public static final String PROP_LISTENING = "listening";
    private int requestCount = 0;
    public static final String PROP_REQUESTCOUNT = "requestCount";
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public void startListening() {
        logger.fine("start listening");
        this.listening = true;
        new Thread(this.run).start();
    }

    public void stopListening() {
        logger.fine("stop listening");
        this.listening = false;
    }

    public boolean isReadData() {
        return this.readData;
    }

    public void setReadData(boolean newreadData) {
        boolean oldreadData = this.readData;
        this.readData = newreadData;
        this.propertyChangeSupport.firePropertyChange(PROP_READDATA, oldreadData, newreadData);
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void setSocket(Socket newsocket) {
        Socket oldsocket = this.socket;
        this.socket = newsocket;
        this.propertyChangeSupport.firePropertyChange(PROP_SOCKET, oldsocket, newsocket);
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int newport) {
        int old = this.port;
        this.port = newport;
        this.propertyChangeSupport.firePropertyChange(PROP_PORT, old, this.port);
    }

    public OutputStream getOutputStream() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public String getData() {
        return this.data;
    }

    public void setData(String newdata) {
        String olddata = this.data;
        this.data = newdata;
        logger.log(Level.FINE, "setData({0})", newdata);
        this.propertyChangeSupport.firePropertyChange(PROP_DATA, olddata, newdata);
    }

    public boolean isListening() {
        return this.listening;
    }

    public void setListening(boolean newlistening) {
        logger.log(Level.FINE, "setListening({0})", newlistening);
        boolean oldlistening = this.listening;
        this.listening = newlistening;
        this.propertyChangeSupport.firePropertyChange(PROP_LISTENING, oldlistening, newlistening);
    }

    public int getRequestCount() {
        return this.requestCount;
    }

    public void setRequestCount(int newrequestCount) {
        int oldrequestCount = this.requestCount;
        this.requestCount = newrequestCount;
        this.propertyChangeSupport.firePropertyChange(PROP_REQUESTCOUNT, oldrequestCount, newrequestCount);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public synchronized void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }
}

