/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.autoplot.ApplicationModel;
import org.autoplot.JythonUtil;
import org.autoplot.ScriptContext;
import org.autoplot.jythonsupport.JythonRefactory;
import org.das2.util.LoggerManager;
import org.python.core.Py;
import org.python.core.PyDictionary;
import org.python.core.PyObject;
import org.python.util.InteractiveInterpreter;

public class RequestHandler {
    private static final Logger logger = LoggerManager.getLogger("autoplot.server");

    private String untaint(String in, OutputStream out) {
        try {
            if (in.contains("import")) {
                out.write("commands cannot contain import\n".getBytes());
                in = null;
            } else if (in.contains("eval")) {
                out.write("commands cannot contain eval\n".getBytes());
                in = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return in;
    }

    public String handleRequest(InputStream in, ApplicationModel model, OutputStream out) {
        try {
            InteractiveInterpreter interp = JythonUtil.createInterpreter(true, false);
            interp.setOut(out);
            interp.set("dom", (Object)model.getDocumentModel());
            interp.set("params", (PyObject)new PyDictionary());
            interp.set("resourceURI", Py.None);
            ScriptContext._setOutputStream(out);
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            boolean echo = true;
            if (echo) {
                out.write("autoplot> ".getBytes());
            }
            String s = reader.readLine();
            while (s != null) {
                if ((s = this.untaint(s, out)) != null) {
                    logger.log(Level.FINE, "executing command: \"{0}\"", s);
                    try {
                        echo = !s.trim().endsWith(";");
                        interp.exec(JythonRefactory.fixImports(s));
                    }
                    catch (RuntimeException ex) {
                        ex.printStackTrace(new PrintStream(out));
                        ex.printStackTrace();
                    }
                }
                try {
                    if (echo) {
                        out.write("autoplot> ".getBytes());
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                s = reader.readLine();
            }
            return null;
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            return null;
        }
    }
}

