/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.scriptconsole;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.beans.ExceptionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.autoplot.ApplicationModel;
import org.autoplot.AutoplotUtil;
import org.autoplot.JythonUtil;
import org.autoplot.datasource.AutoplotSettings;
import org.autoplot.datasource.DataSetSelector;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.FileSystemUtil;
import org.autoplot.datasource.URISplit;
import org.autoplot.datasource.jython.JythonDataSourceFactory;
import org.autoplot.dom.ApplicationController;
import org.autoplot.jythonsupport.JythonRefactory;
import org.autoplot.jythonsupport.ui.EditorAnnotationsSupport;
import org.autoplot.jythonsupport.ui.EditorTextPane;
import org.autoplot.jythonsupport.ui.ParametersFormPanel;
import org.autoplot.scriptconsole.DebuggerConsole;
import org.autoplot.scriptconsole.JythonScriptPanel;
import org.das2.components.DasProgressPanel;
import org.das2.util.LoggerManager;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.python.core.FileUtil;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyInteger;
import org.python.core.PyObject;
import org.python.core.PySyntaxError;
import org.python.core.PyTraceback;
import org.python.core.ThreadState;
import org.python.util.InteractiveInterpreter;
import org.python.util.PythonInterpreter;

public class ScriptPanelSupport {
    private static final Logger logger = LoggerManager.getLogger("autoplot.jython");
    private static final int RECENT_FILES_COUNT = 100;
    File file;
    final ApplicationModel model;
    final ApplicationController applicationController;
    final DataSetSelector selector;
    final JythonScriptPanel panel;
    final EditorAnnotationsSupport annotationsSupport;
    private final String PREFERENCE_OPEN_FILE = "openFile";
    private InteractiveInterpreter interruptible;
    ThreadState ts;
    WatchService watcher;
    public static final String PROP_INTERRUPTABLE = "interruptable";
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    ScriptPanelSupport(final JythonScriptPanel panel, ApplicationModel model, DataSetSelector selector) {
        this.model = model;
        this.applicationController = model.getDocumentModel().getController();
        this.selector = selector;
        this.panel = panel;
        this.annotationsSupport = panel.getEditorPanel().getEditorAnnotationsSupport();
        this.applicationController.addPropertyChangeListener("focusUri", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (panel.runningScript == null) {
                    ScriptPanelSupport.this.maybeDisplayDataSourceScript();
                }
            }
        });
    }

    private boolean maybeDisplayDataSourceScript() throws HeadlessException, NullPointerException {
        try {
            LinkedHashMap<String, String> params;
            String sfile = this.applicationController.getFocusUri();
            if (sfile == null) {
                return false;
            }
            URISplit split = URISplit.parse(sfile);
            if (!URISplit.implicitVapScheme(split).endsWith("jyds")) {
                return false;
            }
            if (this.panel.isDirty()) {
                logger.fine("editor is dirty, not showing script.");
                return false;
            }
            if (this.panel.getRunningScript() != null) {
                logger.fine("editor is busy running a script.");
                return false;
            }
            sfile = split.params != null ? ((params = URISplit.parseParams(split.params)).containsKey("script") ? (String)params.get("script") : split.resourceUri.toString()) : split.resourceUri.toString();
            final URI fsfile = DataSetURI.getURI(sfile);
            if (this.panel.getFilename() != null) {
                File ff1;
                File ff2;
                File ff12;
                URI u1 = DataSetURI.getURI(this.panel.getFilename());
                String f1 = URISplit.parse((URI)u1).file;
                URI u2 = DataSetURI.getURI(sfile);
                String f2 = URISplit.parse((URI)u2).file;
                if (f1.startsWith("file:") && f2.startsWith("file:") && (ff12 = new File(f1.substring(5))).equals(ff2 = new File(f2.substring(5)))) {
                    return true;
                }
                File ff3 = DataSetURI.getCacheFilename(fsfile);
                if (f1.startsWith("file:") && ff3 != null && ff3.equals(ff1 = new File(f1.substring(5)))) {
                    return true;
                }
            }
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    try {
                        ScriptPanelSupport.this.file = DataSetURI.getFile(fsfile, (ProgressMonitor)new NullProgressMonitor());
                        ScriptPanelSupport.this.loadFile(ScriptPanelSupport.this.file);
                        ScriptPanelSupport.this.panel.setContext(1);
                        ScriptPanelSupport.this.panel.setFilename(ScriptPanelSupport.this.file.toString());
                    }
                    catch (IOException ex) {
                        logger.log(Level.SEVERE, ex.getMessage(), ex);
                    }
                }
            };
            try {
                this.panel.getEditorPanel().getEditorKit();
                SimpleAttributeSet att = new SimpleAttributeSet();
                StyleConstants.setItalic(att, true);
                this.panel.getEditorPanel().getDocument().remove(0, this.panel.getEditorPanel().getDocument().getLength());
                this.panel.getEditorPanel().getDocument().insertString(0, "loading " + fsfile, att);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            new Thread(run, "load script thread").start();
        }
        catch (NullPointerException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            return false;
        }
        catch (URISyntaxException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            return false;
        }
        return true;
    }

    public int getSaveFile() throws IOException {
        int r;
        String openFile;
        Preferences prefs;
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(this.getFileFilter());
        JCheckBox cb = new JCheckBox("rename");
        cb.setEnabled(true);
        cb.setToolTipText("rename file, deleting old name \"" + this.file + "\"");
        chooser.setAccessory(cb);
        if (this.file != null && !FileSystemUtil.isChildOf(FileSystem.settings().getLocalCacheDir(), this.file)) {
            chooser.setSelectedFile(this.file);
        } else {
            if (FileSystemUtil.isChildOf(FileSystem.settings().getLocalCacheDir(), this.file)) {
                String home = System.getProperty("user.home");
                File ff = new File(home + File.separator + this.file.getName());
                chooser.setSelectedFile(ff);
            } else {
                chooser.setSelectedFile(this.file);
            }
            prefs = AutoplotSettings.settings().getPreferences(ScriptPanelSupport.class);
            openFile = prefs.get("openFile", "");
            if (!openFile.equals("") && !FileSystemUtil.isChildOf(FileSystem.settings().getLocalCacheDir(), new File(openFile))) {
                File dir = new File(openFile).getParentFile();
                chooser.setCurrentDirectory(dir);
            }
        }
        if (this.file == null && !(openFile = (prefs = AutoplotSettings.settings().getPreferences(ScriptPanelSupport.class)).get("openFile", "")).equals("")) {
            chooser.setCurrentDirectory(new File(openFile).getParentFile());
        }
        if ((r = chooser.showSaveDialog(this.panel)) == 0) {
            File oldFile = this.file;
            this.file = chooser.getSelectedFile();
            if (!(this.file.toString().endsWith(".jy") || this.file.toString().endsWith(".py") || this.file.toString().endsWith(".jyds"))) {
                this.file = this.panel.getContext() == 1 ? new File(this.file.toString() + ".jyds") : new File(this.file.toString() + ".jy");
            }
            if (oldFile != null && cb.isSelected() && !oldFile.equals(this.file) && !oldFile.delete()) {
                JOptionPane.showMessageDialog(this.panel, "unable to delete old file: " + oldFile);
            }
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int save() throws FileNotFoundException, IOException {
        if (this.file == null || this.file.toString().contains(FileSystem.settings().getLocalCacheDir().toString())) {
            logger.fine("file is null ");
            if (this.panel.isDirty()) {
                return this.saveAs();
            }
            return 0;
        }
        try (OutputStream out = null;){
            if (!(this.file.exists() && this.file.canWrite() || this.file.getParentFile().canWrite())) {
                throw new IOException("unable to write to file: " + this.file);
            }
            if (this.watcher != null) {
                try {
                    logger.fine("closing watcher");
                    this.watcher.close();
                }
                catch (IOException ex) {
                    logger.log(Level.WARNING, ex.getMessage(), ex);
                }
            } else {
                logger.fine("logger was null");
            }
            out = new FileOutputStream(this.file);
            String text = this.panel.getEditorPanel().getText();
            out.write(text.getBytes());
            this.panel.setDirty(false);
            final File ffile = this.file;
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    try {
                        logger.fine("pausing before restarting watcher");
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(ScriptPanelSupport.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    try {
                        logger.fine("restarting watcher");
                        ScriptPanelSupport.this.restartWatcher(ffile);
                    }
                    catch (IOException ex) {
                        Logger.getLogger(ScriptPanelSupport.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            };
            new Thread(run).start();
        }
        return 0;
    }

    private void watcherRunnable(final WatchService watch, final Path fpath) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                Path parent = fpath.getParent();
                logger.log(Level.FINER, "start watch event loop on {0}", new Object[]{parent});
                while (true) {
                    try {
                        WatchKey key;
                        block19: do {
                            key = ScriptPanelSupport.this.watcher.take();
                            Iterator<WatchEvent<?>> iterator = key.pollEvents().iterator();
                            while (iterator.hasNext()) {
                                WatchEvent<?> e;
                                WatchEvent<?> ev = e = iterator.next();
                                Path name = (Path)ev.context();
                                logger.log(Level.FINER, "watch event {0} {1}", new Object[]{ev.kind(), ev.context()});
                                if (!parent.resolve(name).equals(fpath)) continue;
                                try (FileInputStream in = new FileInputStream(ScriptPanelSupport.this.file);){
                                    String newContents = new String(FileUtil.readBytes((InputStream)in));
                                    String currentf = ScriptPanelSupport.this.panel.getEditorPanel().getText();
                                    currentf = currentf.trim();
                                    newContents = newContents.trim();
                                    if (currentf.equals(newContents)) {
                                        logger.fine("timestamp changed but contents are the same.");
                                        continue block19;
                                    }
                                }
                                catch (IOException ex) {
                                    continue block19;
                                }
                                if (0 == JOptionPane.showConfirmDialog(ScriptPanelSupport.this.panel, "File changed on disk.  Do you want to reload?", "File Changed on Disk", 2)) {
                                    try {
                                        ScriptPanelSupport.this.loadFile(ScriptPanelSupport.this.file);
                                    }
                                    catch (IOException ex) {
                                        logger.log(Level.SEVERE, null, ex);
                                    }
                                    continue;
                                }
                                ScriptPanelSupport.this.panel.setDirty(true);
                            }
                        } while (key.reset());
                        logger.log(Level.FINER, "watch key could not be reset: {0}", key);
                        return;
                    }
                    catch (ClosedWatchServiceException ex) {
                        logger.log(Level.FINER, "watch service was closed: {0}", watch);
                        return;
                    }
                    catch (InterruptedException ex) {
                        logger.log(Level.SEVERE, null, ex);
                        continue;
                    }
                    break;
                }
            }
        };
        new Thread(run, "fileWatcherRunnable").start();
    }

    private void restartWatcher(File file) throws IOException {
        logger.entering("org.autoplot.scriptconsole", "restartWatcher {0}", file);
        if (this.watcher != null) {
            this.watcher.close();
        }
        this.watcher = FileSystems.getDefault().newWatchService();
        Path fpath = file.toPath();
        Path parent = fpath.getParent();
        try {
            parent.register(this.watcher, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE);
            this.watcherRunnable(this.watcher, file.toPath());
        }
        catch (ClosedWatchServiceException ex) {
            logger.fine("watch service was closed");
        }
        logger.exiting("org.autoplot.scriptconsole", "restartWatcher {0}", file);
    }

    protected void loadFile(File file) throws IOException, FileNotFoundException {
        try (FileInputStream r = new FileInputStream(file);){
            this.file = file;
            this.panel.setFilename(file.toString());
            this.loadInputStream(r);
            if (file.toString().endsWith(".jyds")) {
                this.panel.setContext(1);
            } else {
                this.panel.setContext(0);
            }
        }
        this.restartWatcher(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadInputStream(InputStream in) throws IOException {
        this.panel.containsTabs = false;
        try (BufferedReader r = null;){
            StringBuilder buf = new StringBuilder();
            r = new BufferedReader(new InputStreamReader(in));
            String s = r.readLine();
            int tabWarn = 3;
            int lineNum = 1;
            while (s != null) {
                if (s.contains("\t")) {
                    this.panel.containsTabs = true;
                    if (tabWarn > 0) {
                        logger.log(Level.FINE, "line {0} contains tabs: {1}", new Object[]{lineNum, s});
                        --tabWarn;
                    }
                }
                buf.append(s).append("\n");
                s = r.readLine();
                ++lineNum;
            }
            final String fs = buf.toString();
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    try {
                        ScriptPanelSupport.this.annotationsSupport.clearAnnotations();
                        Document d = ScriptPanelSupport.this.panel.getEditorPanel().getDocument();
                        d.remove(0, d.getLength());
                        d.insertString(0, fs, null);
                        ScriptPanelSupport.this.panel.setDirty(false);
                    }
                    catch (NullPointerException ex) {
                        try {
                            Document d = ScriptPanelSupport.this.panel.getEditorPanel().getDocument();
                            d.remove(0, d.getLength());
                            d.insertString(0, fs, null);
                            ScriptPanelSupport.this.panel.setDirty(false);
                        }
                        catch (BadLocationException badLocationException) {}
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            };
            SwingUtilities.invokeLater(run);
        }
    }

    private boolean uriFilesEqual(String surl1, String surl2) throws URISyntaxException {
        int i1 = surl1.indexOf(63);
        if (i1 == -1) {
            i1 = surl1.length();
        }
        URI uri1 = DataSetURI.getURI(surl1.substring(0, i1));
        int i2 = surl2.indexOf(63);
        if (i2 == -1) {
            i2 = surl2.length();
        }
        URI uri2 = DataSetURI.getURI(surl2.substring(0, i2));
        if (uri1 == null) {
            return false;
        }
        return uri1.equals(uri2);
    }

    public void annotateError(Throwable ex) {
        StackTraceElement[] ses = ex.getStackTrace();
        if (this.file != null) {
            for (StackTraceElement se : ses) {
                if (se == null || se.getFileName() == null || !se.getFileName().endsWith(this.file.getName()) || se.getLineNumber() <= -1) continue;
                int line = se.getLineNumber();
                this.annotationsSupport.annotateLine(line, "error", ex.toString(), null);
            }
        }
    }

    public void annotateError(PyException ex, int offset, PythonInterpreter interp) {
        if (ex instanceof PySyntaxError) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            int lineno = offset + ((PyInteger)ex.value.__getitem__(1).__getitem__(1)).getValue();
            this.annotationsSupport.annotateLine(lineno, "error", ex.toString(), interp);
        } else {
            PyTraceback otraceback = ex.traceback;
            int line = 0;
            int count = 0;
            while (otraceback instanceof PyTraceback && count < 3) {
                PyTraceback traceback = otraceback;
                if (traceback.tb_frame == null) {
                    Exception e;
                    PyObject o = ex.value;
                    if (o != null && !(o instanceof PyObject) && (e = (Exception)o.__tojava__(Exception.class)) != null) {
                        this.annotateError(e);
                    }
                    otraceback = traceback.tb_next;
                    continue;
                }
                String fn = traceback.tb_frame.f_code.co_filename;
                if (fn != null && (fn.equals("<iostream>") || fn.equals("<string>") || this.file != null && fn.equals(this.file.getName()))) {
                    this.annotationsSupport.annotateLine(offset + traceback.tb_lineno, "error", ex.toString(), interp);
                    line = traceback.tb_lineno - 1;
                    otraceback = traceback.tb_next;
                    ++count;
                    continue;
                }
                otraceback = traceback.tb_next;
            }
            if (line < 0) {
                logger.warning("no trace information available for error " + ex.getMessage());
                line = 0;
            }
            final int fline = line;
            final EditorTextPane textArea = this.panel.getEditorPanel();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Element element = textArea.getDocument().getDefaultRootElement().getElement(Math.max(0, fline - 5));
                    if (element != null) {
                        textArea.setCaretPosition(element.getStartOffset());
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Element element = textArea.getDocument().getDefaultRootElement().getElement(fline);
                            if (element != null) {
                                textArea.setCaretPosition(element.getStartOffset());
                            }
                        }
                    });
                }
            });
        }
    }

    protected void executeScript() {
        this.executeScript(0);
    }

    protected void executeScript(boolean trace) {
        this.executeScript(trace ? 2 : 0);
    }

    protected void executeScript(final int mode) {
        block18: {
            try {
                if (this.panel.getContext() == 1) {
                    if (this.file != null) {
                        try {
                            URI uri = new URI("vap+jyds:" + this.file.toURI().toString());
                            JythonDataSourceFactory factory = (JythonDataSourceFactory)DataSetURI.getDataSourceFactory(uri, new NullProgressMonitor());
                            if (factory != null) {
                                factory.addExeceptionListener(new ExceptionListener(){

                                    @Override
                                    public void exceptionThrown(Exception e) {
                                        if (e instanceof PyException) {
                                            PyException ex = (PyException)((Object)e);
                                            ScriptPanelSupport.this.annotateError(ex, 0, null);
                                        }
                                    }
                                });
                            }
                        }
                        catch (URISyntaxException ex) {
                            throw new RuntimeException(ex);
                        }
                    }
                    boolean updateSurl = false;
                    if (this.file == null || this.panel.isDirty() && FileSystemUtil.isChildOf(FileSystem.settings().getLocalCacheDir(), this.file)) {
                        if (this.getSaveFile() == 0) {
                            updateSurl = true;
                        } else {
                            return;
                        }
                    }
                    if (this.file != null) {
                        try {
                            if (!this.uriFilesEqual(this.selector.getValue(), this.file.toURI().toString())) {
                                updateSurl = true;
                            }
                        }
                        catch (URISyntaxException ex) {
                            updateSurl = true;
                        }
                        if (this.panel.isDirty() && (this.file.exists() && this.file.canWrite() || this.file.getParentFile().canWrite())) {
                            this.save();
                        }
                        if (updateSurl) {
                            this.selector.setValue("vap+jyds:" + this.file.toURI().toString());
                        }
                        this.annotationsSupport.clearAnnotations();
                        this.selector.maybePlot(mode);
                        if (updateSurl) {
                            this.panel.setFilename(this.file.toString());
                        }
                    }
                    this.panel.setRunningScript(null);
                    break block18;
                }
                if (this.panel.getContext() == 0) {
                    this.applicationController.setStatus("busy: executing application script");
                    Runnable run = new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            int offset = 0;
                            DasProgressPanel mon = DasProgressPanel.createFramed(SwingUtilities.getWindowAncestor(ScriptPanelSupport.this.panel), "running script");
                            try {
                                if (ScriptPanelSupport.this.file != null && (ScriptPanelSupport.this.file.exists() && ScriptPanelSupport.this.file.canWrite() || ScriptPanelSupport.this.file.getParentFile().canWrite())) {
                                    if (ScriptPanelSupport.this.panel.isDirty()) {
                                        ScriptPanelSupport.this.save();
                                    }
                                    ScriptPanelSupport.this.applicationController.getApplicationModel().addRecent("script:" + ScriptPanelSupport.this.file.toURI().toString());
                                }
                                InteractiveInterpreter interp = null;
                                try {
                                    interp = JythonUtil.createInterpreter(true, false);
                                    EditorAnnotationsSupport.setExpressionLookup(ScriptPanelSupport.this.annotationsSupport.getForInterp((PythonInterpreter)interp));
                                    interp.set("dom", (Object)ScriptPanelSupport.this.model.getDocumentModel());
                                    interp.set("monitor", (Object)mon);
                                    if (ScriptPanelSupport.this.file != null) {
                                        URISplit split = URISplit.parse(ScriptPanelSupport.this.file.toString());
                                        interp.set("PWD", (Object)split.path);
                                    }
                                    ScriptPanelSupport.this.setInterruptible(interp);
                                    ScriptPanelSupport.this.ts = Py.getThreadState();
                                    boolean dirty0 = ScriptPanelSupport.this.panel.isDirty();
                                    ScriptPanelSupport.this.annotationsSupport.clearAnnotations();
                                    ScriptPanelSupport.this.panel.setDirty(dirty0);
                                    if ((mode & 2) == 2) {
                                        String text = ScriptPanelSupport.this.panel.getEditorPanel().getText();
                                        int i0 = 0;
                                        while (i0 < text.length()) {
                                            int i1 = text.indexOf("\n", i0);
                                            while (i1 < text.length() - 1 && Character.isWhitespace(text.charAt(i1 + 1))) {
                                                i1 = text.indexOf("\n", i1 + 1);
                                            }
                                            String s = i1 != -1 ? text.substring(i0, ++i1) : text.substring(i0);
                                            ScriptPanelSupport.this.annotationsSupport.clearAnnotations();
                                            ScriptPanelSupport.this.annotationsSupport.annotateChars(i0, i1, "programCounter", "pc", (PythonInterpreter)interp);
                                            interp.exec(JythonRefactory.fixImports(s));
                                            i0 = i1;
                                            ++offset;
                                            System.err.println(s);
                                        }
                                        ScriptPanelSupport.this.annotationsSupport.clearAnnotations();
                                    } else if ((mode & 1) == 1 || (mode & 8) == 8) {
                                        JPanel p = new JPanel();
                                        HashMap<String, String> vars = new HashMap<String, String>();
                                        ParametersFormPanel pfp = new ParametersFormPanel();
                                        HashMap<String, Object> env = new HashMap<String, Object>();
                                        env.put("dom", interp.get("dom"));
                                        env.put("PWD", interp.get("PWD"));
                                        ParametersFormPanel.FormData fd = pfp.doVariables(env, ScriptPanelSupport.this.panel.getEditorPanel().getText(), vars, p);
                                        if (fd.count > 0) {
                                            JScrollPane pane = new JScrollPane(p);
                                            if (AutoplotUtil.showConfirmDialog2(ScriptPanelSupport.this.panel, pane, "edit parameters", 2) == 0) {
                                                ParametersFormPanel.resetVariables(fd, vars);
                                                String parseExcept = null;
                                                for (Map.Entry v : vars.entrySet()) {
                                                    try {
                                                        fd.implement((PythonInterpreter)interp, (String)v.getKey(), (String)v.getValue());
                                                    }
                                                    catch (ParseException ex) {
                                                        parseExcept = (String)v.getKey();
                                                    }
                                                }
                                                if (parseExcept != null) {
                                                    JOptionPane.showMessageDialog(ScriptPanelSupport.this.panel, "ParseException in parameter " + parseExcept);
                                                } else {
                                                    interp.exec(JythonRefactory.fixImports(ScriptPanelSupport.this.panel.getEditorPanel().getText()));
                                                }
                                            }
                                        } else {
                                            interp.exec(JythonRefactory.fixImports(ScriptPanelSupport.this.panel.getEditorPanel().getText()));
                                        }
                                    } else {
                                        boolean experiment = System.getProperty("jythonDebugger", "false").equals("true");
                                        if (experiment) {
                                            final DebuggerConsole dc = DebuggerConsole.getInstance(ScriptPanelSupport.this.panel);
                                            dc.setInterp((PythonInterpreter)interp);
                                            interp.setOut(ScriptPanelSupport.this.getOutput(dc));
                                            EditorAnnotationsSupport.setExpressionLookup(new EditorAnnotationsSupport.ExpressionLookup(){

                                                @Override
                                                public PyObject lookup(String expr) {
                                                    return dc.setEval(expr);
                                                }
                                            });
                                        }
                                        String code = ScriptPanelSupport.this.panel.getEditorPanel().getText();
                                        if (ScriptPanelSupport.this.file != null) {
                                            char[] cc = code.toCharArray();
                                            boolean warning = false;
                                            for (char c : cc) {
                                                if (c <= '\u0080') continue;
                                                warning = true;
                                            }
                                            if (warning) {
                                                System.err.println("code contains data that will not be represented properly!");
                                            }
                                            try (ByteArrayInputStream in = new ByteArrayInputStream(code.getBytes());){
                                                interp.execfile(JythonRefactory.fixImports(in), ScriptPanelSupport.this.file.getName());
                                            }
                                        } else {
                                            interp.exec(JythonRefactory.fixImports(code));
                                        }
                                    }
                                    ScriptPanelSupport.this.setInterruptible(null);
                                    if (!mon.isFinished()) {
                                        mon.finished();
                                    }
                                    ScriptPanelSupport.this.applicationController.setStatus("done executing script");
                                }
                                catch (IOException ex) {
                                    if (!mon.isFinished()) {
                                        mon.finished();
                                    }
                                    logger.log(Level.WARNING, ex.getMessage(), ex);
                                    ScriptPanelSupport.this.applicationController.setStatus("error: I/O exception: " + ex.toString());
                                }
                                catch (PyException ex) {
                                    if (!mon.isFinished()) {
                                        mon.finished();
                                    }
                                    ScriptPanelSupport.this.annotateError(ex, offset, (PythonInterpreter)interp);
                                    ScriptPanelSupport.this.applicationController.setStatus("error: " + ex.toString());
                                }
                            }
                            catch (IOException ex) {
                                throw new RuntimeException(ex);
                            }
                            catch (Error ex) {
                                if (!ex.getMessage().contains("Python interrupt")) {
                                    throw ex;
                                }
                                ScriptPanelSupport.this.applicationController.setStatus("script interrupted");
                            }
                            finally {
                                if (!mon.isFinished()) {
                                    mon.finished();
                                }
                                ScriptPanelSupport.this.setInterruptible(null);
                                ScriptPanelSupport.this.panel.setRunningScript(null);
                            }
                        }
                    };
                    new Thread(run, "sessionRunScriptThread").start();
                }
            }
            catch (IOException iOException) {
                this.model.getExceptionHandler().handle(iOException);
                this.panel.setRunningScript(null);
            }
        }
    }

    private OutputStream getOutput(DebuggerConsole dc) {
        return new MyOutputStream(System.out, dc);
    }

    private FileFilter getFileFilter() {
        return new FileFilter(){

            @Override
            public boolean accept(File f) {
                if (f.toString() == null) {
                    return false;
                }
                return f.isDirectory() || f.toString().endsWith(".jy") || f.toString().endsWith(".py") || f.toString().endsWith(".jyds");
            }

            @Override
            public String getDescription() {
                return "python and jython scripts";
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int saveAs() {
        int result;
        block17: {
            OutputStream out = null;
            result = 1;
            try {
                result = this.getSaveFile();
                if (result != 0) break block17;
                if (this.watcher != null) {
                    try {
                        this.watcher.close();
                    }
                    catch (IOException ex) {
                        logger.log(Level.WARNING, ex.getMessage(), ex);
                    }
                }
                out = new FileOutputStream(this.file);
                String text = this.panel.getEditorPanel().getText();
                out.write(text.getBytes());
                this.panel.setDirty(false);
                this.panel.setFilename(this.file.toString());
                this.restartWatcher(this.file);
                Preferences prefs = AutoplotSettings.settings().getPreferences(ScriptPanelSupport.class);
                prefs.put("openFile", this.file.toString());
                if (this.file.toString().endsWith(".jyds")) {
                    this.panel.setContext(1);
                } else {
                    this.panel.setContext(0);
                }
            }
            catch (IOException iOException) {
                this.model.getExceptionHandler().handle(iOException);
            }
            finally {
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                }
            }
        }
        return result;
    }

    protected void newScript() {
        if (this.panel.isDirty()) {
            int result = AutoplotUtil.showConfirmDialog(this.panel, "save edits first?", "new script", 1);
            if (result == 2) {
                return;
            }
            if (result == 0 && this.saveAs() == 2) {
                return;
            }
        }
        if (this.file != null && this.watcher != null) {
            try {
                this.watcher.close();
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
        try {
            Document d = this.panel.getEditorPanel().getDocument();
            d.remove(0, d.getLength());
            this.panel.containsTabs = false;
            this.panel.setDirty(false);
            this.panel.setFilename(null);
            this.annotationsSupport.clearAnnotations();
            this.file = null;
        }
        catch (BadLocationException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    private JComponent getRecentAccessory(final String filter, final int limit, final JFileChooser c) {
        JPanel recentPanel = new JPanel(new BorderLayout());
        String msgWait = "Getting Recent...                    ..";
        DefaultListModel<String> waitModel = new DefaultListModel<String>();
        waitModel.add(0, "Getting Recent...                    ..");
        final JList p = new JList(waitModel);
        p.setFont(p.getFont().deriveFont(10.0f));
        Runnable run = new Runnable(){

            @Override
            public void run() {
                Map<String, String> recent = ScriptPanelSupport.this.model.getRecent(filter, 10 * limit);
                final DefaultListModel<String> mm = new DefaultListModel<String>();
                ArrayList<String> ss = new ArrayList<String>(recent.keySet());
                int count = 0;
                for (int i = ss.size() - 1; i > 0; --i) {
                    int iq;
                    int iscript;
                    String s = (String)ss.get(i);
                    if (s.startsWith("script:")) {
                        s = s.substring(7);
                    }
                    if (s.startsWith("vap+jyds:")) {
                        s = s.substring(9);
                    }
                    if (s.startsWith("vap+jy:")) {
                        s = s.substring(7);
                    }
                    if ((iscript = s.indexOf("script=")) > -1) {
                        s = s.substring(iscript + "script=".length());
                    }
                    if (!s.startsWith("file:")) continue;
                    if (s.startsWith("file://")) {
                        s = s.substring(7);
                    }
                    if (s.startsWith("file:")) {
                        s = s.substring(5);
                    }
                    if ((iq = s.indexOf(63)) > -1) {
                        s = s.substring(0, iq);
                    }
                    if (mm.contains(s)) {
                        mm.removeElement(s);
                    }
                    mm.addElement(s);
                    if (++count == limit) break;
                }
                Runnable run = new Runnable(){

                    @Override
                    public void run() {
                        p.setModel(mm);
                    }
                };
                SwingUtilities.invokeLater(run);
            }
        };
        new Thread(run).start();
        p.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting() && !p.getSelectedValue().equals("Getting Recent...                    ..")) {
                    String s = (String)p.getSelectedValue();
                    File ff = new File(s);
                    c.setSelectedFile(ff);
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(p);
        scrollPane.setPreferredSize(new Dimension(300, 200));
        scrollPane.setMinimumSize(new Dimension(300, 100));
        scrollPane.setMaximumSize(new Dimension(300, 200));
        recentPanel.add((Component)new JLabel("Recently used local (" + filter + ") files:"), "North");
        recentPanel.add((Component)scrollPane, "Center");
        return recentPanel;
    }

    protected void open() {
        try {
            if (this.file == null) {
                String sfile = this.selector.getValue();
                URISplit split = null;
                if (sfile != null) {
                    split = URISplit.parse(sfile);
                }
                if (split == null || split.file == null || !split.file.endsWith(".py") && !split.file.endsWith(".jy")) {
                    this.file = null;
                } else {
                    try {
                        this.file = DataSetURI.getFile(DataSetURI.getURL(sfile), (ProgressMonitor)new NullProgressMonitor());
                    }
                    catch (IOException ex) {
                        logger.fine("old file reference from data set selector is ignored");
                        this.file = null;
                    }
                }
            }
            Preferences prefs = AutoplotSettings.settings().getPreferences(ScriptPanelSupport.class);
            String openFile = prefs.get("openFile", "");
            JFileChooser chooser = new JFileChooser();
            chooser.setFileSelectionMode(0);
            chooser.setFileFilter(this.getFileFilter());
            if (this.file != null) {
                chooser.setSelectedFile(this.file);
            }
            if (openFile.length() > 0) {
                chooser.getFileSystemView().isParent(chooser.getCurrentDirectory(), new File(openFile));
                File fopenFile = new File(openFile);
                chooser.setSelectedFile(fopenFile);
            }
            chooser.setAccessory(this.getRecentAccessory("*.jy*", 100, chooser));
            chooser.revalidate();
            int r = chooser.showOpenDialog(this.panel);
            if (r == 0) {
                this.file = chooser.getSelectedFile();
                prefs.put("openFile", this.file.toString());
                this.loadFile(this.file);
                this.panel.setFilename(this.file.toString());
                this.annotationsSupport.clearAnnotations();
            }
        }
        catch (IOException ex) {
            this.model.getExceptionHandler().handle(ex);
        }
    }

    void interrupt() {
        InteractiveInterpreter interp = this.getInterruptible();
        if (interp != null) {
            interp.interrupt(this.ts);
        }
    }

    public InteractiveInterpreter getInterruptible() {
        return this.interruptible;
    }

    private void setInterruptible(InteractiveInterpreter interruptable) {
        InteractiveInterpreter old = this.interruptible;
        this.interruptible = interruptable;
        this.propertyChangeSupport.firePropertyChange(PROP_INTERRUPTABLE, old, interruptable);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String name, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(name, listener);
    }

    public void removePropertyChangeListener(String name, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(name, listener);
    }

    protected class MyOutputStream
    extends FilterOutputStream {
        OutputStream sink;
        DebuggerConsole dc;
        StringBuilder currentLine;
        private final Object STATE_OPEN;
        private final Object STATE_FORM_PDB_PROMPT;
        private final Object STATE_RETURN_INIT_PROMPT;
        private final Object STATE_PDB;
        protected final Object STATE_FORM_PDB_RESPONSE;
        Object state;

        public MyOutputStream(OutputStream out, DebuggerConsole dc) {
            super(out);
            this.currentLine = new StringBuilder();
            this.STATE_OPEN = "OPEN";
            this.STATE_FORM_PDB_PROMPT = "PROMPT";
            this.STATE_RETURN_INIT_PROMPT = "RETURN";
            this.STATE_PDB = "PDB";
            this.STATE_FORM_PDB_RESPONSE = "RESPONSE";
            this.state = this.STATE_OPEN;
            this.sink = out;
            this.dc = dc;
        }

        @Override
        public void write(byte[] b) throws IOException {
            for (int i = 0; i < b.length; ++i) {
                this.write(b[i]);
            }
        }

        public void writeNew(int b) throws IOException {
            if (this.dc != null) {
                this.dc.print(String.valueOf((char)b));
            }
            if (this.state == this.STATE_OPEN) {
                if (b >= 0) {
                    this.currentLine.append((char)b);
                }
                if (this.currentLine.length() == 1 && this.currentLine.substring(0, 1).equals("(")) {
                    this.state = this.STATE_FORM_PDB_PROMPT;
                } else if (this.currentLine.length() == 1 && this.currentLine.substring(0, 1).equals(">")) {
                    this.state = this.STATE_FORM_PDB_RESPONSE;
                } else if (this.currentLine.length() > 10 && this.currentLine.substring(0, 10).equals("--Return--")) {
                    this.state = this.STATE_RETURN_INIT_PROMPT;
                } else if (this.currentLine.length() > 0 && (b == 10 || b == 13)) {
                    this.currentLine = new StringBuilder();
                }
            } else if (this.state == this.STATE_RETURN_INIT_PROMPT) {
                if (b >= 0) {
                    this.currentLine.append((char)b);
                }
                if (this.currentLine.length() == 1 && this.currentLine.substring(0, 1).equals("(")) {
                    this.state = this.STATE_FORM_PDB_PROMPT;
                } else if (this.currentLine.length() > 0 && (b == 10 || b == 13)) {
                    this.currentLine = new StringBuilder();
                }
            } else if (this.state == this.STATE_FORM_PDB_PROMPT) {
                if (b >= 0) {
                    this.currentLine.append((char)b);
                }
                if (this.currentLine.length() >= 6) {
                    if (this.currentLine.substring(0, 5).equals("(Pdb) ")) {
                        this.state = this.STATE_PDB;
                    } else {
                        this.sink.write(this.currentLine.toString().getBytes());
                        this.state = this.STATE_OPEN;
                    }
                } else if (this.currentLine.length() > 0 && (b == 10 || b == 13)) {
                    this.sink.write(this.currentLine.toString().getBytes());
                    this.currentLine = new StringBuilder();
                    this.state = this.STATE_OPEN;
                }
            } else if (this.state == this.STATE_FORM_PDB_RESPONSE) {
                Pattern p;
                Matcher m;
                if (b >= 0 && b != 10 && b != 13) {
                    this.currentLine.append((char)b);
                }
                if ((m = (p = Pattern.compile("\\>? \\S+\\((\\d+)\\)\\S+\\(\\)")).matcher(this.currentLine)).matches()) {
                    String linenum = m.group(1);
                    ScriptPanelSupport.this.annotationsSupport.clearAnnotations();
                    int[] pos = ScriptPanelSupport.this.annotationsSupport.getLinePosition(Integer.parseInt(linenum));
                    ScriptPanelSupport.this.annotationsSupport.annotateChars(pos[0], pos[1], "programCounter", "pc", (PythonInterpreter)ScriptPanelSupport.this.interruptible);
                    this.state = this.STATE_OPEN;
                    this.currentLine = new StringBuilder();
                } else if (b == 13 || b == 10) {
                    this.state = this.STATE_OPEN;
                    this.sink.write(this.currentLine.toString().getBytes());
                    this.currentLine = new StringBuilder();
                }
            } else if (this.state == this.STATE_PDB) {
                Pattern p = Pattern.compile("\\(Pdb\\) (.*)>? <string>\\((\\d+)\\)\\?\\(\\)\\s*");
                Pattern p2 = Pattern.compile("\\(Pdb\\) (.*)--Return--.*>? <string>\\((\\d+)\\)\\?\\(\\)\\s*.*");
                int l = this.currentLine.length();
                if (b >= 0 && b != 10 && b != 13) {
                    this.currentLine.append((char)b);
                }
                if (l > 2 && this.currentLine.substring(l - 2, l).equals("()")) {
                    Matcher m = p.matcher(this.currentLine);
                    if (m.matches()) {
                        String linenum = m.group(2);
                        ScriptPanelSupport.this.annotationsSupport.clearAnnotations();
                        int[] pos = ScriptPanelSupport.this.annotationsSupport.getLinePosition(Integer.parseInt(linenum));
                        ScriptPanelSupport.this.annotationsSupport.annotateChars(pos[0], pos[1], "programCounter", "pc", (PythonInterpreter)ScriptPanelSupport.this.interruptible);
                        String userOutput = m.group(1);
                        if (userOutput.length() > 0) {
                            this.sink.write(userOutput.getBytes());
                            this.sink.write("\n".getBytes());
                        }
                        this.state = this.STATE_OPEN;
                        this.currentLine = new StringBuilder();
                    } else {
                        Matcher m2 = p2.matcher(this.currentLine);
                        if (m2.matches()) {
                            ScriptPanelSupport.this.annotationsSupport.clearAnnotations();
                            String userOutput = m2.group(1);
                            if (userOutput.length() > 0) {
                                this.sink.write(userOutput.getBytes());
                                this.sink.write("\n".getBytes());
                            }
                            this.state = this.STATE_OPEN;
                            this.currentLine = new StringBuilder();
                        } else {
                            this.state = this.STATE_OPEN;
                            this.currentLine = new StringBuilder();
                        }
                    }
                }
            }
        }

        @Override
        public void write(int b) throws IOException {
            if (this.dc != null) {
                this.dc.print(String.valueOf((char)b), this.state);
            }
            if (this.state == this.STATE_OPEN) {
                if (b >= 0) {
                    this.currentLine.append((char)b);
                }
                if (this.currentLine.length() == 1 && this.currentLine.substring(0, 1).equals("(")) {
                    this.state = this.STATE_FORM_PDB_PROMPT;
                } else if (this.currentLine.length() > 10 && this.currentLine.substring(0, 10).equals("--Return--")) {
                    this.state = this.STATE_RETURN_INIT_PROMPT;
                    this.dc.started();
                    this.dc.next();
                } else if (this.currentLine.length() > 0 && (b == 10 || b == 13)) {
                    this.currentLine = new StringBuilder();
                }
            } else if (this.state == this.STATE_RETURN_INIT_PROMPT) {
                if (b >= 0) {
                    this.currentLine.append((char)b);
                }
                if (this.currentLine.length() == 1 && this.currentLine.substring(0, 1).equals("(")) {
                    this.state = this.STATE_FORM_PDB_PROMPT;
                } else if (this.currentLine.length() > 0 && (b == 10 || b == 13)) {
                    this.currentLine = new StringBuilder();
                }
            } else if (this.state == this.STATE_FORM_PDB_PROMPT) {
                if (b >= 0) {
                    this.currentLine.append((char)b);
                }
                if (this.currentLine.length() >= 5) {
                    if (this.currentLine.substring(0, 5).equals("(Pdb)")) {
                        this.state = this.STATE_PDB;
                    } else {
                        this.sink.write(this.currentLine.toString().getBytes());
                        this.state = this.STATE_OPEN;
                    }
                } else if (this.currentLine.length() > 0 && (b == 10 || b == 13)) {
                    this.sink.write(this.currentLine.toString().getBytes());
                    this.currentLine = new StringBuilder();
                    this.state = this.STATE_OPEN;
                }
            } else if (this.state == this.STATE_PDB) {
                Pattern p = Pattern.compile("\\(Pdb\\) (.*)> .*\\.jy\\((\\d+)\\).*\\(\\)\\s*");
                Pattern p2 = Pattern.compile("\\(Pdb\\) (.*)--Return--.*");
                int l = this.currentLine.length();
                if (b >= 0 && b != 10 && b != 13) {
                    this.currentLine.append((char)b);
                }
                if (l > 2 && this.currentLine.substring(l - 2, l).equals("()")) {
                    Matcher m = p.matcher(this.currentLine);
                    if (m.matches()) {
                        String linenum = m.group(2);
                        ScriptPanelSupport.this.annotationsSupport.clearAnnotations();
                        int[] pos = ScriptPanelSupport.this.annotationsSupport.getLinePosition(Integer.parseInt(linenum));
                        ScriptPanelSupport.this.annotationsSupport.annotateChars(pos[0], pos[1], "programCounter", "pc", (PythonInterpreter)ScriptPanelSupport.this.interruptible);
                        String userOutput = m.group(1);
                        if (userOutput != null && userOutput.length() > 0) {
                            this.sink.write(userOutput.getBytes());
                            this.sink.write("\n".getBytes());
                        }
                        this.state = this.STATE_OPEN;
                        this.currentLine = new StringBuilder();
                    } else {
                        Matcher m2 = p2.matcher(this.currentLine);
                        if (m2.matches()) {
                            ScriptPanelSupport.this.annotationsSupport.clearAnnotations();
                            String userOutput = m2.group(1);
                            if (userOutput.length() > 0) {
                                this.sink.write(userOutput.getBytes());
                                this.sink.write("\n".getBytes());
                            }
                            this.state = this.STATE_OPEN;
                            this.currentLine = new StringBuilder();
                            this.dc.finished();
                            this.dc.next();
                        } else {
                            this.state = this.STATE_OPEN;
                            this.currentLine = new StringBuilder();
                        }
                    }
                }
            }
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            for (int i = off; i < len; ++i) {
                this.write(b[i]);
            }
        }
    }
}

