/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.scriptconsole;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.XMLFormatter;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class LogConsoleUtil {
    public static void serializeLogRecords(List<LogRecord> list, OutputStream out) throws IOException {
        XMLFormatter formatter = new XMLFormatter();
        out.write("<log>\n".getBytes());
        for (LogRecord rec : list) {
            out.write(formatter.format(rec).getBytes());
        }
        out.write("</log>".getBytes());
    }

    public static List<LogRecord> deserializeLogRecords(InputStream in) throws ParserConfigurationException, SAXException, IOException {
        SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
        final ArrayList<LogRecord> records = new ArrayList<LogRecord>();
        parser.parse(in, new DefaultHandler(){
            LogRecord rec;
            StringBuffer databuf;

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                if (qName.equals("record")) {
                    this.rec = new LogRecord(Level.ALL, "");
                }
                this.databuf = new StringBuffer();
                super.startElement(uri, localName, qName, attributes);
            }

            @Override
            public void characters(char[] ch, int start, int length) throws SAXException {
                this.databuf.append(ch, start, length);
            }

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                String data = this.databuf.toString();
                if (qName.equals("record")) {
                    records.add(this.rec);
                } else if (qName.equals("millis")) {
                    this.rec.setMillis(Long.parseLong(data));
                } else if (qName.equals("logger")) {
                    this.rec.setLoggerName(data);
                } else if (qName.equals("level")) {
                    this.rec.setLevel(Level.parse(data));
                } else if (qName.equals("sequence")) {
                    this.rec.setSequenceNumber(Integer.parseInt(data));
                } else if (qName.equals("thread")) {
                    this.rec.setThreadID(Integer.parseInt(data));
                } else if (qName.equals("message")) {
                    this.rec.setMessage(data);
                }
                this.databuf = new StringBuffer();
                super.endElement(uri, localName, qName);
            }

            @Override
            public void endDocument() throws SAXException {
                super.endDocument();
            }
        });
        return records;
    }
}

