/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.scriptconsole;

import ZoeloeSoft.projects.JFontChooser.JFontChooser;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashSet;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableRowSorter;
import org.autoplot.AutoplotUtil;
import org.autoplot.scriptconsole.LogConsole;
import org.das2.util.LoggerManager;
import org.jdesktop.layout.GroupLayout;

public class LogConsoleSettingsDialog
extends JDialog {
    LogConsole console;
    private static final Level[] LOG_LEVELS = new Level[]{null, Level.OFF, Level.SEVERE, Level.WARNING, Level.INFO, Level.CONFIG, Level.FINE, Level.FINER, Level.FINEST, Level.ALL};
    private JButton consoleFontButton;
    private JLabel highliteLinesLabel;
    private JButton jButton1;
    private JLabel jLabel1;
    private JScrollPane jScrollPane2;
    private JTable jTable1;
    private JCheckBox logLevelCheckBox;
    private JCheckBox loggerIDCheckBox;
    private JTextField searchForTextField;
    private JCheckBox showOnlyHighlitedCB;
    private JCheckBox threadsCB;
    private JCheckBox timeStampsCheckBox;

    public LogConsoleSettingsDialog(Frame parent, boolean modal, LogConsole console) {
        super(parent, modal);
        this.setTitle("Log Console Settings");
        this.initComponents();
        this.setLocationRelativeTo(parent);
        this.initLogTable();
        this.console = console;
        this.searchForTextField.setText(console.getSearchText());
        this.timeStampsCheckBox.setSelected(console.showTimeStamps);
        this.logLevelCheckBox.setSelected(console.showLevel);
        this.loggerIDCheckBox.setSelected(console.showLoggerId);
        this.showOnlyHighlitedCB.setSelected(console.isShowOnlyHighlited());
    }

    private Level getLoggerMindingInheritance(Logger anscestor) {
        Level value = anscestor.getLevel();
        while (value == null) {
            anscestor = anscestor.getParent();
            value = anscestor.getLevel();
        }
        return value;
    }

    private static Color slightlyDarker(Color c) {
        return new Color(Math.max((int)((double)c.getRed() * 0.9), 0), Math.max((int)((double)c.getGreen() * 0.9), 0), Math.max((int)((double)c.getBlue() * 0.9), 0), c.getAlpha());
    }

    private void initLogTable() {
        HashSet<String> otherLoggers = new HashSet<String>(LoggerManager.getLoggers());
        otherLoggers.addAll(org.das2.datum.LoggerManager.getLoggers());
        Object[] sloggers = otherLoggers.toArray(new String[otherLoggers.size()]);
        Arrays.sort(sloggers);
        DefaultTableModel m = LoggerManager.isUseTimeTaggingLoggers() ? new DefaultTableModel(new String[]{"name", "level", "time"}, sloggers.length) : new DefaultTableModel(new String[]{"name", "level"}, sloggers.length);
        int irow = 0;
        for (Object slogger : sloggers) {
            m.setValueAt(slogger, irow, 0);
            Logger logger = Logger.getLogger((String)slogger);
            m.setValueAt(logger, irow, 1);
            if (LoggerManager.isUseTimeTaggingLoggers()) {
                m.setValueAt(logger, irow, 2);
            }
            ++irow;
        }
        this.jTable1.setAutoCreateRowSorter(true);
        this.jTable1.setModel(m);
        this.jTable1.getColumnModel().getColumn(0).setCellRenderer(new MyCellRenderer(new DefaultTableCellRenderer()));
        this.jTable1.getColumnModel().getColumn(1).setCellRenderer(new LevelCellRenderer(new DefaultTableCellRenderer()));
        this.jTable1.getColumnModel().getColumn(1).setCellEditor(new MyEditor());
        if (LoggerManager.isUseTimeTaggingLoggers()) {
            this.jTable1.getColumnModel().getColumn(2).setCellRenderer(new TimeTaggingCellRenderer(new DefaultTableCellRenderer()));
        }
        TableRowSorter<DefaultTableModel> rowSorter = new TableRowSorter<DefaultTableModel>(m);
        this.jTable1.setRowSorter(rowSorter);
        rowSorter.setComparator(1, new Comparator(){

            public int compare(Object o1, Object o2) {
                Logger l1 = (Logger)o1;
                Logger l2 = (Logger)o2;
                Level level1 = LogConsoleSettingsDialog.this.getLoggerMindingInheritance(l1);
                Level level2 = LogConsoleSettingsDialog.this.getLoggerMindingInheritance(l2);
                return level2.intValue() - level1.intValue();
            }
        });
    }

    private void updateSearchText() {
        this.console.setSearchText(this.searchForTextField.getText());
        this.console.setShowOnlyHighlited(this.showOnlyHighlitedCB.isSelected());
        try {
            Pattern.compile(this.searchForTextField.getText());
            this.highliteLinesLabel.setText("Highlite Lines Matching:");
        }
        catch (PatternSyntaxException ex) {
            this.highliteLinesLabel.setText("Highlite Lines Containing:");
        }
    }

    private void initComponents() {
        this.loggerIDCheckBox = new JCheckBox();
        this.timeStampsCheckBox = new JCheckBox();
        this.logLevelCheckBox = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.highliteLinesLabel = new JLabel();
        this.searchForTextField = new JTextField();
        this.jButton1 = new JButton();
        this.threadsCB = new JCheckBox();
        this.jScrollPane2 = new JScrollPane();
        this.jTable1 = new JTable();
        this.consoleFontButton = new JButton();
        this.showOnlyHighlitedCB = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.loggerIDCheckBox.setText("logger name");
        this.loggerIDCheckBox.setToolTipText("identifies the logger posting the message");
        this.loggerIDCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogConsoleSettingsDialog.this.loggerIDCheckBoxActionPerformed(evt);
            }
        });
        this.timeStampsCheckBox.setText("timing");
        this.timeStampsCheckBox.setToolTipText("Show time of the message, in seconds before the most recent message.");
        this.timeStampsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogConsoleSettingsDialog.this.timeStampsCheckBoxActionPerformed(evt);
            }
        });
        this.logLevelCheckBox.setText("log levels");
        this.logLevelCheckBox.setToolTipText("show the log level (verbosity) of the messages.");
        this.logLevelCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogConsoleSettingsDialog.this.logLevelCheckBoxActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Verbosity of the logger channels:");
        this.jLabel1.setToolTipText("<html>Autoplot uses Java Logging, which allows messages to be sent to named channels with a verbosity level.   Set verbosity to finer levels to see messages intended for developers.");
        this.highliteLinesLabel.setText("Highlite Lines Matching:");
        this.highliteLinesLabel.setToolTipText("Enter a regular expression.  Lines containing this will be highlited.");
        this.searchForTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                LogConsoleSettingsDialog.this.searchForTextFieldFocusLost(evt);
            }
        });
        this.searchForTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogConsoleSettingsDialog.this.searchForTextFieldActionPerformed(evt);
            }
        });
        this.jButton1.setText("Okay");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogConsoleSettingsDialog.this.jButton1ActionPerformed(evt);
            }
        });
        this.threadsCB.setText("threads");
        this.threadsCB.setToolTipText("Show unique number for each execution thread.  The GUI event thread is labelled \"GUI.\"");
        this.threadsCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogConsoleSettingsDialog.this.threadsCBActionPerformed(evt);
            }
        });
        this.jTable1.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane2.setViewportView(this.jTable1);
        this.consoleFontButton.setText("Console Font...");
        this.consoleFontButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogConsoleSettingsDialog.this.consoleFontButtonActionPerformed(evt);
            }
        });
        this.showOnlyHighlitedCB.setText("Show only these lines");
        this.showOnlyHighlitedCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogConsoleSettingsDialog.this.showOnlyHighlitedCBActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jScrollPane2).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.highliteLinesLabel).addPreferredGap(0).add((Component)this.searchForTextField, -2, 172, -2).addPreferredGap(0).add((Component)this.showOnlyHighlitedCB).addPreferredGap(0, 223, Short.MAX_VALUE).add((Component)this.jButton1)).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.jLabel1).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.loggerIDCheckBox).addPreferredGap(0).add((Component)this.timeStampsCheckBox).addPreferredGap(0).add((Component)this.logLevelCheckBox).addPreferredGap(0).add((Component)this.threadsCB).add(18, 18, 18).add((Component)this.consoleFontButton))).add(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jScrollPane2, -1, 251, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.timeStampsCheckBox).add((Component)this.logLevelCheckBox).add((Component)this.loggerIDCheckBox).add((Component)this.threadsCB).add((Component)this.consoleFontButton)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.highliteLinesLabel).add((Component)this.searchForTextField, -2, -1, -2).add((Component)this.jButton1).add((Component)this.showOnlyHighlitedCB)).addContainerGap()));
        this.pack();
    }

    private void loggerIDCheckBoxActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        this.console.setShowLoggerId(this.loggerIDCheckBox.isSelected());
        this.console.update();
    }

    private void timeStampsCheckBoxActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        this.console.setShowTimeStamps(this.timeStampsCheckBox.isSelected());
        this.console.update();
    }

    private void logLevelCheckBoxActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        this.console.setShowLevel(this.logLevelCheckBox.isSelected());
        this.console.update();
    }

    private void searchForTextFieldActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        this.updateSearchText();
    }

    private void searchForTextFieldFocusLost(FocusEvent evt) {
        this.updateSearchText();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        this.setVisible(false);
    }

    private void threadsCBActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        this.console.setShowThreads(this.threadsCB.isSelected());
        this.console.update();
    }

    private void consoleFontButtonActionPerformed(ActionEvent evt) {
        JFontChooser chooser = new JFontChooser(null);
        chooser.setFont(this.console.getLogTextArea().getFont());
        chooser.setLocationRelativeTo(this.console);
        if (chooser.showDialog() == 0) {
            this.console.getLogTextArea().setFont(chooser.getFont());
        }
    }

    private void showOnlyHighlitedCBActionPerformed(ActionEvent evt) {
        this.updateSearchText();
    }

    public static void main(String[] args) {
        Logger l = LoggerManager.getLogger("autoplot.first");
        l.finest("hi there");
        LoggerManager.getLogger("qdataset");
        org.das2.datum.LoggerManager.getLogger("qdataset.first");
        org.das2.datum.LoggerManager.getLogger("qdataset.second");
        org.das2.datum.LoggerManager.getLogger("qdataset.second").setLevel(Level.FINE);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                LogConsole console = new LogConsole();
                LogConsoleSettingsDialog dialog = new LogConsoleSettingsDialog((Frame)new JFrame(), true, console);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    static class LevelCellRenderer
    implements TableCellRenderer {
        JComponent component = null;
        TableCellRenderer delegate;
        Color backgroundColor;
        Color oddColor = Color.LIGHT_GRAY;
        Color selectedColor;
        Color selectedBackgroundColor;
        Color focusColor;
        Color focusBackgroundColor;

        public LevelCellRenderer(TableCellRenderer delegate) {
            this.delegate = delegate;
            Component c = delegate.getTableCellRendererComponent(null, "", false, false, 0, 0);
            this.backgroundColor = c.getBackground();
            c = delegate.getTableCellRendererComponent(null, "", true, false, 0, 0);
            this.selectedBackgroundColor = c.getBackground();
            this.selectedColor = c.getForeground();
            c = delegate.getTableCellRendererComponent(null, "", false, true, 0, 0);
            this.focusBackgroundColor = c.getBackground();
            this.focusColor = c.getForeground();
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object lvalue, boolean isSelected, boolean hasFocus, int row, int column) {
            Logger logger = (Logger)lvalue;
            Object value = logger.getLevel();
            if (value == null) {
                Logger anscestor = logger;
                if (logger.getParent() == null) {
                    value = logger.getLevel();
                } else {
                    do {
                        if ((anscestor = anscestor.getParent()) == null) {
                            new Exception("anscestor is null").printStackTrace();
                            value = "NULL";
                            continue;
                        }
                        value = anscestor.getLevel();
                    } while (value == null);
                    value = "INHERITED(" + value + ")";
                    if (this.component != null) {
                        String name = anscestor.getName();
                        if (name.equals("")) {
                            name = "<anonymous>";
                        }
                        this.component.setToolTipText("inherited from " + name);
                    }
                }
            } else {
                ((JComponent)((Object)this.delegate)).setToolTipText(null);
            }
            Component c = this.delegate.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (row % 2 == 0) {
                if (isSelected) {
                    c.setBackground(table.getSelectionBackground());
                } else {
                    c.setBackground(table.getBackground());
                }
            } else if (isSelected) {
                c.setBackground(LogConsoleSettingsDialog.slightlyDarker(table.getSelectionBackground()));
            } else {
                c.setBackground(LogConsoleSettingsDialog.slightlyDarker(table.getBackground()));
            }
            return c;
        }
    }

    private static class LogLevelCellRenderer
    implements ListCellRenderer {
        private final Logger logger;
        private final ListCellRenderer delegate;
        private JComponent component;

        private LogLevelCellRenderer(ListCellRenderer delegate, Logger logger) {
            this.delegate = delegate;
            this.logger = logger;
            if (delegate instanceof JComponent) {
                this.component = (JComponent)((Object)delegate);
            }
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value == null) {
                Logger anscestor = this.logger;
                if (this.logger.getParent() == null) {
                    value = this.logger.getLevel();
                } else {
                    while ((value = (anscestor = anscestor.getParent()) == null ? "NULL" : anscestor.getLevel()) == null) {
                    }
                    value = "INHERITED(" + value + ")";
                    if (this.component != null) {
                        String name = anscestor.getName();
                        if (name.equals("")) {
                            name = "<anonymous>";
                        }
                        this.component.setToolTipText("inherited from " + name);
                    }
                }
            } else {
                ((JComponent)((Object)this.delegate)).setToolTipText(null);
            }
            return this.delegate.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }
    }

    private class LogLevelComboBoxModel
    implements ComboBoxModel {
        private Logger logger;

        private LogLevelComboBoxModel(Logger logger) {
            if (logger == null) {
                throw new NullPointerException("logger must be non-null");
            }
            this.logger = logger;
        }

        @Override
        public void setSelectedItem(Object anItem) {
            Level level = (Level)anItem;
            this.logger.setLevel(level);
            StringBuilder err = new StringBuilder();
            for (Handler h : this.logger.getHandlers()) {
                if (level == null || h.getLevel().intValue() <= level.intValue()) continue;
                err.append("handler filters data: ").append(h).append("\n");
            }
            if (err.length() > 0) {
                AutoplotUtil.showMessageDialog(LogConsoleSettingsDialog.this, err.toString(), "Misconfigured Logger", 0);
            }
        }

        @Override
        public Object getSelectedItem() {
            return this.logger.getLevel();
        }

        @Override
        public int getSize() {
            return LOG_LEVELS.length;
        }

        @Override
        public Object getElementAt(int index) {
            return LOG_LEVELS[index];
        }

        @Override
        public void addListDataListener(ListDataListener l) {
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
        }
    }

    static class MyCellRenderer
    implements TableCellRenderer {
        TableCellRenderer delegate;
        Color backgroundColor;
        Color oddColor = Color.LIGHT_GRAY;
        Color selectedColor;
        Color selectedBackgroundColor;
        Color focusColor;
        Color focusBackgroundColor;

        public MyCellRenderer(TableCellRenderer delegate) {
            this.delegate = delegate;
            Component c = delegate.getTableCellRendererComponent(null, "", false, false, 0, 0);
            this.backgroundColor = c.getBackground();
            c = delegate.getTableCellRendererComponent(null, "", true, false, 0, 0);
            this.selectedBackgroundColor = c.getBackground();
            this.selectedColor = c.getForeground();
            c = delegate.getTableCellRendererComponent(null, "", false, true, 0, 0);
            this.focusBackgroundColor = c.getBackground();
            this.focusColor = c.getForeground();
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object lvalue, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = this.delegate.getTableCellRendererComponent(table, lvalue, isSelected, hasFocus, row, column);
            if (row % 2 == 0) {
                if (isSelected) {
                    c.setBackground(table.getSelectionBackground());
                } else {
                    c.setBackground(table.getBackground());
                }
            } else if (isSelected) {
                c.setBackground(LogConsoleSettingsDialog.slightlyDarker(table.getSelectionBackground()));
            } else {
                c.setBackground(LogConsoleSettingsDialog.slightlyDarker(table.getBackground()));
            }
            return c;
        }
    }

    class MyEditor
    implements TableCellEditor {
        JComboBox cb;
        Logger value;
        private final EventListenerList listeners = new EventListenerList();
        private ChangeEvent evt;

        MyEditor() {
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.value = (Logger)value;
            LogLevelComboBoxModel m = new LogLevelComboBoxModel((Logger)value);
            this.cb = new JComboBox(m);
            this.cb.setRenderer(new LogLevelCellRenderer(this.cb.getRenderer(), this.value));
            return this.cb;
        }

        @Override
        public Object getCellEditorValue() {
            return this.value;
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            return true;
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            return true;
        }

        @Override
        public boolean stopCellEditing() {
            this.fireEditingStopped();
            return true;
        }

        @Override
        public void cancelCellEditing() {
            this.fireEditingCanceled();
        }

        private void fireEditingStopped() {
            Object[] l = this.listeners.getListenerList();
            for (int i = 0; i < l.length; i += 2) {
                if (l[i] != CellEditorListener.class) continue;
                CellEditorListener cel = (CellEditorListener)l[i + 1];
                if (this.evt == null) {
                    this.evt = new ChangeEvent(this);
                }
                cel.editingStopped(this.evt);
            }
        }

        private void fireEditingCanceled() {
            Object[] l = this.listeners.getListenerList();
            for (int i = 0; i < l.length; i += 2) {
                if (l[i] != CellEditorListener.class) continue;
                CellEditorListener cel = (CellEditorListener)l[i + 1];
                if (this.evt == null) {
                    this.evt = new ChangeEvent(this);
                }
                cel.editingCanceled(this.evt);
            }
        }

        @Override
        public void addCellEditorListener(CellEditorListener l) {
            this.listeners.add(CellEditorListener.class, l);
        }

        @Override
        public void removeCellEditorListener(CellEditorListener l) {
            this.listeners.add(CellEditorListener.class, l);
        }
    }

    static class TimeTaggingCellRenderer
    implements TableCellRenderer {
        JComponent component = null;
        TableCellRenderer delegate;

        public TimeTaggingCellRenderer(TableCellRenderer delegate) {
            this.delegate = delegate;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object lvalue, boolean isSelected, boolean hasFocus, int row, int column) {
            Logger logger = (Logger)lvalue;
            if (logger instanceof LoggerManager.TimeTaggingLogger) {
                long time = ((LoggerManager.TimeTaggingLogger)logger).getLastTime();
                return new JLabel(String.valueOf(System.currentTimeMillis() - time));
            }
            return new JLabel("???");
        }
    }
}

