/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.scriptconsole;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.Element;
import org.autoplot.AppManager;
import org.autoplot.ApplicationModel;
import org.autoplot.AutoplotUI;
import org.autoplot.JythonUtil;
import org.autoplot.ScriptContext;
import org.autoplot.datasource.DataSetSelector;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSourceUtil;
import org.autoplot.dom.ApplicationController;
import org.autoplot.jythonsupport.ui.EditorAnnotationsSupport;
import org.autoplot.jythonsupport.ui.EditorContextMenu;
import org.autoplot.jythonsupport.ui.EditorTextPane;
import org.autoplot.scriptconsole.ScriptPanelSupport;
import org.das2.jythoncompletion.JythonCompletionProvider;
import org.das2.jythoncompletion.JythonInterpreterProvider;
import org.das2.jythoncompletion.ui.CompletionImpl;
import org.das2.util.FileUtil;
import org.das2.util.LoggerManager;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.jdesktop.layout.GroupLayout;
import org.python.core.Py;
import org.python.core.PyDictionary;
import org.python.core.PyObject;
import org.python.util.InteractiveInterpreter;
import org.python.util.PythonInterpreter;

public class JythonScriptPanel
extends JPanel {
    private static final Logger logger = LoggerManager.getLogger("autoplot");
    ApplicationModel model;
    ApplicationController applicationController;
    DataSetSelector selector;
    ScriptPanelSupport support;
    static final int CONTEXT_DATA_SOURCE = 1;
    static final int CONTEXT_APPLICATION = 0;
    private int context = 0;
    File runningScript = null;
    boolean containsTabs = false;
    private transient DocumentListener dirtyListener;
    private static final String ACTIONKEY_SAVE = "save";
    private static final String ACTIONKEY_EXECUTE = "execute";
    private JLabel caretPositionLabel;
    private JComboBox contextSelector;
    private JButton executeButton;
    private JTextField fileNameTextField;
    private JButton interruptButton;
    private JScrollPane jScrollPane2;
    private JButton newScriptButton;
    private JButton openButton;
    private JButton saveAsButton;
    private EditorTextPane textArea;
    protected String filename = null;
    public static final String PROP_FILENAME = "filename";
    protected boolean dirty = false;
    public static final String PROP_DIRTY = "dirty";

    public void loadExampleUri(String uri) {
        try {
            File ff = DataSetURI.getFile(uri, (ProgressMonitor)new NullProgressMonitor());
            this.loadFile(ff);
        }
        catch (IOException ex) {
            Logger.getLogger(JythonScriptPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public JythonScriptPanel(AutoplotUI app, DataSetSelector selector) {
        this.initComponents();
        this.setMinimumSize(new Dimension(400, 400));
        this.jScrollPane2.getVerticalScrollBar().setUnitIncrement(12);
        this.setContext(0);
        this.model = app.getApplicationModel();
        this.support = new ScriptPanelSupport(this, this.model, selector);
        this.applicationController = this.model.getDocumentModel().getController();
        this.selector = selector;
        this.textArea.setFont(Font.decode(JythonCompletionProvider.getInstance().settings().getEditorFont()));
        this.textArea.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                int pos = JythonScriptPanel.this.textArea.getCaretPosition();
                Element root = JythonScriptPanel.this.textArea.getDocument().getDefaultRootElement();
                int irow = root.getElementIndex(pos);
                int icol = pos - root.getElement(irow).getStartOffset();
                String text = "" + (1 + irow) + "," + (1 + icol);
                int isel = JythonScriptPanel.this.textArea.getSelectionEnd() - JythonScriptPanel.this.textArea.getSelectionStart();
                int iselRow0 = root.getElementIndex(JythonScriptPanel.this.textArea.getSelectionStart());
                int iselRow1 = root.getElementIndex(JythonScriptPanel.this.textArea.getSelectionEnd());
                if (isel > 0) {
                    text = iselRow1 > iselRow0 ? "[" + isel + "ch," + (1 + iselRow1 - iselRow0) + "lines]" : "[" + isel + "ch]";
                }
                JythonScriptPanel.this.caretPositionLabel.setText(text);
            }
        });
        this.dirtyListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                JythonScriptPanel.this.setDirty(true);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                JythonScriptPanel.this.setDirty(true);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        };
        this.textArea.getDocument().addDocumentListener(this.dirtyListener);
        this.textArea.addPropertyChangeListener("document", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getOldValue() != null) {
                    ((Document)evt.getOldValue()).removeDocumentListener(JythonScriptPanel.this.dirtyListener);
                }
                ((Document)evt.getNewValue()).addDocumentListener(JythonScriptPanel.this.dirtyListener);
            }
        });
        this.textArea.getActionMap().put(ACTIONKEY_SAVE, new AbstractAction(ACTIONKEY_SAVE){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                try {
                    JythonScriptPanel.this.support.save();
                }
                catch (FileNotFoundException ex) {
                    JythonScriptPanel.this.model.getExceptionHandler().handle(ex);
                }
                catch (IOException ex) {
                    JythonScriptPanel.this.model.getExceptionHandler().handle(ex);
                }
            }
        });
        this.textArea.getActionMap().put(ACTIONKEY_EXECUTE, new AbstractAction(ACTIONKEY_EXECUTE){

            @Override
            public void actionPerformed(ActionEvent e) {
                JythonScriptPanel.this.executeButtonActionPerformed(e);
            }
        });
        AppManager.getInstance().addCloseCallback(app, "jythonScriptPanel", new AppManager.CloseCallback(){

            @Override
            public boolean checkClose() {
                if (JythonScriptPanel.this.isDirty() && JythonScriptPanel.this.isVisible() && JythonScriptPanel.this.textArea.getDocument().getLength() > 0) {
                    int resp = JOptionPane.showConfirmDialog(JythonScriptPanel.this, "Script Editor contains unsaved changes.  Save these changes?");
                    switch (resp) {
                        case 2: {
                            return false;
                        }
                        case 0: {
                            try {
                                return JythonScriptPanel.this.support.save() == 0;
                            }
                            catch (IOException ex) {
                                return false;
                            }
                        }
                        case 1: {
                            return true;
                        }
                    }
                    return false;
                }
                return true;
            }
        });
        this.textArea.getInputMap().put(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), ACTIONKEY_SAVE);
        this.textArea.getInputMap().put(KeyStroke.getKeyStroke(117, 0), ACTIONKEY_EXECUTE);
        this.textArea.getInputMap().put(KeyStroke.getKeyStroke(117, 64), ACTIONKEY_EXECUTE);
        EditorContextMenu menu = new EditorContextMenu(this.textArea);
        menu.addExampleAction(new AbstractAction("makePngWalk.jy"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                JythonScriptPanel.this.loadExample("/scripts/pngwalk/makePngWalk.jy");
            }
        });
        menu.addExampleAction(new AbstractAction("addDigitizer.jy"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                JythonScriptPanel.this.loadExample("/scripts/addDigitizer.jy");
            }
        });
        menu.addExampleAction(new AbstractAction("splineDemo.jy"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                JythonScriptPanel.this.loadExample("/scripts/splineDemo.jy");
            }
        });
        menu.addExampleAction(new AbstractAction("More Jython Scripts..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                DataSourceUtil.openBrowser("http://apps-pw.physics.uiowa.edu/hudson/job/autoplot-release2017/ws/autoplot/Autoplot/src/scripts/");
            }
        });
        menu.addExampleAction(new AbstractAction("mashup.jyds"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                JythonScriptPanel.this.loadExample("/mashup.jyds");
            }
        });
        menu.addExampleAction(new AbstractAction("rheology.jyds"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                JythonScriptPanel.this.loadExample("/rheology.jyds");
            }
        });
        menu.addExampleAction(new AbstractAction("More Jython Data Source Scripts..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                DataSourceUtil.openBrowser("http://apps-pw.physics.uiowa.edu/hudson/job/autoplot-release2017/ws/autoplot/JythonDataSource/src/");
            }
        });
        menu.setDataSetSelector(selector);
        JythonCompletionProvider.getInstance().addPropertyChangeListener("message", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                JythonScriptPanel.this.applicationController.setStatus(JythonCompletionProvider.getInstance().getMessage());
            }
        });
        this.support.addPropertyChangeListener("interruptable", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() == null) {
                    JythonScriptPanel.this.interruptButton.setEnabled(false);
                    JythonScriptPanel.this.executeButton.setEnabled(true);
                } else {
                    JythonScriptPanel.this.interruptButton.setEnabled(true);
                    JythonScriptPanel.this.executeButton.setEnabled(false);
                }
            }
        });
        CompletionImpl impl = CompletionImpl.get();
        impl.startPopup(this.textArea);
    }

    private void loadExample(String resourceFile) {
        try {
            URL url = EditorContextMenu.class.getResource(resourceFile);
            if (this.isDirty() && this.support.saveAs() == 1) {
                return;
            }
            this.support.loadInputStream(url.openStream());
            if (resourceFile.endsWith(".jy")) {
                this.setContext(0);
            } else {
                this.setContext(1);
            }
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }

    protected void updateStatus() {
        if (this.filename == null) {
            this.fileNameTextField.setText("" + (this.dirty ? " *" : "") + (this.containsTabs ? " TAB" : ""));
            this.getEditorPanel().setEditable(true);
        } else {
            File lfile = new File(this.filename);
            boolean writable = lfile.canWrite() && !FileUtil.isParent(FileSystem.settings().getLocalCacheDir(), lfile);
            this.getEditorPanel().setEditable(writable);
            this.fileNameTextField.setText(this.filename + (writable ? "" : " (read only)") + (this.dirty ? " *" : "") + (this.containsTabs ? " TAB" : ""));
        }
    }

    int getContext() {
        return this.context;
    }

    protected final void setContext(int context) {
        this.context = context;
        this.contextSelector.setSelectedIndex(context);
        if (context == 0) {
            this.textArea.putClientProperty("JYTHON_INTERPRETER_PROVIDER", new JythonInterpreterProvider(){

                @Override
                public PythonInterpreter createInterpreter() throws IOException {
                    InteractiveInterpreter interp = JythonUtil.createInterpreter(true, false);
                    interp.set("dom", (Object)JythonScriptPanel.this.model.getDocumentModel());
                    interp.set("params", (PyObject)new PyDictionary());
                    interp.set("resourceURI", Py.None);
                    return interp;
                }
            });
        } else if (context == 1) {
            this.textArea.putClientProperty("JYTHON_INTERPRETER_PROVIDER", new JythonInterpreterProvider(){

                @Override
                public PythonInterpreter createInterpreter() throws IOException {
                    InteractiveInterpreter interp = JythonUtil.createInterpreter(false, false);
                    interp.set("params", (PyObject)new PyDictionary());
                    interp.set("resourceURI", Py.None);
                    return interp;
                }
            });
        }
    }

    private void initComponents() {
        this.executeButton = new JButton();
        this.saveAsButton = new JButton();
        this.openButton = new JButton();
        this.contextSelector = new JComboBox();
        this.caretPositionLabel = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.textArea = new EditorTextPane();
        this.newScriptButton = new JButton();
        this.interruptButton = new JButton();
        this.fileNameTextField = new JTextField();
        this.executeButton.setIcon(new ImageIcon(this.getClass().getResource("/org/autoplot/go.png")));
        this.executeButton.setText("Execute");
        this.executeButton.setToolTipText("<html>Execute script.  <br>Alt modifier enters editor GUI.  <br>Ctrl modifier attempts to trace program location.  <br>Shift modifier will being up parameters gui.");
        this.executeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JythonScriptPanel.this.executeButtonActionPerformed(evt);
            }
        });
        this.saveAsButton.setText("Save As...");
        this.saveAsButton.setToolTipText("Save the buffer to a local file.");
        this.saveAsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JythonScriptPanel.this.saveAsButtonActionPerformed(evt);
            }
        });
        this.openButton.setText("Open...");
        this.openButton.setToolTipText("Open the local file to the buffer.");
        this.openButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JythonScriptPanel.this.openButtonActionPerformed(evt);
            }
        });
        this.contextSelector.setModel(new DefaultComboBoxModel<String>(new String[]{"Application Context", "Data Source Context"}));
        this.contextSelector.setToolTipText("<html>select the context for the script: to create new datasets (data source context), or to control an application (application context)</html>\n");
        this.contextSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JythonScriptPanel.this.contextSelectorActionPerformed(evt);
            }
        });
        this.caretPositionLabel.setText("1,1");
        this.caretPositionLabel.setToolTipText("row,column; or the number of characters and lines selected.");
        this.textArea.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                JythonScriptPanel.this.textAreaFocusGained(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.textArea);
        this.newScriptButton.setText("New");
        this.newScriptButton.setToolTipText("Reset the buffer to a new file.");
        this.newScriptButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JythonScriptPanel.this.newScriptButtonActionPerformed(evt);
            }
        });
        this.interruptButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/stop.png")));
        this.interruptButton.setText("Stop");
        this.interruptButton.setToolTipText("Interrupt running script");
        this.interruptButton.setEnabled(false);
        this.interruptButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JythonScriptPanel.this.interruptButtonActionPerformed(evt);
            }
        });
        this.fileNameTextField.setEditable(false);
        this.fileNameTextField.setFont(this.fileNameTextField.getFont().deriveFont((float)this.fileNameTextField.getFont().getSize() - 2.0f));
        this.fileNameTextField.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.executeButton, -2, 124, -2).addPreferredGap(0).add((Component)this.interruptButton).add(7, 7, 7).add((Component)this.saveAsButton).addPreferredGap(0).add((Component)this.openButton).addPreferredGap(0).add((Component)this.newScriptButton).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.contextSelector, -2, -1, -2)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.fileNameTextField).addPreferredGap(0).add((Component)this.caretPositionLabel, -2, 99, -2)).add((Component)this.jScrollPane2));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.executeButton).add((Component)this.contextSelector, -2, -1, -2).add((Component)this.saveAsButton).add((Component)this.openButton).add((Component)this.newScriptButton).add((Component)this.interruptButton)).addPreferredGap(0).add((Component)this.jScrollPane2, -1, 280, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.caretPositionLabel).add((Component)this.fileNameTextField, -2, -1, -2))));
        layout.linkSize(new Component[]{this.executeButton, this.interruptButton, this.newScriptButton, this.openButton, this.saveAsButton}, 2);
    }

    private void executeButtonActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        if (this.dirty && this.support.file != null) {
            try {
                this.support.save();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        System.err.println("== Executing Script ==");
        ScriptContext.setWindow(this.model);
        if (this.support.file != null) {
            this.setRunningScript(this.support.file);
        }
        this.support.executeScript(evt.getModifiers());
    }

    private void saveAsButtonActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        this.support.saveAs();
    }

    private void openButtonActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        this.support.open();
    }

    private void contextSelectorActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        this.setContext(this.contextSelector.getSelectedIndex());
    }

    private void textAreaFocusGained(FocusEvent evt) {
        CompletionImpl impl = CompletionImpl.get();
        impl.startPopup(this.textArea);
    }

    private void newScriptButtonActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        this.support.newScript();
    }

    private void interruptButtonActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        this.support.interrupt();
    }

    public EditorTextPane getEditorPanel() {
        return this.textArea;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        String oldFilename = this.filename;
        this.filename = filename;
        this.updateStatus();
        this.firePropertyChange(PROP_FILENAME, oldFilename, filename);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        boolean oldDirty = this.dirty;
        this.dirty = dirty;
        if (oldDirty != dirty) {
            this.updateStatus();
        }
        this.firePropertyChange(PROP_DIRTY, oldDirty, dirty);
    }

    public boolean loadFile(File file) throws IOException {
        if (this.isDirty()) {
            return false;
        }
        this.support.loadFile(file);
        return true;
    }

    public EditorAnnotationsSupport getAnnotationsSupport() {
        return this.support.annotationsSupport;
    }

    public void setRunningScript(File f) {
        this.runningScript = f;
    }

    public File getRunningScript() {
        return this.runningScript;
    }
}

