/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.scriptconsole;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.ByteArrayPartSource;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.PartSource;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.autoplot.APSplash;
import org.autoplot.AppManager;
import org.autoplot.ApplicationModel;
import org.autoplot.AutoplotUI;
import org.autoplot.AutoplotUtil;
import org.autoplot.ScriptContext;
import org.autoplot.dom.Application;
import org.autoplot.scriptconsole.GuiExceptionHandlerSubmitForm;
import org.autoplot.scriptconsole.JythonScriptPanel;
import org.autoplot.scriptconsole.LogConsole;
import org.autoplot.scriptconsole.SendEmailFeedback;
import org.autoplot.state.SerializeUtil;
import org.autoplot.state.StatePersistence;
import org.autoplot.state.UndoRedoSupport;
import org.das2.DasApplication;
import org.das2.datum.LoggerManager;
import org.das2.util.AboutUtil;
import org.das2.util.Base64;
import org.das2.util.ExceptionHandler;
import org.python.core.PyException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;

public final class GuiExceptionHandler
implements ExceptionHandler {
    private static final Logger logger = LoggerManager.getLogger("autoplot.util");
    private static final String CUSTODIAN = "faden@cottagesystems.com";
    private static final String UNCAUGHT = "An unexpected error has occurred. The system may not be able to recover properly.  You can inspect information about the crash with the Show Details button below, and submit an error report.\n\nThis submission to the Autoplot developers will include information about the program state including data URIs, undos, source code version tags,and platform information.\n\n";
    private JButton submitButton;
    public static final String USER_ID = "USER_ID";
    public static final String EMAIL = "EMAIL";
    public static final String FOCUS_URI = "FOCUS_URI";
    public static final String PENDING_FOCUS_URI = "PENDING_FOCUS_URI";
    public static final String APP_COUNT = "APP_COUNT";
    public static final String INCLDOM = "INCLDOM";
    public static final String INCLSCREEN = "INCLSCREEN";
    public static final String APP_MODEL = "APP_MODEL";
    public static final String UNDO_REDO_SUPPORT = "UNDO_REDO_SUPPORT";
    public static final String THROWABLE = "throwable";
    public static final String BUILD_INFO = "build_info";
    public static final String LOG_RECORDS = "log_records";
    private ApplicationModel appModel = null;
    private UndoRedoSupport undoRedoSupport = null;
    JythonScriptPanel scriptPanel = null;
    private final Map<Integer, DiaDescriptor> dialogs = Collections.synchronizedMap(new HashMap());
    private LogConsole lc;
    private String focusURI;
    List<LogRecord> recs;
    List<String> bis;
    Map<String, Object> map;
    boolean uncaught;
    Throwable t;

    @Override
    public void handle(Throwable t) {
        if (DasApplication.getDefaultApplication().isHeadless()) {
            t.printStackTrace();
        } else {
            this.checkJythonError(t);
            this.showExceptionDialog(t, "");
        }
    }

    @Override
    public void handleUncaught(Throwable t) {
        if (DasApplication.getDefaultApplication().isHeadless()) {
            t.printStackTrace();
        } else {
            this.checkJythonError(t);
            this.showExceptionDialog(t, UNCAUGHT);
        }
    }

    public void setScriptPanel(JythonScriptPanel scriptPanel) {
        this.scriptPanel = scriptPanel;
    }

    private void checkJythonError(Throwable t) {
        if (t instanceof PyException && this.scriptPanel != null) {
            this.scriptPanel.support.annotateError((PyException)t, 0, null);
        } else if (this.scriptPanel != null) {
            this.scriptPanel.support.annotateError(t);
        }
    }

    private boolean checkOutOfMemoryError(Throwable t) {
        if (t == null) {
            return false;
        }
        if (t instanceof OutOfMemoryError) {
            return true;
        }
        if (t instanceof PyException) {
            return ((PyException)t).toString().contains("java.lang.OutOfMemory");
        }
        return false;
    }

    private DiaDescriptor createDialog(final Throwable throwable, final boolean uncaught) {
        final DiaDescriptor diaDescriptor = new DiaDescriptor();
        diaDescriptor.hits = 1;
        final JDialog dialog = new JDialog(DasApplication.getDefaultApplication().getMainFrame());
        if (!uncaught) {
            dialog.setTitle("Error Notification");
        } else {
            dialog.setTitle("Runtime Error Occurred");
        }
        dialog.setModal(false);
        dialog.setResizable(true);
        dialog.setDefaultCloseOperation(2);
        JTextArea messageArea = new JTextArea(12, 60);
        messageArea.setLineWrap(true);
        messageArea.setWrapStyleWord(true);
        messageArea.setEditable(false);
        JScrollPane message = new JScrollPane(messageArea);
        message.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)message, "Center");
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        JButton ok = new JButton("Ok");
        final JToggleButton details = new JToggleButton("Show Details");
        JButton submit = new JButton("Submit Error Report...");
        submit.setToolTipText("<html>Submit exception, platform information, source tags, and possibly log records to RTE server</html>");
        buttonPanel.add(submit);
        buttonPanel.add(details);
        buttonPanel.add(ok);
        mainPanel.add((Component)buttonPanel, "South");
        dialog.getContentPane().add((Component)mainPanel, "Center");
        final JTextArea traceArea = new JTextArea(10, 60);
        traceArea.setLineWrap(false);
        traceArea.setEditable(false);
        traceArea.setTabSize(4);
        diaDescriptor.textArea = messageArea;
        StringWriter writer = new StringWriter();
        throwable.printStackTrace(new PrintWriter(writer));
        traceArea.setText(writer.toString());
        final JPanel stackPane = new JPanel(new BorderLayout());
        stackPane.add((Component)new JScrollPane(traceArea), "North");
        stackPane.setBorder(new EmptyBorder(10, 10, 10, 10));
        JPanel buttonPanel2 = new JPanel(new FlowLayout(2));
        buttonPanel2.setBorder(new EmptyBorder(10, 0, 0, 0));
        JButton dump = new JButton("Dump to Console");
        buttonPanel2.add(dump);
        this.submitButton = submit;
        stackPane.add((Component)buttonPanel2, "South");
        Dimension size = message.getPreferredSize();
        size.width = stackPane.getPreferredSize().width;
        message.setPreferredSize(size);
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
                GuiExceptionHandler.this.dialogs.remove(diaDescriptor.hash);
            }
        });
        details.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (details.isSelected()) {
                    details.setText("Less Details");
                    dialog.getContentPane().add((Component)stackPane, "South");
                    dialog.pack();
                } else {
                    details.setText("More Details");
                    dialog.getContentPane().remove(stackPane);
                    dialog.pack();
                }
            }
        });
        dump.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String text = traceArea.getText();
                System.err.print(text);
            }
        });
        submit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GuiExceptionHandler.this.submitRuntimeException(throwable, uncaught);
            }
        });
        diaDescriptor.dialog = dialog;
        return diaDescriptor;
    }

    public void setApplicationModel(ApplicationModel appModel) {
        this.appModel = appModel;
    }

    public void setUndoRedoSupport(UndoRedoSupport undoRedoSupport) {
        this.undoRedoSupport = undoRedoSupport;
    }

    String updateText(GuiExceptionHandlerSubmitForm form, String userComments) {
        this.map.put(INCLDOM, form.isAllowDom());
        this.map.put(INCLSCREEN, form.isAllowScreenshot());
        this.map.put(EMAIL, form.getEmailTextField().getText());
        this.map.put(USER_ID, form.getUsernameTextField().getText().replaceAll(" ", "_"));
        return GuiExceptionHandler.formatReport(this.t, this.bis, this.recs, this.map, this.uncaught, userComments);
    }

    private void showExceptionDialog(Throwable t, String extraInfo) {
        boolean isUncaught = extraInfo.equals(UNCAUGHT);
        int hash = GuiExceptionHandler.hashCode(t);
        DiaDescriptor dia1 = this.dialogs.get(hash);
        String errorMessage = extraInfo + t.getClass().getName() + "\n" + (t.getMessage() == null ? "" : t.getMessage());
        if (t.getClass().getName().contains("PyException") || t.getClass().getName().contains("PySyntaxError")) {
            int i;
            String[] ss = t.toString().split("\n");
            if (ss[i = 0].contains("Traceback")) {
                ++i;
            }
            if (ss.length > 0 && ss[i].contains("in ?")) {
                ++i;
            }
            if (ss.length > i) {
                StringBuilder msg = new StringBuilder(ss[i++]);
                while (i < ss.length) {
                    msg.append("\n").append(ss[i++]);
                }
                errorMessage = errorMessage + msg.toString();
            }
        }
        if (dia1 != null) {
            errorMessage = errorMessage + "\n\nError hit " + (1 + dia1.hits) + " times";
            ++dia1.hits;
            if (dia1.hits % 100 == 0) {
                System.err.println("== Error hit " + dia1.hits + " times");
                t.printStackTrace(System.err);
            }
        }
        if (this.checkOutOfMemoryError(t)) {
            errorMessage = errorMessage + "\n\nThe wiki page at \"http://autoplot.org/outOfMemory\" might be helpful in resolving this issue.";
        }
        if (dia1 == null) {
            dia1 = this.createDialog(t, isUncaught);
        }
        JDialog dialog = dia1.dialog;
        this.dialogs.put(hash, dia1);
        dia1.hash = hash;
        dia1.textArea.setText(errorMessage);
        dialog.pack();
        dialog.setLocationRelativeTo(DasApplication.getDefaultApplication().getMainFrame());
        dialog.setVisible(true);
    }

    public static int hashCode(StackTraceElement[] ee) {
        int rteHash = 0;
        for (int i = 0; i < ee.length && i < 5; ++i) {
            rteHash = 31 * rteHash + GuiExceptionHandler.hashCode(ee[i]);
        }
        rteHash = Math.abs(rteHash) + (ee.length > 0 ? ee[0].getLineNumber() : 0);
        return rteHash;
    }

    public static int hashCode(Throwable t) {
        StackTraceElement[] ee = t.getStackTrace();
        return GuiExceptionHandler.hashCode(ee);
    }

    private static int hashCode(StackTraceElement e) {
        try {
            int result = 31 * e.getClassName().hashCode() + e.getMethodName().hashCode();
            return result;
        }
        catch (NullPointerException ex) {
            return 1;
        }
    }

    public void setLogConsole(LogConsole lc) {
        this.lc = lc;
    }

    public void setFocusURI(String uri) {
        this.focusURI = uri;
    }

    private static void formatException(Document doc, Element parent, Throwable th) {
        Element ex = doc.createElement("exception");
        Element type = doc.createElement("type");
        type.appendChild(doc.createTextNode(th.getClass().getName()));
        ex.appendChild(type);
        Element msg = doc.createElement("message");
        msg.appendChild(doc.createTextNode(th.toString()));
        ex.appendChild(msg);
        int hash = GuiExceptionHandler.hashCode(th);
        Element hashe = doc.createElement("hash");
        hashe.appendChild(doc.createTextNode(String.valueOf(hash)));
        ex.appendChild(hashe);
        StackTraceElement[] stes = th.getStackTrace();
        Element location = doc.createElement("location");
        if (stes.length > 0) {
            StackTraceElement ste = stes[0];
            Element ele = doc.createElement("class");
            ele.appendChild(doc.createTextNode(ste.getClassName()));
            location.appendChild(ele);
            ele = doc.createElement("method");
            ele.appendChild(doc.createTextNode(ste.getMethodName()));
            location.appendChild(ele);
            ele = doc.createElement("file");
            ele.appendChild(doc.createTextNode(ste.getFileName()));
            location.appendChild(ele);
            ele = doc.createElement("lineNumber");
            ele.appendChild(doc.createTextNode(String.valueOf(ste.getLineNumber())));
            location.appendChild(ele);
            ex.appendChild(location);
            ele = doc.createElement("toString");
            StringWriter sw = new StringWriter();
            th.printStackTrace(new PrintWriter(sw));
            ele.appendChild(doc.createTextNode("\n" + sw.toString()));
            ex.appendChild(ele);
        } else {
            Element ele = doc.createElement("noStackTrace");
            location.appendChild(ele);
            ex.appendChild(location);
        }
        parent.appendChild(ex);
    }

    private static void formatBuildInfos(Document doc, Element parent, List<String> bis) {
        Element pp = doc.createElement("buildInfos");
        try {
            Element tag = doc.createElement("releaseTag");
            tag.appendChild(doc.createTextNode(AboutUtil.getReleaseTag()));
            pp.appendChild(tag);
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "", ex);
        }
        try {
            Element url = doc.createElement("buildUrl");
            url.appendChild(doc.createTextNode(AboutUtil.getJenkinsURL()));
            pp.appendChild(url);
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "", ex);
        }
        for (String s : bis) {
            Element jar = doc.createElement("jar");
            jar.appendChild(doc.createTextNode(s));
            pp.appendChild(jar);
        }
        parent.appendChild(pp);
    }

    private static void formatSysProp(Document doc, Element parent, String prop) {
        Element ele = doc.createElement("property");
        ele.setAttribute("name", prop);
        String v = System.getProperty(prop);
        if (v != null) {
            ele.setAttribute("value", v);
        } else {
            ele.setAttribute("value", "(null)");
        }
        parent.appendChild(ele);
    }

    private static void formatPlatform(Document doc, Element parent) {
        Element p = doc.createElement("platform");
        GuiExceptionHandler.formatSysProp(doc, p, "java.version");
        GuiExceptionHandler.formatSysProp(doc, p, "java.vendor");
        GuiExceptionHandler.formatSysProp(doc, p, "os.name");
        GuiExceptionHandler.formatSysProp(doc, p, "os.arch");
        GuiExceptionHandler.formatSysProp(doc, p, "os.version");
        GuiExceptionHandler.formatSysProp(doc, p, "javawebstart.version");
        DecimalFormat nf = new DecimalFormat("0.0");
        String mem = nf.format(Runtime.getRuntime().maxMemory() / 0x100000L);
        String tmem = nf.format(Runtime.getRuntime().totalMemory() / 0x100000L);
        String fmem = nf.format(Runtime.getRuntime().freeMemory() / 0x100000L);
        Element ele = doc.createElement("property");
        ele.setAttribute("runtime.maxMemory", String.valueOf(mem) + " Mb");
        p.appendChild(ele);
        ele = doc.createElement("property");
        ele.setAttribute("runtime.totalMemory", String.valueOf(tmem) + " Mb");
        p.appendChild(ele);
        ele = doc.createElement("property");
        ele.setAttribute("runtime.freeMemory", String.valueOf(fmem) + " Mb");
        p.appendChild(ele);
        parent.appendChild(p);
    }

    private static void formatThreads(Document doc, Element parent) {
        Element ele = doc.createElement("threads");
        Map<Thread, StackTraceElement[]> threads = Thread.getAllStackTraces();
        for (Map.Entry<Thread, StackTraceElement[]> ent : threads.entrySet()) {
            Thread thread = ent.getKey();
            if (thread.getName().matches("RequestProcessor\\[\\d+\\]") && thread.getState() == Thread.State.WAITING) continue;
            Element ele1 = doc.createElement("thread");
            ele1.setAttribute("name", thread.getName());
            ele1.setAttribute("state", thread.getState().toString());
            Element ste = doc.createElement("stackTrace");
            ele1.appendChild(ste);
            StackTraceElement[] st = ent.getValue();
            StringBuilder b = new StringBuilder();
            for (StackTraceElement st1 : st) {
                b.append(st1.toString()).append("\n");
            }
            ste.appendChild(doc.createTextNode(b.toString()));
            ele.appendChild(ele1);
        }
        parent.appendChild(ele);
    }

    private static void formatUndos(Document doc, Element parent, UndoRedoSupport undo) {
        Element ele = doc.createElement("states");
        for (int i = undo.getDepth() - 1; i > 0; --i) {
            Element ele1 = doc.createElement("undo");
            ele1.setAttribute("pos", String.valueOf(i));
            ele1.appendChild(doc.createTextNode(undo.getLongUndoDescription(i)));
            ele.appendChild(ele1);
        }
        parent.appendChild(ele);
    }

    public static String formatReport(Map<String, Object> data, boolean uncaught, String userComments) {
        List<LogRecord> recs;
        List<String> bis;
        Throwable t = (Throwable)data.get(THROWABLE);
        if (t == null) {
            t = new RuntimeException("");
        }
        if ((bis = (List<String>)data.get(BUILD_INFO)) == null) {
            bis = Collections.emptyList();
        }
        if ((recs = (List<LogRecord>)data.get(LOG_RECORDS)) == null) {
            recs = Collections.emptyList();
        }
        return GuiExceptionHandler.formatReport(t, bis, recs, data, uncaught, userComments);
    }

    private static String formatReport(Throwable t, List<String> bis, List<LogRecord> recs, Map<String, Object> data, boolean uncaught, String userComments) {
        String s;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ApplicationModel appModel;
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element e = doc.createElement("exceptionReport");
            e.setAttribute("version", "1.1");
            doc.appendChild(e);
            Element app = doc.createElement("applicationId");
            app.appendChild(doc.createTextNode("autoplot"));
            e.appendChild(app);
            Element v = doc.createElement("applicationVersion");
            v.appendChild(doc.createTextNode(APSplash.getVersion()));
            e.appendChild(v);
            Element user = doc.createElement("userComments");
            user.appendChild(doc.createTextNode(userComments));
            e.appendChild(user);
            Element userN = doc.createElement("userName");
            userN.appendChild(doc.createTextNode((String)data.get(USER_ID)));
            e.appendChild(userN);
            Element mail = doc.createElement("email");
            mail.appendChild(doc.createTextNode((String)data.get(EMAIL)));
            e.appendChild(mail);
            Element focus = doc.createElement("focusUri");
            focus.appendChild(doc.createTextNode((String)data.get(FOCUS_URI)));
            e.appendChild(focus);
            Element ele = doc.createElement("pendingFocusUri");
            ele.appendChild(doc.createTextNode((String)data.get(PENDING_FOCUS_URI)));
            e.appendChild(ele);
            ele = doc.createElement("appCount");
            ele.appendChild(doc.createTextNode(String.valueOf(data.get(APP_COUNT))));
            e.appendChild(ele);
            GuiExceptionHandler.formatException(doc, e, t);
            GuiExceptionHandler.formatBuildInfos(doc, e, bis);
            GuiExceptionHandler.formatPlatform(doc, e);
            ele = doc.createElement("uncaught");
            ele.appendChild(doc.createTextNode(String.valueOf(uncaught)));
            e.appendChild(ele);
            if (data.get(INCLDOM) == null || ((Boolean)data.get(INCLDOM)).booleanValue()) {
                appModel = (ApplicationModel)data.get(APP_MODEL);
                if (appModel != null) {
                    Application state = appModel.getDocumentModel();
                    Element app1 = SerializeUtil.getDomElement(doc, state, StatePersistence.currentScheme(), false);
                    Element vap = doc.createElement("vap");
                    vap.appendChild(app1);
                    vap.setAttribute("domVersion", StatePersistence.currentScheme().getId());
                    try {
                        vap.setAttribute("appVersionTag", AboutUtil.getReleaseTag());
                    }
                    catch (IOException ex) {
                        vap.setAttribute("appVersionTag", ex.getMessage());
                    }
                    Element dom = doc.createElement("dom");
                    dom.appendChild(vap);
                    e.appendChild(vap);
                }
                GuiExceptionHandler.formatThreads(doc, e);
                UndoRedoSupport undoRedoSupport = (UndoRedoSupport)data.get(UNDO_REDO_SUPPORT);
                if (undoRedoSupport != null) {
                    GuiExceptionHandler.formatUndos(doc, e, undoRedoSupport);
                }
            }
            if (data.get(INCLSCREEN) != null && ((Boolean)data.get(INCLSCREEN)).booleanValue()) {
                appModel = (ApplicationModel)data.get(APP_MODEL);
                if (appModel != null) {
                    Window w = SwingUtilities.getWindowAncestor(appModel.getCanvas());
                    BufferedImage img = new BufferedImage(w.getWidth(), w.getHeight(), 1);
                    w.print(img.getGraphics());
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    try {
                        ImageIO.write((RenderedImage)img, "png", baos);
                        baos.close();
                        byte[] array = baos.toByteArray();
                        String image64 = Base64.encodeBytes(array);
                        Element screen = doc.createElement("screenshot");
                        screen.setAttribute("mimetype", "image/png");
                        screen.appendChild(doc.createTextNode("\n" + image64 + "\n"));
                        e.appendChild(screen);
                    }
                    catch (IOException ex) {
                        logger.log(Level.WARNING, null, ex);
                    }
                } else {
                    System.err.println("couldnt find appModel");
                }
            }
            DOMImplementationLS ls = (DOMImplementationLS)doc.getImplementation().getFeature("LS", "3.0");
            LSOutput output = ls.createLSOutput();
            output.setEncoding("UTF-8");
            output.setByteStream(out);
            LSSerializer serializer = ls.createLSSerializer();
            try {
                if (serializer.getDomConfig().canSetParameter("format-pretty-print", Boolean.TRUE)) {
                    serializer.getDomConfig().setParameter("format-pretty-print", Boolean.TRUE);
                }
            }
            catch (Error error) {
                error.printStackTrace();
            }
            serializer.write(doc, output);
        }
        catch (ParserConfigurationException doc) {
            // empty catch block
        }
        try {
            out.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        try {
            s = out.toString("UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            s = out.toString();
        }
        return s;
    }

    FileFilter getFileNameExtensionFilter(final String desc, final String[] exts) {
        return new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                if (pathname.isFile()) {
                    return true;
                }
                int n = 0;
                String[] stringArray = exts;
                int n2 = stringArray.length;
                if (n < n2) {
                    String ext = stringArray[n];
                    if (ext.length() > 1 && ext.charAt(0) == '.') {
                        return pathname.toString().endsWith(ext);
                    }
                    return pathname.toString().endsWith("." + ext);
                }
                return false;
            }

            @Override
            public String getDescription() {
                return desc;
            }
        };
    }

    private synchronized String getReport(GuiExceptionHandlerSubmitForm form) {
        String id = form.getUsernameTextField().getText().replaceAll(" ", "_");
        if (id.trim().equals("")) {
            id = "anon";
        }
        this.map.put(USER_ID, id);
        String email = form.getEmailTextField().getText();
        this.map.put(EMAIL, email);
        this.map.put(INCLSCREEN, form.isAllowScreenshot());
        String report = GuiExceptionHandler.formatReport(this.t, this.bis, this.recs, this.map, this.uncaught, form.getUserTextArea().getText());
        logger.log(Level.FINE, "indexOf arrow= {0}", report.indexOf(8594));
        return report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submitRuntimeException(Throwable t, boolean uncaught) {
        int rteHash = GuiExceptionHandler.hashCode(t);
        Date now = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd_HHmmss");
        String eventId = sdf.format(now);
        String pendingFocus = "N/A";
        Window w = ScriptContext.getViewWindow();
        if (w instanceof AutoplotUI) {
            AutoplotUI app = (AutoplotUI)w;
            pendingFocus = app.getDataSetSelector().getValue();
        }
        int appCount = AppManager.getInstance().getApplicationCount();
        this.bis = null;
        try {
            this.bis = AboutUtil.getBuildInfos();
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        this.recs = null;
        if (this.lc != null) {
            this.recs = this.lc.records;
        }
        this.map = new HashMap<String, Object>();
        this.map.put(APP_MODEL, this.appModel);
        this.map.put(UNDO_REDO_SUPPORT, this.undoRedoSupport);
        String id = System.getProperty("user.name");
        this.map.put(USER_ID, id);
        this.map.put(EMAIL, "");
        this.map.put(FOCUS_URI, this.focusURI);
        this.map.put(PENDING_FOCUS_URI, pendingFocus);
        this.map.put(APP_COUNT, appCount);
        this.uncaught = uncaught;
        this.t = t;
        String report = GuiExceptionHandler.formatReport(t, this.bis, this.recs, this.map, uncaught, "USER COMMENTS");
        String url = "http://papco.org/RTEReceiver/LargeUpload.jsp";
        GuiExceptionHandlerSubmitForm form = new GuiExceptionHandlerSubmitForm();
        form.setGuiExceptionHandler(this);
        boolean notsent = true;
        while (notsent) {
            String fname;
            ImageIcon icon;
            Window parent;
            int option;
            form.getDataTextArea().setText(report);
            form.getUsernameTextField().setText((String)this.map.get(USER_ID));
            form.getEmailTextField().setText((String)this.map.get(EMAIL));
            Object[] choices = new String[]{"Copy to Clipboard", "Save to File", "Cancel", "Switch to Email", "Submit"};
            boolean useEmail = "T".equals(System.getProperty("autoplot.emailrte"));
            if (useEmail) {
                choices[4] = "Submit Email";
                choices[3] = "Switch to Post";
            }
            if ((option = JOptionPane.showOptionDialog(parent = this.appModel == null ? null : SwingUtilities.getWindowAncestor(this.appModel.getCanvas()), form, "Submit Exception Report", 0, 3, icon = new ImageIcon(AutoplotUtil.getAutoplotIcon()), choices, choices[4])) == 2) {
                return;
            }
            if (option == 1) {
                report = this.getReport(form);
                JFileChooser chooser = new JFileChooser();
                chooser.setFileFilter(this.getFileNameExtensionFilter("xml files", new String[]{".xml"}));
                fname = String.format("rte_%010d_%s_%s.xml", rteHash, eventId, id);
                chooser.setSelectedFile(new File(fname));
                if (chooser.showSaveDialog(form) != 0) continue;
                try {
                    File f = chooser.getSelectedFile();
                    try (PrintWriter out = null;){
                        out = new PrintWriter(f);
                        out.write(report);
                    }
                    notsent = false;
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(null, ex.toString());
                }
                continue;
            }
            if (option == 3) {
                if (useEmail) {
                    System.setProperty("autoplot.emailrte", "F");
                    continue;
                }
                System.setProperty("autoplot.emailrte", "T");
                continue;
            }
            if (option == 4) {
                report = this.getReport(form);
                if (useEmail) {
                    try {
                        SendEmailFeedback.sendEmail(report);
                        notsent = false;
                    }
                    catch (AddressException ex) {
                        JOptionPane.showMessageDialog(null, ex.toString());
                    }
                    catch (MessagingException ex) {
                        JOptionPane.showMessageDialog(null, ex.toString());
                    }
                    continue;
                }
                report = GuiExceptionHandler.formatReport(t, this.bis, this.recs, this.map, uncaught, form.getUserTextArea().getText());
                String sid = (String)this.map.get(USER_ID);
                sid = GuiExceptionHandler.safe(sid.replaceAll(" ", "").replaceAll("_", ""));
                fname = String.format("rte_%010d_%s_%s.xml", rteHash, eventId, sid);
                HttpClient client = new HttpClient();
                client.getHttpConnectionManager().getParams().setConnectionTimeout(3000);
                PostMethod postMethod = new PostMethod(url);
                Charset ch = Charset.forName("UTF-8");
                Part[] parts = new Part[]{new StringPart("secret", "secret"), new StringPart("todo", "upload"), new FilePart("uploadfile", (PartSource)new ByteArrayPartSource(fname, report.getBytes(ch)), "text/xml", ch.name())};
                postMethod.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, postMethod.getParams()));
                try {
                    int statusCode1 = client.executeMethod((HttpMethod)postMethod);
                    if (statusCode1 == 200) {
                        if (this.submitButton != null) {
                            this.submitButton.setEnabled(false);
                        }
                        notsent = false;
                        postMethod.releaseConnection();
                        continue;
                    }
                    postMethod.releaseConnection();
                    JOptionPane.showMessageDialog(null, "<html>I/O Exception when posting to<br>" + url + ":<br><br>" + postMethod.getStatusLine() + "<br><br>Consider save to file and email to faden@cottagesystems.com");
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(null, "<html>I/O Exception when posting to<br>" + url + ":<br><br>" + ex.toString() + "<br><br>Consider save to file and email to " + CUSTODIAN);
                }
                continue;
            }
            if (option != 0) continue;
            id = form.getUsernameTextField().getText().replaceAll(" ", "_");
            if (id.trim().equals("")) {
                id = "anon";
            }
            this.map.put(USER_ID, id);
            String email = form.getEmailTextField().getText();
            this.map.put(EMAIL, email);
            report = GuiExceptionHandler.formatReport(t, this.bis, this.recs, this.map, uncaught, form.getUserTextArea().getText());
            StringSelection stringSelection = new StringSelection(report);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(stringSelection, new ClipboardOwner(){

                @Override
                public void lostOwnership(Clipboard clipboard, Transferable contents) {
                }
            });
        }
    }

    public static String safe(String s) {
        try {
            if (s == null) {
                return "null";
            }
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(s);
        }
    }

    private static void syncroTest() {
        final GuiExceptionHandler eh = new GuiExceptionHandler();
        Runnable run1 = new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < 10; ++i) {
                    eh.handle(new RuntimeException("sync test ex 1!"));
                }
            }
        };
        Runnable run2 = new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < 10; ++i) {
                    eh.handle(new RuntimeException("sync test ex 2!"));
                }
            }
        };
        new Thread(run1).start();
        new Thread(run2).start();
    }

    public static void main(String[] args) {
        GuiExceptionHandler.syncroTest();
        GuiExceptionHandler eh = new GuiExceptionHandler();
        eh.handle(new RuntimeException("Bad Deal!"));
        eh.handle(new RuntimeException("Bad Deal!"));
        eh.handle(new RuntimeException("Bad Deal!"));
        for (int i = 0; i < 3; ++i) {
            eh.handle(new RuntimeException("Bad Deal 2!"));
        }
        GuiExceptionHandler eh2 = new GuiExceptionHandler();
        eh2.handleUncaught(new RuntimeException("Bad Deal!"));
    }

    static class DiaDescriptor {
        JDialog dialog;
        int hits;
        JTextArea textArea;
        int hash;

        DiaDescriptor() {
        }
    }
}

