/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.scriptconsole;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.das2.qds.ops.Ops;
import org.python.core.Py;
import org.python.core.PyFile;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.util.PythonInterpreter;

public class DebuggerConsole
extends JPanel {
    private static PipedOutputStream myout;
    private static JDialog dialog;
    private static Thread workerThread;
    private static BlockingQueue<String> queue;
    private static final Logger logger;
    private static PipedInputStream pin;
    private PyObject printObj;
    private static DebuggerConsole instance;
    PythonInterpreter out;
    protected final Object STATE_OPEN = "OPEN";
    protected final Object STATE_FORM_PDB_PROMPT = "PROMPT";
    protected final Object STATE_RETURN_INIT_PROMPT = "RETURN";
    protected final Object STATE_PDB = "PDB";
    protected final Object STATE_FORM_PDB_RESPONSE = "RESPONSE";
    private JButton continueButton;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    private JTextArea jTextArea1;
    private JTextArea jTextArea2;
    private JButton nextButton;
    private JTextField pdbInput;
    private JButton stepButton;
    private JButton upButton;
    private JButton whereButton;

    public static DebuggerConsole getInstance(JPanel panel) {
        if (instance == null) {
            instance = new DebuggerConsole();
            JDialog d = new JDialog(SwingUtilities.getWindowAncestor(panel), "Jython Debugger");
            d.setModal(false);
            d.getContentPane().add(instance);
            d.pack();
            d.setVisible(true);
            d.setDefaultCloseOperation(1);
            dialog = d;
        } else {
            dialog.setVisible(true);
        }
        return instance;
    }

    public void setInterp(PythonInterpreter out) {
        this.out = out;
        Py.getSystemState().stdin = new PyFile((InputStream)pin);
    }

    private DebuggerConsole() {
        this.initComponents();
    }

    public void println(String s) {
        this.jTextArea1.append(s);
        this.jTextArea1.append("\n");
    }

    public void print(String s) {
        this.jTextArea1.append(s);
    }

    private String getCharsForState(String s, Object state) {
        StringBuilder result;
        block6: {
            block9: {
                block8: {
                    block7: {
                        block5: {
                            result = new StringBuilder();
                            if (!state.toString().equals(this.STATE_OPEN)) break block5;
                            for (int i = 0; i < s.length(); ++i) {
                                result.append("O");
                            }
                            break block6;
                        }
                        if (!state.toString().equals(this.STATE_FORM_PDB_PROMPT)) break block7;
                        for (int i = 0; i < s.length(); ++i) {
                            result.append("P");
                        }
                        break block6;
                    }
                    if (!state.toString().equals(this.STATE_FORM_PDB_RESPONSE)) break block8;
                    for (int i = 0; i < s.length(); ++i) {
                        result.append("R");
                    }
                    break block6;
                }
                if (!state.toString().equals(this.STATE_PDB)) break block9;
                for (int i = 0; i < s.length(); ++i) {
                    result.append("D");
                }
                break block6;
            }
            if (!state.toString().equals(this.STATE_RETURN_INIT_PROMPT)) break block6;
            for (int i = 0; i < s.length(); ++i) {
                result.append("I");
            }
        }
        return result.toString();
    }

    public void print(String s, Object state) {
        this.jTextArea1.append(s);
        String ss = this.getCharsForState(s, state);
        this.jTextArea2.append(ss);
        if (s.endsWith("\n")) {
            this.jTextArea2.append("\n");
            this.jTextArea1.setCaretPosition(this.jTextArea1.getDocument().getLength());
            this.jTextArea2.setCaretPosition(this.jTextArea2.getDocument().getLength());
        }
    }

    private void initComponents() {
        this.nextButton = new JButton();
        this.upButton = new JButton();
        this.whereButton = new JButton();
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.jScrollPane2 = new JScrollPane();
        this.jTextArea2 = new JTextArea();
        this.stepButton = new JButton();
        this.pdbInput = new JTextField();
        this.continueButton = new JButton();
        this.nextButton.setText("Next");
        this.nextButton.setToolTipText("step to the next line, stepping over called function");
        this.nextButton.setEnabled(false);
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebuggerConsole.this.nextButtonActionPerformed(evt);
            }
        });
        this.upButton.setText("Up");
        this.upButton.setToolTipText("Continue until returning to the caller");
        this.upButton.setEnabled(false);
        this.upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebuggerConsole.this.upButtonActionPerformed(evt);
            }
        });
        this.whereButton.setText("Where");
        this.whereButton.setToolTipText("Refresh the debug position (Currently not functional)");
        this.whereButton.setEnabled(false);
        this.whereButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebuggerConsole.this.whereButtonActionPerformed(evt);
            }
        });
        this.jSplitPane1.setDividerLocation(300);
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setFont(new Font("Ubuntu", 0, 8));
        this.jTextArea1.setRows(5);
        this.jScrollPane1.setViewportView(this.jTextArea1);
        this.jSplitPane1.setLeftComponent(this.jScrollPane1);
        this.jTextArea2.setColumns(20);
        this.jTextArea2.setFont(new Font("Ubuntu", 0, 8));
        this.jTextArea2.setRows(5);
        this.jScrollPane2.setViewportView(this.jTextArea2);
        this.jSplitPane1.setRightComponent(this.jScrollPane2);
        this.stepButton.setText("Step");
        this.stepButton.setToolTipText("Execute the current line stepping to the next line or into a function.");
        this.stepButton.setEnabled(false);
        this.stepButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebuggerConsole.this.stepButtonActionPerformed(evt);
            }
        });
        this.pdbInput.setToolTipText("Enter expression, return will evaluate");
        this.pdbInput.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebuggerConsole.this.pdbInputActionPerformed(evt);
            }
        });
        this.continueButton.setText("Continue");
        this.continueButton.setToolTipText("Continue execution until breakpoint is hit.  (Currently not functional)");
        this.continueButton.setEnabled(false);
        this.continueButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DebuggerConsole.this.continueButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.stepButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nextButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.upButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.whereButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.continueButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pdbInput)).addComponent(this.jSplitPane1, -1, 586, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nextButton).addComponent(this.upButton).addComponent(this.whereButton).addComponent(this.stepButton).addComponent(this.pdbInput, -2, -1, -2).addComponent(this.continueButton)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSplitPane1, -1, 267, Short.MAX_VALUE)));
    }

    private void nextButtonActionPerformed(ActionEvent evt) {
        this.next();
    }

    private void upButtonActionPerformed(ActionEvent evt) {
        this.up();
    }

    private void whereButtonActionPerformed(ActionEvent evt) {
        queue.add("where\n");
    }

    private void stepButtonActionPerformed(ActionEvent evt) {
        queue.add("step\n");
    }

    private void pdbInputActionPerformed(ActionEvent evt) {
        queue.add(this.pdbInput.getText() + "\n");
    }

    private void continueButtonActionPerformed(ActionEvent evt) {
        this.continu();
    }

    public void next() {
        queue.add("next\n");
    }

    public void up() {
        queue.add("up\n");
    }

    public void continu() {
        queue.add("continue\n");
    }

    public PyObject setEval(String expr) {
        expr = expr.trim();
        PyObject lo = this.out.getLocals();
        if (lo instanceof PyStringMap) {
            PyStringMap psm = (PyStringMap)lo;
            this.printObj = psm.get((PyObject)new PyString(expr));
        }
        if (this.printObj == null || this.printObj == Py.None) {
            this.printObj = Ops.safeName(expr).equals(expr) ? new PyString("Name error: " + expr) : new PyString("expressions cannot be evaluated");
        }
        return this.printObj;
    }

    public PyObject getEval() {
        return this.printObj;
    }

    void finished() {
        this.stepButton.setEnabled(false);
        this.nextButton.setEnabled(false);
        this.upButton.setEnabled(false);
        this.whereButton.setEnabled(false);
        this.continueButton.setEnabled(false);
        this.pdbInput.setEnabled(false);
    }

    void started() {
        this.stepButton.setEnabled(true);
        this.nextButton.setEnabled(true);
        this.upButton.setEnabled(true);
        this.whereButton.setEnabled(true);
        this.continueButton.setEnabled(true);
        this.pdbInput.setEnabled(true);
    }

    static {
        workerThread = null;
        logger = Logger.getLogger("autoplot.jython.console");
        try {
            queue = new LinkedBlockingQueue<String>();
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                final String cmd = (String)queue.take();
                                Runnable doRun = new Runnable(){

                                    @Override
                                    public void run() {
                                        try {
                                            myout.write(cmd.getBytes());
                                            myout.flush();
                                        }
                                        catch (IOException ex) {
                                            logger.log(Level.SEVERE, null, ex);
                                        }
                                    }
                                };
                                doRun.run();
                            }
                        }
                        catch (InterruptedException ex) {
                            logger.log(Level.SEVERE, null, ex);
                            continue;
                        }
                        break;
                    }
                }
            };
            workerThread = new Thread(run, "debuggerConsoleWorker");
            workerThread.start();
            myout = new PipedOutputStream();
            pin = new PipedInputStream(myout);
            Py.getSystemState().stdin = new PyFile((InputStream)pin);
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
    }
}

