/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.scriptconsole;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import org.autoplot.datasource.AutoplotSettings;
import org.das2.util.TickleTimer;

public class CommandLineTextPane
extends JTextPane {
    List<String> history;
    int historyIndex;
    String pendingEntry;
    private static final int HIST_LENGTH = 20;
    TickleTimer flushTimer = new TickleTimer(500L, new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Preferences prefs = AutoplotSettings.settings().getPreferences(CommandLineTextPane.class);
            try {
                prefs.flush();
            }
            catch (BackingStoreException ex) {
                Logger.getLogger(CommandLineTextPane.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    });

    private String packHistoryCommands(List<String> history) {
        StringBuilder build = new StringBuilder();
        for (int i = 0; i < history.size(); ++i) {
            build.append(history.get(i));
            build.append("\\n");
        }
        return build.toString();
    }

    public CommandLineTextPane() {
        ActionMap map = this.getActionMap();
        this.history = new LinkedList<String>();
        this.historyIndex = 0;
        this.pendingEntry = "";
        AbstractAction evalAction = new AbstractAction("eval"){

            @Override
            public void actionPerformed(ActionEvent e) {
                String cmd = CommandLineTextPane.this.getText();
                if ((cmd = cmd.trim()).length() > 0 && (CommandLineTextPane.this.history.isEmpty() || !CommandLineTextPane.this.history.get(CommandLineTextPane.this.history.size() - 1).equals(cmd))) {
                    CommandLineTextPane.this.history.add(cmd);
                    while (CommandLineTextPane.this.history.size() > 20) {
                        CommandLineTextPane.this.history.remove(0);
                    }
                }
                CommandLineTextPane.this.historyIndex = CommandLineTextPane.this.history.size();
                CommandLineTextPane.this.pendingEntry = "";
                Preferences prefs = AutoplotSettings.settings().getPreferences(CommandLineTextPane.class);
                prefs.put("lastCommands", CommandLineTextPane.this.packHistoryCommands(CommandLineTextPane.this.history.subList(0, CommandLineTextPane.this.historyIndex)));
                CommandLineTextPane.this.flushTimer.tickle();
                CommandLineTextPane.this.fireActionPerformed(e);
            }
        };
        AbstractAction histNextAction = new AbstractAction("histNext"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CommandLineTextPane.this.historyIndex < CommandLineTextPane.this.history.size()) {
                    ++CommandLineTextPane.this.historyIndex;
                    if (CommandLineTextPane.this.historyIndex == CommandLineTextPane.this.history.size()) {
                        CommandLineTextPane.this.setText(CommandLineTextPane.this.pendingEntry);
                    } else {
                        CommandLineTextPane.this.setText(CommandLineTextPane.this.history.get(CommandLineTextPane.this.historyIndex));
                    }
                }
            }
        };
        AbstractAction histPrevAction = new AbstractAction("histPrev"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CommandLineTextPane.this.historyIndex > 0) {
                    if (CommandLineTextPane.this.historyIndex == CommandLineTextPane.this.history.size()) {
                        CommandLineTextPane.this.pendingEntry = CommandLineTextPane.this.getText();
                    }
                    --CommandLineTextPane.this.historyIndex;
                    CommandLineTextPane.this.setText(CommandLineTextPane.this.history.get(CommandLineTextPane.this.historyIndex));
                }
            }
        };
        map.put("eval", evalAction);
        map.put("histPrev", histPrevAction);
        map.put("histNext", histNextAction);
        this.setActionMap(map);
        InputMap imap = this.getInputMap();
        imap.put(KeyStroke.getKeyStroke(10, 0), "eval");
        imap.put(KeyStroke.getKeyStroke(38, 0), "histPrev");
        imap.put(KeyStroke.getKeyStroke(40, 0), "histNext");
        this.loadFromPrefs();
    }

    private List<String> unpackHistoryCommands(String history) {
        String[] hh = history.split("\\\\n");
        return Arrays.asList(hh);
    }

    private void loadFromPrefs() {
        Preferences prefs = AutoplotSettings.settings().getPreferences(CommandLineTextPane.class);
        String last = prefs.get("lastCommands", "");
        if (last.trim().length() > 0) {
            this.history.addAll(this.unpackHistoryCommands(last));
            this.historyIndex = this.history.size();
        }
    }

    public synchronized void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    public synchronized void removeActionListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
    }

    protected void fireActionPerformed(ActionEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        ActionEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ActionListener.class) continue;
            if (e == null) {
                e = new ActionEvent(this, 1001, "", event.getWhen(), event.getModifiers());
            }
            ((ActionListener)listeners[i + 1]).actionPerformed(e);
        }
    }
}

