/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.renderer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedHashMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.autoplot.PlotStylePanel;
import org.autoplot.dom.PlotElement;
import org.autoplot.dom.PlotElementStyle;
import org.das2.components.propertyeditor.ColorEditor;
import org.das2.graph.Renderer;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;

public class OrbitStylePanel
extends JPanel
implements PlotStylePanel.StylePanel {
    Renderer renderer;
    BindingGroup elementBindingContext;
    private String control = "";
    public static final String PROP_CONTROL = "control";
    private ColorEditor colorEditor;
    private JPanel colorPanel;
    private JTextField fontSizeTF;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel6;
    private JTextField thickTextField;
    private JTextField tickLengthTextField;
    private JComboBox<String> tickSpacingComboBox;

    public OrbitStylePanel() {
        this.initComponents();
        this.colorEditor.setValue(Color.BLACK);
        this.colorPanel.add(this.colorEditor.getSmallEditor());
        this.colorEditor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                OrbitStylePanel.this.update();
            }
        });
        this.validate();
    }

    public String getControl() {
        return this.control;
    }

    public void setControl(String control) {
        String oldControl = this.control;
        this.control = control;
        this.renderer.setControl(control);
        this.updateGUI(this.renderer);
        this.firePropertyChange(PROP_CONTROL, oldControl, control);
    }

    private void update() {
        String c;
        String oldValue = this.control;
        LinkedHashMap<String, String> controls = new LinkedHashMap<String, String>();
        controls.put("fontSize", this.fontSizeTF.getText());
        controls.put("color", Renderer.encodeColorControl((Color)this.colorEditor.getValue()));
        controls.put("lineThick", this.thickTextField.getText());
        controls.put("tickLength", this.tickLengthTextField.getText());
        controls.put("tickSpacing", this.tickSpacingComboBox.getSelectedItem().toString());
        this.control = c = Renderer.formatControl(controls);
        this.firePropertyChange(PROP_CONTROL, oldValue, c);
    }

    private void updateGUI(Renderer renderer) {
        this.control = renderer.getControl();
        this.fontSizeTF.setText(renderer.getControl("fontSize", this.fontSizeTF.getText()));
        this.colorEditor.setValue(renderer.getColorControl("color", (Color)this.colorEditor.getValue()));
        this.thickTextField.setText(renderer.getControl("lineThick", this.thickTextField.getText()));
        this.tickLengthTextField.setText(renderer.getControl("tickLength", this.tickLengthTextField.getText()));
        this.tickSpacingComboBox.setSelectedItem(renderer.getControl("tickSpacing", this.tickSpacingComboBox.getSelectedItem().toString()));
    }

    @Override
    public void doElementBindings(PlotElement element) {
        this.renderer = element.getController().getRenderer();
        this.updateGUI(this.renderer);
        BindingGroup bc = new BindingGroup();
        PlotElementStyle style = element.getStyle();
        bc.addBinding((Binding)Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)style, (Property)BeanProperty.create((String)"color"), (Object)this.colorEditor, (Property)BeanProperty.create((String)"value")));
        bc.addBinding((Binding)Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)element, (Property)BeanProperty.create((String)"renderControl"), (Object)this, (Property)BeanProperty.create((String)PROP_CONTROL)));
        if (this.elementBindingContext != null) {
            this.releaseElementBindings();
        }
        bc.bind();
        this.repaint();
        this.elementBindingContext = bc;
    }

    @Override
    public void releaseElementBindings() {
        if (this.elementBindingContext != null) {
            this.elementBindingContext.unbind();
            this.elementBindingContext = null;
        }
    }

    private void initComponents() {
        this.colorEditor = new ColorEditor();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.colorPanel = new JPanel();
        this.fontSizeTF = new JTextField();
        this.jLabel6 = new JLabel();
        this.thickTextField = new JTextField();
        this.jLabel3 = new JLabel();
        this.tickLengthTextField = new JTextField();
        this.jLabel4 = new JLabel();
        this.tickSpacingComboBox = new JComboBox();
        this.setBorder(BorderFactory.createTitledBorder("Orbit Plot"));
        this.jLabel1.setText("Font Size:");
        this.jLabel2.setText("Color:");
        this.colorPanel.setLayout(new BorderLayout());
        this.fontSizeTF.setToolTipText("Font size, relative to canvas font size.  For example \"0.5em\" is half of the font size. \"7pt\" is 7 points.");
        this.fontSizeTF.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                OrbitStylePanel.this.focusLost(evt);
            }
        });
        this.fontSizeTF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrbitStylePanel.this.fontSizeTFActionPerformed(evt);
            }
        });
        this.jLabel6.setText("Thick:");
        this.jLabel6.setToolTipText("Line thickness");
        this.thickTextField.setToolTipText("Line thickness in pixels/points");
        this.thickTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                OrbitStylePanel.this.thickTextFieldFocusLost(evt);
            }
        });
        this.thickTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrbitStylePanel.this.thickTextFieldActionPerformed(evt);
            }
        });
        this.jLabel3.setText("Tick Length:");
        this.tickLengthTextField.setToolTipText("Tick Length relative to the font size, so .66em is 2/3 of the font size.");
        this.tickLengthTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                OrbitStylePanel.this.tickLengthTextFieldFocusLost(evt);
            }
        });
        this.tickLengthTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrbitStylePanel.this.tickLengthTextFieldActionPerformed(evt);
            }
        });
        this.jLabel4.setText("Ticks Spacing:");
        this.jLabel4.setToolTipText("override the default spacing, to specific cadence");
        this.tickSpacingComboBox.setEditable(true);
        this.tickSpacingComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"1hr", "2hr", "12hr", "1day", "2day", "10day"}));
        this.tickSpacingComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                OrbitStylePanel.this.tickSpacingComboBoxItemStateChanged(evt);
            }
        });
        this.tickSpacingComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrbitStylePanel.this.tickSpacingComboBoxActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.colorPanel, -2, 100, -2).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addGap(134, 134, 134))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addGap(18, 18, 18).addComponent(this.fontSizeTF, -2, 67, -2)).addComponent(this.jLabel6, GroupLayout.Alignment.LEADING)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addGap(5, 5, 5).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.thickTextField).addComponent(this.tickLengthTextField, -2, 67, -2))).addGroup(layout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tickSpacingComboBox, -2, -1, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2)).addComponent(this.colorPanel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fontSizeTF, -2, -1, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.thickTextField, -2, -1, -2).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.tickLengthTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tickSpacingComboBox, -2, -1, -2).addComponent(this.jLabel4)).addContainerGap(26, Short.MAX_VALUE)));
    }

    private void fontSizeTFActionPerformed(ActionEvent evt) {
        this.update();
    }

    private void focusLost(FocusEvent evt) {
        this.update();
    }

    private void thickTextFieldActionPerformed(ActionEvent evt) {
        this.update();
    }

    private void thickTextFieldFocusLost(FocusEvent evt) {
        this.update();
    }

    private void tickLengthTextFieldActionPerformed(ActionEvent evt) {
        this.update();
    }

    private void tickLengthTextFieldFocusLost(FocusEvent evt) {
        this.update();
    }

    private void tickSpacingComboBoxActionPerformed(ActionEvent evt) {
    }

    private void tickSpacingComboBoxItemStateChanged(ItemEvent evt) {
        if (evt.getStateChange() == 1) {
            this.update();
        }
    }
}

