/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.renderer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedHashMap;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.autoplot.PlotStylePanel;
import org.autoplot.dom.PlotElement;
import org.das2.components.propertyeditor.ColorEditor;
import org.das2.graph.Renderer;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;

public class EventsStylePanel
extends JPanel
implements PlotStylePanel.StylePanel {
    private JCheckBox colorCB;
    private JPanel colorPanel;
    private JTextField fontSizeTF;
    private JCheckBox ganttModeCB;
    private JLabel jLabel1;
    private JCheckBox orbitModeCB;
    private JCheckBox showLabelsCB;
    BindingGroup elementBindingContext;
    Renderer renderer;
    ColorEditor colorEditor1;
    private String control = "";
    public static final String PROP_CONTROL = "control";

    public EventsStylePanel() {
        this.initComponents();
        this.colorEditor1 = new ColorEditor();
        this.colorEditor1.setValue(Color.BLACK);
        this.colorPanel.add(this.colorEditor1.getSmallEditor());
        this.colorEditor1.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                EventsStylePanel.this.update();
            }
        });
    }

    private void initComponents() {
        this.showLabelsCB = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.fontSizeTF = new JTextField();
        this.orbitModeCB = new JCheckBox();
        this.ganttModeCB = new JCheckBox();
        this.colorPanel = new JPanel();
        this.colorCB = new JCheckBox();
        this.setBorder(BorderFactory.createTitledBorder("Events Bar"));
        this.showLabelsCB.setText("Show Labels");
        this.showLabelsCB.setToolTipText("Show event labels along with bar.");
        this.showLabelsCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EventsStylePanel.this.showLabelsCBActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Font Size:");
        this.fontSizeTF.setText("1em");
        this.fontSizeTF.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                EventsStylePanel.this.fontSizeTFFocusLost(evt);
            }
        });
        this.fontSizeTF.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EventsStylePanel.this.fontSizeTFActionPerformed(evt);
            }
        });
        this.orbitModeCB.setText("Orbit Mode");
        this.orbitModeCB.setToolTipText("Show the events in special orbit mode along the bottom with labels.");
        this.orbitModeCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EventsStylePanel.this.orbitModeCBActionPerformed(evt);
            }
        });
        this.ganttModeCB.setText("Gantt Mode");
        this.ganttModeCB.setToolTipText("Show events in a Gantt Chart, with instances enumerated along the vertical axis.\n");
        this.ganttModeCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EventsStylePanel.this.ganttModeCBActionPerformed(evt);
            }
        });
        this.colorPanel.setLayout(new BorderLayout());
        this.colorCB.setText("Color:");
        this.colorCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EventsStylePanel.this.colorCBActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.showLabelsCB).addComponent(this.orbitModeCB).addComponent(this.ganttModeCB).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.colorCB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.colorPanel, -2, 89, -2)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fontSizeTF, -2, 83, -2)))).addContainerGap(215, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.showLabelsCB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.fontSizeTF, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.orbitModeCB).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ganttModeCB).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(11, 11, 11).addComponent(this.colorCB)).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.colorPanel, -2, 37, -2))).addContainerGap(106, Short.MAX_VALUE)));
    }

    private void showLabelsCBActionPerformed(ActionEvent evt) {
        this.update();
    }

    private void fontSizeTFActionPerformed(ActionEvent evt) {
        this.update();
    }

    private void fontSizeTFFocusLost(FocusEvent evt) {
        this.update();
    }

    private void orbitModeCBActionPerformed(ActionEvent evt) {
        if (this.orbitModeCB.isSelected()) {
            this.ganttModeCB.setSelected(false);
        }
        this.update();
    }

    private void ganttModeCBActionPerformed(ActionEvent evt) {
        if (this.ganttModeCB.isSelected()) {
            this.orbitModeCB.setSelected(false);
        }
        this.update();
    }

    private void colorCBActionPerformed(ActionEvent evt) {
        this.update();
    }

    public String getControl() {
        return this.control;
    }

    public void setControl(String control) {
        String oldControl = this.control;
        this.control = control;
        this.renderer.setControl(control);
        this.updateGUI(this.renderer);
        this.firePropertyChange(PROP_CONTROL, oldControl, control);
    }

    private void update() {
        String c;
        String oldValue = this.control;
        LinkedHashMap<String, String> controls = new LinkedHashMap<String, String>();
        controls.put("fontSize", this.fontSizeTF.getText());
        controls.put("showLabels", Renderer.encodeBooleanControl(this.showLabelsCB.isSelected()));
        controls.put("orbitMode", Renderer.encodeBooleanControl(this.orbitModeCB.isSelected()));
        controls.put("ganttMode", Renderer.encodeBooleanControl(this.ganttModeCB.isSelected()));
        if (this.colorCB.isSelected()) {
            controls.put("color", Renderer.encodeColorControl((Color)this.colorEditor1.getValue()));
        }
        this.control = c = Renderer.formatControl(controls);
        this.firePropertyChange(PROP_CONTROL, oldValue, c);
    }

    private void updateGUI(Renderer renderer) {
        this.control = renderer.getControl();
        this.fontSizeTF.setText(renderer.getControl("fontSize", "1em"));
        this.showLabelsCB.setSelected(renderer.getBooleanControl("showLabels", false));
        this.orbitModeCB.setSelected(renderer.getBooleanControl("orbitMode", false));
        this.ganttModeCB.setSelected(renderer.getBooleanControl("ganttMode", false));
        if (renderer.hasControl("color")) {
            this.colorCB.setSelected(true);
            this.colorEditor1.setValue(renderer.getColorControl("color", Color.BLACK));
        }
    }

    @Override
    public void doElementBindings(PlotElement element) {
        this.renderer = element.getController().getRenderer();
        this.updateGUI(this.renderer);
        BindingGroup bc = new BindingGroup();
        bc.addBinding((Binding)Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)element, (Property)BeanProperty.create((String)"renderControl"), (Object)this, (Property)BeanProperty.create((String)PROP_CONTROL)));
        if (this.elementBindingContext != null) {
            this.releaseElementBindings();
        }
        bc.bind();
        this.repaint();
        this.elementBindingContext = bc;
    }

    @Override
    public void releaseElementBindings() {
        if (this.elementBindingContext != null) {
            this.elementBindingContext.unbind();
            this.elementBindingContext = null;
        }
    }
}

