/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.renderer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedHashMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.autoplot.PlotStylePanel;
import org.autoplot.dom.PlotElement;
import org.das2.components.propertyeditor.ColorEditor;
import org.das2.graph.Renderer;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;

public class ContourStylePanel
extends JPanel
implements PlotStylePanel.StylePanel {
    BindingGroup elementBindingContext;
    Renderer renderer;
    private String control = "";
    public static final String PROP_CONTROL = "control";
    private ColorEditor colorEditor1;
    private JPanel colorPanel;
    private JCheckBox drawLabelsCheckBox;
    private JComboBox<String> fontSizeComboBox;
    private JComboBox<String> formatComboBox;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JPanel jPanel1;
    private JComboBox<String> labelCadenceComboBox;
    private JComboBox<String> labelOrientationComboBox;
    private JTextField levelsTextField;
    private JSpinner lineThickSpinner;

    public ContourStylePanel() {
        this.initComponents();
        this.colorEditor1.setValue(Color.BLACK);
        this.colorPanel.add(this.colorEditor1.getSmallEditor());
        this.colorEditor1.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                ContourStylePanel.this.update();
            }
        });
        this.formatComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"", "%.1f", ".2f", "%d", "%.1e"}));
        this.labelOrientationComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"", "N"}));
    }

    public String getControl() {
        return this.control;
    }

    public void setControl(String control) {
        String oldControl = this.control;
        this.control = control;
        this.renderer.setControl(control);
        this.updateGUI(this.renderer);
        this.firePropertyChange(PROP_CONTROL, oldControl, control);
    }

    private void update() {
        String c;
        String oldValue = this.control;
        LinkedHashMap<String, String> controls = new LinkedHashMap<String, String>();
        controls.put("levels", this.levelsTextField.getText());
        controls.put("labels", Renderer.encodeBooleanControl(this.drawLabelsCheckBox.isSelected()));
        controls.put("lineThick", String.format("%.1f", this.lineThickSpinner.getValue()));
        controls.put("labelCadence", this.labelCadenceComboBox.getSelectedItem().toString());
        controls.put("color", Renderer.encodeColorControl((Color)this.colorEditor1.getValue()));
        controls.put("format", this.formatComboBox.getSelectedItem().toString());
        controls.put("fontSize", this.fontSizeComboBox.getSelectedItem().toString());
        controls.put("labelOrient", this.labelOrientationComboBox.getSelectedItem().toString());
        this.control = c = Renderer.formatControl(controls);
        this.firePropertyChange(PROP_CONTROL, oldValue, c);
    }

    private void updateGUI(Renderer renderer) {
        this.control = renderer.getControl();
        this.levelsTextField.setText(renderer.getControl("levels", "0."));
        this.drawLabelsCheckBox.setSelected(renderer.getBooleanControl("labels", false));
        this.lineThickSpinner.setValue(renderer.getDoubleControl("lineThick", 1.0));
        this.labelCadenceComboBox.setSelectedItem(renderer.getControl("labelCadence", "100px"));
        this.colorEditor1.setValue(renderer.getColorControl("color", Color.BLACK));
        this.formatComboBox.setSelectedItem(renderer.getControl("format", ""));
        this.fontSizeComboBox.setSelectedItem(renderer.getControl("fontSize", ""));
        this.labelOrientationComboBox.setSelectedItem(renderer.getControl("labelOrient", ""));
    }

    @Override
    public void doElementBindings(PlotElement element) {
        this.renderer = element.getController().getRenderer();
        this.updateGUI(this.renderer);
        BindingGroup bc = new BindingGroup();
        bc.addBinding((Binding)Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)element, (Property)BeanProperty.create((String)"renderControl"), (Object)this, (Property)BeanProperty.create((String)PROP_CONTROL)));
        if (this.elementBindingContext != null) {
            this.releaseElementBindings();
        }
        bc.bind();
        this.repaint();
        this.elementBindingContext = bc;
    }

    @Override
    public void releaseElementBindings() {
        if (this.elementBindingContext != null) {
            this.elementBindingContext.unbind();
            this.elementBindingContext = null;
        }
    }

    private void initComponents() {
        this.colorEditor1 = new ColorEditor();
        this.jPanel1 = new JPanel();
        this.drawLabelsCheckBox = new JCheckBox();
        this.jLabel6 = new JLabel();
        this.jLabel2 = new JLabel();
        this.lineThickSpinner = new JSpinner();
        this.levelsTextField = new JTextField();
        this.jLabel3 = new JLabel();
        this.colorPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel4 = new JLabel();
        this.formatComboBox = new JComboBox();
        this.jLabel5 = new JLabel();
        this.fontSizeComboBox = new JComboBox();
        this.jLabel7 = new JLabel();
        this.labelCadenceComboBox = new JComboBox();
        this.jLabel8 = new JLabel();
        this.labelOrientationComboBox = new JComboBox();
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Contour"));
        this.drawLabelsCheckBox.setText("Draw Labels");
        this.drawLabelsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ContourStylePanel.this.drawLabelsCheckBoxActionPerformed(evt);
            }
        });
        this.jLabel6.setText("Color:");
        this.jLabel6.setToolTipText("color of the line and plot symbols");
        this.jLabel2.setText("Thick:");
        this.lineThickSpinner.setModel(new SpinnerNumberModel(1.0, 0.0, 10.0, 0.1));
        this.lineThickSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ContourStylePanel.this.lineThickSpinnerStateChanged(evt);
            }
        });
        this.levelsTextField.setText("0");
        this.levelsTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                ContourStylePanel.this.levelsTextFieldFocusLost(evt);
            }
        });
        this.levelsTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ContourStylePanel.this.levelsTextFieldActionPerformed(evt);
            }
        });
        this.jLabel3.setFont(this.jLabel3.getFont().deriveFont(this.jLabel3.getFont().getStyle() | 2, this.jLabel3.getFont().getSize() - 2));
        this.jLabel3.setText("a comma-separated list of trace locations:");
        this.colorPanel.setLayout(new BorderLayout());
        this.jLabel1.setText("Levels:");
        this.jLabel4.setText("Format:");
        this.formatComboBox.setEditable(true);
        this.formatComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"%d", "%.1f", "%.2f", "%e"}));
        this.formatComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ContourStylePanel.this.formatComboBoxItemStateChanged(evt);
            }
        });
        this.jLabel5.setText("Font Size:");
        this.fontSizeComboBox.setEditable(true);
        this.fontSizeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"8pt", "12pt", ".8em", "1.2em"}));
        this.fontSizeComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ContourStylePanel.this.fontSizeComboBoxItemStateChanged(evt);
            }
        });
        this.jLabel7.setText("Label Cadence:");
        this.labelCadenceComboBox.setEditable(true);
        this.labelCadenceComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"100px", "15em"}));
        this.labelCadenceComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ContourStylePanel.this.labelCadenceComboBoxItemStateChanged(evt);
            }
        });
        this.jLabel8.setText("Label Orientation:");
        this.labelOrientationComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"\"\"", "up"}));
        this.labelOrientationComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ContourStylePanel.this.labelOrientationComboBoxItemStateChanged(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(12, 12, 12).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.jLabel5)).addGap(47, 47, 47).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.formatComboBox, -2, -1, -2).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.fontSizeComboBox, 0, -1, Short.MAX_VALUE).addContainerGap(35, Short.MAX_VALUE)))).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelOrientationComboBox, 0, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, jPanel1Layout.createSequentialGroup().addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.labelCadenceComboBox, -2, 132, -2))))).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lineThickSpinner, -2, 61, -2)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.colorPanel, -2, 132, -2)).addComponent(this.jLabel1, -2, 244, -2).addComponent(this.drawLabelsCheckBox)).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.levelsTextField).addComponent(this.jLabel3, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE)).addContainerGap()))));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.levelsTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.lineThickSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel6, GroupLayout.Alignment.TRAILING, -2, 29, -2).addComponent(this.colorPanel, GroupLayout.Alignment.TRAILING, -2, 29, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.drawLabelsCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.formatComboBox, -2, -1, -2)).addGap(4, 4, 4).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.fontSizeComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel7).addComponent(this.labelCadenceComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel8).addComponent(this.labelOrientationComboBox, -2, -1, -2)).addContainerGap(37, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
    }

    private void drawLabelsCheckBoxActionPerformed(ActionEvent evt) {
        this.update();
    }

    private void lineThickSpinnerStateChanged(ChangeEvent evt) {
        this.update();
    }

    private void levelsTextFieldActionPerformed(ActionEvent evt) {
        this.update();
    }

    private void levelsTextFieldFocusLost(FocusEvent evt) {
        this.update();
    }

    private void formatComboBoxItemStateChanged(ItemEvent evt) {
        this.update();
    }

    private void fontSizeComboBoxItemStateChanged(ItemEvent evt) {
        this.update();
    }

    private void labelCadenceComboBoxItemStateChanged(ItemEvent evt) {
        this.update();
    }

    private void labelOrientationComboBoxItemStateChanged(ItemEvent evt) {
        this.update();
    }
}

