/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.renderer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedHashMap;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.autoplot.PlotStylePanel;
import org.autoplot.dom.PlotElement;
import org.das2.components.propertyeditor.ColorEditor;
import org.das2.graph.Renderer;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;

public class BoundsStylePanel
extends JPanel
implements PlotStylePanel.StylePanel {
    Renderer renderer;
    BindingGroup elementBindingContext;
    private String control = "";
    public static final String PROP_CONTROL = "control";
    private ColorEditor colorEditor1;
    private JPanel colorPanel;
    private JLabel jLabel2;

    public BoundsStylePanel() {
        this.initComponents();
        this.colorEditor1.setValue(Color.BLACK);
        this.colorPanel.add(this.colorEditor1.getSmallEditor());
        this.colorEditor1.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                BoundsStylePanel.this.update();
            }
        });
        this.validate();
    }

    public String getControl() {
        return this.control;
    }

    public void setControl(String control) {
        String oldControl = this.control;
        this.control = control;
        this.renderer.setControl(control);
        this.updateGUI(this.renderer);
        this.firePropertyChange(PROP_CONTROL, oldControl, control);
    }

    private void update() {
        String c;
        String oldValue = this.control;
        LinkedHashMap<String, String> controls = new LinkedHashMap<String, String>();
        controls.put("color", Renderer.encodeColorControl((Color)this.colorEditor1.getValue()));
        this.control = c = Renderer.formatControl(controls);
        this.firePropertyChange(PROP_CONTROL, oldValue, c);
    }

    private void updateGUI(Renderer renderer) {
        this.control = renderer.getControl();
        this.colorEditor1.setValue(renderer.getColorControl("color", (Color)this.colorEditor1.getValue()));
    }

    @Override
    public void doElementBindings(PlotElement element) {
        this.renderer = element.getController().getRenderer();
        this.updateGUI(this.renderer);
        BindingGroup bc = new BindingGroup();
        bc.addBinding((Binding)Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)element, (Property)BeanProperty.create((String)"renderControl"), (Object)this, (Property)BeanProperty.create((String)PROP_CONTROL)));
        if (this.elementBindingContext != null) {
            this.releaseElementBindings();
        }
        bc.bind();
        this.repaint();
        this.elementBindingContext = bc;
    }

    @Override
    public void releaseElementBindings() {
        if (this.elementBindingContext != null) {
            this.elementBindingContext.unbind();
            this.elementBindingContext = null;
        }
    }

    private void initComponents() {
        this.colorEditor1 = new ColorEditor();
        this.jLabel2 = new JLabel();
        this.colorPanel = new JPanel();
        this.setBorder(BorderFactory.createTitledBorder("Bounds"));
        this.jLabel2.setText("Color:");
        this.colorPanel.setLayout(new BorderLayout());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.colorPanel, -2, 100, -2).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addGap(134, 134, 134))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2)).addComponent(this.colorPanel, -1, -1, Short.MAX_VALUE)).addContainerGap(127, Short.MAX_VALUE)));
    }
}

