/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.pngwalk;

import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.autoplot.datasource.DataSetURI;
import org.das2.datum.DatumRange;
import org.das2.datum.TimeParser;
import org.das2.fsm.FileStorageModel;
import org.das2.util.LoggerManager;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.filesystem.FileSystemUtil;
import org.das2.util.monitor.ProgressMonitor;

public class WalkUtil {
    private static final Logger logger = LoggerManager.getLogger("autoplot.pngwalk");

    private static int firstIndexOf(String str, List<String> targets) {
        int i0 = Integer.MAX_VALUE;
        for (String t : targets) {
            int i = str.indexOf(t);
            if (i <= -1 || i >= i0) continue;
            i0 = i;
        }
        return i0 == Integer.MAX_VALUE ? -1 : i0;
    }

    protected static int splitIndex(String surl) {
        int i = WalkUtil.firstIndexOf(surl, Arrays.asList("%Y", "$Y", "%y", "$y", "$(", "%{", "*"));
        i = i != -1 ? surl.lastIndexOf(47, i) : surl.lastIndexOf(47);
        return i;
    }

    public static boolean fileExists(String surl) throws FileSystem.FileSystemOfflineException, URISyntaxException {
        FileSystem fs;
        int i = WalkUtil.splitIndex(surl);
        try {
            fs = FileSystem.create(DataSetURI.getResourceURI(surl.substring(0, i + 1)));
        }
        catch (UnknownHostException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            return false;
        }
        catch (FileNotFoundException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            return false;
        }
        return fs.getFileObject(surl.substring(i + 1)).exists();
    }

    private static String makeSafe(String s) {
        try {
            String result = URLEncoder.encode(s, "UTF-8");
            result = result.replaceAll("\\%2F", "/");
            result = result.replaceAll("\\%7E", "~");
            return result;
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static List<URI> getFilesFor(String surl, DatumRange timeRange, List<DatumRange> timeRanges, boolean download, ProgressMonitor mon) throws IOException, ParseException, URISyntaxException {
        Object[] ss;
        DatumRange dr = timeRange;
        int i = surl.indexOf(63);
        String sansArgs = i == -1 ? surl : surl.substring(0, i);
        i = WalkUtil.splitIndex(sansArgs);
        URI surls = DataSetURI.getResourceURI(sansArgs.substring(0, i + 1));
        FileSystem fs = FileSystem.create(surls);
        String spec = sansArgs.substring(i + 1);
        spec = spec.replaceAll("\\*", ".*");
        spec = spec.replaceAll("\\?", ".");
        FileStorageModel fsm = null;
        if (TimeParser.isSpec(spec)) {
            fsm = FileStorageModel.create(fs, spec);
        }
        if (fsm != null) {
            ss = fsm.getNamesFor(dr);
        } else {
            ss = fs.listDirectoryDeep("/", spec);
            Arrays.sort(ss);
        }
        ArrayList<URI> result = new ArrayList<URI>(ss.length);
        timeRanges.clear();
        for (i = 0; i < ss.length; ++i) {
            DatumRange dr2 = null;
            if (fsm != null) {
                dr2 = fsm.getRangeFor((String)ss[i]);
            }
            if (dr != null && dr2 != null && !dr.contains(dr2)) continue;
            if (((String)ss[i]).startsWith("/")) {
                result.add(fs.getRootURI().resolve("./" + FileSystemUtil.uriEncode(((String)ss[i]).substring(1))));
            } else {
                result.add(fs.getRootURI().resolve("./" + FileSystemUtil.uriEncode((String)ss[i])));
            }
            timeRanges.add(dr2);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String readFile(File pf) throws IOException {
        StringBuilder result = new StringBuilder();
        try (BufferedReader read = null;){
            read = new BufferedReader(new FileReader(pf));
            String s = read.readLine();
            while (s != null) {
                result.append(s);
                result.append("\n");
                s = read.readLine();
            }
        }
        return result.toString();
    }

    static void writeFile(File pf, String s) throws IOException {
        try (FileWriter write = null;){
            write = new FileWriter(pf);
            write.write(s);
        }
    }

    public static BufferedImage resizeImage(BufferedImage originalImage, int width, int height) {
        BufferedImage resizedImage = new BufferedImage(width, height, originalImage.getType());
        Graphics2D g = resizedImage.createGraphics();
        g.fillRect(0, 0, width, height);
        if (originalImage.getWidth() > 65) {
            g.setComposite(AlphaComposite.Src);
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        g.drawImage(originalImage, 0, 0, width, height, null);
        g.dispose();
        return resizedImage;
    }
}

