/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.pngwalk;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.dom.DebugPropertyChangeSupport;
import org.autoplot.pngwalk.QualityControlRecord;
import org.autoplot.pngwalk.QualityControlSequence;
import org.autoplot.pngwalk.WalkImage;
import org.autoplot.pngwalk.WalkUtil;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.Units;
import org.das2.util.LoggerManager;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.filesystem.FileSystemUtil;

public class WalkImageSequence
implements PropertyChangeListener {
    private static final Logger logger = LoggerManager.getLogger("autoplot.pngwalk");
    private List<WalkImage> existingImages;
    private List<WalkImage> displayImages = new ArrayList<WalkImage>();
    private boolean showMissing = false;
    private boolean useSubRange = false;
    private int index;
    private DatumRange timeSpan = null;
    private List<DatumRange> datumRanges = null;
    private List<DatumRange> possibleRanges = null;
    private List<DatumRange> subRange = null;
    private final String template;
    private final PropertyChangeSupport pcs = new DebugPropertyChangeSupport(this);
    public static final String PROP_INDEX = "index";
    public static final String PROP_SELECTED_INDECES = "selectedIndeces";
    public static final String PROP_IMAGE_LOADED = "imageLoaded";
    public static final String PROP_THUMB_LOADED = "thumbLoaded";
    public static final String PROP_USESUBRANGE = "useSubRange";
    public static final String PROP_SEQUENCE_CHANGED = "sequenceChanged";
    public static final String PROP_BADGE_CHANGE = "badgeChange";
    private URI qcFolder = null;
    private QualityControlSequence qualitySeq;
    private String qcFilter = "";
    private boolean haveThumbs400 = true;
    private boolean limitWarning = false;
    private DatumRange timerange = null;
    public static final String PROP_TIMERANGE = "timerange";
    List<Integer> sel = Collections.emptyList();
    protected String status = "idle";
    public static final String PROP_STATUS = "status";

    public WalkImageSequence(String template) {
        this.template = template;
    }

    public DatumRange getTimerange() {
        return this.timerange;
    }

    public void setTimerange(DatumRange timerange) {
        DatumRange oldTimerange = this.timerange;
        this.timerange = timerange;
        this.pcs.firePropertyChange(PROP_TIMERANGE, oldTimerange, timerange);
    }

    public void initialLoad() throws IOException {
        List<URI> uris;
        this.datumRanges = new ArrayList<DatumRange>();
        this.subRange = new ArrayList<DatumRange>();
        if (this.template == null) {
            throw new IllegalStateException("template was null");
        }
        try {
            this.setStatus("busy: listing " + this.template);
            uris = WalkUtil.getFilesFor(this.template, this.timerange, this.datumRanges, false, null);
            if (uris.size() > 0) {
                this.setStatus("Done listing " + this.template);
            } else {
                this.setStatus("warning: no files found in " + this.template);
            }
        }
        catch (IOException | IllegalArgumentException | URISyntaxException | ParseException ex) {
            ex.printStackTrace();
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            this.setStatus("error: Error listing " + this.template + ", " + ex.getMessage());
            throw new IOException("Error listing " + this.template + ", " + ex.getMessage());
        }
        finally {
            this.setStatus(" ");
        }
        if (this.template.equals("file:///")) {
            this.haveThumbs400 = false;
        } else {
            int splitIndex = WalkUtil.splitIndex(this.template);
            URI fsRoot = DataSetURI.getResourceURI(this.template.substring(0, splitIndex));
            try {
                FileSystem fs = FileSystem.create(fsRoot);
                if (fs.getFileObject("/thumbs400/").exists()) {
                    String[] result = fs.listDirectory("/thumbs400/");
                    if (result.length < 2) {
                        this.haveThumbs400 = false;
                    }
                } else {
                    this.haveThumbs400 = false;
                }
            }
            catch (IOException ex) {
                this.haveThumbs400 = false;
            }
        }
        this.existingImages = new ArrayList<WalkImage>();
        for (int i = 0; i < uris.size(); ++i) {
            String captionString;
            this.existingImages.add(new WalkImage(uris.get(i), this.haveThumbs400));
            int splitIndex = -1;
            if (this.datumRanges.get(i) != null) {
                captionString = this.datumRanges.get(i).toString();
            } else {
                captionString = FileSystemUtil.uriDecode(uris.get(i).toString());
                if (splitIndex == -1) {
                    splitIndex = WalkUtil.splitIndex(this.template);
                }
                if (this.template.startsWith("file:///") && captionString.length() > 6 && captionString.charAt(6) != '/') {
                    splitIndex -= 2;
                }
                captionString = captionString.substring(splitIndex + 1);
            }
            this.existingImages.get(i).setCaption(captionString);
            this.existingImages.get(i).setDatumRange(this.datumRanges.get(i));
        }
        for (DatumRange dr : this.datumRanges) {
            if (this.timeSpan == null) {
                this.timeSpan = dr;
                continue;
            }
            this.timeSpan = DatumRangeUtil.union(this.timeSpan, dr);
        }
        if (this.timeSpan != null) {
            if (this.timeSpan.width().divide(this.datumRanges.get(0).width()).doubleValue(Units.dimensionless) > 100000.0) {
                logger.warning("too many spans to indicate gaps.");
                this.possibleRanges = this.datumRanges;
            } else {
                this.possibleRanges = DatumRangeUtil.generateList(this.timeSpan, this.datumRanges.get(0));
            }
        }
        for (WalkImage i : this.existingImages) {
            i.addPropertyChangeListener(this);
        }
        this.subRange = this.possibleRanges;
        this.rebuildSequence();
    }

    protected int indexOfSubrange(DatumRange dr) {
        int idx = -1;
        for (int i = this.datumRanges.size() - 1; i >= 0; --i) {
            if (this.datumRanges.get(i) == null) {
                logger.info("ranges are not available");
                return -1;
            }
            if (dr.contains(this.datumRanges.get(i).min())) {
                idx = i;
                break;
            }
            if (!this.datumRanges.get(i).contains(dr)) continue;
            idx = i;
            break;
        }
        return idx;
    }

    void gotoSubrange(DatumRange ds) {
        int i;
        int idx = -1;
        if (this.datumRanges.isEmpty() || this.datumRanges.get(0) == null) {
            logger.info("ranges are not available");
            return;
        }
        for (i = 0; i < this.size(); ++i) {
            if (!ds.intersects(this.imageAt(i).getDatumRange())) continue;
            idx = i;
            break;
        }
        if (idx == -1) {
            for (i = this.datumRanges.size() - 1; i >= 0; --i) {
                if (ds.contains(this.datumRanges.get(i).min())) {
                    idx = i;
                    break;
                }
                if (this.datumRanges.get(i).contains(ds)) {
                    idx = i;
                    break;
                }
                if (!this.datumRanges.get(i).min().ge(ds.min())) continue;
                idx = i;
            }
        }
        if (idx == -1) {
            this.setIndex(this.datumRanges.size() - 1);
        } else {
            this.setIndex(idx);
        }
    }

    private synchronized void rebuildSequence() {
        WalkImage currentImage = null;
        if (this.displayImages.size() > 0) {
            currentImage = this.currentImage();
        }
        if (this.timeSpan != null || this.qcFilter.length() > 0) {
            List<DatumRange> displayRange = this.isUseSubRange() && this.subRange.size() > 0 ? this.subRange : this.possibleRanges;
            this.limitWarning = this.possibleRanges != null && this.possibleRanges.size() == 20000;
            ArrayList<QualityControlRecord.Status> statuses = null;
            if (this.qualitySeq != null) {
                statuses = new ArrayList<QualityControlRecord.Status>(this.datumRanges.size());
                for (int i = 0; i < this.datumRanges.size(); ++i) {
                    statuses.add(i, this.qualitySeq.getQualityControlRecordNoSubRange(i).getStatus());
                }
            }
            HashSet<QualityControlRecord.Status> allowedStatuses = new HashSet<QualityControlRecord.Status>();
            if (this.qcFilter.length() > 0) {
                block7: for (int i = 0; i < this.qcFilter.length(); ++i) {
                    char ch = this.qcFilter.charAt(i);
                    switch (ch) {
                        case 'o': {
                            allowedStatuses.add(QualityControlRecord.Status.OK);
                            continue block7;
                        }
                        case 'p': {
                            allowedStatuses.add(QualityControlRecord.Status.PROBLEM);
                            continue block7;
                        }
                        case 'i': {
                            allowedStatuses.add(QualityControlRecord.Status.IGNORE);
                            continue block7;
                        }
                        case 'u': {
                            allowedStatuses.add(QualityControlRecord.Status.UNKNOWN);
                            continue block7;
                        }
                    }
                }
            }
            if (displayRange != null) {
                this.displayImages.clear();
                for (DatumRange dr : displayRange) {
                    int ind = this.datumRanges.indexOf(dr);
                    if (ind > -1) {
                        if (this.qualitySeq != null && this.qcFilter.length() > 0) {
                            assert (statuses != null);
                            if (!allowedStatuses.contains(statuses.get(ind))) continue;
                        }
                        this.displayImages.add(this.existingImages.get(ind));
                        continue;
                    }
                    if (this.showMissing && this.timeSpan != null) {
                        if (this.qualitySeq != null && this.qcFilter.length() > 0) continue;
                        WalkImage ph = new WalkImage(null, this.haveThumbs400);
                        ph.setCaption(dr.toString());
                        this.displayImages.add(ph);
                        continue;
                    }
                    logger.fine("I don't think we should get here (but we do, harmless).");
                }
            } else {
                this.displayImages.clear();
                for (int ind = 0; ind < this.existingImages.size(); ++ind) {
                    if (this.qualitySeq != null && this.qcFilter.length() > 0) {
                        assert (statuses != null);
                        if (!allowedStatuses.contains(statuses.get(ind))) continue;
                    }
                    this.displayImages.add(this.existingImages.get(ind));
                }
            }
        } else {
            this.displayImages.clear();
            this.displayImages = new ArrayList<WalkImage>(this.existingImages);
        }
        this.index = this.displayImages.contains(currentImage) ? this.displayImages.indexOf(currentImage) : 0;
        this.pcs.firePropertyChange(PROP_SEQUENCE_CHANGED, false, true);
    }

    protected boolean isLimitWarning() {
        return this.limitWarning;
    }

    protected synchronized void initQualitySequence(URI qcFolder) {
        try {
            this.qcFolder = qcFolder;
            this.qualitySeq = new QualityControlSequence(this, qcFolder);
            for (int i = 0; i < this.displayImages.size(); ++i) {
                this.qualitySeq.getQualityControlRecord(i).addPropertyChangeListener(this);
                this.pcs.firePropertyChange(PROP_BADGE_CHANGE, -1, i);
            }
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            this.setStatus("warning: " + ex.toString());
            throw new RuntimeException(ex);
        }
    }

    public WalkImage currentImage() {
        return this.imageAt(this.index);
    }

    public WalkImage getImage(URI image) {
        for (WalkImage i : this.displayImages) {
            if (!i.getUri().equals(image)) continue;
            return i;
        }
        throw new IllegalStateException("didn't find image for " + image);
    }

    public WalkImage imageAt(int n) {
        if (n < 0 || n > this.displayImages.size() - 1) {
            throw new IndexOutOfBoundsException("index must be within 0-" + (this.displayImages.size() - 1) + ": " + n);
        }
        return this.displayImages.get(n);
    }

    public WalkImage imageAtNoSubRange(int n) {
        if (n < 0 || n > this.existingImages.size() - 1) {
            throw new IndexOutOfBoundsException("index must be within 0-" + (this.displayImages.size() - 1) + ": " + n);
        }
        return this.existingImages.get(n);
    }

    public URI getQCFolder() {
        return this.qcFolder;
    }

    public void setQCFolder(URI folder) {
        this.qcFolder = folder;
    }

    public synchronized QualityControlSequence getQualityControlSequence() {
        return this.qualitySeq;
    }

    public boolean isShowMissing() {
        return this.showMissing;
    }

    public void setShowMissing(boolean showMissing) {
        if (showMissing != this.showMissing) {
            this.showMissing = showMissing;
            this.rebuildSequence();
        }
    }

    public boolean isUseSubRange() {
        return this.useSubRange;
    }

    public void setUseSubRange(boolean useSubRange) {
        boolean oldSubRange = this.useSubRange;
        this.useSubRange = useSubRange;
        this.pcs.firePropertyChange(PROP_USESUBRANGE, oldSubRange, useSubRange);
        if (useSubRange != oldSubRange) {
            this.rebuildSequence();
        }
    }

    public void setActiveSubrange(int first, int last) {
        this.subRange = this.possibleRanges.subList(first, last + 1);
        if (this.isUseSubRange()) {
            this.rebuildSequence();
        }
    }

    public void setActiveSubrange(DatumRange range) {
        int first = -1;
        int last = -1;
        for (int i = 0; i < this.possibleRanges.size(); ++i) {
            if (!this.possibleRanges.get(i).intersects(range)) continue;
            if (first == -1) {
                first = i;
            }
            last = i;
        }
        if (first != -1) {
            this.setActiveSubrange(first, last);
        }
    }

    public synchronized void setQCFilter(String s) {
        if (s == null) {
            throw new NullPointerException("qcfilter cannot be null, set to empty string to clear");
        }
        String oldQcFilter = this.qcFilter;
        this.qcFilter = s;
        if (!this.qcFilter.equals(oldQcFilter)) {
            this.rebuildSequence();
        }
    }

    public List<DatumRange> getActiveSubrange() {
        return this.subRange;
    }

    public DatumRange getTimeSpan() {
        return this.timeSpan;
    }

    public List<DatumRange> getAllTimes() {
        return this.possibleRanges;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        if (index == this.index) {
            return;
        }
        if (index < 0) {
            index = 0;
        }
        if (index >= this.displayImages.size()) {
            index = this.displayImages.size() - 1;
        }
        int oldIndex = this.index;
        this.index = index;
        this.pcs.firePropertyChange(PROP_INDEX, oldIndex, this.index);
    }

    public void setSelectedIndeces(List<Integer> sel) {
        List<Integer> old = this.sel;
        this.sel = sel;
        this.pcs.firePropertyChange(PROP_SELECTED_INDECES, old, sel);
    }

    public List<Integer> getSelectedIndeces() {
        return this.sel;
    }

    public void next() {
        if (this.index < this.displayImages.size() - 1) {
            this.setIndex(this.index + 1);
        }
    }

    public void prev() {
        if (this.index > 0) {
            this.setIndex(this.index - 1);
        }
    }

    public void first() {
        this.setIndex(0);
    }

    public void last() {
        this.setIndex(this.displayImages.size() - 1);
    }

    public void skipBy(int n) {
        if (this.index + n > this.displayImages.size() - 1) {
            this.setIndex(this.displayImages.size() - 1);
        } else if (this.index + n < 0) {
            this.setIndex(0);
        } else {
            this.setIndex(this.index + n);
        }
    }

    public int size() {
        return this.displayImages.size();
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    public synchronized void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public String getTemplate() {
        return this.template;
    }

    public String getStatus() {
        return this.status;
    }

    protected void setStatus(String status) {
        String oldStatus = this.status;
        this.status = status;
        this.pcs.firePropertyChange(PROP_STATUS, oldStatus, status);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getNewValue() instanceof WalkImage.Status) {
            if ((WalkImage.Status)((Object)e.getNewValue()) == WalkImage.Status.IMAGE_LOADED || (WalkImage.Status)((Object)e.getNewValue()) == WalkImage.Status.THUMB_LOADED) {
                int i = this.displayImages.indexOf(e.getSource());
                if (i == -1) {
                    if (this.existingImages.indexOf(e.getSource()) == -1) {
                        throw new RuntimeException("Status change from unknown image object");
                    }
                    return;
                }
                this.pcs.firePropertyChange(PROP_THUMB_LOADED, -1, i);
                if ((WalkImage.Status)((Object)e.getNewValue()) == WalkImage.Status.IMAGE_LOADED) {
                    this.pcs.firePropertyChange(PROP_IMAGE_LOADED, -1, i);
                }
            }
        } else if (e.getPropertyName().equals(PROP_STATUS)) {
            URI imageURI = ((QualityControlRecord)e.getSource()).getImageURI();
            WalkImage im = this.getImage(imageURI);
            int i = this.displayImages.indexOf(im);
            this.pcs.firePropertyChange(PROP_BADGE_CHANGE, -1, i);
        }
        int loadingCount = 0;
        int loadedCount = 0;
        int thumbLoadingCount = 0;
        int totalCount = 0;
        for (WalkImage i : this.existingImages) {
            ++totalCount;
            if (i.getStatus() == WalkImage.Status.IMAGE_LOADING) {
                ++loadingCount;
            }
            if (i.getStatus() == WalkImage.Status.IMAGE_LOADED) {
                ++loadedCount;
            }
            if (i.getStatus() != WalkImage.Status.THUMB_LOADING) continue;
            ++thumbLoadingCount;
        }
        if (loadingCount == 0 && thumbLoadingCount == 0) {
            if (this.limitWarning) {
                this.setStatus("<html>" + loadedCount + " of " + totalCount + " images loaded.  Limitations of the PNG Walk Tool prevent use of the entire series.");
            } else {
                this.setStatus("" + loadedCount + " of " + totalCount + " images loaded.");
            }
        } else {
            this.setStatus("busy: " + loadedCount + " of " + totalCount + " images loaded, " + loadingCount + " are loading and " + thumbLoadingCount + " thumbs are loading.");
        }
    }

    public int findIndex(String name) {
        for (int i = 0; i < this.displayImages.size(); ++i) {
            WalkImage img = this.displayImages.get(i);
            if (!img.getUri().toString().endsWith(name)) continue;
            return i;
        }
        return -1;
    }

    public String getSelectedName() {
        WalkImage img = this.displayImages.get(this.getIndex());
        String surl = img.getUri().toString();
        int i = surl.indexOf(63);
        String sansArgs = i == -1 ? surl : surl.substring(0, i);
        i = WalkUtil.splitIndex(sansArgs);
        String spec = sansArgs.substring(i + 1);
        return spec;
    }

    void fireBadgeChanged() {
        this.pcs.firePropertyChange(PROP_BADGE_CHANGE, -1, this.getIndex());
    }
}

