/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.pngwalk;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.URISplit;
import org.autoplot.pngwalk.PngWalkView;
import org.autoplot.pngwalk.ScalePerspectiveImageOp;
import org.autoplot.pngwalk.WalkUtil;
import org.das2.datum.DatumRange;
import org.das2.system.RequestProcessor;
import org.das2.util.LoggerManager;
import org.das2.util.filesystem.FileObject;
import org.das2.util.filesystem.FileSystem;

public class WalkImage {
    private static final Logger logger = LoggerManager.getLogger("autoplot.pngwalk");
    public static final String PROP_STATUS_CHANGE = "status";
    public static final String PROP_BADGE_CHANGE = "badgeChange";
    public static final int THUMB_SIZE = 400;
    private static final int SQUASH_FACTOR = 10;
    private static final int LOADED_IMAGE_COUNT_LIMIT = 10;
    private static final int LOADED_THUMB_COUNT_LIMIT = 400;
    final String uriString;
    private URI imgURI;
    private BufferedImage im;
    private BufferedImage thumb;
    private Dimension thumbDimension;
    private BufferedImage squishedThumb;
    private BufferedImage sizeThumb;
    private int sizeThumbWidth = -1;
    private String caption;
    private Status status;
    private long initLoadBirthTime;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private final boolean haveThumbs400;
    private static BufferedImage missingImage = WalkImage.initMissingImage();
    private static final LinkedList<WalkImage> freshness = new LinkedList();
    private static final LinkedList<WalkImage> thumbFreshness = new LinkedList();
    DatumRange dr;

    public URI getUri() {
        if (this.imgURI != null) {
            return this.imgURI;
        }
        try {
            return new URI("");
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public WalkImage(URI uri, boolean haveThumbs400) {
        this.imgURI = uri;
        this.haveThumbs400 = haveThumbs400;
        if (this.imgURI != null) {
            this.uriString = DataSetURI.fromUri(uri);
            this.status = Status.UNKNOWN;
        } else {
            this.uriString = null;
            this.status = Status.MISSING;
        }
    }

    public Status getStatus() {
        return this.status;
    }

    private void setStatus(Status s) {
        logger.log(Level.FINER, "setStatus {0} {1}", new Object[]{s, this.caption});
        Status oldStatus = this.status;
        this.status = s;
        this.pcs.firePropertyChange(PROP_STATUS_CHANGE, (Object)oldStatus, (Object)this.status);
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public String getCaption() {
        return this.caption;
    }

    public DatumRange getDatumRange() {
        return this.dr;
    }

    public void setDatumRange(DatumRange dr) {
        this.dr = dr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getImage() {
        if (this.status == Status.MISSING) {
            return missingImage;
        }
        if (this.im == null && this.status != Status.IMAGE_LOADING) {
            this.loadImage();
        }
        LinkedList<WalkImage> linkedList = freshness;
        synchronized (linkedList) {
            freshness.remove(this);
            freshness.addFirst(this);
        }
        return this.im;
    }

    public long getInitLoadBirthTime() {
        return this.initLoadBirthTime;
    }

    BufferedImage getImageIfLoaded() {
        return this.im;
    }

    public BufferedImage getThumbnail() {
        return this.getThumbnail(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized BufferedImage getThumbnail(int w, int h, boolean waitOk) {
        LinkedList<WalkImage> linkedList = thumbFreshness;
        synchronized (linkedList) {
            thumbFreshness.remove(this);
            thumbFreshness.addFirst(this);
        }
        if (this.sizeThumbWidth == w) {
            return this.sizeThumb;
        }
        if (waitOk) {
            BufferedImage theThumb = this.getThumbnail(true);
            if (theThumb == null) {
                return PngWalkView.loadingImage;
            }
            ScalePerspectiveImageOp resizeOp = new ScalePerspectiveImageOp(theThumb.getWidth(), theThumb.getHeight(), 0, 0, w, h, 0, 1, 1, 0.0, false);
            this.sizeThumb = resizeOp.filter(theThumb, null);
            this.sizeThumbWidth = w;
            return this.sizeThumb;
        }
        return PngWalkView.loadingImage;
    }

    public BufferedImage readImage(File f) throws IllegalArgumentException, IOException {
        try {
            BufferedImage lim = ImageIO.read(f);
            if (lim == null) {
                logger.info("fail to read image: " + f);
                return missingImage;
            }
            if (lim.getType() == 0) {
                BufferedImage imNew = new BufferedImage(lim.getWidth(), lim.getHeight(), 2);
                imNew.getGraphics().drawImage(lim, 0, 0, null);
                lim = imNew;
            }
            return lim;
        }
        catch (IOException ex) {
            return missingImage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getThumbnailImmediately() {
        BufferedImage rawThumb;
        Serializable localFile;
        block24: {
            logger.log(Level.FINER, "getThumbnailImmediately {0}", this.caption);
            try {
                if (this.haveThumbs400) {
                    String s;
                    URI fsRoot = DataSetURI.toUri(URISplit.parse((URI)this.imgURI).path + "thumbs400");
                    FileSystem fs = FileSystem.create(fsRoot);
                    FileObject fo = fs.getFileObject((s = DataSetURI.fromUri(this.imgURI)).substring(s.lastIndexOf(47) + 1));
                    localFile = fo.getFile();
                    rawThumb = this.readImage((File)localFile);
                    if (rawThumb == null) {
                        throw new RuntimeException("Unable to read: " + localFile);
                    }
                    break block24;
                }
                throw new IOException("silly code to jump");
            }
            catch (IOException ex) {
                logger.log(Level.FINER, "attempt to load thumbnail in thumbs400 failed, load original: {0}", this.caption);
                if (this.im == null) {
                    this.loadImage();
                    return;
                }
                rawThumb = this.im;
            }
            catch (IllegalArgumentException ex) {
                if (this.im == null) {
                    this.loadImageImmediately();
                    return;
                }
                rawThumb = this.im;
            }
        }
        double aspect = (double)rawThumb.getWidth() / (double)rawThumb.getHeight();
        int height = (int)Math.round(Math.sqrt(160000.0 / (aspect * aspect + 1.0)));
        int width = (int)Math.round((double)height * aspect);
        localFile = this;
        synchronized (localFile) {
            this.thumb = WalkUtil.resizeImage(rawThumb, width, height);
            this.thumbDimension = new Dimension(width, height);
            if (this.status == Status.THUMB_LOADING) {
                this.setStatus(Status.THUMB_LOADED);
            } else if (this.status == Status.SIZE_THUMB_LOADED) {
                this.setStatus(Status.THUMB_LOADED);
            }
        }
        localFile = thumbFreshness;
        synchronized (localFile) {
            thumbFreshness.remove(this);
            thumbFreshness.addFirst(this);
        }
        LinkedList<WalkImage> clear = new LinkedList<WalkImage>();
        LinkedList<WalkImage> linkedList = thumbFreshness;
        synchronized (linkedList) {
            while (thumbFreshness.size() > 400) {
                WalkImage old = thumbFreshness.getLast();
                thumbFreshness.remove(old);
                clear.add(old);
            }
        }
        while (clear.size() > 0) {
            WalkImage old;
            WalkImage walkImage = old = (WalkImage)clear.poll();
            synchronized (walkImage) {
                logger.log(Level.FINE, "unloading thumbnail for {0}", old);
                old.setStatus(Status.SIZE_THUMB_LOADED);
                old.clearImages();
            }
        }
    }

    public synchronized Dimension getThumbnailDimension(boolean loadIfNeeded) {
        if (loadIfNeeded) {
            this.getThumbnail(loadIfNeeded);
        }
        return this.thumbDimension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getThumbnail(boolean loadIfNeeded) {
        Object object = thumbFreshness;
        synchronized (object) {
            thumbFreshness.remove(this);
            thumbFreshness.addFirst(this);
        }
        object = this;
        synchronized (object) {
            switch (this.status) {
                case THUMB_LOADING: {
                    return null;
                }
                case THUMB_LOADED: {
                    if (this.thumb == null) {
                        throw new RuntimeException("thumb should not be null");
                    }
                    return this.thumb;
                }
                case IMAGE_LOADED: {
                    return this.thumb;
                }
                case ERROR: {
                    return this.thumb;
                }
                case MISSING: {
                    return missingImage;
                }
                case SIZE_THUMB_LOADED: 
                case UNKNOWN: {
                    if (!loadIfNeeded) {
                        return null;
                    }
                    this.setStatus(Status.THUMB_LOADING);
                    return this.maybeReturnThumb(loadIfNeeded);
                }
                case IMAGE_LOADING: {
                    return this.maybeReturnThumb(loadIfNeeded);
                }
            }
            throw new IllegalArgumentException("Encountered invalid status in walk image.");
        }
    }

    private BufferedImage maybeReturnThumb(boolean loadIfNeeded) {
        if (this.thumb != null) {
            return this.thumb;
        }
        if (!loadIfNeeded) {
            return null;
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                WalkImage.this.getThumbnailImmediately();
            }
        };
        RequestProcessor.invokeLater(r);
        return null;
    }

    public BufferedImage getSquishedThumbnail() {
        return this.getSquishedThumbnail(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getSquishedThumbnail(boolean loadIfNeeded) {
        if (this.status == Status.MISSING) {
            return missingImage;
        }
        BufferedImage lsquishedThumb = this.getSquishedThumb();
        if (lsquishedThumb == null) {
            WalkImage walkImage = this;
            synchronized (walkImage) {
                if (this.thumb == null && this.getThumbnail(loadIfNeeded) == null) {
                    return null;
                }
                if (this.thumb != null) {
                    ScalePerspectiveImageOp resizeOp = new ScalePerspectiveImageOp(this.thumb.getWidth(), this.thumb.getHeight(), 0, 0, this.thumb.getWidth() / 10, this.thumb.getHeight(), 0, 1, 1, 0.0, false);
                    lsquishedThumb = this.squishedThumb = resizeOp.filter(this.thumb, null);
                }
            }
        }
        return lsquishedThumb;
    }

    private synchronized BufferedImage getSquishedThumb() {
        return this.squishedThumb;
    }

    private synchronized void clearImages() {
        this.squishedThumb = null;
        this.thumb = null;
        this.im = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadImageImmediately() {
        logger.log(Level.FINER, "loadImageImmediately {0}", this.caption);
        try {
            BufferedImage lthumb;
            WalkImage walkImage;
            URI fsRoot = DataSetURI.toUri(URISplit.parse((URI)this.imgURI).path);
            FileSystem fs = FileSystem.create(fsRoot);
            String s = DataSetURI.fromUri(this.imgURI);
            FileObject fo = fs.getFileObject(s.substring(s.lastIndexOf(47) + 1));
            File localFile = fo.getFile();
            Thread.yield();
            this.im = this.readImage(localFile);
            if (this.im == null) {
                throw new RuntimeException("unable to read: " + localFile);
            }
            LinkedList<WalkImage> linkedList = freshness;
            synchronized (linkedList) {
                freshness.remove(this);
                freshness.addFirst(this);
            }
            LinkedList<WalkImage> clear = new LinkedList<WalkImage>();
            LinkedList<WalkImage> linkedList2 = freshness;
            synchronized (linkedList2) {
                while (freshness.size() > 10) {
                    WalkImage old = freshness.getLast();
                    freshness.remove(old);
                    clear.add(old);
                }
            }
            while (clear.size() > 0) {
                WalkImage old;
                walkImage = old = (WalkImage)clear.poll();
                synchronized (walkImage) {
                    logger.log(Level.FINE, "unloading image for {0}", old);
                    old.im = null;
                    if (old.getStatus() == Status.IMAGE_LOADED) {
                        old.setStatus(Status.THUMB_LOADED);
                    }
                }
            }
            walkImage = this;
            synchronized (walkImage) {
                lthumb = this.thumb;
            }
            if (lthumb == null) {
                this.getThumbnailImmediately();
            }
            this.setStatus(Status.IMAGE_LOADED);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            this.setStatus(Status.MISSING);
            throw new RuntimeException(ex);
        }
    }

    private void loadImage() {
        logger.log(Level.FINER, "loadImage {0}", this.caption);
        if (this.status == Status.IMAGE_LOADING || this.status == Status.IMAGE_LOADED) {
            return;
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                WalkImage.this.loadImageImmediately();
            }
        };
        this.setStatus(Status.IMAGE_LOADING);
        this.initLoadBirthTime = System.currentTimeMillis();
        RequestProcessor.invokeLater(r);
    }

    private static BufferedImage initMissingImage() {
        BufferedImage missing = new BufferedImage(200, 200, 2);
        Graphics2D g2 = missing.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setColor(Color.GRAY);
        FontMetrics fm = g2.getFontMetrics(g2.getFont());
        String msg = "(Missing)";
        g2.drawString(msg, (200 - fm.stringWidth(msg)) / 2, 100);
        return missing;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public String toString() {
        return this.getCaption() == null ? this.uriString : this.getCaption();
    }

    public static enum Status {
        UNKNOWN,
        SIZE_THUMB_LOADED,
        THUMB_LOADING,
        THUMB_LOADED,
        IMAGE_LOADING,
        IMAGE_LOADED,
        MISSING,
        ERROR;

    }
}

