/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.pngwalk;

import java.text.ParseException;
import java.util.LinkedList;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RichPngUtil {
    public static DatumRange getXRange(String json) {
        try {
            JSONObject jo = new JSONObject(json);
            JSONArray plots = jo.getJSONArray("plots");
            LinkedList<DatumRange> ranges = new LinkedList<DatumRange>();
            for (int i = 0; i < plots.length(); ++i) {
                JSONObject plot = plots.getJSONObject(i);
                if (plot == null) continue;
                JSONObject xaxis = plot.getJSONObject("xaxis");
                DatumRange range = RichPngUtil.getRange(xaxis);
                if (UnitsUtil.isTimeLocation(range.getUnits())) {
                    ranges.add(0, range);
                    continue;
                }
                ranges.add(range);
            }
            if (ranges.size() > 0) {
                return (DatumRange)ranges.get(0);
            }
            return null;
        }
        catch (JSONException ex) {
            return null;
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static DatumRange getRange(JSONObject axis) throws JSONException, ParseException {
        DatumRange range;
        String sunits = axis.has("units") ? axis.getString("units") : "";
        if ("UTC".equals(sunits)) {
            range = DatumRangeUtil.parseISO8601Range(axis.getString("min") + "/" + axis.getString("max"));
        } else {
            Units units = Units.lookupUnits(sunits);
            range = new DatumRange(units.parse(axis.getString("min")), units.parse(axis.getString("max")));
        }
        return range;
    }
}

