/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.pngwalk;

import java.io.IOException;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.autoplot.pngwalk.PngWalkTool;
import org.autoplot.pngwalk.QualityControlRecord;
import org.autoplot.pngwalk.WalkImageSequence;
import org.das2.util.LoggerManager;

public class QualityControlSequence {
    private int qcOK;
    private int qcProb;
    private int qcIgn;
    private int qcUnknown;
    WalkImageSequence walkImageSequence;
    URI qcFolder;
    private static final Logger logger = LoggerManager.getLogger("autoplot.pngwalk");

    QualityControlSequence(WalkImageSequence wis, URI qcFolder) throws IOException {
        this.walkImageSequence = wis;
        this.qcFolder = qcFolder;
        try {
            if (this.walkImageSequence.size() > 0) {
                QualityControlRecord.getRecord(this.walkImageSequence.imageAt(0).getUri(), qcFolder);
            }
        }
        catch (UnknownHostException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        this.refreshQCTotals();
    }

    protected final int[] refreshQCTotals() {
        this.qcUnknown = 0;
        this.qcIgn = 0;
        this.qcProb = 0;
        this.qcOK = 0;
        block6: for (int i = 0; i < this.walkImageSequence.size(); ++i) {
            if (this.getQualityControlRecord(i) == null) continue;
            switch (this.getQualityControlRecord(i).getStatus()) {
                case OK: {
                    ++this.qcOK;
                    continue block6;
                }
                case PROBLEM: {
                    ++this.qcProb;
                    continue block6;
                }
                case IGNORE: {
                    ++this.qcIgn;
                    continue block6;
                }
                case UNKNOWN: {
                    ++this.qcUnknown;
                }
            }
        }
        this.walkImageSequence.fireBadgeChanged();
        return new int[]{this.qcOK, this.qcProb, this.qcIgn, this.qcUnknown};
    }

    public int[] getQCTotals() {
        int[] r = new int[]{this.qcOK, this.qcProb, this.qcIgn, this.qcUnknown};
        return r;
    }

    public QualityControlRecord getQualityControlRecord(int forIndex) {
        QualityControlRecord rec;
        if (!PngWalkTool.isQualityControlEnabled()) {
            throw new IllegalStateException();
        }
        try {
            URI imageURI = this.walkImageSequence.imageAt(forIndex).getUri();
            rec = imageURI.toString().length() == 0 ? null : QualityControlRecord.getRecord(imageURI, this.qcFolder);
        }
        catch (UnknownHostException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            rec = null;
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            rec = null;
        }
        return rec;
    }

    public QualityControlRecord getQualityControlRecordNoSubRange(int forIndex) {
        QualityControlRecord rec;
        if (!PngWalkTool.isQualityControlEnabled()) {
            throw new IllegalStateException();
        }
        try {
            URI imageURI = this.walkImageSequence.imageAtNoSubRange(forIndex).getUri();
            rec = imageURI.toString().length() == 0 ? null : QualityControlRecord.getRecord(imageURI, this.qcFolder);
        }
        catch (UnknownHostException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            rec = null;
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            rec = null;
        }
        return rec;
    }
}

