/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.pngwalk;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.pngwalk.QualityControlRecord;
import org.autoplot.pngwalk.QualityControlSequence;
import org.autoplot.pngwalk.WalkImageSequence;
import org.autoplot.pngwalk.WalkUtil;
import org.das2.util.LoggerManager;
import org.das2.util.filesystem.FileObject;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.filesystem.KeyChain;
import org.das2.util.filesystem.WriteCapability;
import org.das2.util.monitor.CancelledOperationException;
import org.jdesktop.layout.GroupLayout;

public class QualityControlPanel
extends JPanel {
    private final JRadioButton nullRadioButton;
    private transient QualityControlRecord qcRecord;
    public static final String KEY_QUALITY_CONTROL_URI = "QualityControlURI";
    private static final Logger logger = LoggerManager.getLogger("autoplot.pngwalk");
    transient PropertyChangeListener pc = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            QualityControlSequence qcs;
            int i;
            if (evt.getPropertyName().equals("badgeChange") && (i = ((Integer)evt.getNewValue()).intValue()) == QualityControlPanel.this.walkImageSequence.getIndex() && (qcs = QualityControlPanel.this.walkImageSequence.getQualityControlSequence()) != null) {
                QualityControlPanel.this.displayRecord(qcs.getQualityControlRecord(i));
            }
        }
    };
    protected transient WalkImageSequence walkImageSequence = null;
    private JSplitPane commentSplitPane;
    private JRadioButton ignoreRadioButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JButton loginButton;
    private JTextArea newCommentTextArea;
    private JRadioButton okRadioButton;
    private JEditorPane previousCommentEditorPane;
    private JRadioButton problemRadioButton;
    private JButton saveButton;
    private JTextField sequencePropertiesHost;
    private ButtonGroup statusButtonGroup;
    private JLabel statusLabel;

    public QualityControlPanel() {
        this.initComponents();
        this.nullRadioButton = new JRadioButton();
        this.statusButtonGroup.add(this.nullRadioButton);
        ItemListener l = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (QualityControlPanel.this.okRadioButton.isSelected() || QualityControlPanel.this.problemRadioButton.isSelected() || QualityControlPanel.this.ignoreRadioButton.isSelected()) {
                    QualityControlPanel.this.saveButton.setEnabled(true);
                } else {
                    QualityControlPanel.this.saveButton.setEnabled(false);
                }
            }
        };
        this.nullRadioButton.addItemListener(l);
        this.okRadioButton.addItemListener(l);
        this.problemRadioButton.addItemListener(l);
        this.ignoreRadioButton.addItemListener(l);
        this.statusButtonGroup.setSelected(this.nullRadioButton.getModel(), true);
        this.previousCommentEditorPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    String t = QualityControlPanel.this.qcRecord.doCopyLink(e);
                    QualityControlPanel.this.newCommentTextArea.insert(t, QualityControlPanel.this.newCommentTextArea.getCaretPosition());
                }
            }
        });
    }

    public void displayRecord(QualityControlRecord rec) {
        if (rec == null) {
            this.previousCommentEditorPane.setText("");
            this.newCommentTextArea.setText("");
            this.statusButtonGroup.setSelected(this.okRadioButton.getModel(), false);
            this.setStatus(0, 0, 0, 0);
            this.qcRecord = null;
            return;
        }
        this.previousCommentEditorPane.setText(rec.getCommentsHTML());
        this.newCommentTextArea.setText(rec.getNewCommentText());
        switch (rec.getStatus()) {
            case OK: {
                this.statusButtonGroup.setSelected(this.okRadioButton.getModel(), true);
                break;
            }
            case PROBLEM: {
                this.statusButtonGroup.setSelected(this.problemRadioButton.getModel(), true);
                break;
            }
            case IGNORE: {
                this.statusButtonGroup.setSelected(this.ignoreRadioButton.getModel(), true);
                break;
            }
            default: {
                this.statusButtonGroup.setSelected(this.nullRadioButton.getModel(), true);
            }
        }
        QualityControlSequence seq = this.walkImageSequence.getQualityControlSequence();
        int[] t = seq.getQCTotals();
        this.qcRecord = rec;
        this.setStatus(t[0], t[1], t[2], t[3]);
    }

    protected void setStatus(int numOK, int numProblem, int numIgnore, int numUnknown) {
        String statustxt;
        if (this.walkImageSequence == null || this.walkImageSequence.getQCFolder() == null) {
            statustxt = " ";
        } else {
            int index = this.walkImageSequence.getIndex();
            statustxt = String.format("#%d of %d OK | %d Prob | %d Ign | %d Unknown", index + 1, numOK, numProblem, numIgnore, numUnknown);
        }
        this.statusLabel.setText(statustxt);
        this.statusLabel.setToolTipText(statustxt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initQualitySequeuce() {
        InputStream in = null;
        try {
            Properties sequenceProperties = new Properties();
            String template = this.walkImageSequence.getTemplate();
            int i = WalkUtil.splitIndex(template);
            String path = template.substring(0, i);
            URI fsRoot = DataSetURI.getResourceURI(path);
            FileSystem tfs = FileSystem.create(fsRoot);
            FileObject propsFile = tfs.getFileObject("sequence.properties");
            if (propsFile.exists()) {
                in = propsFile.getInputStream();
                sequenceProperties.load(in);
                in.close();
            }
            this.walkImageSequence.setQCFolder(DataSetURI.getResourceURI(sequenceProperties.getProperty(KEY_QUALITY_CONTROL_URI, path)));
            QualityControlSequence qseq = this.walkImageSequence.getQualityControlSequence();
            int index = this.walkImageSequence.getIndex();
            if (qseq == null || qseq.getQualityControlRecord(index) != null) {
                this.saveButton.setEnabled(true);
                this.setStateButtonedEnabled(true);
            } else {
                this.saveButton.setEnabled(false);
                this.setStateButtonedEnabled(false);
            }
            this.setStateButtonedEnabled(false);
            this.loginButton.setEnabled(true);
        }
        catch (FileNotFoundException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
    }

    private void login() {
        block6: {
            if (this.walkImageSequence.getQualityControlSequence() == null) {
                URI uri = this.walkImageSequence.getQCFolder();
                try {
                    URI uris = KeyChain.getDefault().resolveUserInfo(uri);
                    this.walkImageSequence.initQualitySequence(uris);
                    try {
                        FileSystem fs = FileSystem.create(uri);
                        WriteCapability w = fs.getFileObject("testwrite.txt").getCapability(WriteCapability.class);
                        if (w != null && w.canWrite()) {
                            this.setStateButtonedEnabled(true);
                            this.saveButton.setEnabled(true);
                            this.loginButton.setEnabled(false);
                            break block6;
                        }
                        this.loginButton.setEnabled(false);
                        this.loginButton.setToolTipText("<html>Unable to write to File System<br>" + fs.getRootURI());
                        this.saveButton.setEnabled(false);
                        this.sequencePropertiesHost.setText(uri.toString() + " -- Unable to write to file system");
                    }
                    catch (FileNotFoundException | UnknownHostException | FileSystem.FileSystemOfflineException ex) {
                        Logger.getLogger(QualityControlPanel.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                catch (CancelledOperationException ex) {
                    return;
                }
            }
        }
    }

    public void setPreviousCommentText(String txt) {
        String htxt = "<html><body>" + txt + "<hr/></body></html>";
        this.previousCommentEditorPane.setText(htxt);
    }

    private void initComponents() {
        this.statusButtonGroup = new ButtonGroup();
        this.jLabel2 = new JLabel();
        this.jPanel1 = new JPanel();
        this.okRadioButton = new JRadioButton();
        this.problemRadioButton = new JRadioButton();
        this.ignoreRadioButton = new JRadioButton();
        this.saveButton = new JButton();
        this.loginButton = new JButton();
        this.sequencePropertiesHost = new JTextField();
        this.commentSplitPane = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.previousCommentEditorPane = new JEditorPane();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.newCommentTextArea = new JTextArea();
        this.jPanel3 = new JPanel();
        this.statusLabel = new JLabel();
        this.jLabel2.setText("jLabel2");
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.statusButtonGroup.add(this.okRadioButton);
        this.okRadioButton.setSelected(true);
        this.okRadioButton.setText("OK");
        this.okRadioButton.setToolTipText("Submit for further processing");
        this.okRadioButton.setEnabled(false);
        this.okRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QualityControlPanel.this.okRadioButtonActionPerformed(evt);
            }
        });
        this.statusButtonGroup.add(this.problemRadioButton);
        this.problemRadioButton.setText("Problem");
        this.problemRadioButton.setToolTipText("Send back for reprocessing");
        this.problemRadioButton.setEnabled(false);
        this.problemRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QualityControlPanel.this.problemRadioButtonActionPerformed(evt);
            }
        });
        this.statusButtonGroup.add(this.ignoreRadioButton);
        this.ignoreRadioButton.setText("Ignore");
        this.ignoreRadioButton.setToolTipText("Do nothing further");
        this.ignoreRadioButton.setEnabled(false);
        this.ignoreRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QualityControlPanel.this.ignoreRadioButtonActionPerformed(evt);
            }
        });
        this.saveButton.setText("Save");
        this.saveButton.setToolTipText("Save the record to disk");
        this.saveButton.setEnabled(false);
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QualityControlPanel.this.saveButtonActionPerformed(evt);
            }
        });
        this.loginButton.setText("Log In...");
        this.loginButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QualityControlPanel.this.loginButtonActionPerformed(evt);
            }
        });
        this.sequencePropertiesHost.setEditable(false);
        this.sequencePropertiesHost.setFont(this.sequencePropertiesHost.getFont().deriveFont(this.sequencePropertiesHost.getFont().getStyle() | 2, this.sequencePropertiesHost.getFont().getSize() - 2));
        this.sequencePropertiesHost.setText("reading sequence.properties...");
        this.sequencePropertiesHost.setToolTipText("reading sequence.properties...");
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.okRadioButton).add((Component)this.problemRadioButton).add((Component)this.ignoreRadioButton)).addPreferredGap(0, -1, Short.MAX_VALUE).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(2).add((Component)this.saveButton, -2, 69, -2).add((Component)this.loginButton)).addContainerGap()).add((Component)this.sequencePropertiesHost));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((Component)this.sequencePropertiesHost, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(2).add((Component)this.saveButton).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.okRadioButton).add((Component)this.loginButton)).addPreferredGap(0).add((Component)this.problemRadioButton).addPreferredGap(0).add((Component)this.ignoreRadioButton))).addContainerGap(19, Short.MAX_VALUE)));
        this.commentSplitPane.setOrientation(0);
        this.commentSplitPane.setResizeWeight(1.0);
        this.previousCommentEditorPane.setEditable(false);
        this.previousCommentEditorPane.setContentType("text/html");
        Font font = UIManager.getFont("Label.font");
        String bodyRule = "body { font-family: " + font.getFamily() + "; font-size: " + font.getSize() + "pt; }";
        ((HTMLDocument)this.previousCommentEditorPane.getDocument()).getStyleSheet().addRule(bodyRule);
        this.jScrollPane1.setViewportView(this.previousCommentEditorPane);
        this.commentSplitPane.setTopComponent(this.jScrollPane1);
        this.jLabel1.setText("Enter your comments below:");
        this.newCommentTextArea.setColumns(20);
        this.newCommentTextArea.setLineWrap(true);
        this.newCommentTextArea.setWrapStyleWord(true);
        this.jScrollPane2.setViewportView(this.newCommentTextArea);
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.jScrollPane2, -1, 324, Short.MAX_VALUE).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.jLabel1).add(0, 0, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.jLabel1, -2, 17, -2).addPreferredGap(0).add((Component)this.jScrollPane2, -1, 130, Short.MAX_VALUE)));
        this.commentSplitPane.setRightComponent(this.jPanel2);
        this.jPanel3.setBorder(BorderFactory.createBevelBorder(1));
        this.jPanel3.setAutoscrolls(true);
        this.statusLabel.setText("Waiting for status count...");
        this.statusLabel.setMaximumSize(new Dimension(1000, 17));
        this.statusLabel.setMinimumSize(new Dimension(50, 17));
        GroupLayout jPanel3Layout = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)jPanel3Layout);
        jPanel3Layout.setHorizontalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((Component)this.statusLabel, -1, -1, Short.MAX_VALUE));
        jPanel3Layout.setVerticalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((Component)this.statusLabel, -2, -1, -2));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.commentSplitPane).add((Component)this.jPanel3, -1, -1, Short.MAX_VALUE).add(2, (Component)this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.commentSplitPane, -1, 250, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jPanel1, -2, -1, -2).addPreferredGap(0).add((Component)this.jPanel3, -2, -1, -2)));
    }

    private void okRadioButtonActionPerformed(ActionEvent evt) {
    }

    private void problemRadioButtonActionPerformed(ActionEvent evt) {
    }

    private void ignoreRadioButtonActionPerformed(ActionEvent evt) {
    }

    public synchronized WalkImageSequence getWalkImageSequece() {
        return this.walkImageSequence;
    }

    public synchronized void setWalkImageSequece(final WalkImageSequence walkImageSequence) {
        if (this.walkImageSequence != null) {
            this.walkImageSequence.removePropertyChangeListener(this.pc);
        }
        if (walkImageSequence == null) {
            this.loginButton.setToolTipText("");
        } else {
            this.loginButton.setToolTipText("Log in to site");
            this.loginButton.setEnabled(true);
        }
        this.walkImageSequence = walkImageSequence;
        if (walkImageSequence != null) {
            walkImageSequence.addPropertyChangeListener(this.pc);
        }
        this.displayRecord(null);
        this.sequencePropertiesHost.setText("reading sequence.properties...");
        this.sequencePropertiesHost.setToolTipText("");
        if (walkImageSequence != null) {
            this.loginButton.setEnabled(false);
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    QualityControlSequence qseq;
                    QualityControlPanel.this.initQualitySequeuce();
                    URI uri = walkImageSequence.getQCFolder();
                    QualityControlPanel.this.sequencePropertiesHost.setText(uri.toString());
                    QualityControlPanel.this.sequencePropertiesHost.setToolTipText(uri.toString());
                    QualityControlPanel.this.loginButton.setEnabled(true);
                    int index = walkImageSequence.getIndex();
                    if (index >= 0 && ((qseq = walkImageSequence.getQualityControlSequence()) == null || qseq.getQualityControlRecord(index) != null)) {
                        QualityControlPanel.this.saveButton.setEnabled(true);
                        QualityControlPanel.this.setStateButtonedEnabled(true);
                    }
                    if (uri.getScheme().equals("file")) {
                        QualityControlPanel.this.login();
                    }
                }
            };
            new Thread(run).start();
        }
    }

    protected void setStatus(String text, QualityControlRecord.Status status) {
        if (text == null) {
            text = "";
        }
        this.qcRecord.setStatus(status);
        this.qcRecord.setNewCommentText(System.getProperty("user.name"), text);
        this.qcRecord.save();
        this.walkImageSequence.getQualityControlSequence().refreshQCTotals();
        this.displayRecord(this.qcRecord);
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        String text = this.newCommentTextArea.getText();
        QualityControlRecord.Status status = this.ignoreRadioButton.isSelected() ? QualityControlRecord.Status.IGNORE : (this.problemRadioButton.isSelected() ? QualityControlRecord.Status.PROBLEM : (this.okRadioButton.isSelected() ? QualityControlRecord.Status.OK : QualityControlRecord.Status.PROBLEM));
        this.setStatus(text, status);
    }

    private void loginButtonActionPerformed(ActionEvent evt) {
        this.login();
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        f.add(new QualityControlPanel());
        f.pack();
        f.setDefaultCloseOperation(3);
        f.setVisible(true);
    }

    private void setStateButtonedEnabled(boolean b) {
        Enumeration<AbstractButton> e = this.statusButtonGroup.getElements();
        while (e.hasMoreElements()) {
            e.nextElement().setEnabled(b);
        }
    }
}

