/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.pngwalk;

import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Image;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfWriter;
import external.AnimatedGifDemo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.autoplot.AppManager;
import org.autoplot.AutoplotUI;
import org.autoplot.AutoplotUtil;
import org.autoplot.GuiSupport;
import org.autoplot.JythonUtil;
import org.autoplot.ScriptContext;
import org.autoplot.Util;
import org.autoplot.bookmarks.Bookmark;
import org.autoplot.bookmarks.BookmarksException;
import org.autoplot.bookmarks.BookmarksManager;
import org.autoplot.datasource.AutoplotSettings;
import org.autoplot.datasource.DataSetSelector;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.FileSystemUtil;
import org.autoplot.datasource.URISplit;
import org.autoplot.pngwalk.ContextFlowView;
import org.autoplot.pngwalk.CoversWalkView;
import org.autoplot.pngwalk.GridPngWalkView;
import org.autoplot.pngwalk.HtmlOutputOptions;
import org.autoplot.pngwalk.ImageResize;
import org.autoplot.pngwalk.PngWalkView;
import org.autoplot.pngwalk.QualityControlPanel;
import org.autoplot.pngwalk.QualityControlRecord;
import org.autoplot.pngwalk.QualityControlSequence;
import org.autoplot.pngwalk.RichPngUtil;
import org.autoplot.pngwalk.RowPngWalkView;
import org.autoplot.pngwalk.SinglePngWalkView;
import org.autoplot.pngwalk.SubrangeEditorDialog;
import org.autoplot.pngwalk.WalkImageSequence;
import org.autoplot.pngwalk.WalkUtil;
import org.autoplot.transferrable.ImageSelection;
import org.das2.components.DasProgressPanel;
import org.das2.components.DataPointRecorder;
import org.das2.components.TearoffTabbedPane;
import org.das2.dataset.DataSetUpdateEvent;
import org.das2.dataset.DataSetUpdateListener;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.TimeParser;
import org.das2.datum.TimeUtil;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.datum.format.TimeDatumFormatter;
import org.das2.event.DataPointSelectionEvent;
import org.das2.event.DataPointSelectionListener;
import org.das2.qds.QDataSet;
import org.das2.util.ArgumentList;
import org.das2.util.FileUtil;
import org.das2.util.ImageUtil;
import org.das2.util.LoggerManager;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.monitor.AlertNullProgressMonitor;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.layout.GroupLayout;
import org.xml.sax.SAXException;

public final class PngWalkTool
extends JPanel {
    private static boolean ENABLE_QUALITY_CONTROL;
    private QualityControlPanel qcPanel = null;
    public static final String PREF_RECENT = "pngWalkRecent";
    public static final String PREF_LAST_EXPORT = "pngWalkLastExport";
    public PngWalkView[] views;
    TearoffTabbedPane tabs;
    transient WalkImageSequence seq;
    JMenu navMenu;
    Pattern actionMatch = null;
    String actionCommand = null;
    static final Logger logger;
    private static final String RESOURCES = "/org/autoplot/resources/";
    private static final Icon WARNING_ICON;
    private static final Icon ERROR_ICON;
    private static final Icon BUSY_ICON;
    private static final Icon READY_ICON;
    private static final Icon IDLE_ICON;
    int returnTabIndex = 0;
    transient DatumRange pendingGoto = null;
    private String product;
    private String baseurl;
    private Window parentWindow;
    private JCheckBoxMenuItem qcFilterMenuItem;
    private transient PropertyChangeListener indexListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (PngWalkTool.this.seq == null) {
                logger.fine("seq was null");
                return;
            }
            String item = PngWalkTool.this.seq.currentImage().getUri().toString();
            for (int i = 0; i < PngWalkTool.this.actionEnablers.size(); ++i) {
                boolean actionEnabled = PngWalkTool.this.actionEnablers.get(i).isActionEnabled(item);
                PngWalkTool.this.actionButtons.get(i).setEnabled(actionEnabled);
                if (!actionEnabled) continue;
                PngWalkTool.this.actionButtons.get(i).setActionCommand(PngWalkTool.this.actionCommand + " " + item);
            }
            PngWalkTool.this.firePropertyChange(PngWalkTool.PROP_SELECTED_NAME, null, PngWalkTool.this.seq.getSelectedName());
            PngWalkTool.this.firePropertyChange(PngWalkTool.PROP_TIMERANGE, null, PngWalkTool.this.getTimeRange());
            if (PngWalkTool.this.qcPanel != null && PngWalkTool.this.seq.getQualityControlSequence() != null) {
                PngWalkTool.this.qcPanel.displayRecord(PngWalkTool.this.seq.getQualityControlSequence().getQualityControlRecord(PngWalkTool.this.seq.getIndex()));
            }
        }
    };
    private transient PropertyChangeListener statusListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            PngWalkTool.this.setStatus((String)evt.getNewValue());
        }
    };
    private final transient PropertyChangeListener qcStatusListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (PngWalkTool.this.seq == null) {
                logger.fine("seq was null");
                return;
            }
            if (PngWalkTool.this.seq.getQualityControlSequence() != null) {
                int[] n = PngWalkTool.this.seq.getQualityControlSequence().getQCTotals();
                PngWalkTool.this.qcPanel.setStatus(n[0], n[1], n[2], n[3]);
            }
        }
    };
    protected int thumbnailSize = 100;
    public static final String PROP_THUMBNAILSIZE = "thumbnailSize";
    transient DatumRange timeRange;
    public static final String PROP_TIMERANGE = "timeRange";
    private transient QDataSet mousePressLocation = null;
    public static final String PROP_MOUSEPRESSLOCATION = "mousePressLocation";
    private transient QDataSet mouseReleaseLocation = null;
    public static final String PROP_MOUSERELEASELOCATION = "mouseReleaseLocation";
    transient PropertyChangeListener seqTimeRangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            PngWalkTool.this.setTimeRange((DatumRange)evt.getNewValue());
        }
    };
    boolean setting = false;
    transient PropertyChangeListener seqIndexListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            boolean setting0 = PngWalkTool.this.setting;
            PngWalkTool.this.setting = true;
            DatumRange dr = PngWalkTool.this.seq.currentImage().getDatumRange();
            if (setting0 && dr != null) {
                PngWalkTool.this.setTimeRange(dr);
            }
            PngWalkTool.this.setting = false;
        }
    };
    protected transient String status = "initializing...";
    public static final String PROP_STATUS = "status";
    protected DataPointRecorder digitizer = null;
    protected boolean digitizerRecording = true;
    protected char annoTypeChar = (char)124;
    public static final ActionEnabler LOCAL_FILE_ENABLER;
    transient List<ActionEnabler> actionEnablers = new ArrayList<ActionEnabler>();
    List<JButton> actionButtons = new ArrayList<JButton>();
    public static final String PROP_SELECTED_NAME = "selectedName";
    private JPanel actionButtonsPanel;
    private DataSetSelector dataSetSelector1;
    private JButton editRangeButton;
    private JPanel jPanel1;
    private JButton jumpToFirstButton;
    private JButton jumpToLastButton;
    private JButton nextButton;
    private JButton nextSetButton;
    private JPanel pngsPanel;
    private JButton prevButton;
    private JButton prevSetButton;
    private JCheckBox showMissingCheckBox;
    private JLabel statusLabel;
    private JTextField timeFilterTextField;
    private JCheckBox useRangeCheckBox;

    public static void main(String[] args) {
        DataSetURI.init();
        System.err.println("autoplot pngwalk 20141111");
        ArgumentList alm = new ArgumentList("PngWalkTool");
        alm.addOptionalSwitchArgument("nativeLAF", "n", "nativeLAF", alm.TRUE, "use the system look and feel (T or F)");
        alm.addOptionalSwitchArgument("mode", "m", "mode", "filmStrip", "initial display mode: grid, filmStrip, covers, contextFlow, etc");
        alm.addOptionalSwitchArgument("goto", "g", "goto", "", "start display at the beginning of this range, e.g. 2010-01-01");
        alm.addBooleanSwitchArgument("qualityControl", "q", "qualityControl", "enable quality control review mode");
        String home = System.getProperty("user.home") + System.getProperty("file.separator");
        String output = "file:" + home + "pngwalk" + System.getProperty("file.separator") + "product_$Y$m$d.png";
        alm.addOptionalPositionArgument(0, "template", output, "initial template to use.");
        alm.addOptionalSwitchArgument("template", "t", "template", output, "initial template to use.");
        alm.process(args);
        if (alm.getBooleanValue("nativeLAF")) {
            logger.fine("nativeLAF");
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
        ENABLE_QUALITY_CONTROL = alm.getBooleanValue("qualityControl");
        String template = alm.getValue("template");
        PngWalkTool pngWalkTool = PngWalkTool.start(template, null);
        pngWalkTool.processArguments(alm);
    }

    private static Map readPngwalkFile(String template) {
        URISplit split = URISplit.parse(template);
        InputStream in = null;
        String product = "";
        String baseurl = "";
        try {
            Properties p = new Properties();
            if (split.file == null) {
                throw new IllegalArgumentException("template does not appear to be files: " + template);
            }
            File local = FileSystemUtil.doDownload(split.file, new NullProgressMonitor());
            in = new FileInputStream(local);
            p.load(in);
            String vers = p.getProperty("version");
            vers = vers == null || vers.trim().length() == 0 ? "" : "_" + vers;
            baseurl = p.getProperty("baseurl", ".");
            if (!baseurl.equals(".")) {
                if (!baseurl.endsWith("/")) {
                    baseurl = baseurl + "/";
                }
                split.path = baseurl;
            }
            String t = !p.getProperty("filePattern", "").equals("") ? split.path + p.getProperty("filePattern", "") : split.path + p.getProperty("product") + "_" + p.getProperty("timeFormat") + vers + ".png";
            template = t;
            product = p.getProperty("product");
        }
        catch (URISyntaxException | FileSystem.FileSystemOfflineException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        catch (FileNotFoundException ex) {
            throw new IllegalArgumentException("File does not exist: " + template);
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, ex.getMessage(), ex);
            throw new RuntimeException(ex);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {
                logger.log(Level.WARNING, ex.getMessage(), ex);
            }
        }
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("template", template);
        result.put("product", product);
        result.put("baseurl", baseurl);
        return result;
    }

    private static void raiseApWindowSoon(final Window apWindow) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                GuiSupport.raiseApplicationWindow((JFrame)apWindow);
                apWindow.toFront();
                apWindow.repaint();
            }
        };
        SwingUtilities.invokeLater(run);
    }

    private static String checkRelativeBaseurl(String baseurl, String template, String product) {
        if (baseurl.equals(".")) {
            URISplit split = URISplit.parse(template);
            String f = split.path;
            int i = f.indexOf("/" + product + ".pngwalk");
            if (i == -1 && (i = f.indexOf(42)) > -1) {
                i = f.lastIndexOf(47, i);
            }
            if (i == -1 && f.endsWith("/")) {
                baseurl = f;
            }
            if (i > -1) {
                baseurl = f.substring(0, i + 1);
            }
        }
        return baseurl;
    }

    public static PngWalkTool start(String template, final Window parent) {
        final PngWalkTool tool = new PngWalkTool();
        tool.parentWindow = parent;
        if (template != null) {
            URISplit split = URISplit.parse(template);
            if (split.file.endsWith(".pngwalk")) {
                Map map = PngWalkTool.readPngwalkFile(template);
                tool.product = (String)map.get("product");
                tool.baseurl = (String)map.get("baseurl");
                tool.baseurl = PngWalkTool.checkRelativeBaseurl(tool.baseurl, template, tool.product);
                template = (String)map.get("template");
            } else {
                tool.product = "";
                tool.baseurl = "";
            }
            tool.setTemplate(template);
        } else {
            tool.product = "";
            tool.baseurl = "";
        }
        String sdeft = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><bookmark-list version=\"1.1\">    <bookmark-folder remoteUrl=\"http://autoplot.org/git/pngwalks.xml\"><title>Demos</title><bookmark-list>    <bookmark>        <title>POLAR/VIS Images</title>        <uri>pngwalk:http://vis.physics.uiowa.edu/survey/1996/04-apr/03/images/VIS_$Y_$m_$d_$H_$M_$S_EC.PNG</uri>        <description>Images from the POLAR/VIS instrument</description>    </bookmark>    <bookmark>        <title>RBSP Emfisis HFR-WFR Orbits</title>        <uri>pngwalk:http://emfisis.physics.uiowa.edu/pngwalk/RBSP-A/HFR-WFR_orbit/product_$(o,id=rbspa-pp).png</uri>    </bookmark>    <bookmark>        <title>RBSP-A MagEIS Combined Spectra</title>        <uri>pngwalk:https://www.rbsp-ect.lanl.gov/data_pub/rbspa/ect/level2/combined-elec/rbspa_ect_L2-elec_$Y$m$d_v.1.0.0.png</uri>    </bookmark></bookmark-list></bookmark-folder></bookmark-list>";
        List<Bookmark> deft = null;
        try {
            deft = Bookmark.parseBookmarks(sdeft);
        }
        catch (IOException | BookmarksException | SAXException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        org.autoplot.bookmarks.Util.loadRecent("pngwalkRecent", tool.dataSetSelector1, deft);
        Runnable run = new Runnable(){

            @Override
            public void run() {
                PngWalkTool.addFileEnabler(tool, parent);
            }
        };
        new Thread(run).start();
        JFrame frame = new JFrame("PNG Walk Viewer");
        frame.setIconImage(AutoplotUtil.getAutoplotIcon());
        frame.setJMenuBar(PngWalkTool.createMenuBar(tool, frame));
        AppManager.getInstance().addApplication(tool);
        frame.getContentPane().add(tool);
        frame.addWindowListener(AppManager.getInstance().getWindowListener(tool));
        frame.pack();
        frame.setLocationRelativeTo(parent);
        frame.setVisible(true);
        return tool;
    }

    private static void addFileEnabler(final PngWalkTool tool, final Window parent) {
        ActionEnabler enabler = new ActionEnabler(){

            @Override
            public boolean isActionEnabled(String filename) {
                String template = tool.getTemplate();
                int i0 = -1;
                if (i0 == -1) {
                    i0 = template.indexOf("_$Y");
                }
                if (i0 == -1) {
                    i0 = template.indexOf("_$o");
                }
                if (i0 == -1) {
                    i0 = template.indexOf("_$(o,");
                }
                String productFile = null;
                if (i0 == -1) {
                    try {
                        File file = DataSetURI.getFile(filename, (ProgressMonitor)new AlertNullProgressMonitor("get image file"));
                        String json = ImageUtil.getJSONMetadata(file);
                        if (json != null) {
                            if (i0 == -1) {
                                i0 = template.indexOf(42);
                            }
                            if (i0 == -1) {
                                i0 = template.indexOf("$x");
                            }
                        }
                        productFile = tool.baseurl + tool.product + ".vap";
                    }
                    catch (IOException ex) {
                        logger.log(Level.WARNING, null, ex);
                    }
                }
                if (i0 == -1) {
                    return false;
                }
                if (productFile == null) {
                    productFile = template.substring(0, i0) + ".vap";
                }
                try {
                    return WalkUtil.fileExists(productFile);
                }
                catch (URISyntaxException | FileSystem.FileSystemOfflineException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                    return false;
                }
            }
        };
        String lap = "View in Autoplot";
        tool.addFileAction(enabler, new AbstractAction("View in Autoplot"){

            @Override
            public void actionPerformed(ActionEvent e) {
                String suri;
                LoggerManager.logGuiEvent(e);
                if (tool.seq == null) {
                    suri = null;
                } else {
                    String timeRange;
                    int i0;
                    String s = tool.getSelectedFile();
                    String template = tool.getTemplate();
                    if (s.startsWith("file:/") && !s.startsWith("file:///") && template.startsWith("file:///")) {
                        s = "file:///" + s.substring(6);
                    }
                    DatumRange jsonTimeRange = null;
                    try {
                        File file = DataSetURI.getFile(s, (ProgressMonitor)new AlertNullProgressMonitor("get image file"));
                        String json = ImageUtil.getJSONMetadata(file);
                        if (json != null) {
                            jsonTimeRange = RichPngUtil.getXRange(json);
                        }
                    }
                    catch (IOException ex) {
                        logger.log(Level.WARNING, null, ex);
                    }
                    int i = template.indexOf(36);
                    if (i != -1) {
                        int i2 = i + 1;
                        if (i2 == template.length()) {
                            throw new IllegalArgumentException("template must start with $Y, $y or $(o,...)");
                        }
                        char c = template.charAt(i2);
                        while (i2 < template.length() && (Character.isDigit(c) || c == '(')) {
                            c = template.charAt(++i2);
                        }
                        if (i2 == template.length() || c != 'Y' && c != 'y' && c != 'o' && c != 'x') {
                            throw new IllegalArgumentException("template must start with $Y, $y or $(o,...)");
                        }
                    }
                    if ((i0 = template.indexOf("_$Y")) == -1) {
                        i0 = template.indexOf("_$y");
                    }
                    if (i0 == -1) {
                        i0 = template.indexOf("_$o");
                    }
                    if (i0 == -1) {
                        i0 = template.indexOf("_$(o,");
                    }
                    if (i0 == -1 && jsonTimeRange != null) {
                        if (i0 == -1) {
                            i0 = template.indexOf("_*");
                        }
                        if (i0 == -1) {
                            i0 = template.indexOf("_$x");
                        }
                    }
                    if (s.contains("//user@") && !template.contains("//user@")) {
                        s = s.replace("//user@", "//");
                    }
                    if (jsonTimeRange == null || !UnitsUtil.isTimeLocation(jsonTimeRange.getUnits())) {
                        TimeParser tp = TimeParser.create(template);
                        timeRange = s;
                        try {
                            DatumRange dr = tp.parse(timeRange).getTimeRange();
                            if (tp.getValidRange().equals(dr)) {
                                timeRange = null;
                            }
                            timeRange = dr.toString().replaceAll(" ", "+");
                        }
                        catch (ParseException ex) {
                            throw new RuntimeException(ex);
                        }
                    } else {
                        timeRange = jsonTimeRange.toString().replaceAll("\\s", "+");
                    }
                    String productFile = tool.product != null && tool.product.length() > 0 && tool.baseurl.length() > 1 ? tool.baseurl + tool.product + ".vap" : template.substring(0, i0) + ".vap";
                    if (timeRange != null) {
                        suri = productFile + "?timeRange=" + timeRange;
                    } else {
                        JOptionPane.showMessageDialog(ScriptContext.getViewWindow(), "unable to resolve time range from image metadata or filename.");
                        return;
                    }
                }
                Runnable run = new Runnable(){

                    @Override
                    public void run() {
                        ScriptContext.createGui();
                        Window apWindow = ScriptContext.getViewWindow();
                        if (suri != null) {
                            PngWalkTool.raiseApWindowSoon(apWindow);
                            ScriptContext.plot(suri);
                        }
                        if (parent == null) {
                            apWindow.setVisible(true);
                        }
                    }
                };
                new Thread(run).start();
            }
        });
    }

    protected static void copyToClipboard(Component parent, String ssrc) {
        File src;
        if (ssrc == null) {
            JOptionPane.showMessageDialog(parent, "No image is selected.");
            return;
        }
        try {
            src = FileSystemUtil.doDownload(ssrc, new NullProgressMonitor());
        }
        catch (IOException | URISyntaxException ex) {
            JOptionPane.showMessageDialog(parent, "<html>Unexpected error when downloading file<br>" + ssrc + "<br><br>" + ex.toString());
            return;
        }
        try {
            ImageSelection iss = new ImageSelection();
            iss.setImage(ImageIO.read(src));
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(iss, ImageSelection.getNullClipboardOwner());
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(parent, "<html>Unable to read image<br>" + ex.getMessage());
        }
    }

    protected static void saveLocalCopy(Component parent, String ssrc) {
        File src;
        Preferences prefs = AutoplotSettings.settings().getPreferences(PngWalkTool.class);
        String srecent = prefs.get(PREF_RECENT, System.getProperty("user.home"));
        if (ssrc == null) {
            JOptionPane.showMessageDialog(parent, "No image is selected.");
            return;
        }
        try {
            src = FileSystemUtil.doDownload(ssrc, new NullProgressMonitor());
        }
        catch (IOException | URISyntaxException ex) {
            JOptionPane.showMessageDialog(parent, "<html>Unexpected error when downloading file<br>" + ssrc + "<br><br>" + ex.toString());
            return;
        }
        JFileChooser chooser = new JFileChooser(srecent);
        JPanel accessoryPanel = new JPanel();
        accessoryPanel.setLayout(new BoxLayout(accessoryPanel, 1));
        JCheckBox r60 = new JCheckBox("Reduce to 60%");
        accessoryPanel.add(r60);
        chooser.setMultiSelectionEnabled(false);
        chooser.setAccessory(accessoryPanel);
        chooser.setSelectedFile(new File(chooser.getCurrentDirectory(), src.getName()));
        int r = chooser.showSaveDialog(parent);
        if (r == 0) {
            prefs.put(PREF_RECENT, chooser.getSelectedFile().getParent());
            try {
                if (r60.isSelected()) {
                    BufferedImage im = ImageIO.read(src);
                    int size = (int)Math.sqrt(im.getWidth() * im.getWidth() + im.getHeight() * im.getHeight());
                    im = ImageResize.getScaledInstance(im, size * 60 / 100);
                    String ext = chooser.getSelectedFile().toString();
                    int i = ext.lastIndexOf(".");
                    ext = ext.substring(i + 1);
                    ImageIO.write((RenderedImage)im, ext, chooser.getSelectedFile());
                } else if (!Util.copyFile(src, chooser.getSelectedFile())) {
                    JOptionPane.showMessageDialog(parent, "<html>Unable to save image to: <br>" + chooser.getSelectedFile());
                }
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(parent, "<html>Unable to save image to: <br>" + chooser.getSelectedFile() + "<br><br>" + ex.toString());
            }
        }
    }

    int nextInterval(int index) {
        Component c = this.tabs.getSelectedComponent();
        if (c instanceof PngWalkView) {
            PngWalkView v = (PngWalkView)c;
            return v.getNextInterval(index);
        }
        if (c instanceof JSplitPane) {
            if ((c = ((JSplitPane)c).getTopComponent()) instanceof PngWalkView) {
                PngWalkView v = (PngWalkView)c;
                return v.getNextInterval(index);
            }
            return index + 7;
        }
        return index + 7;
    }

    int nextPage(int index) {
        Component c = this.tabs.getSelectedComponent();
        if (c instanceof PngWalkView) {
            PngWalkView v = (PngWalkView)c;
            return v.getNextPage(index);
        }
        if (c instanceof JSplitPane) {
            if ((c = ((JSplitPane)c).getTopComponent()) instanceof PngWalkView) {
                PngWalkView v = (PngWalkView)c;
                return v.getNextPage(index);
            }
            return index + 7;
        }
        return index + 28;
    }

    int prevInterval(int index) {
        Component c = this.tabs.getSelectedComponent();
        if (c instanceof PngWalkView) {
            PngWalkView v = (PngWalkView)c;
            return v.getPrevInterval(index);
        }
        if (c instanceof JSplitPane) {
            if ((c = ((JSplitPane)c).getTopComponent()) instanceof PngWalkView) {
                PngWalkView v = (PngWalkView)c;
                return v.getPrevInterval(index);
            }
            return index + 7;
        }
        return index - 7;
    }

    int prevPage(int index) {
        Component c = this.tabs.getSelectedComponent();
        if (c instanceof PngWalkView) {
            PngWalkView v = (PngWalkView)c;
            return v.getPrevPage(index);
        }
        if (c instanceof JSplitPane) {
            if ((c = ((JSplitPane)c).getTopComponent()) instanceof PngWalkView) {
                PngWalkView v = (PngWalkView)c;
                return v.getPrevPage(index);
            }
            return index + 7;
        }
        return index - 28;
    }

    private static JMenuBar createMenuBar(final PngWalkTool tool, final JFrame frame) {
        JCheckBoxMenuItem qcmi;
        JMenuBar result = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.add(new AbstractAction("Save Local Copy..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                PngWalkTool.saveLocalCopy(tool, tool.getSelectedFile());
            }
        });
        fileMenu.add(new AbstractAction("Show Autoplot"){

            @Override
            public void actionPerformed(ActionEvent ae) {
                LoggerManager.logGuiEvent(ae);
                AppManager appman = AppManager.getInstance();
                for (int i = 0; i < appman.getApplicationCount(); ++i) {
                    if (!(appman.getApplication(i) instanceof AutoplotUI)) continue;
                    AutoplotUI.raiseApplicationWindow((AutoplotUI)appman.getApplication(i));
                    return;
                }
                if (AppManager.getInstance().getApplicationCount() == 1) {
                    ScriptContext.createGui();
                    Window apWindow = ScriptContext.getViewWindow();
                    PngWalkTool.raiseApWindowSoon(apWindow);
                }
            }
        });
        fileMenu.add(new AbstractAction("Close"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                if (AppManager.getInstance().getApplicationCount() == 1) {
                    if (0 == JOptionPane.showConfirmDialog(tool, "Quit application?", "Quit PNG Walk", 2)) {
                        frame.dispose();
                        AppManager.getInstance().closeApplication(tool);
                    }
                } else {
                    frame.dispose();
                    AppManager.getInstance().closeApplication(tool);
                }
            }
        });
        fileMenu.add(new AbstractAction("Quit"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                if (AppManager.getInstance().requestQuit()) {
                    frame.dispose();
                    AppManager.getInstance().quit();
                }
            }
        });
        result.add(fileMenu);
        JMenu navMenu = new JMenu("Navigate");
        navMenu.add(new AbstractAction("Go To Date..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                DatumRange dr = tool.seq.getTimeSpan();
                if (dr == null) {
                    JOptionPane.showMessageDialog(tool, "File times are not available");
                    return;
                }
                String str = JOptionPane.showInputDialog(tool, "Select date to display", TimeDatumFormatter.DAYS.format(TimeUtil.prevMidnight(dr.min())));
                if (str != null) {
                    try {
                        DatumRange ds = DatumRangeUtil.parseTimeRange(str);
                        tool.seq.gotoSubrange(ds);
                    }
                    catch (ParseException ex) {
                        try {
                            double d = Units.us2000.parse(str).doubleValue(Units.us2000);
                            tool.seq.gotoSubrange(DatumRange.newDatumRange(d, d, Units.us2000));
                        }
                        catch (ParseException ex2) {
                            JOptionPane.showMessageDialog(tool, "parse error: " + ex2);
                        }
                    }
                    catch (RuntimeException ex) {
                        tool.setStatus("warning: " + ex.toString());
                    }
                }
            }
        });
        navMenu.add(new AbstractAction("First"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                tool.seq.setIndex(0);
            }
        }).setAccelerator(KeyStroke.getKeyStroke(36, 0));
        navMenu.add(new AbstractAction("Previous Page"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                tool.seq.setIndex(tool.prevPage(tool.seq.getIndex()));
            }
        }).setAccelerator(KeyStroke.getKeyStroke(33, 0));
        navMenu.add(new AbstractAction("Previous Interval"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                tool.seq.setIndex(tool.prevInterval(tool.seq.getIndex()));
            }
        }).setAccelerator(KeyStroke.getKeyStroke(38, 0));
        navMenu.add(new AbstractAction("Previous Item"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                tool.seq.skipBy(-1);
            }
        }).setAccelerator(KeyStroke.getKeyStroke(37, 0));
        navMenu.add(new AbstractAction("Next Item"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                tool.seq.skipBy(1);
            }
        }).setAccelerator(KeyStroke.getKeyStroke(39, 0));
        navMenu.add(new AbstractAction("Next Interval"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                tool.seq.setIndex(tool.nextInterval(tool.seq.getIndex()));
            }
        }).setAccelerator(KeyStroke.getKeyStroke(40, 0));
        navMenu.add(new AbstractAction("Next Page"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                tool.seq.setIndex(tool.nextPage(tool.seq.getIndex()));
            }
        }).setAccelerator(KeyStroke.getKeyStroke(34, 0));
        navMenu.add(new AbstractAction("Last"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                tool.seq.setIndex(tool.seq.size() - 1);
            }
        }).setAccelerator(KeyStroke.getKeyStroke(35, 0));
        result.add(navMenu);
        tool.navMenu = navMenu;
        navMenu.setEnabled(tool.seq != null);
        JMenu optionsMenu = new JMenu("Options");
        final JCheckBoxMenuItem persMi = new JCheckBoxMenuItem("Use Perspective", true);
        persMi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((CoversWalkView)tool.views[4]).setPerspective(persMi.isSelected());
            }
        });
        optionsMenu.add(persMi);
        ButtonGroup buttonGroup1 = new ButtonGroup();
        JMenu thumbsizeMenu = new JMenu("Thumbnail Size");
        int[] sizes = new int[]{50, 100, 200, 400};
        for (int i = 0; i < sizes.length; ++i) {
            final int fsize = sizes[i];
            JCheckBoxMenuItem mi = new JCheckBoxMenuItem(new AbstractAction("" + fsize + " px"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LoggerManager.logGuiEvent(e);
                    tool.setThumbnailSize(fsize);
                }
            });
            buttonGroup1.add(mi);
            if (tool.getThumbnailSize() == sizes[i]) {
                buttonGroup1.setSelected(mi.getModel(), true);
            }
            thumbsizeMenu.add(mi);
        }
        optionsMenu.add(thumbsizeMenu);
        tool.qcFilterMenuItem = qcmi = new JCheckBoxMenuItem("Show Only Quality Control Records", false);
        JMenuItem qc = new JMenuItem(new AbstractAction("Start Quality Control Tool (QC)"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                if (!PngWalkTool.isQualityControlEnabled()) {
                    tool.startQC();
                }
            }
        });
        qc.setToolTipText("Start up the Quality Control tool that adds documentation to images.");
        optionsMenu.add(qc);
        qcmi.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (qcmi.isSelected()) {
                    tool.seq.setQCFilter("op");
                } else {
                    tool.seq.setQCFilter("");
                }
            }
        });
        qcmi.setToolTipText("show only QC records with Okay or Bad setting.");
        qcmi.setEnabled(false);
        optionsMenu.add(qcmi);
        JMenuItem dg = new JMenuItem(new AbstractAction("Start Digitizer"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                if (!tool.isDigitizerEnabled()) {
                    tool.startDigitizer();
                }
            }
        });
        dg.setToolTipText("Start up the Digitizer that receives pairs from the single view.  See http://autoplot.org/richPng.");
        optionsMenu.add(dg);
        result.add(optionsMenu);
        JMenu toolsMenu = new JMenu("Tools");
        JMenuItem writePdf = new JMenuItem(new AbstractAction("Write to PDF..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                tool.writePdf();
            }
        });
        writePdf.setToolTipText("Write the visible images to a PDF file with last QC annotation.");
        toolsMenu.add(writePdf);
        result.add(toolsMenu);
        JMenuItem writeGif = new JMenuItem(new AbstractAction("Write to Animated GIF..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                tool.writeAnimatedGif();
            }
        });
        writeGif.setToolTipText("Write the visible images to an animated GIF file.");
        toolsMenu.add(writeGif);
        JMenuItem writeHtml = new JMenuItem(new AbstractAction("Write to HTML..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                LoggerManager.logGuiEvent(e);
                tool.writeHtml();
            }
        });
        writeHtml.setToolTipText("Write the visible images to an HTML file.");
        toolsMenu.add(writeHtml);
        result.add(toolsMenu);
        final JMenu bookmarksMenu = new JMenu("Bookmarks");
        final BookmarksManager man = new BookmarksManager((Frame)frame, true, "PNG Bookmarks");
        man.getModel().addPropertyChangeListener("list", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                man.updateBookmarks(bookmarksMenu, tool.getSelector());
            }
        });
        man.setVisible(false);
        man.setPrefNode("pngwalk", "autoplot.default.pngwalk.bookmarks", "http://autoplot.org/data/pngwalk.demos.xml");
        man.updateBookmarks(bookmarksMenu, tool.getSelector());
        result.add(bookmarksMenu);
        return result;
    }

    public PngWalkTool() {
        this.initComponents();
        this.setNavButtonsEnabled(false);
        this.dataSetSelector1.setEnableDataSource(false);
        this.dataSetSelector1.setAcceptPattern("(?i).*(\\.gif|\\.png|\\.jpg|\\.pngwalk)");
        this.dataSetSelector1.setSuggestFiles(false);
        this.dataSetSelector1.addSuggestFile(".*\\.pngwalk");
        this.dataSetSelector1.registerActionTrigger(".*\\.pngwalk", new AbstractAction("pngwalk"){

            @Override
            public void actionPerformed(ActionEvent ev) {
                String template = PngWalkTool.this.dataSetSelector1.getValue();
                if (template.endsWith(".pngwalk")) {
                    Map m = PngWalkTool.readPngwalkFile(template);
                    template = (String)m.get("template");
                    PngWalkTool.this.product = (String)m.get("product");
                    PngWalkTool.this.baseurl = (String)m.get("baseurl");
                    PngWalkTool.this.baseurl = PngWalkTool.checkRelativeBaseurl(PngWalkTool.this.baseurl, template, PngWalkTool.this.product);
                }
                PngWalkTool.this.setTemplate(template);
            }
        });
        this.views = new PngWalkView[7];
        this.views[0] = new GridPngWalkView(null);
        this.views[1] = new RowPngWalkView(null);
        this.views[2] = new SinglePngWalkView(null);
        this.views[3] = new SinglePngWalkView(null);
        this.views[4] = new CoversWalkView(null);
        this.views[5] = new SinglePngWalkView(null);
        this.views[6] = new ContextFlowView(null);
        ((SinglePngWalkView)this.views[2]).clickDigitizer.setViewer(this);
        final int SCROLLBAR_HEIGHT = (int)Math.round(new JScrollPane().getHorizontalScrollBar().getPreferredSize().getHeight());
        final JSplitPane filmStripSplitPane = new JSplitPane(0, this.views[1], this.views[2]);
        filmStripSplitPane.setDividerLocation(this.getThumbnailSize() + (int)(1.2 * (double)SCROLLBAR_HEIGHT));
        this.views[1].addPropertyChangeListener(PROP_THUMBNAILSIZE, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                filmStripSplitPane.setDividerLocation((Integer)evt.getNewValue() + SCROLLBAR_HEIGHT);
            }
        });
        filmStripSplitPane.setMinimumSize(new Dimension(640, 480));
        filmStripSplitPane.setPreferredSize(new Dimension(640, 480));
        final JSplitPane coversSplitPane = new JSplitPane(0, this.views[4], this.views[5]);
        coversSplitPane.setDividerLocation(this.getThumbnailSize() + (int)(1.2 * (double)SCROLLBAR_HEIGHT));
        this.views[4].addPropertyChangeListener(PROP_THUMBNAILSIZE, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                coversSplitPane.setDividerLocation((Integer)evt.getNewValue() + SCROLLBAR_HEIGHT);
            }
        });
        coversSplitPane.setMinimumSize(new Dimension(640, 480));
        coversSplitPane.setPreferredSize(new Dimension(640, 480));
        this.tabs = new TearoffTabbedPane();
        this.tabs.addTab("Single", new JScrollPane(this.views[3]));
        this.tabs.addTab("ContextFlow", this.views[6]);
        this.tabs.addTab("Grid", this.views[0]);
        this.tabs.addTab("Film Strip", filmStripSplitPane);
        this.tabs.addTab("Covers", coversSplitPane);
        this.tabs.setSelectedIndex(3);
        for (PngWalkView view : this.views) {
            view.getMouseTarget().addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2 && PngWalkTool.this.digitizer == null) {
                        int oldIndex = PngWalkTool.this.tabs.getSelectedIndex();
                        if (oldIndex == 0) {
                            PngWalkTool.this.tabs.setSelectedIndex(PngWalkTool.this.returnTabIndex);
                        } else {
                            PngWalkTool.this.tabs.setSelectedIndex(0);
                            PngWalkTool.this.returnTabIndex = oldIndex;
                        }
                    }
                }
            });
        }
        this.tabs.setFocusable(false);
        this.nextButton.requestFocus();
        if (PngWalkTool.isQualityControlEnabled()) {
            this.qcPanel = new QualityControlPanel();
            JSplitPane qcPane = new JSplitPane(1, true, this.tabs, this.qcPanel);
            qcPane.setResizeWeight(1.0);
            this.pngsPanel.add(qcPane);
            this.qcPanel.setWalkImageSequece(this.seq);
        } else {
            this.pngsPanel.add(this.tabs);
        }
        this.pngsPanel.revalidate();
        BindingGroup bc = new BindingGroup();
        for (PngWalkView view : this.views) {
            AutoBinding b = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)view, (Property)BeanProperty.create((String)PROP_THUMBNAILSIZE), (Object)this, (Property)BeanProperty.create((String)PROP_THUMBNAILSIZE));
            bc.addBinding((Binding)b);
        }
        bc.bind();
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (PngWalkTool.this.seq != null && PngWalkTool.this.seq.size() != 0) {
                    PngWalkTool.this.seq.skipBy(e.getWheelRotation());
                }
            }
        });
        this.setStatus("ready");
    }

    private void processArguments(ArgumentList alm) {
        String tab = alm.getValue("mode");
        if (tab.equalsIgnoreCase("filmStrip")) {
            this.tabs.setSelectedIndex(3);
        } else if (tab.equalsIgnoreCase("single")) {
            this.tabs.setSelectedIndex(0);
        } else if (tab.equalsIgnoreCase("contextFlow")) {
            this.tabs.setSelectedIndex(1);
        } else if (tab.equalsIgnoreCase("grid")) {
            this.tabs.setSelectedIndex(2);
        } else if (tab.equalsIgnoreCase("film strip")) {
            this.tabs.setSelectedIndex(3);
        } else if (tab.equalsIgnoreCase("covers")) {
            this.tabs.setSelectedIndex(4);
        }
        String show = alm.getValue("goto");
        if (!show.equals("") && this.seq != null) {
            try {
                if (this.seq.getTimeSpan() != null) {
                    this.seq.gotoSubrange(DatumRangeUtil.parseTimeRange(show));
                }
                this.pendingGoto = DatumRangeUtil.parseTimeRange(show);
            }
            catch (ParseException ex) {
                throw new RuntimeException(ex);
            }
        } else {
            logger.fine("show was empty or seq was null");
        }
    }

    private void setNavButtonsEnabled(boolean enabled) {
        this.jumpToFirstButton.setEnabled(enabled);
        this.jumpToLastButton.setEnabled(enabled);
        this.prevButton.setEnabled(enabled);
        this.nextButton.setEnabled(enabled);
        this.nextSetButton.setEnabled(enabled);
        this.prevSetButton.setEnabled(enabled);
    }

    public void setTemplate(String template) {
        if (template.contains("%") && !template.contains("$") && (template = template.replaceAll("\\%", "\\$")).contains("{") && !template.contains("(")) {
            template = template.replaceAll("\\{", "(");
            template = template.replaceAll("\\}", ")");
        }
        URISplit split = URISplit.parse(template);
        LinkedHashMap<String, String> params = URISplit.parseParams(split.params);
        this.dataSetSelector1.setValue(template);
        WalkImageSequence oldseq = this.seq;
        URI uri = DataSetURI.getResourceURI(template);
        if (uri == null) {
            throw new IllegalArgumentException("Unable to parse: " + template);
        }
        String surl = DataSetURI.fromUri(uri);
        try {
            this.seq = new WalkImageSequence(surl);
            String tr = (String)params.get("timerange");
            if (tr != null) {
                try {
                    DatumRange trdr = DatumRangeUtil.parseTimeRange(tr);
                    this.seq.setTimerange(trdr);
                }
                catch (ParseException ex) {
                    this.setMessage(ERROR_ICON, "unable to parse timerange");
                }
            }
            this.setNavButtonsEnabled(true);
            if (this.navMenu != null) {
                this.navMenu.setEnabled(true);
            }
            this.seq.setQCFilter("");
            if (this.qcFilterMenuItem != null) {
                this.qcFilterMenuItem.setSelected(false);
            }
            if (this.qcPanel != null) {
                this.qcPanel.setWalkImageSequece(this.seq);
            }
        }
        catch (Exception ex) {
            this.seq = null;
            this.setNavButtonsEnabled(false);
            if (this.navMenu != null) {
                this.navMenu.setEnabled(false);
            }
            logger.log(Level.WARNING, ex.getMessage(), ex);
        }
        if (oldseq != null) {
            oldseq.removePropertyChangeListener("index", this.indexListener);
            oldseq.removePropertyChangeListener(PROP_STATUS, this.statusListener);
            if (ENABLE_QUALITY_CONTROL) {
                oldseq.removePropertyChangeListener("badgeChange", this.qcStatusListener);
            }
            oldseq.removePropertyChangeListener(PROP_TIMERANGE, this.seqTimeRangeListener);
            oldseq.removePropertyChangeListener("index", this.seqIndexListener);
        }
        if (this.seq != null) {
            this.seq.addPropertyChangeListener("index", this.indexListener);
            this.seq.addPropertyChangeListener(PROP_STATUS, this.statusListener);
            if (ENABLE_QUALITY_CONTROL) {
                this.seq.addPropertyChangeListener("badgeChange", this.qcStatusListener);
            }
            this.seq.addPropertyChangeListener(PROP_TIMERANGE, this.seqTimeRangeListener);
            this.seq.addPropertyChangeListener("index", this.seqIndexListener);
        }
        if (template.length() == 0) {
            this.setStatus("Enter the location of a pngwalk file by providing a template for the files, such as /tmp/$Y$m$d.png");
            return;
        }
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    PngWalkTool.this.seq.initialLoad();
                    if (PngWalkTool.this.pendingGoto != null) {
                        PngWalkTool.this.seq.gotoSubrange(PngWalkTool.this.pendingGoto);
                        PngWalkTool.this.pendingGoto = null;
                    }
                }
                catch (IOException e) {
                    if (!PngWalkTool.this.getStatus().startsWith("error")) {
                        PngWalkTool.this.setStatus("error:" + e.getMessage());
                    }
                    throw new RuntimeException(e);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PngWalkTool.this.updateInitialGui();
                    }
                });
            }
        };
        new Thread(run).start();
    }

    private void updateInitialGui() {
        ArrayList<String> urls = new ArrayList<String>();
        List<String> recent = this.dataSetSelector1.getRecent();
        recent.removeAll(Collections.singleton(this.seq.getTemplate()));
        for (String string : recent) {
            urls.add(string);
        }
        urls.add(this.seq.getTemplate());
        this.dataSetSelector1.setRecent(urls);
        this.useRangeCheckBox.setEnabled(this.seq.getTimeSpan() != null);
        this.useRangeCheckBox.setSelected(false);
        this.editRangeButton.setEnabled(false);
        this.timeFilterTextField.setEnabled(false);
        this.timeFilterTextField.setText("");
        if (this.seq.size() == 0) {
            Container p = SwingUtilities.getWindowAncestor(this);
            if (p == null) {
                p = this.parentWindow;
            }
            if (this.getX() != 0) {
                p = this;
            }
            JOptionPane.showMessageDialog(p, "<html>Unable to find any images in sequence:<br>" + this.seq.getTemplate());
            return;
        }
        DatumRange tr = this.seq.currentImage().getDatumRange();
        if (tr != null) {
            this.setTimeRange(tr);
        }
        this.showMissingCheckBox.setEnabled(this.seq.getTimeSpan() != null);
        if (this.seq.getTimeSpan() == null) {
            this.showMissingCheckBox.setEnabled(false);
            this.showMissingCheckBox.setSelected(false);
        } else {
            this.seq.setShowMissing(this.showMissingCheckBox.isSelected());
        }
        for (PngWalkView v : this.views) {
            v.setSequence(this.seq);
        }
        if (this.seq.size() == 0) {
            this.setStatus("warning: no files found in " + this.seq.getTemplate());
        } else {
            this.indexListener.propertyChange(null);
            if (this.qcPanel != null) {
                this.qcPanel.setWalkImageSequece(this.seq);
                if (this.seq.getIndex() < this.seq.size()) {
                    if (this.seq.getQualityControlSequence() != null) {
                        QualityControlRecord qualityControlRecord = this.seq.getQualityControlSequence().getQualityControlRecord(this.seq.getIndex());
                        this.qcPanel.displayRecord(qualityControlRecord);
                        int[] n = this.seq.getQualityControlSequence().getQCTotals();
                        this.qcPanel.setStatus(n[0], n[1], n[2], n[3]);
                    }
                } else {
                    this.qcPanel.setStatus(0, 0, 0, 0);
                }
            }
        }
    }

    public String getTemplate() {
        return this.seq.getTemplate();
    }

    public int getThumbnailSize() {
        return this.thumbnailSize;
    }

    public void setThumbnailSize(int thumbnailSize) {
        int oldThumbnailSize = this.thumbnailSize;
        this.thumbnailSize = thumbnailSize;
        this.firePropertyChange(PROP_THUMBNAILSIZE, oldThumbnailSize, thumbnailSize);
    }

    public DatumRange getTimeRange() {
        DatumRange tr = null;
        tr = this.seq.imageAt(this.seq.getIndex()).getDatumRange();
        if (tr != null) {
            return tr;
        }
        return this.timeRange;
    }

    public void setTimeRange(DatumRange timeRange) {
        boolean setting0 = this.setting;
        this.setting = true;
        DatumRange old = this.timeRange;
        this.timeRange = timeRange;
        if (this.seq != null && timeRange != null) {
            this.seq.gotoSubrange(timeRange);
        }
        if (setting0) {
            this.firePropertyChange(PROP_TIMERANGE, old, timeRange);
        }
        this.setting = false;
    }

    public QDataSet getMousePressLocation() {
        return this.mousePressLocation;
    }

    public void setMousePressLocation(QDataSet mousePressLocation) {
        QDataSet oldMousePressLocation = this.mousePressLocation;
        this.mousePressLocation = mousePressLocation;
        this.firePropertyChange(PROP_MOUSEPRESSLOCATION, oldMousePressLocation, mousePressLocation);
    }

    public QDataSet getMouseReleaseLocation() {
        return this.mouseReleaseLocation;
    }

    public void setMouseReleaseLocation(QDataSet mouseReleaseLocation) {
        QDataSet oldMouseReleaseLocation = this.mouseReleaseLocation;
        this.mouseReleaseLocation = mouseReleaseLocation;
        this.firePropertyChange(PROP_MOUSERELEASELOCATION, oldMouseReleaseLocation, mouseReleaseLocation);
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String message) {
        String oldStatus = this.status;
        this.status = message;
        if (message.startsWith("busy:")) {
            this.setMessage(BUSY_ICON, message.substring(5).trim());
            logger.finer(message);
        } else if (message.startsWith("warning:")) {
            this.setMessage(WARNING_ICON, message.substring(8).trim());
            logger.warning(message);
        } else if (message.startsWith("error:")) {
            this.setMessage(ERROR_ICON, message.substring(6).trim());
            logger.severe(message);
        } else {
            logger.fine(message);
            this.setMessage(message);
        }
        this.firePropertyChange(PROP_STATUS, oldStatus, message);
    }

    public void setMessage(String message) {
        this.statusLabel.setIcon(IDLE_ICON);
        this.statusLabel.setText(message);
    }

    public void setMessage(Icon icon, String message) {
        String myMess;
        if (message == null) {
            message = "<null>";
        }
        if ((myMess = message).length() > 100) {
            myMess = myMess.substring(0, 100) + "...";
        }
        this.statusLabel.setIcon(icon);
        this.statusLabel.setText(myMess);
        this.statusLabel.setToolTipText(message);
    }

    public void startQC() {
        if (!PngWalkTool.isQualityControlEnabled()) {
            this.qcPanel = new QualityControlPanel();
            this.tabs.add("Quality Control", this.qcPanel);
            if (this.seq != null) {
                this.qcPanel.setWalkImageSequece(this.seq);
                this.seq.addPropertyChangeListener("badgeChange", this.qcStatusListener);
            }
            ENABLE_QUALITY_CONTROL = true;
        }
        this.qcFilterMenuItem.setEnabled(true);
    }

    public void startDigitizer() {
        if (this.digitizer == null) {
            this.digitizer = new DataPointRecorder();
            this.digitizer.addDataSetUpdateListener(new DataSetUpdateListener(){

                @Override
                public void dataSetUpdated(DataSetUpdateEvent e) {
                    for (PngWalkView v : PngWalkTool.this.views) {
                        if (!(v instanceof SinglePngWalkView)) continue;
                        v.repaint();
                    }
                }
            });
            this.digitizer.addDataPointSelectionListener(new DataPointSelectionListener(){

                @Override
                public void dataPointSelected(DataPointSelectionEvent e) {
                    String image = e.getPlane("image").toString();
                    int i = PngWalkTool.this.seq.findIndex(image);
                    if (i > -1) {
                        PngWalkTool.this.seq.setIndex(i);
                    }
                }
            });
            this.tabs.add("Digitizer", this.digitizer);
            for (PngWalkView v : this.views) {
                if (!(v instanceof SinglePngWalkView)) continue;
                ((SinglePngWalkView)v).clickDigitizer.setViewer(this);
            }
            JComboBox<String> annoType = new JComboBox<String>(new String[]{"| vertical line", "+ cross hairs", ". dots"});
            this.digitizer.addAccessory(annoType);
            annoType.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    PngWalkTool.this.annoTypeChar = e.getItem().toString().charAt(0);
                    for (PngWalkView v : PngWalkTool.this.views) {
                        if (!(v instanceof SinglePngWalkView)) continue;
                        v.repaint();
                    }
                }
            });
            this.digitizerRecording = true;
        }
    }

    private boolean isDigitizerEnabled() {
        return this.digitizer != null;
    }

    public DataPointRecorder getDigitizerDataPointRecorder() {
        return this.digitizer;
    }

    public void setDigitizerRecording(boolean enable) {
        this.digitizerRecording = enable;
    }

    public void addFileAction(ActionEnabler match, Action abstractAction) {
        this.actionEnablers.add(match);
        JButton b = new JButton(abstractAction);
        this.actionButtons.add(b);
        this.actionButtonsPanel.add(b);
        this.revalidate();
    }

    public void addActionComponent(JComponent c, PropertyChangeListener p) {
        if (c != null) {
            this.actionButtonsPanel.add(c);
        }
        if (p != null) {
            this.addPropertyChangeListener(PROP_SELECTED_NAME, p);
            this.addPropertyChangeListener(PROP_TIMERANGE, p);
            this.addPropertyChangeListener(PROP_MOUSEPRESSLOCATION, p);
            this.addPropertyChangeListener(PROP_MOUSERELEASELOCATION, p);
        }
        this.revalidate();
    }

    public void removeActionComponent(JComponent c, PropertyChangeListener p) {
        if (c != null) {
            this.actionButtonsPanel.remove(c);
        }
        if (p != null) {
            this.removePropertyChangeListener(PROP_SELECTED_NAME, p);
            this.removePropertyChangeListener(PROP_TIMERANGE, p);
            this.removePropertyChangeListener(PROP_MOUSEPRESSLOCATION, p);
            this.removePropertyChangeListener(PROP_MOUSERELEASELOCATION, p);
        }
        this.revalidate();
    }

    public String getSelectedFile() {
        if (this.seq == null) {
            return null;
        }
        return DataSetURI.fromUri(this.seq.currentImage().getUri());
    }

    public String getSelectedName() {
        if (this.seq.size() > 0) {
            return this.seq.getSelectedName();
        }
        return "";
    }

    public void setSelectedName(String name) {
        String oldName = this.getSelectedName();
        int i = this.seq.findIndex(name);
        if (i != -1) {
            this.seq.setIndex(i);
        }
        this.firePropertyChange(PROP_SELECTED_NAME, oldName, name);
    }

    public BufferedImage getSelectedImage() {
        return this.seq.currentImage().getImage();
    }

    DataSetSelector getSelector() {
        return this.dataSetSelector1;
    }

    public static boolean isQualityControlEnabled() {
        return ENABLE_QUALITY_CONTROL;
    }

    public void setQCStatus(String text, QualityControlRecord.Status status) {
        if (this.qcPanel == null) {
            throw new IllegalArgumentException("QC Panel must be started");
        }
        this.qcPanel.setStatus(text, status);
        this.repaint();
    }

    private void initComponents() {
        this.pngsPanel = new JPanel();
        this.timeFilterTextField = new JTextField();
        this.actionButtonsPanel = new JPanel();
        this.jPanel1 = new JPanel();
        this.prevSetButton = new JButton();
        this.prevButton = new JButton();
        this.nextButton = new JButton();
        this.nextSetButton = new JButton();
        this.jumpToFirstButton = new JButton();
        this.jumpToLastButton = new JButton();
        this.dataSetSelector1 = new DataSetSelector();
        this.statusLabel = new JLabel();
        this.showMissingCheckBox = new JCheckBox();
        this.useRangeCheckBox = new JCheckBox();
        this.editRangeButton = new JButton();
        this.pngsPanel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.pngsPanel.setLayout(new BorderLayout());
        this.timeFilterTextField.setToolTipText("Enter a time range, for example a year like \"2009\", or month \"2009 may\", or \"2009-01-01 to 2009-03-10\"\n");
        this.timeFilterTextField.setEnabled(false);
        this.timeFilterTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PngWalkTool.this.timeFilterTextFieldActionPerformed(evt);
            }
        });
        this.timeFilterTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                PngWalkTool.this.timeFilterTextFieldFocusLost(evt);
            }
        });
        this.actionButtonsPanel.setLayout(new FlowLayout(2));
        this.prevSetButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/prevPrevPrev.png")));
        this.prevSetButton.setToolTipText("Skip to previous interval");
        this.prevSetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PngWalkTool.this.prevSetButtonActionPerformed(evt);
            }
        });
        this.prevButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/prevPrev.png")));
        this.prevButton.setToolTipText("previous");
        this.prevButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PngWalkTool.this.prevButtonActionPerformed(evt);
            }
        });
        this.nextButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/nextNext.png")));
        this.nextButton.setToolTipText("next");
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PngWalkTool.this.nextButtonActionPerformed(evt);
            }
        });
        this.nextSetButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/nextNextNext.png")));
        this.nextSetButton.setToolTipText("Skip to next interval");
        this.nextSetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PngWalkTool.this.nextSetButtonActionPerformed(evt);
            }
        });
        this.jumpToFirstButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/prevPrevPrevStop.png")));
        this.jumpToFirstButton.setToolTipText("jump to first");
        this.jumpToFirstButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PngWalkTool.this.jumpToFirstButtonActionPerformed(evt);
            }
        });
        this.jumpToLastButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/nextNextNextStop.png")));
        this.jumpToLastButton.setToolTipText("jump to last");
        this.jumpToLastButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PngWalkTool.this.jumpToLastButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap(112, Short.MAX_VALUE).add((Component)this.jumpToFirstButton).addPreferredGap(0).add((Component)this.prevSetButton).addPreferredGap(0).add((Component)this.prevButton).add(39, 39, 39).add((Component)this.nextButton).addPreferredGap(0).add((Component)this.nextSetButton).addPreferredGap(0).add((Component)this.jumpToLastButton)));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.prevButton).add((Component)this.prevSetButton).add((Component)this.jumpToFirstButton).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.nextButton).add((Component)this.nextSetButton).add((Component)this.jumpToLastButton)));
        jPanel1Layout.linkSize(new Component[]{this.nextButton, this.nextSetButton, this.prevButton, this.prevSetButton}, 2);
        this.dataSetSelector1.setToolTipText("Enter the location of the images as a wildcard (/tmp/*.png) or template (/tmp/$Y$m$d.png).  .png, .gif, and .jpg files are supported.");
        this.dataSetSelector1.setPromptText("Enter images filename template");
        this.dataSetSelector1.setValue("");
        this.dataSetSelector1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PngWalkTool.this.dataSetSelector1ActionPerformed(evt);
            }
        });
        this.statusLabel.setText("starting application...");
        this.showMissingCheckBox.setText("Show Missing");
        this.showMissingCheckBox.setToolTipText("Insert placeholder images where there are gaps detected in the sequence");
        this.showMissingCheckBox.setEnabled(false);
        this.showMissingCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                PngWalkTool.this.showMissingCheckBoxItemStateChanged(evt);
            }
        });
        this.showMissingCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PngWalkTool.this.showMissingCheckBoxActionPerformed(evt);
            }
        });
        this.useRangeCheckBox.setText("Limit range to:");
        this.useRangeCheckBox.setToolTipText("Limit the time range of the images in the sequence.");
        this.useRangeCheckBox.setEnabled(false);
        this.useRangeCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                PngWalkTool.this.useRangeCheckBoxItemStateChanged(evt);
            }
        });
        this.editRangeButton.setText("Select...");
        this.editRangeButton.setEnabled(false);
        this.editRangeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PngWalkTool.this.editRangeButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (Component)this.pngsPanel, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jPanel1, -2, -1, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.actionButtonsPanel, -2, 463, -2)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(12, 12, 12).add((Component)this.useRangeCheckBox).addPreferredGap(0).add((Component)this.timeFilterTextField, -2, 236, -2).add(12, 12, 12).add((Component)this.editRangeButton).add(18, 18, 18).add((Component)this.showMissingCheckBox)).add((Component)this.dataSetSelector1, -1, -1, Short.MAX_VALUE))).add((Component)this.statusLabel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.pngsPanel, -1, 638, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.dataSetSelector1, -2, 27, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.timeFilterTextField, -2, -1, -2).add((Component)this.useRangeCheckBox).add((Component)this.editRangeButton).add((Component)this.showMissingCheckBox)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.actionButtonsPanel, -1, -1, Short.MAX_VALUE).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.statusLabel)));
    }

    private void nextButtonActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        this.seq.skipBy(1);
    }

    private void prevButtonActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        this.seq.skipBy(-1);
    }

    private void nextSetButtonActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        this.seq.setIndex(this.nextInterval(this.seq.getIndex()));
    }

    private void prevSetButtonActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        this.seq.setIndex(this.prevInterval(this.seq.getIndex()));
    }

    private void timeFilterTextFieldActionPerformed(ActionEvent evt) {
        try {
            LoggerManager.logGuiEvent(evt);
            this.timeFilterTextField.setBackground(this.dataSetSelector1.getBackground());
            DatumRange range = DatumRangeUtil.parseTimeRange(this.timeFilterTextField.getText());
            this.seq.setActiveSubrange(range);
        }
        catch (ParseException ex) {
            this.timeFilterTextField.setBackground(Color.PINK);
        }
    }

    private void timeFilterTextFieldFocusLost(FocusEvent evt) {
    }

    private void jumpToLastButtonActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        this.seq.last();
    }

    private void jumpToFirstButtonActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        this.seq.first();
    }

    private void dataSetSelector1ActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        String t = this.dataSetSelector1.getValue();
        if (t.endsWith(".pngwalk")) {
            Map m = PngWalkTool.readPngwalkFile(t);
            t = (String)m.get("template");
            this.baseurl = PngWalkTool.checkRelativeBaseurl(this.baseurl, t, (String)m.get("product"));
        }
        this.setTemplate(t);
        this.nextButton.requestFocus();
    }

    private void showMissingCheckBoxItemStateChanged(ItemEvent evt) {
        this.seq.setShowMissing(evt.getStateChange() == 1);
    }

    private void editRangeButtonActionPerformed(ActionEvent evt) {
        LoggerManager.logGuiEvent(evt);
        Frame myFrame = (Frame)SwingUtilities.getWindowAncestor(this);
        SubrangeEditorDialog d = new SubrangeEditorDialog(myFrame, true);
        List<DatumRange> times = this.seq.getAllTimes();
        d.setTimeSpan(times);
        if (this.seq.isUseSubRange()) {
            List<DatumRange> sub = this.seq.getActiveSubrange();
            d.setStartIndex(times.indexOf(sub.get(0)));
            d.setEndIndex(times.indexOf(sub.get(sub.size() - 1)));
        }
        d.setVisible(true);
        if (d.isOkClicked()) {
            this.seq.setActiveSubrange(d.getStartIndex(), d.getEndIndex());
            DatumRange range = new DatumRange(times.get(d.getStartIndex()).min(), times.get(d.getEndIndex()).max());
            this.timeFilterTextField.setText(range.toString());
        }
    }

    private void useRangeCheckBoxItemStateChanged(ItemEvent evt) {
        boolean enable = evt.getStateChange() == 1;
        this.seq.setUseSubRange(enable);
        this.timeFilterTextField.setEnabled(enable);
        this.editRangeButton.setEnabled(enable);
        if (!enable) {
            return;
        }
        List<DatumRange> current = this.seq.getActiveSubrange();
        DatumRange range = DatumRangeUtil.union(current.get(0), current.get(current.size() - 1));
        this.timeFilterTextField.setText(range.toString());
    }

    private void showMissingCheckBoxActionPerformed(ActionEvent evt) {
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    public TearoffTabbedPane getTabs() {
        return this.tabs;
    }

    public WalkImageSequence getSequence() {
        return this.seq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToHtmlImmediately(ProgressMonitor monitor, File f, String summary) throws FileNotFoundException {
        URI base;
        monitor.setTaskSize(this.seq.size());
        monitor.started();
        if (this.seq.getQCFolder() != null) {
            base = this.seq.getQCFolder();
        } else {
            int splitIndex = -1;
            if (splitIndex == -1) {
                splitIndex = WalkUtil.splitIndex(this.seq.getTemplate());
            }
            try {
                base = new URI(this.seq.getTemplate().substring(0, splitIndex));
            }
            catch (URISyntaxException ex) {
                throw new RuntimeException(ex);
            }
        }
        boolean writeInSitu = this.seq.getQCFolder().relativize(f.toURI()).toString().trim().length() == 0;
        try {
            for (int i = 0; i < this.seq.size(); ++i) {
                monitor.setTaskProgress(i);
                if (monitor.isCancelled()) {
                    break;
                }
                BufferedImage im = this.seq.imageAt(i).getImage();
                while (im == null) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ex) {
                        throw new RuntimeException(ex);
                    }
                    im = this.seq.imageAt(i).getImage();
                }
                try {
                    if (writeInSitu) continue;
                    String n = base.relativize(this.seq.imageAt(i).getUri()).getPath();
                    ImageIO.write((RenderedImage)im, "png", new File(f, n));
                    File qcFile = new File(this.seq.imageAt(i).getUri().getPath() + ".ok");
                    if (qcFile.exists()) {
                        FileUtil.fileCopy(qcFile, new File(f, n + ".ok"));
                    }
                    if (!(qcFile = new File(this.seq.imageAt(i).getUri().getPath() + ".problem")).exists()) continue;
                    FileUtil.fileCopy(qcFile, new File(f, n + ".problem"));
                    continue;
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
            }
        }
        finally {
            monitor.finished();
        }
        try {
            URL url = new URL("http://autoplot.org/data/tools/makeTutorialHtml.jy");
            DasProgressPanel mon = DasProgressPanel.createFramed(SwingUtilities.getWindowAncestor(this), "write HTML");
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("dir", base.toString());
            params.put("qconly", "T");
            params.put("outdir", f.toString());
            params.put("name", "");
            params.put("summary", summary);
            try {
                JythonUtil.invokeScriptSoon(url, null, params, false, false, (ProgressMonitor)mon);
            }
            catch (IOException ex) {
                Logger.getLogger(PngWalkTool.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public void writeHtml() {
        JFileChooser choose = new JFileChooser();
        Preferences prefs = Preferences.userNodeForPackage(PngWalkTool.class);
        String fname = prefs.get("writeToHtml", "/tmp/pngwalk/");
        choose.setFileSelectionMode(1);
        choose.setSelectedFile(new File(fname));
        final HtmlOutputOptions hoo = new HtmlOutputOptions();
        choose.setAccessory(hoo);
        if (choose.showSaveDialog(this) == 0) {
            final File f = choose.getSelectedFile();
            prefs.put("writeToHtml", f.toString());
            final DasProgressPanel mon = DasProgressPanel.createFramed(SwingUtilities.getWindowAncestor(this), "write html");
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    try {
                        PngWalkTool.this.writeToHtmlImmediately(mon, f, hoo.getTitle());
                    }
                    catch (FileNotFoundException ex) {
                        logger.log(Level.SEVERE, null, ex);
                    }
                }
            };
            new Thread(run).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToPdfImmediately(ProgressMonitor monitor, File f) throws FileNotFoundException {
        try {
            monitor.setTaskSize(this.seq.size());
            monitor.started();
            int imageNumber = 1;
            FileOutputStream out = new FileOutputStream(f);
            Rectangle rect = new Rectangle(612.0f, 792.0f);
            Document doc = new Document(rect, 0.0f, 0.0f, 0.0f, 0.0f);
            doc.addCreator("autoplotPngwalkTool");
            doc.addCreationDate();
            PdfWriter writer = PdfWriter.getInstance((Document)doc, (OutputStream)out);
            doc.open();
            QualityControlSequence qcseq = this.seq.getQualityControlSequence();
            for (int i = 0; i < this.seq.size(); ++i) {
                monitor.setTaskProgress(i);
                PdfContentByte cb = writer.getDirectContent();
                cb.saveState();
                BufferedImage im = this.seq.imageAt(i).getImage();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    QualityControlRecord r;
                    while (im == null) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException ex) {
                            throw new RuntimeException(ex);
                        }
                        im = this.seq.imageAt(i).getImage();
                    }
                    ImageIO.write((RenderedImage)im, "png", baos);
                    Image pdfImage = Image.getInstance((byte[])baos.toByteArray());
                    int w = 540;
                    int h = w * im.getHeight() / im.getWidth();
                    pdfImage.setAbsolutePosition(36.0f, (float)(756 - h));
                    pdfImage.scaleToFit((float)w, (float)h);
                    cb.addImage(pdfImage);
                    doc.add((Element)pdfImage.rectangle(36.0f, (float)(756 - h)));
                    String caption = qcseq != null ? ((r = qcseq.getQualityControlRecord(i)) != null ? String.format("%d. %s", imageNumber, r.getLastComment()) : String.format("%d.", imageNumber)) : String.format("%d.", imageNumber);
                    Paragraph p = new Paragraph();
                    p.add(caption);
                    doc.add((Element)p);
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
                cb.restoreState();
                doc.newPage();
                ++imageNumber;
            }
            doc.close();
        }
        catch (DocumentException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        finally {
            monitor.finished();
        }
    }

    public void writePdf() {
        JFileChooser choose = new JFileChooser();
        Preferences prefs = Preferences.userNodeForPackage(PngWalkTool.class);
        String fname = prefs.get("writeToPdf", "/tmp/pngwalk.pdf");
        choose.setSelectedFile(new File(fname));
        if (choose.showSaveDialog(this) == 0) {
            final File f = choose.getSelectedFile();
            prefs.put("writeToPdf", f.toString());
            final DasProgressPanel mon = DasProgressPanel.createFramed(SwingUtilities.getWindowAncestor(this), "write pdf");
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    try {
                        PngWalkTool.this.writeToPdfImmediately(mon, f);
                        JPanel panel = new JPanel();
                        panel.setLayout(new BoxLayout(panel, 1));
                        panel.add(new JLabel("wrote file " + f));
                        JButton b = new JButton("Open in Browser");
                        b.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                AutoplotUtil.openBrowser(f.toURI().toString());
                            }
                        });
                        panel.add(b);
                        JOptionPane.showMessageDialog(PngWalkTool.this, panel);
                    }
                    catch (FileNotFoundException ex) {
                        logger.log(Level.SEVERE, null, ex);
                    }
                }
            };
            new Thread(run).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToAnimatedGifImmediately(final ProgressMonitor monitor, File f, final String overrideDelays) throws FileNotFoundException {
        try {
            Datum baset;
            monitor.setTaskSize(this.seq.size());
            monitor.started();
            DatumRange baseRange = this.seq.imageAt(0).getDatumRange();
            if (baseRange != null) {
                baset = this.seq.imageAt(0).getDatumRange().min();
            } else {
                if (overrideDelays != null && !overrideDelays.endsWith("ms")) {
                    throw new IllegalArgumentException("template does not imply timeranges");
                }
                baset = null;
            }
            Iterator images = new Iterator(){
                int i = 0;

                @Override
                public boolean hasNext() {
                    return this.i < PngWalkTool.this.seq.size() && !monitor.isCancelled();
                }

                public Object next() {
                    BufferedImage im = PngWalkTool.this.seq.imageAt(this.i).getImage();
                    monitor.setTaskProgress(this.i);
                    while (im == null) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException ex) {
                            throw new RuntimeException(ex);
                        }
                        im = PngWalkTool.this.seq.imageAt(this.i).getImage();
                    }
                    ++this.i;
                    return im;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("remove is not supported");
                }
            };
            Iterator delays = new Iterator(){
                int i = 0;
                Datum lastTime;

                @Override
                public boolean hasNext() {
                    throw new IllegalArgumentException("use images.next");
                }

                public String next() {
                    String result;
                    if (this.i == 0) {
                        this.lastTime = baset;
                    }
                    ++this.i;
                    if (this.i == PngWalkTool.this.seq.size()) {
                        --this.i;
                    }
                    if (overrideDelays != null) {
                        switch (overrideDelays) {
                            case "realTime": {
                                result = String.valueOf((int)Math.ceil(PngWalkTool.this.seq.imageAt(this.i).getDatumRange().min().subtract(this.lastTime).convertTo(Units.milliseconds).value() / 100.0));
                                this.lastTime = PngWalkTool.this.seq.imageAt(this.i).getDatumRange().min();
                                break;
                            }
                            case "secondPerDay": {
                                result = String.valueOf((int)Math.ceil(PngWalkTool.this.seq.imageAt(this.i).getDatumRange().min().subtract(this.lastTime).convertTo(Units.milliseconds).value() / 864000.0));
                                this.lastTime = PngWalkTool.this.seq.imageAt(this.i).getDatumRange().min();
                                break;
                            }
                            default: {
                                try {
                                    result = String.valueOf((int)Math.ceil(Units.milliseconds.parse(overrideDelays).value() / 10.0));
                                    break;
                                }
                                catch (ParseException ex) {
                                    throw new IllegalArgumentException(ex);
                                }
                            }
                        }
                    } else {
                        result = "1";
                    }
                    return result;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("remove is not supported");
                }
            };
            AnimatedGifDemo.saveAnimate(f, images, delays);
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        finally {
            monitor.finished();
        }
    }

    public void writeAnimatedGif() {
        JFileChooser choose = new JFileChooser();
        Preferences prefs = Preferences.userNodeForPackage(PngWalkTool.class);
        String fname = prefs.get("writeToGif", "/tmp/pngwalk.gif");
        choose.setSelectedFile(new File(fname));
        String[] opts = new String[]{"10ms", "50ms", "200ms", "400ms", "800ms", "1000ms", "1200ms", "realTime", "secondPerDay"};
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 1));
        JComboBox<String> jo = new JComboBox<String>(opts);
        jo.setSelectedIndex(1);
        jo.setMaximumSize(new Dimension(1000, 30));
        p.add(new JLabel("Interslide-Delay:"));
        p.add(jo);
        p.add(Box.createGlue());
        choose.setAccessory(p);
        if (choose.showSaveDialog(this) == 0) {
            final File f = choose.getSelectedFile();
            prefs.put("writeToGif", f.toString());
            final DasProgressPanel mon = DasProgressPanel.createFramed(SwingUtilities.getWindowAncestor(this), "write animated gif");
            final String fdelay = (String)jo.getSelectedItem();
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    try {
                        PngWalkTool.this.writeToAnimatedGifImmediately(mon, f, fdelay);
                        JPanel panel = new JPanel();
                        panel.setLayout(new BoxLayout(panel, 1));
                        panel.add(new JLabel("wrote file " + f));
                        JButton b = new JButton("Open in Browser");
                        b.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                AutoplotUtil.openBrowser(f.toURI().toString());
                            }
                        });
                        panel.add(b);
                        JOptionPane.showMessageDialog(PngWalkTool.this, panel);
                    }
                    catch (FileNotFoundException ex) {
                        Logger.getLogger(PngWalkTool.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            };
            new Thread(run).start();
        }
    }

    static {
        logger = LoggerManager.getLogger("autoplot.pngwalk");
        WARNING_ICON = new ImageIcon(AutoplotUI.class.getResource("/org/autoplot/resources/warning-icon.png"));
        ERROR_ICON = new ImageIcon(AutoplotUI.class.getResource("/org/autoplot/resources/error-icon.png"));
        BUSY_ICON = new ImageIcon(AutoplotUI.class.getResource("/org/autoplot/resources/spinner.gif"));
        READY_ICON = new ImageIcon(AutoplotUI.class.getResource("/org/autoplot/resources/indProgress0.png"));
        IDLE_ICON = new ImageIcon(AutoplotUI.class.getResource("/org/autoplot/resources/idle-icon.png"));
        LOCAL_FILE_ENABLER = new ActionEnabler(){

            @Override
            public boolean isActionEnabled(String filename) {
                return DataSetURI.getResourceURI(filename).toString().startsWith("file:");
            }
        };
    }

    public static interface ActionEnabler {
        public boolean isActionEnabled(String var1);
    }
}

