/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.pngwalk;

import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.autoplot.ApplicationModel;
import org.autoplot.AutoplotUtil;
import org.autoplot.ScriptContext;
import org.autoplot.datasource.URISplit;
import org.autoplot.dom.Application;
import org.autoplot.dom.Plot;
import org.autoplot.jythonsupport.Util;
import org.autoplot.pngwalk.CreatePngWalkDialog;
import org.autoplot.pngwalk.ImageResize;
import org.autoplot.pngwalk.PngWalkTool;
import org.autoplot.state.StatePersistence;
import org.das2.components.DasProgressPanel;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.DatumUtil;
import org.das2.datum.TimeParser;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.datum.format.DatumFormatter;
import org.das2.datum.format.FormatStringFormatter;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.ops.Ops;
import org.das2.util.ArgumentList;
import org.das2.util.DasPNGEncoder;
import org.das2.util.ExceptionHandler;
import org.das2.util.FileUtil;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;

public class CreatePngWalk {
    private static final Logger logger = LoggerManager.getLogger("autoplot.pngwalk");
    private static int returnCode1 = 0;

    private static String[] getListOfTimes(Params params, List<String> warnings) throws IllegalArgumentException, ParseException {
        String[] times;
        if (params.useBatchUri) {
            try {
                String uri = params.batchUri;
                QDataSet timesds = Util.getDataSet(uri);
                times = new String[timesds.length()];
                if (params.batchUriName.equals("")) {
                    if (!UnitsUtil.isTimeLocation(SemanticOps.getUnits(timesds))) {
                        if ((QDataSet)timesds.property("DEPEND_0") != null) {
                            timesds = (QDataSet)timesds.property("DEPEND_0");
                        } else if (SemanticOps.isBundle(timesds)) {
                            timesds = Ops.bundle(DataSetOps.unbundle(timesds, 0), DataSetOps.unbundle(timesds, 1));
                        } else {
                            throw new IllegalArgumentException("expected events list URI");
                        }
                    }
                    if (timesds.rank() != 2) {
                        timesds = Ops.createEvents(timesds);
                    }
                    if (timesds.rank() != 2) {
                        throw new IllegalArgumentException("expected bins dataset for times");
                    }
                    TimeParser tp = TimeParser.create(params.timeFormat);
                    for (int i = 0; i < times.length; ++i) {
                        times[i] = tp.format(DataSetUtil.asDatumRange(timesds.slice(i))) + ": " + DataSetUtil.asDatumRange(timesds.slice(i)).toString();
                    }
                }
                timesds = Ops.createEvents(timesds);
                Units tu = (Units)((QDataSet)timesds.property("BUNDLE_1")).property("UNITS", 0);
                Units eu = (Units)((QDataSet)timesds.property("BUNDLE_1")).property("UNITS", 3);
                if (uri.endsWith(".txt")) {
                    logger.fine("reading events file to preserve identity of orbits.");
                    for (int i = 0; i < times.length; ++i) {
                        String s;
                        String s1 = eu.createDatum(timesds.slice(i).value(3)).toString();
                        times[i] = s = s1 + ": orbit:" + uri + ":" + s1;
                    }
                }
                logger.fine("reading events file as start/stop times.");
                for (int i = 0; i < times.length; ++i) {
                    times[i] = eu.createDatum(timesds.slice(i).value(3)).toString() + ": " + DatumRange.newDatumRange(timesds.slice(i).value(0), timesds.slice(i).value(1), tu);
                }
            }
            catch (Exception ex) {
                if (ex instanceof IllegalArgumentException) {
                    throw (IllegalArgumentException)ex;
                }
                throw new IllegalArgumentException(ex);
            }
        } else {
            times = ScriptContext.generateTimeRanges(params.timeFormat, params.timeRangeStr);
        }
        return times;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BufferedImage myWriteToPng(String filename, Application ldom, int width, int height) throws InterruptedException, FileNotFoundException, IOException {
        BufferedImage image = null;
        try (OutputStream out = null;){
            File outf = new File(filename);
            File parentf = outf.getParentFile();
            if (parentf != null && !parentf.exists() && !parentf.mkdirs()) {
                throw new IllegalArgumentException("failed to make directories " + parentf);
            }
            out = new FileOutputStream(filename);
            image = ldom.getCanvases(0).getController().getDasCanvas().getImage(width, height);
            DasPNGEncoder encoder = new DasPNGEncoder();
            encoder.addText("Creation Time", new Date().toString());
            encoder.addText("Software", "Autoplot");
            encoder.addText("plotInfo", ldom.getCanvases(0).getController().getDasCanvas().getImageMetadata());
            encoder.write(image, out);
        }
        if (image == null) {
            throw new IllegalArgumentException("image not assigned, this shouldn't happen.");
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int doBatch(String[] times, Application readOnlyDom, Params params, ProgressMonitor mon) throws IOException, InterruptedException {
        File thumbsFolder;
        File outputFolder;
        ArrayList<String> pngFilenameArrayThumbs = new ArrayList<String>();
        ArrayList<String> pngFilenameArrayBig = new ArrayList<String>();
        ArrayList<String> timeLabels = new ArrayList<String>();
        int returnCodeAll = 10;
        logger.log(Level.CONFIG, "CreatePngWalk.doBatch with params {0}", params);
        if (!params.outputFolder.endsWith("/") && !params.outputFolder.endsWith("\\")) {
            params.outputFolder = params.outputFolder + "/";
        }
        if (!(outputFolder = new File(params.outputFolder)).exists() && !outputFolder.mkdirs()) {
            throw new IOException("failed mkdirs: " + outputFolder);
        }
        if (!outputFolder.canWrite()) {
            throw new IOException("unable to write to folder " + outputFolder);
        }
        if (params.createThumbs) {
            thumbsFolder = new File(params.outputFolder, "thumbs400/");
            if (!thumbsFolder.exists() && !thumbsFolder.mkdirs()) {
                throw new IOException("failed mkdirs: " + thumbsFolder);
            }
            if (!thumbsFolder.canWrite()) {
                throw new IOException("unable to write to folder " + thumbsFolder);
            }
        } else {
            thumbsFolder = new File(params.outputFolder, "thumbs400/");
            if (thumbsFolder.exists()) {
                System.err.println("warning: thumbs folder already exists!");
            }
        }
        int n = times.length;
        mon.setTaskSize(n);
        mon.started();
        try {
            int h0;
            int w0;
            Application dom2;
            ApplicationModel appmodel;
            mon.setProgressMessage("initializing child application");
            TimeParser tp = TimeParser.create(params.timeFormat);
            Application dom = (Application)readOnlyDom.copy();
            dom.getOptions().syncToAll(readOnlyDom.getOptions(), new ArrayList<String>());
            try {
                DatumRange tr1;
                String atime = times[0];
                int ic = atime.indexOf(": ");
                String exactTime = ic > -1 ? atime.substring(ic + 2) : atime;
                if (params.useBatchUri) {
                    tr1 = DatumRangeUtil.parseTimeRange(exactTime);
                    dom.setTimeRange(tr1);
                } else {
                    tr1 = tp.parse(exactTime).getTimeRange();
                    dom.setTimeRange(tr1);
                }
            }
            catch (ParseException ex) {
                throw new RuntimeException(ex);
            }
            if (params.runOnCopy) {
                appmodel = new ApplicationModel();
                appmodel.addDasPeersToAppAndWait();
                dom2 = appmodel.getDocumentModel();
                mon.setProgressMessage("synchronize to this application");
                dom2.getCanvases(0).setHeight(dom.getCanvases(0).getHeight());
                dom2.getCanvases(0).setWidth(dom.getCanvases(0).getWidth());
                w0 = dom2.getCanvases(0).getWidth();
                h0 = dom2.getCanvases(0).getHeight();
                dom2.getCanvases(0).getController().getDasCanvas().setSize(w0, h0);
                dom2.getCanvases(0).getController().getDasCanvas().revalidate();
                dom2.syncTo(dom, Arrays.asList("id"));
                dom2.getController().waitUntilIdle();
                dom2.syncTo(dom, Arrays.asList("id"));
                dom2.getOptions().syncToAll(readOnlyDom.getOptions(), new ArrayList<String>());
                mon.setProgressMessage("write " + params.product + ".vap");
                logger.log(Level.FINE, "write {0}.vap", params.product);
            } else {
                dom2 = readOnlyDom;
                w0 = dom2.getCanvases(0).getWidth();
                h0 = dom2.getCanvases(0).getHeight();
            }
            appmodel = dom2.getController().getApplicationModel();
            int thumbSize = 400;
            int thumbH = 0;
            int thumbW = 0;
            if (params.createThumbs) {
                double aspect = 1.0 * (double)w0 / (double)h0;
                thumbH = (int)Math.sqrt(Math.pow(thumbSize, 2.0) / (aspect * aspect + 1.0));
                thumbW = (int)((double)thumbH * aspect);
            }
            StatePersistence.saveState(new File(outputFolder, params.product + ".vap"), (Object)dom2, "");
            String vap = new File(outputFolder, params.product + ".vap").toString();
            StringBuilder build = new StringBuilder();
            build.append(String.format("JAVA -cp autoplot.jar org.autoplot.pngwalk.CreatePngWalk ", new Object[0]));
            try (PrintWriter ff = new PrintWriter(new FileWriter(new File(outputFolder, params.product + ".pngwalk")));){
                build.append("--vap=").append(vap).append(" ");
                build.append("--outputFolder=").append(params.outputFolder).append(" ");
                ff.println("# set the following line to the location of the pngwalk");
                ff.println("baseurl=.");
                ff.println("product=" + params.product);
                build.append("--product=").append(params.product).append(" ");
                ff.println("timeFormat=" + params.timeFormat);
                build.append("--timeFormat='").append(params.timeFormat).append("' ");
                if (!params.useBatchUri) {
                    ff.println("timeRange=" + params.timeRangeStr);
                    build.append("--timeRange='").append(params.timeRangeStr).append("' ");
                }
                if (params.batchUriName.equals("$o")) {
                    ff.println("# the filePattern may need editing, depending on extension and subdirectories.");
                    ff.println("filePattern=*.png");
                }
                if (params.useBatchUri) {
                    if (params.batchUri != null && !params.batchUri.equals("")) {
                        ff.println("batchUri=" + params.batchUri);
                        build.append("--batchUri=").append(params.batchUri).append(" ");
                    }
                    if (!params.batchUriName.equals("")) {
                        ff.println("batchUriName=" + params.batchUri);
                        build.append("--batchUriName=").append(params.batchUri).append(" ");
                    }
                }
                if (params.rescalex != null && !params.rescalex.equals("0%,100%")) {
                    ff.println("rescalex=" + params.rescalex);
                    build.append("--rescalex=").append(params.rescalex).append(" ");
                }
                if (params.autorange) {
                    ff.println("autorange=" + params.autorange);
                    build.append("--autorange=").append(params.autorange).append(" ");
                }
                if (params.version != null && params.version.trim().length() > 0) {
                    ff.println("version=" + params.version);
                    build.append("--version=").append(params.version);
                }
                if (!params.outputFormat.equals("png")) {
                    ff.println("outputFormat=" + params.outputFormat);
                    build.append("--outputFormat=").append(params.outputFormat);
                }
            }
            if (!(mon instanceof NullProgressMonitor)) {
                System.err.println(build.toString());
            }
            dom2.getController().waitUntilIdle();
            mon.setProgressMessage("making images");
            long t0 = System.currentTimeMillis();
            int count = 0;
            appmodel.setExceptionHandler(new ExceptionHandler(){

                @Override
                public void handle(Throwable t) {
                    logger.log(Level.WARNING, null, t);
                    returnCode1 = 11;
                }

                @Override
                public void handleUncaught(Throwable t) {
                    logger.log(Level.WARNING, null, t);
                    returnCode1 = 12;
                }
            });
            for (String atime : times) {
                File out;
                returnCode1 = 0;
                int ic = atime.indexOf(": ");
                String exactTime = null;
                if (ic > -1) {
                    exactTime = atime.substring(ic + 2);
                    atime = atime.substring(0, ic);
                }
                String filename = CreatePngWalk.getFilename(params, "", atime);
                String filenameThumb = CreatePngWalk.getRelativeFilename(params, "thumbs400", atime);
                String filenameBig = CreatePngWalk.getRelativeFilename(params, "", atime);
                pngFilenameArrayThumbs.add(filenameThumb);
                pngFilenameArrayBig.add(filenameBig);
                ++count;
                if (mon.isCancelled()) break;
                mon.setTaskProgress(count);
                if (params.update && (out = new File(filename)).exists()) {
                    mon.setProgressMessage(String.format("skipping %s", filename));
                    logger.log(Level.FINE, String.format("skipping %s", filename));
                    continue;
                }
                try {
                    String rescalex;
                    DatumRange dr = exactTime == null ? tp.parse(atime).getTimeRange() : DatumRangeUtil.parseTimeRange(exactTime);
                    if (params.rescalex != null && (rescalex = params.rescalex.trim()).length() > 0 && !params.rescalex.equals("0%,100%")) {
                        dr = DatumRangeUtil.rescale(dr, params.rescalex);
                    }
                    String currentTimeLabel = dr.toString();
                    timeLabels.add(currentTimeLabel);
                    if (!dom2.getTimeRange().equals(dr)) {
                        dom2.setTimeRange(dr);
                    }
                }
                catch (ParseException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                }
                mon.setProgressMessage(String.format("write %s", filename));
                logger.log(Level.FINE, String.format("write %s", filename));
                appmodel.waitUntilIdle();
                if (params.autorange) {
                    if (params.autorangeFlags) {
                        for (Plot p : dom2.getPlots()) {
                            if (p.getYaxis().isAutoRange()) {
                                AutoplotUtil.resetZoomY(dom2, p);
                            }
                            if (!p.getZaxis().isAutoRange()) continue;
                            AutoplotUtil.resetZoomZ(dom2, p);
                        }
                    } else {
                        for (Plot p : dom2.getPlots()) {
                            dom2.getController().setPlot(p);
                            AutoplotUtil.resetZoomY(dom2);
                            AutoplotUtil.resetZoomZ(dom2);
                        }
                    }
                }
                appmodel.waitUntilIdle();
                if (atime.equals(times[0])) {
                    dom2.getOptions().setAutolayout(false);
                    appmodel.waitUntilIdle();
                }
                BufferedImage image = null;
                try {
                    if (params.outputFormat.equals("png")) {
                        image = CreatePngWalk.myWriteToPng(filename, dom2, w0, h0);
                    } else {
                        dom2.getCanvases(0).getController().getDasCanvas().writeToPDF(filename);
                    }
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, "unable to write file " + filename, ex);
                    throw new IOException("unable to write file " + filename, ex);
                }
                if (returnCode1 == 0) {
                    returnCodeAll = 0;
                } else if (returnCodeAll == 10) {
                    returnCodeAll = returnCode1;
                }
                if (params.createThumbs && params.outputFormat.equals("png")) {
                    BufferedImage thumb400 = ImageResize.getScaledInstance(image, thumbW, thumbH, RenderingHints.VALUE_INTERPOLATION_BILINEAR, true);
                    File outf = new File(CreatePngWalk.getFilename(params, "thumbs400", atime));
                    File parentf = outf.getParentFile();
                    if (parentf != null && !parentf.exists() && !parentf.mkdirs()) {
                        throw new IllegalArgumentException("failed to make directories: " + parentf);
                    }
                    if (!ImageIO.write((RenderedImage)thumb400, "png", outf)) {
                        throw new IllegalArgumentException("no appropriate writer is found");
                    }
                    BufferedImage thumb100 = ImageResize.getScaledInstance(thumb400, thumbW / 4, thumbH / 4, RenderingHints.VALUE_INTERPOLATION_BILINEAR, true);
                    outf = new File(CreatePngWalk.getFilename(params, "thumbs100", atime));
                    parentf = outf.getParentFile();
                    if (parentf != null && !parentf.exists() && !parentf.mkdirs()) {
                        throw new IllegalArgumentException("failed to make directories: " + parentf);
                    }
                    if (!ImageIO.write((RenderedImage)thumb100, "png", outf)) {
                        throw new IllegalArgumentException("no appropriate writer is found");
                    }
                }
                double imagesPerSec = (double)count * 1000.0 / (double)(System.currentTimeMillis() - t0);
                double etaSec = (double)(n - count) / imagesPerSec;
                String etaStr = "";
                if (count > 3) {
                    Datum eta = DatumUtil.asOrderOneUnits(Units.seconds.createDatum(etaSec));
                    FormatStringFormatter df = new FormatStringFormatter("%.1f", true);
                    etaStr = String.format(Locale.US, ", eta %s", ((DatumFormatter)df).format(eta));
                }
                if (imagesPerSec < 1.0) {
                    mon.setAdditionalInfo(String.format(Locale.US, "(%.1f/min%s)", imagesPerSec * 60.0, etaStr));
                    continue;
                }
                mon.setAdditionalInfo(String.format(Locale.US, "(%.1f/sec%s)", imagesPerSec, etaStr));
            }
            if (!mon.isCancelled()) {
                CreatePngWalk.writeHTMLFile(params, pngFilenameArrayThumbs, pngFilenameArrayBig, timeLabels);
            }
        }
        finally {
            if (!mon.isFinished()) {
                mon.finished();
            }
        }
        return returnCodeAll;
    }

    private static String getFilename(Params params, String thumbdir, String atime) throws IllegalArgumentException {
        String filename;
        if (thumbdir.length() > 0 && !thumbdir.endsWith("/")) {
            thumbdir = thumbdir + "/";
        }
        if (params.useBatchUri && params.batchUriName.equals("$o")) {
            String name = atime;
            String outputFormat = params.outputFormat;
            if (name.toLowerCase().endsWith(params.outputFormat)) {
                outputFormat = name.substring(name.length() - outputFormat.length());
                name = name.substring(0, name.length() - (params.outputFormat.length() + 1));
            }
            filename = String.format("%s%s%s.%s", params.outputFolder, thumbdir, name, outputFormat);
        } else {
            if (params.useBatchUri && !params.batchUriName.equals("")) {
                throw new IllegalArgumentException("batchUriName must be \"\" or \"$o\"");
            }
            String vers = params.version == null || params.version.trim().length() == 0 ? "" : "_" + params.version.trim();
            filename = String.format("%s%s%s_%s%s.%s", params.outputFolder, thumbdir, params.product, atime, vers, params.outputFormat);
        }
        return filename;
    }

    private static String getRelativeFilename(Params params, String thumbdir, String atime) throws IllegalArgumentException {
        String filename;
        if (thumbdir.length() > 0 && !thumbdir.endsWith("/")) {
            thumbdir = thumbdir + "/";
        }
        if (params.useBatchUri && params.batchUriName.equals("$o")) {
            String name = atime;
            String outputFormat = params.outputFormat;
            if (name.toLowerCase().endsWith(params.outputFormat)) {
                outputFormat = name.substring(name.length() - outputFormat.length());
                name = name.substring(0, name.length() - (params.outputFormat.length() + 1));
            }
            filename = String.format("%s%s.%s", thumbdir, name, outputFormat);
        } else {
            if (params.useBatchUri && !params.batchUriName.equals("")) {
                throw new IllegalArgumentException("batchUriName must be \"\" or \"$o\"");
            }
            String vers = params.version == null || params.version.trim().length() == 0 ? "" : "_" + params.version.trim();
            filename = String.format("%s%s_%s%s.%s", thumbdir, params.product, atime, vers, params.outputFormat);
        }
        return filename;
    }

    public static int doIt(Application dom, Params params) throws ParseException, IOException, InterruptedException {
        int status = 0;
        if (params == null) {
            CreatePngWalkDialog p = new CreatePngWalkDialog();
            if (AutoplotUtil.showConfirmDialog(ScriptContext.getViewWindow(), p, "Create PngWalk Options", 2) == 0) {
                TimeParser tp;
                ProgressMonitor mon;
                p.writeDefaults();
                params = p.getParams();
                File ff = new File(params.outputFolder);
                if (p.getOverwriteCb().isSelected() && ff.exists()) {
                    FileUtil.deleteFileTree(ff);
                }
                if (ScriptContext.getViewWindow() == null) {
                    mon = new NullProgressMonitor();
                    System.err.println("ScriptContext.getViewWindow is null, running quietly in the background.");
                } else {
                    mon = DasProgressPanel.createFramed(ScriptContext.getViewWindow(), "running batch");
                }
                if (params.timeFormat.length() > 0 && !(tp = TimeParser.create(params.timeFormat)).isNested()) {
                    JOptionPane.showMessageDialog(ScriptContext.getViewWindow(), "<html>Time spec must have fields nested: $Y,$m,$d, etc,<br>not " + params.timeFormat + " .");
                    return -1;
                }
                String[] times = CreatePngWalk.getListOfTimes(params, new ArrayList<String>());
                status = CreatePngWalk.doBatch(times, dom, params, mon);
                if (!mon.isCancelled()) {
                    String url = params.outputFolder.charAt(1) == ':' ? "file:/" + params.outputFolder : "file:" + params.outputFolder;
                    if (ScriptContext.getViewWindow() != null && params.outputFormat.equals("png")) {
                        logger.log(Level.FINE, "version=\"{0}\"", String.valueOf(params.version));
                        String vers = params.version == null || params.version.trim().length() == 0 ? "" : "_" + params.version.trim();
                        String st1 = params.batchUriName.length() == 0 ? url + params.product + "_" + params.timeFormat + vers + ".png" : url + "*.png";
                        final String st = st1;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                PngWalkTool.start(st, ScriptContext.getViewWindow());
                            }
                        });
                    } else if (ScriptContext.getViewWindow() != null) {
                        String vers = params.version == null || params.version.trim().length() == 0 ? "" : "_" + params.version.trim();
                        String st = url + params.product + "_" + params.timeFormat + vers + "." + params.outputFormat;
                        JOptionPane.showMessageDialog(ScriptContext.getViewWindow(), "<html>Files created:<br>" + st);
                    }
                }
            }
        } else {
            String[] times = CreatePngWalk.getListOfTimes(params, new ArrayList<String>());
            ProgressMonitor mon = ScriptContext.getViewWindow() == null ? ("true".equals(System.getProperty("java.awt.headless", "false")) ? new NullProgressMonitor() : DasProgressPanel.createFramed("running batch")) : DasProgressPanel.createFramed(ScriptContext.getViewWindow(), "running batch");
            status = CreatePngWalk.doBatch(times, dom, params, mon);
        }
        return status;
    }

    public static void writeHTMLFile(Params params, ArrayList<String> pngFilenameArrayThumbs, ArrayList<String> pngFilenameArrayBig, ArrayList<String> timeLabels) {
        if (params.update || timeLabels.size() != pngFilenameArrayBig.size()) {
            logger.info("skipping create HTML step because of partial run");
            return;
        }
        String filePath = params.outputFolder + "" + params.product + ".html";
        File f = new File(filePath);
        String htmlOpen = "<html>\n";
        String htmlHead = "\t<head><title>PNG Gallery " + params.product + "</title></head>\n";
        String htmlBody = "\t<body style=\"background-color: #6B6B6B; margin=0;\">\n";
        String htmlClose1 = "\t\t</div2Close>\n";
        String htmlClose2 = "\t</body>\n";
        String htmlClose3 = "</html>";
        String pageHeaderOpen = "\t\t<div style=\"padding:20px; top: 0px; margin-right=0px; background-color:black; color:white;height:30px;\">\n\t\t\t<strong>PNG WALK</strong>\n\t\t</div>\n";
        String htmlAnchorStringOpen = "\t\t\t\t<a href=\"";
        String htmlAnchorStringClose = "\">\n";
        String htmlImageStringOpen = "\t\t\t\t<img src=\"";
        String htmlImageStringClose = "\" style=\"width:304px;height:304px;margin-left:10px;margin-bottom:10px;\"></a>\n";
        String htmlImageCaptionOpen = "\t\t\t\t<figcaption style=\"color: white; text-align:center;\">";
        String htmlImageCaptionClose = "\t\t\t\t</figcaption>\n";
        String htmlImageContainer = "\t\t<div style=\"background-color: #6B6B6B;margin-left:100px;\">\n";
        String htmlFigureOpen = "\t\t\t<figure style=\"width:350px; float:left;\">\n";
        String htmlFigureClose = "\t\t\t</figure>\n";
        int count = 0;
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(f));){
            bw.write(htmlOpen);
            bw.write(htmlHead);
            bw.write(htmlBody);
            bw.write(pageHeaderOpen);
            bw.write(htmlImageContainer);
            Iterator<String> iterator = pngFilenameArrayThumbs.iterator();
            while (iterator.hasNext()) {
                String pngFilenameArray1;
                String currentPngFilename = pngFilenameArray1 = iterator.next();
                String currentPngFilenameBIG = pngFilenameArrayBig.get(count);
                String fileNameToDisplay = timeLabels.get(count);
                ++count;
                String bigImageLink = htmlAnchorStringOpen + currentPngFilenameBIG + htmlAnchorStringClose;
                String addImageString = htmlImageStringOpen + currentPngFilename + htmlImageStringClose;
                String fullImageCaption = htmlImageCaptionOpen + fileNameToDisplay + htmlImageCaptionClose;
                bw.write(htmlFigureOpen);
                bw.write(bigImageLink);
                bw.write(addImageString);
                bw.write(fullImageCaption);
                bw.write(htmlFigureClose);
            }
            bw.write(htmlClose1);
            bw.write(htmlClose2);
            bw.write(htmlClose3);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
    }

    public static void main(String[] args) throws InterruptedException, ParseException, IOException {
        System.err.println("CreatePngWalk 20160610");
        ArgumentList alm = new ArgumentList("CreatePngWalk");
        alm.addOptionalSwitchArgument("timeFormat", "f", "timeFormat", "$Y$m$d", "timeformat for png files, e.g. $Y is year, $j is day of year");
        alm.addOptionalSwitchArgument("timeRange", "r", "timeRange", "", "time range to cover, e.g. 2011 through 2012");
        alm.requireOneOf(new String[]{"timeRange", "batchUri"});
        alm.addOptionalSwitchArgument("batchUri", "b", "batchUri", "", "optionally provide list of timeranges");
        alm.addOptionalSwitchArgument("batchUriName", null, "batchUriName", "", "use $o to use the filename in the batch file");
        alm.addOptionalSwitchArgument("createThumbs", "t", "createThumbs", "y", "create thumbnails, y (default) or n");
        alm.addOptionalSwitchArgument("product", "n", "product", "product", "product name in each filename (default=product)");
        alm.addOptionalSwitchArgument("outputFolder", "o", "outputFolder", "pngwalk", "location of root of pngwalk");
        alm.addOptionalSwitchArgument("outputFormat", null, "outputFormat", "png", "output format png or pdf");
        alm.addSwitchArgument("vap", "v", "vap", "vap file or URI to plot");
        alm.addOptionalSwitchArgument("rescalex", null, "rescalex", "0%,100%", "rescale factor, such as '0%-1hr,100%+1hr', to provide context to each image");
        alm.addOptionalSwitchArgument("version", null, "version", null, "additional version string to add to each filename, like v1.0");
        alm.addBooleanSwitchArgument("autorange", null, "autorange", "rerange dependent dimensions Y and Z");
        alm.addBooleanSwitchArgument("update", null, "update", "only calculate missing images");
        alm.addBooleanSwitchArgument("testException", null, "testException", "throw a runtime exception to test exit code");
        alm.process(args);
        if (alm.getBooleanValue("testException")) {
            throw new RuntimeException("--textException on command line, throwing exception");
        }
        if (System.getProperty("noCheckCertificate", "true").equals("true")) {
            logger.fine("disabling HTTP certificate checks.");
            try {
                TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return new X509Certificate[0];
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] certs, String authType) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] certs, String authType) {
                    }
                }};
                SSLContext sc = SSLContext.getInstance("SSL");
                sc.init(null, trustAllCerts, new SecureRandom());
                HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
                HostnameVerifier allHostsValid = new HostnameVerifier(){

                    @Override
                    public boolean verify(String hostname, SSLSession session) {
                        return true;
                    }
                };
                HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
            }
            catch (KeyManagementException | NoSuchAlgorithmException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
        Params params = new Params();
        params.createThumbs = alm.getValue("createThumbs").equals("y");
        params.outputFolder = alm.getValue("outputFolder");
        params.product = alm.getValue("product");
        params.timeFormat = alm.getValue("timeFormat");
        params.timeRangeStr = alm.getValue("timeRange");
        params.rescalex = alm.getValue("rescalex");
        params.version = alm.getValue("version");
        params.autorange = alm.getBooleanValue("autorange");
        params.update = alm.getBooleanValue("update");
        params.batchUri = alm.getValue("batchUri");
        if (params.batchUri != null && params.batchUri.length() > 0) {
            params.useBatchUri = true;
            params.batchUriName = alm.getValue("batchUriName");
        }
        params.outputFormat = alm.getValue("outputFormat");
        String vap = alm.getValue("vap");
        if (vap.length() > 2 && vap.charAt(1) == ':') {
            logger.fine("reference appears to be absolute (Windows)");
        } else {
            vap = URISplit.makeAbsolute(new File(".").getAbsolutePath(), vap);
        }
        Application dom = (Application)StatePersistence.restoreState(new File(vap));
        int status = CreatePngWalk.doIt(dom, params);
        System.exit(status);
    }

    public static class Params {
        public String outputFolder = null;
        public String timeRangeStr = null;
        public String rescalex = "0%,100%";
        public boolean autorange = true;
        public boolean autorangeFlags = true;
        public boolean runOnCopy = true;
        public String version = null;
        public String product = null;
        public String timeFormat = null;
        public String batchUri = null;
        public boolean useBatchUri = false;
        public String batchUriName = "";
        public boolean createThumbs = true;
        public boolean update = false;
        public String outputFormat = "png";

        public String toString() {
            return String.format("outputFolder=%s\ntimeRange=%s\nrescalex=%s\nautorange=%s\nversion=%s\nproduct=%s\ntimeFormat=%s\ncreateThumbs=%s\nupdate=%s\n", this.outputFolder, this.timeRangeStr, this.rescalex, this.autorange, this.version, this.product, this.timeFormat, this.createThumbs, this.update);
        }
    }
}

