/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.pngwalk;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.autoplot.pngwalk.PngWalkTool;
import org.autoplot.pngwalk.PngWalkView;
import org.autoplot.pngwalk.ScalePerspectiveImageOp;
import org.autoplot.pngwalk.WalkImage;
import org.autoplot.pngwalk.WalkImageSequence;

public class CoversWalkView
extends PngWalkView {
    private static final int HEIGHT_WIDTH_RATIO = 10;
    int cellSize = 100;
    int cellWidth = this.cellSize / 10;
    int MINIMUM_CELL_SIZE = 50;
    int DEFAULT_CELL_SIZE = 100;
    private JScrollPane scrollPane;
    public static final int PAINT_THUMB_TIMEOUT_MS = 400;
    Canvas canvas;
    protected boolean perspective = true;
    public static final String PROP_PERSPECTIVE = "perspective";

    public CoversWalkView(final WalkImageSequence sequence) {
        super(sequence);
        MouseWheelListener[] ll;
        this.setLayout(new BorderLayout());
        this.canvas = new Canvas();
        this.scrollPane = new JScrollPane(this.canvas, 20, 32);
        for (MouseWheelListener l : ll = this.scrollPane.getMouseWheelListeners()) {
            this.scrollPane.removeMouseWheelListener(l);
        }
        this.scrollPane.addMouseWheelListener(this.getMouseWheelListener());
        this.canvas.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (CoversWalkView.this.seq == null) {
                    return;
                }
                int clickCell = (int)Math.floor((double)e.getX() / (double)CoversWalkView.this.cellWidth);
                CoversWalkView.this.selectCell(clickCell);
            }
        });
        this.canvas.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                CoversWalkView.this.cellSize = CoversWalkView.this.getThumbnailSize();
                CoversWalkView.this.updateLayout();
            }
        });
        this.scrollPane.getHorizontalScrollBar().getModel().addChangeListener(new ChangeListener(){
            Timer repaintTimer = new Timer("CoversViewRepaintDelay", true);
            TimerTask task;

            @Override
            public void stateChanged(ChangeEvent e) {
                if (this.task != null) {
                    this.task.cancel();
                }
                if (sequence == null) {
                    return;
                }
                if (!CoversWalkView.this.canvas.isShowing()) {
                    return;
                }
                this.task = new TimerTask(){

                    @Override
                    public void run() {
                        Rectangle bounds = CoversWalkView.this.scrollPane.getViewport().getViewRect();
                        int first = bounds.x / CoversWalkView.this.cellWidth;
                        int last = Math.min(sequence.size(), (bounds.x + bounds.width) / CoversWalkView.this.cellWidth + 1);
                        for (int i = first; i < last; ++i) {
                            sequence.imageAt(i).getThumbnail(true);
                        }
                    }
                };
                this.repaintTimer.schedule(this.task, 200L);
            }
        });
        this.add(this.scrollPane);
    }

    public boolean isPerspective() {
        return this.perspective;
    }

    public void setPerspective(boolean perspective) {
        boolean oldPerspective = this.perspective;
        this.perspective = perspective;
        this.canvas.repaint();
        this.firePropertyChange(PROP_PERSPECTIVE, oldPerspective, perspective);
    }

    @Override
    protected void sequenceChanged() {
        this.updateLayout();
        if (this.scrollPane != null) {
            this.scrollPane.getVerticalScrollBar().setValue(0);
        }
    }

    @Override
    protected void thumbnailSizeChanged() {
        this.cellSize = this.getThumbnailSize();
        this.cellWidth = this.cellSize / 10;
        this.updateLayout();
        super.thumbnailSizeChanged();
    }

    @Override
    public JComponent getMouseTarget() {
        return this.canvas;
    }

    private void updateLayout() {
        if (this.canvas == null) {
            return;
        }
        if (this.seq != null) {
            this.canvas.setPreferredSize(new Dimension(this.cellWidth * this.seq.size(), this.cellSize));
            this.canvas.setMinimumSize(new Dimension(this.cellWidth * this.seq.size(), this.cellSize));
        } else {
            this.canvas.setPreferredSize(new Dimension(640, this.MINIMUM_CELL_SIZE));
            this.canvas.setMinimumSize(new Dimension(640, this.MINIMUM_CELL_SIZE));
        }
        this.scrollPane.revalidate();
        this.canvas.revalidate();
        this.canvas.repaint();
    }

    private void selectCell(int n) {
        this.seq.setIndex(n);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("index")) {
            int i = (Integer)e.getOldValue();
            int x = i % this.seq.size() * this.cellWidth;
            this.canvas.repaint(new Rectangle(x, 0, this.cellWidth, this.cellSize));
            i = (Integer)e.getNewValue();
            x = i % this.seq.size() * this.cellWidth;
            this.canvas.repaint(new Rectangle(x, 0, this.cellWidth, this.cellSize));
            int scrollMin = this.scrollPane.getHorizontalScrollBar().getValue();
            int scrollMax = scrollMin + this.scrollPane.getHorizontalScrollBar().getVisibleAmount();
            int pos = i * this.cellWidth - this.getWidth() / 2 + this.cellWidth / 2;
            if (scrollMin > i * this.cellWidth || scrollMax < (i + 1) * this.cellWidth) {
                this.scrollPane.getHorizontalScrollBar().setValue(pos);
            }
        } else if (e.getPropertyName().equals("thumbLoaded") || e.getPropertyName().equals("imageLoaded") || e.getPropertyName().equals("badgeChange")) {
            int i = (Integer)e.getNewValue();
            int x = i % this.seq.size() * this.cellWidth;
            this.canvas.repaint(new Rectangle(x, 0, this.cellWidth, this.cellSize));
            this.canvas.repaintSoon();
        } else if (e.getPropertyName().equals("sequenceChanged")) {
            this.sequenceChanged();
        }
    }

    private class Canvas
    extends JPanel
    implements Scrollable {
        javax.swing.Timer repaintTimer;

        Canvas() {
            this.repaintTimer = new javax.swing.Timer(300, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Canvas.this.repaint();
                }
            });
            this.repaintTimer.setRepeats(false);
        }

        private void repaintSoon() {
            this.repaintTimer.restart();
        }

        @Override
        public void paintComponent(Graphics g1) {
            double sh;
            boolean useSquished = false;
            boolean outOfTime = false;
            long t0 = System.currentTimeMillis();
            super.paintComponent(g1);
            Graphics2D g2 = (Graphics2D)g1;
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            Rectangle bounds = g2.getClipBounds();
            if (CoversWalkView.this.seq == null) {
                return;
            }
            int cellWidth = CoversWalkView.this.cellSize / 10;
            int imax = Math.min(CoversWalkView.this.seq.size() - 1, (bounds.x + bounds.width) / cellWidth);
            double pp = CoversWalkView.this.perspective ? 0.05 : 0.0;
            double d = sh = useSquished ? 1.0 : 10.0;
            for (int i = bounds.x / cellWidth; i <= imax; ++i) {
                Dimension thumbd;
                if (i == CoversWalkView.this.seq.getIndex()) {
                    g2.setColor(Color.orange);
                    g2.fillRect(i * cellWidth, 0, cellWidth, CoversWalkView.this.cellSize);
                }
                if (CoversWalkView.this.seq.imageAt(i).getStatus() == WalkImage.Status.MISSING) continue;
                WalkImage wimage = CoversWalkView.this.seq.imageAt(i);
                BufferedImage thumb = wimage.getThumbnail(false);
                if (thumb == null && wimage.getStatus() != WalkImage.Status.SIZE_THUMB_LOADED) {
                    thumb = wimage.getThumbnail(!CoversWalkView.this.scrollPane.getVerticalScrollBar().getValueIsAdjusting());
                }
                if ((thumbd = wimage.getThumbnailDimension(false)) != null) {
                    ScalePerspectiveImageOp resizeOp;
                    BufferedImage whthumb;
                    int h;
                    int w;
                    double s = Math.min((double)(CoversWalkView.this.cellSize - 4) / thumbd.getWidth(), (double)(CoversWalkView.this.cellSize - 4) / thumbd.getHeight());
                    boolean bl = outOfTime = outOfTime || System.currentTimeMillis() - t0 > 400L;
                    if (s < 1.0) {
                        w = (int)(s * thumbd.getWidth());
                        whthumb = wimage.getThumbnail(w, h = (int)(s * thumbd.getHeight()), !outOfTime);
                        if (whthumb != PngWalkView.loadingImage) {
                            resizeOp = new ScalePerspectiveImageOp(whthumb.getWidth(), whthumb.getHeight(), 0, 0, (int)(1.1 * (double)w / sh), (int)(1.1 * (double)h), 0, 1, 1, pp, true);
                            thumb = resizeOp.filter(whthumb, null);
                        } else {
                            thumb = PngWalkView.tinyLoadingImage;
                        }
                    } else {
                        w = (int)thumbd.getWidth();
                        whthumb = wimage.getThumbnail(w, h = (int)thumbd.getHeight(), !outOfTime);
                        if (whthumb != PngWalkView.loadingImage) {
                            resizeOp = new ScalePerspectiveImageOp(whthumb.getWidth(), whthumb.getHeight(), 0, 0, (int)(1.1 * (double)w / sh), (int)(1.1 * (double)h), 0, 1, 1, pp, true);
                            thumb = resizeOp.filter(whthumb, null);
                        } else {
                            thumb = PngWalkView.tinyLoadingImage;
                        }
                    }
                } else {
                    thumb = PngWalkView.tinyLoadingImage;
                }
                if (thumb == PngWalkView.tinyLoadingImage) {
                    this.repaintSoon();
                }
                int imgX = i * cellWidth + (cellWidth - thumb.getWidth()) / 2;
                int imgY = (CoversWalkView.this.cellSize - thumb.getHeight()) / 2;
                g2.drawImage((Image)thumb, imgX, imgY, null);
                if (!PngWalkTool.isQualityControlEnabled() || CoversWalkView.this.seq.getQualityControlSequence() == null) continue;
                CoversWalkView.this.paintQualityControlIcon(i, g2, imgX, imgY, CoversWalkView.this.cellSize > 300);
            }
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle arg0, int arg1, int arg2) {
            return CoversWalkView.this.cellSize / 10;
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle arg0, int arg1, int arg2) {
            int x = CoversWalkView.this.scrollPane.getHorizontalScrollBar().getVisibleAmount() / CoversWalkView.this.cellSize * CoversWalkView.this.cellSize;
            return x;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return false;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return true;
        }
    }
}

