/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.pngwalk;

import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.text.ParseException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSourceUtil;
import org.autoplot.pngwalk.PngWalkTool;
import org.autoplot.pngwalk.PngWalkView;
import org.autoplot.pngwalk.SinglePngWalkView;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.EnumerationUnits;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.SemanticOps;
import org.das2.qds.ops.Ops;
import org.das2.util.ImageUtil;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.AlertNullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ClickDigitizer {
    PngWalkView view;
    PngWalkTool viewer;
    private static final Logger logger = LoggerManager.getLogger("autoplot.pngwalk");

    public ClickDigitizer(PngWalkView view) {
        this.view = view;
    }

    void setViewer(PngWalkTool viewer) {
        this.viewer = viewer;
    }

    private JSONObject getPlotContaining(JSONArray plots, int x, int y) throws JSONException {
        for (int i = 0; i < plots.length(); ++i) {
            int t2;
            JSONObject plot = plots.getJSONObject(i);
            JSONObject yaxis = plot.getJSONObject("yaxis");
            int t1 = yaxis.getInt("top");
            if (t1 > (t2 = yaxis.getInt("bottom"))) {
                t2 = yaxis.getInt("top");
                t1 = yaxis.getInt("bottom");
            }
            if (t1 > y || y >= t2) continue;
            JSONObject xaxis = plot.getJSONObject("xaxis");
            t1 = xaxis.getInt("left");
            if (t1 > (t2 = xaxis.getInt("right"))) {
                t2 = yaxis.getInt("left");
                t1 = yaxis.getInt("right");
            }
            if (t1 > x || x >= t2) continue;
            return plot;
        }
        return null;
    }

    private QDataSet invTransform(JSONObject axis, int p, String smaller, String bigger) throws JSONException, ParseException {
        Datum result;
        DatumRange rr;
        DatumRange range;
        boolean log = axis.get("type").equals("log");
        if ("UTC".equals(axis.getString("units"))) {
            range = DatumRangeUtil.parseISO8601Range(axis.getString("min") + "/" + axis.getString("max"));
        } else {
            String sunits = axis.getString("units");
            Units units = Units.lookupUnits(sunits);
            range = new DatumRange(units.parse(axis.getString("min")), units.parse(axis.getString("max")));
        }
        double nn = ((double)p + 0.5 - (double)axis.getInt(smaller)) / (double)(axis.getInt(bigger) - axis.getInt(smaller));
        if (log) {
            rr = DatumRangeUtil.rescaleLog(range, nn, nn);
            result = rr.min();
        } else {
            rr = DatumRangeUtil.rescale(range, nn, nn);
            result = rr.min();
        }
        MutablePropertyDataSet r = DataSetUtil.asDataSet(result);
        r = Ops.putProperty(r, "LABEL", (Object)axis.getString("label"));
        r = Ops.putProperty(r, "SCALE_TYPE", (Object)(log ? "log" : "linear"));
        return r;
    }

    private int transform1D(JSONObject axis, Datum datum, String smaller, String bigger) throws JSONException, ParseException {
        DatumRange range;
        boolean log = axis.get("type").equals("log");
        if ("UTC".equals(axis.getString("units"))) {
            range = DatumRangeUtil.parseISO8601Range(axis.getString("min") + "/" + axis.getString("max"));
        } else {
            String sunits = axis.getString("units");
            Units units = Units.lookupUnits(sunits);
            range = new DatumRange(units.parse(axis.getString("min")), units.parse(axis.getString("max")));
        }
        if (range.getUnits().isConvertibleTo(datum.getUnits()) && range.contains(datum)) {
            if (log) {
                double d = DatumRangeUtil.normalizeLog(range, datum);
                return (int)((double)axis.getInt(smaller) + d * (double)(axis.getInt(bigger) - axis.getInt(smaller)));
            }
            double d = DatumRangeUtil.normalize(range, datum);
            return (int)((double)axis.getInt(smaller) + d * (double)(axis.getInt(bigger) - axis.getInt(smaller)));
        }
        return Integer.MAX_VALUE;
    }

    protected void doLookupMetadata(int x, int y) throws IOException, ParseException {
        this.doLookupMetadata(x, y, false);
    }

    protected void doLookupMetadata(int x, int y, boolean release) throws IOException, ParseException {
        block15: {
            URI uri = this.view.seq.imageAt(this.view.seq.getIndex()).getUri();
            File file = DataSetURI.getFile(uri, (ProgressMonitor)new AlertNullProgressMonitor("get image file"));
            String json = ImageUtil.getJSONMetadata(file);
            HashMap<String, String> meta = new HashMap<String, String>();
            meta.put("image", this.view.seq.getSelectedName());
            if (json != null) {
                try {
                    JSONObject jo = new JSONObject(json);
                    JSONArray plots = jo.getJSONArray("plots");
                    JSONObject plot = this.getPlotContaining(plots, x, y);
                    if (plot == null) break block15;
                    JSONObject xaxis = plot.getJSONObject("xaxis");
                    QDataSet xx = this.invTransform(xaxis, x, "left", "right");
                    JSONObject yaxis = plot.getJSONObject("yaxis");
                    QDataSet yy = this.invTransform(yaxis, y, "bottom", "top");
                    if (this.viewer != null) {
                        this.view.seq.setStatus("Plot Coordinates: " + xx + ", " + yy);
                        if (!release && this.viewer.digitizer != null && this.viewer.digitizerRecording) {
                            try {
                                this.viewer.digitizer.addDataPoint(DataSetUtil.asDatum(xx), DataSetUtil.asDatum(yy), meta);
                            }
                            catch (RuntimeException ex) {
                                String msg = DataSourceUtil.getMessage(ex);
                                JOptionPane.showMessageDialog(this.viewer, msg);
                            }
                        }
                        QDataSet q = Ops.bundle(xx, yy);
                        if (release) {
                            this.viewer.firePropertyChange("mouseReleaseLocation", null, q);
                        } else {
                            this.viewer.firePropertyChange("mousePressLocation", null, q);
                        }
                        break block15;
                    }
                    this.view.seq.setStatus("Plot Coordinates: " + xx + ", " + yy + "  (Options->Start Digitizer to record)");
                }
                catch (JSONException ex) {
                    Logger.getLogger(SinglePngWalkView.class.getName()).log(Level.SEVERE, null, ex);
                    int h = this.view.seq.imageAt(this.view.seq.getIndex()).getImage().getHeight();
                    Datum xx = Units.dimensionless.createDatum(x);
                    Datum yy = Units.dimensionless.createDatum(h - y);
                    this.view.seq.setStatus("Pixel Coordinates: " + xx + ", " + yy + " (unable to use JSON) ");
                }
            } else {
                int h = this.view.seq.imageAt(this.view.seq.getIndex()).getImage().getHeight();
                Datum xx = Units.dimensionless.createDatum(x);
                Datum yy = Units.dimensionless.createDatum(h - y);
                if (this.viewer != null) {
                    this.view.seq.setStatus("Pixel Coordinates: " + xx + ", " + yy);
                    if (!release && this.viewer.digitizer != null) {
                        try {
                            this.viewer.digitizer.addDataPoint(xx, yy, meta);
                        }
                        catch (RuntimeException ex) {
                            JOptionPane.showMessageDialog(this.viewer, ex.getMessage());
                        }
                    }
                } else {
                    this.view.seq.setStatus("Pixel Coordinates: " + xx + ", " + yy + "  (Options->Start Digitizer to record)");
                }
            }
        }
    }

    private QDataSet doTransformPoint(String json, int x, int y) throws IOException, ParseException {
        if (json != null) {
            try {
                JSONObject jo = new JSONObject(json);
                JSONArray plots = jo.getJSONArray("plots");
                JSONObject plot = this.getPlotContaining(plots, x, y);
                if (plot != null) {
                    JSONObject xaxis = plot.getJSONObject("xaxis");
                    QDataSet xx = this.invTransform(xaxis, x, "left", "right");
                    JSONObject yaxis = plot.getJSONObject("yaxis");
                    QDataSet yy = this.invTransform(yaxis, y, "bottom", "top");
                    return Ops.bundle(xx, yy);
                }
                return null;
            }
            catch (JSONException ex) {
                Logger.getLogger(SinglePngWalkView.class.getName()).log(Level.SEVERE, null, ex);
                int h = this.view.seq.imageAt(this.view.seq.getIndex()).getImage().getHeight();
                Datum xx = Units.dimensionless.createDatum(x);
                Datum yy = Units.dimensionless.createDatum(h - y);
                return Ops.bundle(Ops.dataset(xx), Ops.dataset(yy));
            }
        }
        int h = this.view.seq.imageAt(this.view.seq.getIndex()).getImage().getHeight();
        Datum xx = Units.dimensionless.createDatum(x);
        Datum yy = Units.dimensionless.createDatum(h - y);
        return Ops.bundle(Ops.dataset(xx), Ops.dataset(yy));
    }

    protected QDataSet doTransform() throws IOException {
        QDataSet dep0;
        URI uri = this.view.seq.imageAt(this.view.seq.getIndex()).getUri();
        File file = DataSetURI.getFile(uri, (ProgressMonitor)new AlertNullProgressMonitor("get image file"));
        String json = ImageUtil.getJSONMetadata(file);
        QDataSet ds = this.viewer.digitizer.getDataSet();
        if (ds == null) {
            return null;
        }
        if (ds.length() == 0) {
            return null;
        }
        if (ds.rank() > 1) {
            EnumerationUnits eu;
            QDataSet images = Ops.slice1(ds, 1);
            QDataSet r = Ops.where(Ops.eq((Object)images, (eu = (EnumerationUnits)SemanticOps.getUnits(images)).createDatum(this.view.seq.getSelectedName())));
            if (r.length() == 0) {
                return null;
            }
            ds = DataSetOps.applyIndex(ds, 0, r, true);
            ds = Ops.slice1(ds, 0);
        }
        if ((dep0 = (QDataSet)ds.property("DEPEND_0")).rank() > 1) {
            dep0 = dep0.slice(0);
        }
        if (json == null) {
            BufferedImage im = this.view.seq.imageAt(this.view.seq.getIndex()).getImageIfLoaded();
            if (im == null) {
                return null;
            }
            return Ops.bundle(dep0, Ops.subtract(Ops.dataset(im.getHeight()), ds));
        }
        QDataSet result = null;
        for (int ii = 0; ii < ds.length(); ++ii) {
            Datum x = DataSetUtil.asDatum(dep0.slice(ii));
            Datum y = DataSetUtil.asDatum(ds.slice(ii));
            try {
                JSONObject jo = new JSONObject(json);
                JSONArray plots = jo.getJSONArray("plots");
                for (int i = 0; i < plots.length(); ++i) {
                    JSONObject plot = plots.getJSONObject(i);
                    JSONObject xaxis = plot.getJSONObject("xaxis");
                    JSONObject yaxis = plot.getJSONObject("yaxis");
                    int ix = this.transform1D(xaxis, x, "left", "right");
                    int iy = this.transform1D(yaxis, y, "bottom", "top");
                    if (ix == Integer.MAX_VALUE || iy == Integer.MAX_VALUE) continue;
                    result = Ops.join(result, Ops.join(DataSetUtil.asDataSet(ix), DataSetUtil.asDataSet(iy)));
                }
                continue;
            }
            catch (ParseException | JSONException ex) {
                logger.log(Level.SEVERE, "error parsing rich png JSON metadata", ex);
            }
        }
        return result;
    }

    protected int maybeSelect(Point p) throws IOException, ParseException {
        if (this.viewer == null || this.viewer.digitizer == null) {
            return -1;
        }
        URI uri = this.view.seq.imageAt(this.view.seq.getIndex()).getUri();
        File file = DataSetURI.getFile(uri, (ProgressMonitor)new AlertNullProgressMonitor("get image file"));
        String json = ImageUtil.getJSONMetadata(file);
        QDataSet ds1 = this.doTransformPoint(json, p.x - 2, p.y - 2);
        QDataSet ds2 = this.doTransformPoint(json, p.x + 2, p.y + 2);
        if (ds1 == null) {
            return -1;
        }
        DatumRange xrange = DatumRangeUtil.union(DataSetUtil.asDatum(ds1.slice(0)), DataSetUtil.asDatum(ds2.slice(0)));
        DatumRange yrange = DatumRangeUtil.union(DataSetUtil.asDatum(ds1.slice(1)), DataSetUtil.asDatum(ds2.slice(1)));
        if (!UnitsUtil.isTimeLocation(SemanticOps.getUnits(ds2))) {
            return -1;
        }
        if (this.viewer.digitizer != null) {
            int isel;
            switch (this.viewer.annoTypeChar) {
                case '.': {
                    isel = this.viewer.digitizer.select(xrange, yrange);
                    break;
                }
                case '+': {
                    isel = this.viewer.digitizer.select(xrange, yrange, true);
                    break;
                }
                case '|': {
                    isel = this.viewer.digitizer.select(xrange, null);
                    break;
                }
                default: {
                    throw new RuntimeException("can't find annoTypeChar");
                }
            }
            return isel;
        }
        return -1;
    }
}

