/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.pdsppi;

import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.autoplot.datasource.DataSourceUtil;
import org.das2.util.LoggerManager;
import org.das2.util.filesystem.FSTreeModel;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.filesystem.WebFileSystem;
import org.das2.util.monitor.ProgressMonitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PDSPPIFileSystem
extends WebFileSystem {
    private static final Logger logger = LoggerManager.getLogger("apdss.pdsppi");
    private String root = "http://pds-ppi.igpp.ucla.edu/ditdos/view?id=pds:/";

    public PDSPPIFileSystem(String s) throws URISyntaxException {
        super(new URI("http://pds-ppi.igpp.ucla.edu/" + s), new File(FileSystem.settings().getLocalCacheDir(), "/PDSPPI/tmp/"));
        this.root = !s.startsWith("/") ? this.root + "/" + s : this.root + s;
    }

    @Override
    protected void downloadFile(String filename, File f, File partfile, ProgressMonitor monitor) throws IOException {
        logger.log(Level.WARNING, "download file {0}", filename);
    }

    @Override
    public boolean isDirectory(String filename) throws IOException {
        return filename.endsWith("/");
    }

    @Override
    public String[] listDirectory(String directory) throws IOException {
        FileSystem.DirectoryEntry[] cached = this.listDirectoryFromMemory(directory);
        if (cached != null) {
            return FileSystem.getListing(cached);
        }
        boolean noTimes = true;
        String noTimeString = "";
        if (noTimes) {
            noTimeString = "&times=false";
        }
        URL url = !directory.startsWith("/") ? new URL(this.root + "/" + directory + noTimeString) : new URL(this.root + directory + noTimeString);
        try {
            Element node;
            int i;
            logger.log(Level.FINE, "listDirectory {0}", url);
            URLConnection connect = url.openConnection();
            connect.connect();
            InputStream fin = connect.getInputStream();
            PushbackInputStream pbin = new PushbackInputStream(fin);
            byte[] peek = new byte[1];
            for (int bytesRead = 0; bytesRead < 1; ++bytesRead) {
                int ch = pbin.read();
                if (ch < 0) continue;
                peek[bytesRead] = (byte)ch;
            }
            if (!new String(peek).equals("<")) {
                pbin.unread(peek);
                BufferedReader read = new BufferedReader(new InputStreamReader(pbin));
                String s = read.readLine();
                pbin.close();
                throw new IOException("\"" + s + "\" from " + url);
            }
            pbin.unread(peek);
            InputSource source = new InputSource(pbin);
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = builder.parse(source);
            XPathFactory xpf = DataSourceUtil.getXPathFactory();
            XPath xp = xpf.newXPath();
            ArrayList<String> result = new ArrayList<String>();
            NodeList nodes = (NodeList)xp.evaluate("/tree/node", document, XPathConstants.NODESET);
            if (nodes == null) {
                return new String[0];
            }
            for (i = 0; i < nodes.getLength(); ++i) {
                node = (Element)nodes.item(i);
                result.add(node.getAttribute("term") + "/");
            }
            nodes = (NodeList)xp.evaluate("/tree/leaf", document, XPathConstants.NODESET);
            if (nodes == null) {
                return new String[0];
            }
            for (i = 0; i < nodes.getLength(); ++i) {
                node = (Element)nodes.item(i);
                result.add(node.getAttribute("term"));
            }
            Object[] listing = result.toArray(new String[result.size()]);
            Arrays.sort(listing);
            FileSystem.DirectoryEntry[] des = new FileSystem.DirectoryEntry[listing.length];
            for (int i2 = 0; i2 < des.length; ++i2) {
                FileSystem.DirectoryEntry des1 = new FileSystem.DirectoryEntry();
                des1.name = listing[i2];
                des1.modified = 0L;
                des1.size = 0L;
                des1.type = (char)(((String)listing[i2]).endsWith("/") ? 100 : 102);
                des[i2] = des1;
            }
            this.cacheListing(directory, des);
            return listing;
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, ex.getMessage(), ex);
            throw new RuntimeException(ex);
        }
        catch (ParserConfigurationException ex) {
            logger.log(Level.WARNING, ex.getMessage(), ex);
            throw new RuntimeException(ex);
        }
        catch (SAXException ex) {
            logger.log(Level.WARNING, ex.getMessage(), ex);
            throw new RuntimeException(ex);
        }
        catch (XPathExpressionException ex) {
            logger.log(Level.WARNING, ex.getMessage(), ex);
            throw new RuntimeException(ex);
        }
    }

    public static void main(String[] args) throws Exception {
        String[] ff;
        PDSPPIFileSystem fs = new PDSPPIFileSystem("/PPI/CO-V_E_J_S_SS-RPWS-2-REFDR-ALL-V1.0/");
        for (String s : ff = fs.listDirectory("/")) {
            System.err.println(s);
        }
        JTree mytree = new JTree(new FSTreeModel(fs));
        mytree.setMinimumSize(new Dimension(400, 400));
        mytree.setPreferredSize(new Dimension(400, 400));
        JOptionPane.showMessageDialog(null, mytree, "Test FSTREE", 1);
    }
}

