/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.pdsppi;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.LayoutStyle;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.autoplot.datasource.DataSourceEditorPanel;
import org.autoplot.datasource.URISplit;
import org.autoplot.pdsppi.PDSPPIDB;
import org.autoplot.pdsppi.PDSPPIFileSystem;
import org.das2.util.LoggerManager;
import org.das2.util.filesystem.FSTreeModel;
import org.das2.util.filesystem.FileSystem;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;

public class PDSPPIDataSourceEditorPanel
extends JPanel
implements DataSourceEditorPanel {
    private static final Logger logger = LoggerManager.getLogger("apdss.pdsppi");
    private JComboBox datasetComboBox;
    private JComboBox inventoryScComboBox;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JScrollPane jScrollPane1;
    private JList paramList;
    private JButton pickProductButton;
    private JTextField productTextField;
    Map<String, String> params;
    private String sc;
    private String id;
    private String param;
    public static final String PARAM = "param";
    public static final String ID = "id";
    public static final String SC = "sc";

    public PDSPPIDataSourceEditorPanel() {
        this.initComponents();
        if (FileSystem.settings().isOffline()) {
            JOptionPane.showMessageDialog(this, "internet is not available");
            this.setEnabled(false);
            return;
        }
        this.updateSpacecraftSoon();
    }

    private void initComponents() {
        this.productTextField = new JTextField();
        this.jLabel1 = new JLabel();
        this.inventoryScComboBox = new JComboBox();
        this.datasetComboBox = new JComboBox();
        this.pickProductButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.paramList = new JList();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.productTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PDSPPIDataSourceEditorPanel.this.productTextFieldActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Spacecraft:");
        this.inventoryScComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"voyager", "galileo", "cassini"}));
        this.inventoryScComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                PDSPPIDataSourceEditorPanel.this.inventoryScComboBoxItemStateChanged(evt);
            }
        });
        this.datasetComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PDSPPIDataSourceEditorPanel.this.datasetComboBoxActionPerformed(evt);
            }
        });
        this.pickProductButton.setText("Pick...");
        this.pickProductButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PDSPPIDataSourceEditorPanel.this.pickProductButtonActionPerformed(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.paramList);
        this.jLabel2.setText("Dataset:");
        this.jLabel3.setText("Product:");
        this.jLabel4.setText("Parameters:");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.productTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pickProductButton)).addComponent(this.datasetComboBox, 0, -1, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addGap(18, 18, 18).addComponent(this.inventoryScComboBox, -2, 192, -2))).addGap(0, 197, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.inventoryScComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.datasetComboBox, -2, -1, -2).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.productTextField, -2, -1, -2).addComponent(this.pickProductButton).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 182, Short.MAX_VALUE).addContainerGap()));
    }

    private String removeExtraSlashes(String root) {
        int i = root.indexOf("/");
        return root.substring(0, ++i) + root.substring(i).replaceAll("/", "_");
    }

    private String getCurrentRoot() {
        return this.removeExtraSlashes(this.datasetComboBox.getSelectedItem().toString());
    }

    private void setSelectedProduct(JTree tree, TreeModel m, String s) {
        String[] ss = s.split("/", -2);
        Object parent = m.getRoot();
        TreePath p = new TreePath(parent);
        for (String s1 : ss) {
            s1 = s1 + "/";
            int idx = -1;
            for (int i = 0; i < m.getChildCount(parent); ++i) {
                String test = m.getChild(parent, i).toString();
                if (!test.equals(s1)) continue;
                idx = i;
                parent = m.getChild(parent, idx);
                break;
            }
            if (idx == -1) continue;
            parent = m.getChild(parent, idx);
            p = p.pathByAddingChild(parent);
        }
        tree.setSelectionPath(p);
    }

    private void pickProductButtonActionPerformed(ActionEvent evt) {
        try {
            TreePath p;
            String root = this.getCurrentRoot();
            PDSPPIFileSystem fs = new PDSPPIFileSystem(root);
            JTree tree = new JTree(new FSTreeModel(fs));
            ImageIcon icon = new ImageIcon(PDSPPIDataSourceEditorPanel.class.getResource("/resources/ppi_home_16_crop.gif"));
            if (0 == JOptionPane.showConfirmDialog(this.datasetComboBox, new JScrollPane(tree), "Pick Dataset ID", 2, 3, icon) && (p = tree.getSelectionPath()) != null) {
                Object[] o = p.getPath();
                StringBuilder dsb = new StringBuilder();
                for (int i = 1; i < o.length; ++i) {
                    dsb.append(o[i].toString());
                }
                String ds = dsb.toString();
                if (PDSPPIDB.isPlottable(ds)) {
                    int dotpos = ds.lastIndexOf(".");
                    ds = ds.substring(0, dotpos);
                }
                this.productTextField.setText(ds);
                String l_id = this.removeExtraSlashes(this.datasetComboBox.getModel().getSelectedItem().toString()) + "/" + this.productTextField.getText();
                this.updateParamsSoon(l_id);
            }
        }
        catch (URISyntaxException ex) {
            Logger.getLogger(PDSPPIDataSourceEditorPanel.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void updateParamComboBoxSoon(final Map<String, String> dss) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                String[] ss = new String[dss.size()];
                int i = 0;
                for (Map.Entry e : dss.entrySet()) {
                    ss[i] = (String)e.getKey() + ": " + (String)e.getValue();
                    ++i;
                }
                if (ss.length == 0) {
                    PDSPPIDataSourceEditorPanel.this.paramList.setModel(PDSPPIDataSourceEditorPanel.this.getMessageModel("(No plottable parameters)"));
                    return;
                }
                String lparam = PDSPPIDataSourceEditorPanel.this.param;
                if (lparam != null) {
                    lparam = lparam.replaceAll("\\+", " ");
                }
                String selectedParam = null;
                DefaultListModel<String> lm = new DefaultListModel<String>();
                for (String s : ss) {
                    lm.addElement(s);
                    int j = s.indexOf(":");
                    if (j == -1) {
                        j = s.length();
                    }
                    if (!s.substring(0, j).equals(lparam)) continue;
                    selectedParam = s;
                }
                PDSPPIDataSourceEditorPanel.this.paramList.setModel(lm);
                if (selectedParam == null && lparam != null && lparam.matches("col\\d+")) {
                    PDSPPIDataSourceEditorPanel.this.paramList.setSelectedIndex(Integer.parseInt(lparam.substring(3)) - 1);
                } else if (selectedParam != null) {
                    PDSPPIDataSourceEditorPanel.this.paramList.setSelectedValue(selectedParam, true);
                }
            }
        };
        SwingUtilities.invokeLater(run);
    }

    ListModel getMessageModel(final String message) {
        return new DefaultListModel(){

            @Override
            public Object getElementAt(int index) {
                return message;
            }

            @Override
            public int getSize() {
                return 1;
            }
        };
    }

    private void updateParamsSoon(final String id) {
        this.paramList.setModel(this.getMessageModel("(Please Wait...)"));
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    Map<String, String> dss = PDSPPIDB.getInstance().getParams(id, new NullProgressMonitor());
                    PDSPPIDataSourceEditorPanel.this.updateParamComboBoxSoon(dss);
                }
                catch (IllegalArgumentException ex) {
                    Runnable run = new Runnable(){

                        @Override
                        public void run() {
                            PDSPPIDataSourceEditorPanel.this.paramList.setModel(PDSPPIDataSourceEditorPanel.this.getMessageModel("(" + ex.getMessage() + ")"));
                        }
                    };
                    SwingUtilities.invokeLater(run);
                }
            }
        };
        new Thread(run).start();
    }

    private void productTextFieldActionPerformed(ActionEvent evt) {
        String lid = this.productTextField.getText();
        String root = this.getCurrentRoot();
        lid = root + "/" + lid;
        this.updateParamsSoon(lid);
    }

    private void datasetComboBoxActionPerformed(ActionEvent evt) {
        this.productTextField.setText("");
        this.paramList.setModel(this.getMessageModel(""));
    }

    private void inventoryScComboBoxItemStateChanged(ItemEvent evt) {
        this.sc = evt.getItem().toString().replaceAll("\\+", " ");
        this.updateInventorySoon();
    }

    private void updateSpacecraftSoon() {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                final String[] scs = PDSPPIDB.getInstance().getSpacecraft();
                logger.fine("updateFacetSoon");
                Runnable run = new Runnable(){

                    @Override
                    public void run() {
                        PDSPPIDataSourceEditorPanel.this.inventoryScComboBox.setModel(new DefaultComboBoxModel<String>(scs));
                        if (PDSPPIDataSourceEditorPanel.this.sc == null) {
                            logger.finer("picking arbitrary spacecraft for GUI");
                            PDSPPIDataSourceEditorPanel.this.sc = scs[0].replaceAll("\\+", " ");
                        }
                        PDSPPIDataSourceEditorPanel.this.inventoryScComboBox.setSelectedItem(PDSPPIDataSourceEditorPanel.this.sc);
                        PDSPPIDataSourceEditorPanel.this.updateInventorySoon();
                    }
                };
                SwingUtilities.invokeLater(run);
            }
        };
        new Thread(run).start();
    }

    private static boolean isSameId(String s, String t) {
        if (s.length() > t.length()) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == '/' || s.charAt(i) == t.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private void doCheckIdSelectedItem() {
        if (this.inventoryScComboBox.getSelectedItem().equals(this.sc) && this.id != null) {
            int i = this.id.indexOf("/", 0);
            i = this.id.indexOf("/", i + 1);
            for (int ii = 0; ii < this.datasetComboBox.getModel().getSize(); ++ii) {
                String s = this.datasetComboBox.getModel().getElementAt(ii).toString();
                if (!PDSPPIDataSourceEditorPanel.isSameId(s, this.id)) continue;
                this.datasetComboBox.setSelectedIndex(ii);
            }
            this.datasetComboBox.setSelectedItem(this.id.substring(0, i));
            this.productTextField.setText(this.id.substring(i + 1));
            if (this.id.length() > i + 1) {
                this.updateParamsSoon(this.id);
            }
        }
    }

    private void updateInventorySoon() {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                logger.fine("updateInventorySoon");
                try {
                    final String[] dss = PDSPPIDB.getInstance().getIds("sc=" + PDSPPIDataSourceEditorPanel.this.sc, "PPI/");
                    Runnable run = new Runnable(){

                        @Override
                        public void run() {
                            PDSPPIDataSourceEditorPanel.this.datasetComboBox.setModel(new DefaultComboBoxModel<String>(dss));
                            PDSPPIDataSourceEditorPanel.this.doCheckIdSelectedItem();
                        }
                    };
                    SwingUtilities.invokeLater(run);
                }
                catch (IOException ex) {
                    String msg = "<html><b>PDS/PPI Database is not available</b><br>" + ex.getMessage();
                    JOptionPane.showMessageDialog(PDSPPIDataSourceEditorPanel.this, msg);
                }
            }
        };
        new Thread(run).start();
    }

    @Override
    public boolean reject(String uri) throws Exception {
        return false;
    }

    @Override
    public boolean prepare(String uri, Window parent, ProgressMonitor mon) throws Exception {
        return true;
    }

    @Override
    public void setURI(String uri) {
        URISplit split = URISplit.parse(uri);
        LinkedHashMap<String, String> lparams = URISplit.parseParams(split.params);
        this.sc = (String)lparams.get(SC);
        if (this.sc != null) {
            this.sc = this.sc.replaceAll("\\+", " ");
            this.inventoryScComboBox.setSelectedItem(this.sc);
        }
        this.id = (String)lparams.get(ID);
        if (this.id != null && this.id.startsWith("/")) {
            logger.warning("id ought not start with slash, just PPI/CO-E...");
            this.id = this.id.substring(1);
        }
        if (this.id != null && this.id.startsWith("pds://")) {
            logger.warning("id ought not start with pds://, just PPI/CO-E...");
            this.id = this.id.substring(6);
        }
        this.param = (String)lparams.get(PARAM);
        this.updateSpacecraftSoon();
    }

    @Override
    public void markProblems(List<String> problems) {
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    @Override
    public String getURI() {
        String lid = this.getCurrentRoot() + "/" + this.productTextField.getText();
        lid = lid.replaceAll(" ", "+");
        String lparam = (String)this.paramList.getSelectedValue();
        if (lparam != null) {
            int i = lparam.indexOf(": ");
            if (i > -1) {
                lparam = lparam.substring(0, i);
            }
            lparam = lparam.replaceAll(" ", "+");
        }
        String lsc = this.inventoryScComboBox.getSelectedItem().toString().replaceAll(" ", "+");
        if (lparam == null || lparam.startsWith("(")) {
            return "vap+pdsppi:sc=" + lsc + "&" + ID + "=" + lid;
        }
        return "vap+pdsppi:sc=" + lsc + "&" + ID + "=" + lid + "&" + PARAM + "=" + lparam;
    }

    public static void main(String[] args) {
        LoggerManager.getLogger("apdss.pdsppi").setLevel(Level.ALL);
        ConsoleHandler h = new ConsoleHandler();
        h.setLevel(Level.ALL);
        Logger.getLogger("").addHandler(h);
        Logger.getLogger("apdss.pdsppi").fine("run from main");
        PDSPPIDataSourceEditorPanel test = new PDSPPIDataSourceEditorPanel();
        test.setURI("vap+pdsppi:id=PPI/VG1-J-CRS-5-SUMM-FLUX-V1.0/DATA/FPHA_RATE&param=PROTON_FLUX_1&sc=Voyager+1");
        JOptionPane.showMessageDialog(null, test);
        System.err.println(test.getURI());
    }
}

