/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.orbit;

import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.autoplot.datasource.AbstractDataSourceFactory;
import org.autoplot.datasource.CompletionContext;
import org.autoplot.datasource.DataSource;
import org.autoplot.datasource.DefaultTimeSeriesBrowse;
import org.autoplot.datasource.URISplit;
import org.autoplot.datasource.capability.TimeSeriesBrowse;
import org.autoplot.orbit.OrbitDataSource;
import org.das2.util.monitor.ProgressMonitor;

public class OrbitDataSourceFactory
extends AbstractDataSourceFactory {
    @Override
    public DataSource getDataSource(URI uri) throws Exception {
        return new OrbitDataSource(uri);
    }

    @Override
    public List<CompletionContext> getCompletions(CompletionContext cc, ProgressMonitor mon) throws Exception {
        if (cc.context == CompletionContext.CONTEXT_PARAMETER_NAME) {
            ArrayList<CompletionContext> ccresult = new ArrayList<CompletionContext>();
            LinkedHashMap<String, String> names = new LinkedHashMap<String, String>();
            names.put("rbspa-pp", "RBSP-A (Van Allen Probe A)");
            names.put("rbspb-pp", "RBSP-B (Van Allen Probe B)");
            names.put("crres", "CRRES");
            names.put("cassini", "Cassini Spacecraft");
            for (Map.Entry n : names.entrySet()) {
                CompletionContext cc1 = new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, (String)n.getKey(), this, "arg_0", (String)n.getValue(), null, true);
                ccresult.add(cc1);
            }
            CompletionContext cc1 = new CompletionContext(CompletionContext.CONTEXT_PARAMETER_NAME, "timerange=", "timerange to plot");
            ccresult.add(cc1);
            return ccresult;
        }
        return super.getCompletions(cc, mon);
    }

    @Override
    public <T> T getCapability(Class<T> clazz) {
        if (clazz == TimeSeriesBrowse.class) {
            return (T)new DefaultTimeSeriesBrowse();
        }
        return null;
    }

    @Override
    public boolean reject(String surl, List<String> problems, ProgressMonitor mon) {
        URISplit split = URISplit.parse(surl);
        LinkedHashMap<String, String> map = URISplit.parseParams(split.params);
        if (DefaultTimeSeriesBrowse.reject(map, problems)) {
            return true;
        }
        if (!map.containsKey("arg_0")) {
            problems.add("no spacecraft");
            return true;
        }
        return super.reject(surl, problems, mon);
    }
}

