/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.orbit;

import java.net.URI;
import java.text.ParseException;
import java.util.logging.Level;
import org.autoplot.datasource.AbstractDataSource;
import org.autoplot.datasource.DefaultTimeSeriesBrowse;
import org.autoplot.datasource.capability.TimeSeriesBrowse;
import org.das2.datum.DatumRange;
import org.das2.datum.Orbits;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.ops.Ops;
import org.das2.util.monitor.ProgressMonitor;

class OrbitDataSource
extends AbstractDataSource {
    String sc;
    TimeSeriesBrowse tsb = new DefaultTimeSeriesBrowse();

    public OrbitDataSource(URI uri) {
        super(uri);
        this.sc = (String)this.params.get("arg_0");
        String str = (String)this.params.get("timerange");
        if (str != null) {
            try {
                this.tsb.setURI(uri.toString());
            }
            catch (ParseException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
        this.addCapability(TimeSeriesBrowse.class, this.tsb);
    }

    @Override
    public QDataSet getDataSet(ProgressMonitor mon) throws Exception {
        DatumRange dr;
        Orbits o = Orbits.getOrbitsFor(this.sc);
        DatumRange tr = this.tsb.getTimeRange();
        String s = o.getOrbit(tr.min());
        QDataSet result = null;
        while (s != null && (dr = o.getDatumRange(s)).min().lt(tr.max())) {
            result = Ops.createEvent(result, dr.toString(), 0x808080, s);
            s = o.next(s);
        }
        if (result != null) {
            ((MutablePropertyDataSet)result).putProperty("RENDER_TYPE", "eventsBar>orbitMode=T");
        }
        return result;
    }
}

