/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.netCDF;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.autoplot.datasource.MetadataModel;
import org.autoplot.metatree.IstpMetadataModel;
import org.das2.datum.LoggerManager;
import org.das2.datum.TimeParser;
import org.das2.datum.Units;
import org.das2.datum.UnitsConverter;
import org.das2.qds.AbstractDataSet;
import org.das2.qds.DataSetUtil;
import org.das2.qds.QDataSet;
import org.das2.qds.ops.Ops;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;

public class NetCdfVarDataSet
extends AbstractDataSet {
    Variable v;
    double[] data;
    int[] shape;
    private static final Logger logger = LoggerManager.getLogger("apdss.netcdf");

    public static NetCdfVarDataSet create(Variable variable, String constraint, NetcdfDataset ncfile, ProgressMonitor mon) throws IOException {
        NetCdfVarDataSet result = new NetCdfVarDataSet();
        result.read(variable, ncfile, constraint, null, false, mon);
        return result;
    }

    private NetCdfVarDataSet() {
        this.putProperty("QUBE", Boolean.TRUE);
    }

    private static String sliceConstraints(String constraints, int i) {
        String[] cc;
        if (constraints == null) {
            return null;
        }
        if (constraints.startsWith("[") && constraints.endsWith("]")) {
            constraints = constraints.substring(1, constraints.length() - 1);
        }
        if (i >= (cc = constraints.split(",")).length) {
            return null;
        }
        if (cc[i].equals(":")) {
            return null;
        }
        return cc[i];
    }

    public static long[] parseConstraint(String constraint, long recCount) throws ParseException {
        long[] result = new long[]{0L, recCount, 1L};
        if (constraint == null) {
            return result;
        }
        if (constraint.startsWith("[") && constraint.endsWith("]")) {
            constraint = constraint.substring(1, constraint.length() - 1);
        }
        try {
            String[] ss = constraint.split(":", -2);
            if (ss.length > 0 && ss[0].length() > 0) {
                result[0] = Integer.parseInt(ss[0]);
                if (result[0] < 0L) {
                    result[0] = recCount + result[0];
                }
            }
            if (ss.length > 1 && ss[1].length() > 0) {
                result[1] = Integer.parseInt(ss[1]);
                if (result[1] < 0L) {
                    result[1] = recCount + result[1];
                }
            }
            if (ss.length > 2 && ss[2].length() > 0) {
                result[2] = Integer.parseInt(ss[2]);
            }
            if (ss.length == 1) {
                result[1] = -1L;
                result[2] = -1L;
            }
        }
        catch (NumberFormatException ex) {
            throw new ParseException("expected integer: " + ex.toString(), 0);
        }
        return result;
    }

    private int sliceCount(boolean[] slice, int idim) {
        int result = 0;
        for (int i = 0; i < idim; ++i) {
            if (!slice[i]) continue;
            ++result;
        }
        return result;
    }

    private double[] unsigned(double[] data, long limit) {
        for (int i = 0; i < data.length; ++i) {
            double b = data[i];
            if (!(b < 0.0)) continue;
            data[i] = b + (double)limit;
        }
        return data;
    }

    private TimeParser guessTimeParser(String s) {
        TimeParser tp = null;
        int digitCount = -1;
        for (int ich = 0; ich < s.length(); ++ich) {
            if (!Character.isDigit(s.charAt(ich))) {
                if (digitCount != -1) continue;
                digitCount = ich;
                continue;
            }
            if (digitCount <= -1) continue;
            return null;
        }
        switch (digitCount) {
            case 16: {
                tp = TimeParser.create("$Y$j$H$M$S$(subsec,places=3)");
                break;
            }
            case 17: {
                tp = TimeParser.create("$Y$m$d$H$M$S$(subsec,places=3)");
                break;
            }
        }
        return tp;
    }

    private void read(Variable variable, NetcdfDataset ncfile, String constraints, MetadataModel mm, boolean isDepend, ProgressMonitor mon) throws IOException {
        int i;
        String unitsString;
        Array a;
        this.v = variable;
        if (!mon.isStarted()) {
            mon.started();
        }
        mon.setProgressMessage("reading " + this.v.getNameAndDimensions());
        if (mm == null) {
            long t0 = System.currentTimeMillis();
            List vvs = ncfile.getVariables();
            for (Variable vv : vvs) {
                if (vv.findAttribute("DEPEND_0") == null) continue;
                mm = new IstpMetadataModel();
            }
            logger.log(Level.FINER, "look for DEPEND_0 (ms):{0}", System.currentTimeMillis() - t0);
        }
        logger.finer("v.getShape()");
        this.shape = this.v.getShape();
        boolean[] slice = new boolean[this.shape.length];
        if (constraints != null) {
            if (constraints.startsWith("[") && constraints.endsWith("]")) {
                constraints = constraints.substring(1, constraints.length() - 1);
            }
            try {
                String[] cc = constraints.split(",");
                ArrayList<Range> ranges = new ArrayList<Range>(this.v.getRanges());
                for (int i2 = 0; i2 < cc.length; ++i2) {
                    long[] ir = NetCdfVarDataSet.parseConstraint(cc[i2], ((Range)ranges.get(i2)).last() + 1);
                    if (ir[1] == -1L) {
                        ranges.set(i2, new Range((int)ir[0], (int)ir[0]));
                        this.shape[i2] = 1;
                        slice[i2] = true;
                        continue;
                    }
                    ranges.set(i2, new Range((int)ir[0], (int)ir[1] - 1, (int)ir[2]));
                    this.shape[i2] = (int)((ir[1] - ir[0]) / ir[2]);
                }
                logger.finer("v.read()");
                a = this.v.read(ranges);
            }
            catch (ParseException ex) {
                throw new RuntimeException(ex);
            }
            catch (InvalidRangeException ex) {
                throw new RuntimeException(ex);
            }
        } else {
            logger.finer("v.read()");
            a = this.v.read();
        }
        char[] cdata = null;
        try {
            if (a.getElementType() == Character.TYPE) {
                cdata = (char[])a.get1DJavaArray(Character.TYPE);
            } else if (a.isUnsigned() && (a.getElementType() == Byte.TYPE || a.getElementType() == Short.TYPE || a.getElementType() == Integer.TYPE)) {
                this.data = (double[])a.get1DJavaArray(Double.class);
                if (a.getElementType() == Byte.TYPE) {
                    this.data = this.unsigned(this.data, 256L);
                } else if (a.getElementType() == Short.TYPE) {
                    this.data = this.unsigned(this.data, 65536L);
                } else if (a.getElementType() == Integer.TYPE) {
                    this.data = this.unsigned(this.data, 0x100000000L);
                }
            } else {
                this.data = (double[])a.get1DJavaArray(Double.class);
            }
        }
        catch (ClassCastException ex) {
            throw new IllegalArgumentException("data cannot be converted to numbers", ex);
        }
        this.properties.put("NAME", Ops.safeName(variable.getName()));
        if (this.shape.length > 1) {
            this.properties.put("QUBE", Boolean.TRUE);
        }
        if (this.v.getParentStructure() != null) {
            this.shape = new int[]{this.data.length};
            slice = new boolean[this.shape.length];
        }
        boolean isCoordinateVariable = false;
        for (int ir = 0; ir < a.getRank(); ++ir) {
            NetCdfVarDataSet dependi;
            if (slice[ir]) continue;
            logger.log(Level.FINER, "v.getDimension({0})", ir);
            Dimension d = this.v.getDimension(ir);
            if (d == null) continue;
            logger.log(Level.FINER, "ncfile.findVariable({0})", d.getName());
            Variable cv = ncfile.findVariable(d.getName());
            if (cv == null || !cv.isCoordinateVariable()) continue;
            logger.log(Level.FINE, "dimension '{0}' is coordinate variable, adding DEPEND", cv.getName());
            Variable dv = cv;
            if (dv != variable && dv.getRank() == 1) {
                mon.setProgressMessage("reading " + dv.getNameAndDimensions());
                dependi = NetCdfVarDataSet.create(dv, NetCdfVarDataSet.sliceConstraints(constraints, ir), ncfile, new NullProgressMonitor());
                this.properties.put("DEPEND_" + (ir - this.sliceCount(slice, ir)), dependi);
                continue;
            }
            if (dv != variable && dv.getRank() == 2 && dv.getDataType() == DataType.CHAR) {
                mon.setProgressMessage("reading " + dv.getNameAndDimensions());
                dependi = NetCdfVarDataSet.create(dv, NetCdfVarDataSet.sliceConstraints(constraints, ir), ncfile, new NullProgressMonitor());
                this.properties.put("DEPEND_" + (ir - this.sliceCount(slice, ir)), dependi);
                continue;
            }
            isCoordinateVariable = true;
        }
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        mon.setProgressMessage("reading attributes");
        logger.finer("v.getAttributes()");
        List attrs = this.v.getAttributes();
        for (Attribute attr : attrs) {
            if (attr.isArray()) continue;
            if (attr.isString()) {
                attributes.put(attr.getName(), attr.getStringValue());
                continue;
            }
            attributes.put(attr.getName(), String.valueOf(attr.getNumericValue()));
        }
        if (attributes.containsKey("units") && (unitsString = (String)attributes.get("units")).contains(" since ")) {
            Units u;
            try {
                u = Units.lookupTimeUnits(unitsString);
            }
            catch (ParseException ex) {
                throw new RuntimeException(ex);
            }
            this.properties.put("UNITS", u);
            this.properties.put("MONOTONIC", Boolean.TRUE);
        }
        if (this.data == null) {
            if (cdata == null) {
                throw new RuntimeException("Either data or cdata should be defined at this point");
            }
            if (this.shape.length == 2 && this.shape[1] >= 14 && this.shape[1] <= 35) {
                logger.fine("parsing times formatted in char arrays");
                this.data = new double[this.shape[0]];
                String ss = new String(cdata);
                TimeParser tp = null;
                boolean tryGuessTimeParser = true;
                for (int i3 = 0; i3 < this.shape[0]; ++i3) {
                    int n = i3 * this.shape[1];
                    String s = ss.substring(n, n + this.shape[1]);
                    try {
                        if (tp != null) {
                            this.data[i3] = tp.parse(s).getTime(Units.us2000);
                            continue;
                        }
                        this.data[i3] = Units.us2000.parse(s).doubleValue(Units.us2000);
                        continue;
                    }
                    catch (ParseException ex) {
                        if (tryGuessTimeParser) {
                            tryGuessTimeParser = false;
                            tp = this.guessTimeParser(s);
                            if (tp == null) {
                                this.data[i3] = Units.us2000.getFillDouble();
                                continue;
                            }
                            try {
                                this.data[i3] = tp.parse(s).getTime(Units.us2000);
                            }
                            catch (ParseException ex2) {
                                this.data[i3] = Units.us2000.getFillDouble();
                            }
                            continue;
                        }
                        this.data[i3] = Units.us2000.getFillDouble();
                    }
                }
                this.properties.put("UNITS", Units.us2000);
                this.shape = new int[]{this.shape[0]};
            } else {
                this.data = (double[])a.get1DJavaArray(Double.class);
            }
        }
        if (attributes.containsKey("_FillValue")) {
            double fill = Double.parseDouble((String)attributes.get("_FillValue"));
            this.properties.put("FILL_VALUE", fill);
        }
        if (mm != null && mm instanceof IstpMetadataModel || attributes.containsKey("VAR_TYPE") || attributes.containsKey("DEPEND_0")) {
            String[] vvs;
            logger.log(Level.FINE, "variable '{0}' has VAR_TYPE or DEPEND_0 attribute, use ISTP metadata", this.v.getName());
            this.properties.put("METADATA_MODEL", "ISTP-CDF");
            mm = new IstpMetadataModel();
            Map<String, Object> istpProps = mm.properties(attributes);
            if (this.properties.get("UNITS") == Units.us2000) {
                UnitsConverter uc = UnitsConverter.getConverter(Units.cdfEpoch, Units.us2000);
                if (istpProps.containsKey("VALID_MIN")) {
                    istpProps.put("VALID_MIN", uc.convert((Number)istpProps.get("VALID_MIN")));
                }
                if (istpProps.containsKey("VALID_MAX")) {
                    istpProps.put("VALID_MAX", uc.convert((Number)istpProps.get("VALID_MAX")));
                }
                if (istpProps.containsKey("TYPICAL_MIN")) {
                    istpProps.put("TYPICAL_MIN", uc.convert((Number)istpProps.get("TYPICAL_MIN")));
                }
                if (istpProps.containsKey("TYPICAL_MAX")) {
                    istpProps.put("TYPICAL_MAX", uc.convert((Number)istpProps.get("TYPICAL_MAX")));
                }
                istpProps.put("UNITS", Units.us2000);
            }
            this.properties.putAll(istpProps);
            for (int ir = 0; ir < a.getRank(); ++ir) {
                String s = (String)attributes.get("DEPEND_" + ir);
                if (s == null) continue;
                logger.log(Level.FINER, "ncfile.findVariable({0})", s);
                Variable dv = ncfile.findVariable(s);
                if (dv == null || dv == variable) continue;
                NetCdfVarDataSet result1 = new NetCdfVarDataSet();
                result1.read(dv, ncfile, NetCdfVarDataSet.sliceConstraints(constraints, ir), mm, true, new NullProgressMonitor());
                NetCdfVarDataSet dependi = result1;
                this.properties.put("DEPEND_" + (ir - this.sliceCount(slice, ir)), dependi);
            }
            for (String vv : vvs = new String[]{"DELTA_PLUS_VAR", "DELTA_MINUS_VAR"}) {
                if (!attributes.containsKey(vv)) continue;
                String s = (String)attributes.get(vv);
                logger.log(Level.FINER, "{0} ({1})", new Object[]{vv, s});
                Variable dv = ncfile.findVariable(s);
                if (dv == null || dv == variable) continue;
                String[] ss = vv.split("_");
                NetCdfVarDataSet result1 = new NetCdfVarDataSet();
                result1.read(dv, ncfile, NetCdfVarDataSet.sliceConstraints(constraints, 0), mm, true, new NullProgressMonitor());
                NetCdfVarDataSet dependi = result1;
                String qdatasetPropName = isDepend ? "BIN_" + ss[1] : "DELTA_" + ss[1];
                this.properties.put(qdatasetPropName, dependi);
            }
        }
        ArrayList<Integer> newShape = new ArrayList<Integer>(this.shape.length);
        for (i = 0; i < this.shape.length; ++i) {
            if (slice[i]) continue;
            newShape.add(this.shape[i]);
        }
        this.shape = new int[newShape.size()];
        for (i = 0; i < newShape.size(); ++i) {
            this.shape[i] = (Integer)newShape.get(i);
        }
        if (this.properties.get("FILL_VALUE") == null && this.properties.get("VALID_MIN") == null) {
            this.properties.put("VALID_MIN", -1.0E90);
        }
        if (isCoordinateVariable) {
            this.properties.put("CADENCE", DataSetUtil.guessCadenceNew(this, null));
        }
        mon.finished();
    }

    @Override
    public int rank() {
        return this.shape.length;
    }

    @Override
    public double value(int i) {
        return this.data[i];
    }

    @Override
    public double value(int i, int j) {
        int index = j + this.shape[1] * i;
        if (index >= this.data.length) {
            throw new IllegalArgumentException("index out of bounds");
        }
        return this.data[index];
    }

    @Override
    public double value(int i, int j, int k) {
        int index = k + this.shape[2] * j + this.shape[2] * this.shape[1] * i;
        if (index >= this.data.length) {
            throw new IllegalArgumentException("index out of bounds");
        }
        return this.data[index];
    }

    @Override
    public double value(int i, int j, int k, int l) {
        int index = l + this.shape[3] * k + this.shape[3] * this.shape[2] * j + this.shape[3] * this.shape[2] * this.shape[1] * i;
        if (index >= this.data.length) {
            throw new IllegalArgumentException("index out of bounds");
        }
        return this.data[index];
    }

    @Override
    public int length() {
        return this.shape[0];
    }

    @Override
    public int length(int dim) {
        return this.shape[1];
    }

    @Override
    public int length(int dim0, int dim1) {
        return this.shape[2];
    }

    @Override
    public int length(int dim0, int dim1, int dim2) {
        return this.shape[3];
    }

    @Override
    public QDataSet trim(int start, int end) {
        return super.trim(start, end);
    }

    @Override
    public QDataSet slice(int i) {
        return super.slice(i);
    }
}

