/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.netCDF;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.text.ParseException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.autoplot.datasource.AbstractDataSource;
import org.autoplot.datasource.DataSetURI;
import org.autoplot.datasource.DataSourceFactory;
import org.autoplot.datasource.MetadataModel;
import org.autoplot.netCDF.NetCDFDataSourceFactory;
import org.autoplot.netCDF.NetCdfVarDataSet;
import org.das2.dataset.NoDataInIntervalException;
import org.das2.datum.LoggerManager;
import org.das2.datum.Units;
import org.das2.qds.DataSetOps;
import org.das2.qds.QDataSet;
import org.das2.qds.ops.Ops;
import org.das2.qds.util.TransposeRankNDataSet;
import org.das2.util.monitor.NullProgressMonitor;
import org.das2.util.monitor.ProgressMonitor;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ncml.NcMLReader;

public class NetCDFDataSource
extends AbstractDataSource {
    private static final Logger logger = LoggerManager.getLogger("apdss.netcdf");
    protected static final String PARAM_WHERE = "where";
    protected static final String PARAM_X = "x";
    protected static final String PARAM_Y = "y";
    private Variable variable;
    private Variable whereVariable;
    private Variable xVariable;
    private Variable yVariable;
    private String sMyUrl;
    private String svariable;
    private String swhereVariable;
    private String sxVariable;
    private String syVariable;
    private NetcdfDataset ncfile;
    private String constraint;

    public NetCDFDataSource(URI uri) throws IOException {
        super(uri);
        this.parseUrl();
    }

    private void parseUrl() {
        String surl = DataSetURI.fromUri(this.uri);
        int i = surl.lastIndexOf(63);
        this.sMyUrl = i > -1 ? surl.substring(0, i) : surl;
        if (i == -1) {
            this.svariable = null;
        } else {
            Map<String, String> p = this.getParams();
            this.svariable = p.containsKey("id") ? p.get("id") : p.get("arg_0");
            if (this.svariable != null) {
                this.svariable = this.svariable.replaceAll(" ", "+");
                int ic = this.svariable.indexOf("[");
                if (ic > -1) {
                    this.constraint = this.svariable.substring(ic);
                    this.svariable = this.svariable.substring(0, ic);
                } else {
                    this.constraint = null;
                }
            }
            this.swhereVariable = p.get(PARAM_WHERE);
            this.sxVariable = p.get(PARAM_X);
            this.syVariable = p.get(PARAM_Y);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QDataSet getDataSet(ProgressMonitor mon) throws IOException, NoDataInIntervalException, ParseException {
        logger.entering("org.autoplot.netCDF.NetCDFDataSource", "getDataSet");
        mon.started();
        mon.setTaskSize(20L);
        try {
            String sfillValue;
            String svalidMax;
            String svalidMin;
            String w;
            this.readData(mon.getSubtaskMonitor(0, 15, "read data"));
            QDataSet result = NetCdfVarDataSet.create(this.variable, this.constraint, this.ncfile, mon.getSubtaskMonitor(15, 20, "copy over "));
            if (this.sxVariable != null && this.sxVariable.length() > 0) {
                NetCdfVarDataSet xds = NetCdfVarDataSet.create(this.xVariable, this.constraint, this.ncfile, new NullProgressMonitor());
                result = Ops.link(xds, result);
            }
            if (this.syVariable != null && this.syVariable.length() > 0) {
                NetCdfVarDataSet yds = NetCdfVarDataSet.create(this.yVariable, this.constraint, this.ncfile, new NullProgressMonitor());
                result = Ops.link(result.property("DEPEND_0"), (Object)yds, (Object)result);
            }
            if ((w = this.getParam(PARAM_WHERE, "")) != null && w.length() > 0) {
                NetCdfVarDataSet whereParm = NetCdfVarDataSet.create(this.whereVariable, this.constraint, this.ncfile, new NullProgressMonitor());
                result = this.doWhereFilter(w, whereParm, DataSetOps.makePropertiesMutable(result));
            }
            result = this.checkLatLon(result);
            String unitsString = this.getParam("units", null);
            if (unitsString != null) {
                Units u = Units.lookupUnits(unitsString);
                result = Ops.putProperty(result, "UNITS", (Object)u);
            }
            if ((svalidMin = this.getParam("validMin", null)) != null) {
                Double validMin = Double.parseDouble(svalidMin);
                result = Ops.putProperty(result, "VALID_MIN", (Object)validMin);
            }
            if ((svalidMax = this.getParam("validMax", null)) != null) {
                Double validMax = Double.parseDouble(svalidMax);
                result = Ops.putProperty(result, "VALID_MAX", (Object)validMax);
            }
            if ((sfillValue = this.getParam("fillValue", null)) != null) {
                Double fillValue = Double.parseDouble(sfillValue);
                result = Ops.putProperty(result, "FILL_VALUE", (Object)fillValue);
            }
            logger.finer("ncfile.close()");
            this.ncfile.close();
            this.ncfile = null;
            QDataSet qDataSet = result;
            return qDataSet;
        }
        finally {
            mon.finished();
            logger.exiting("org.autoplot.netCDF.NetCDFDataSource", "getDataSet");
        }
    }

    private QDataSet checkLatLon(QDataSet v) {
        int lat = -1;
        int lon = -1;
        for (int i = 0; i < v.rank(); ++i) {
            QDataSet dep = (QDataSet)v.property("DEPEND_" + i);
            if (dep == null) continue;
            String name = (String)dep.property("NAME");
            if ("lon".equals(name)) {
                lon = i;
            }
            if (!"lat".equals(name)) continue;
            lat = i;
        }
        if (lat > -1 && lon > -1 && lat < lon) {
            int[] order = new int[v.rank()];
            for (int i = 0; i < v.rank(); ++i) {
                order[i] = i;
            }
            int t = order[lat];
            order[lat] = order[lon];
            order[lon] = t;
            TransposeRankNDataSet transpose = new TransposeRankNDataSet(v, order);
            return transpose;
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readData(ProgressMonitor mon) throws IOException {
        block27: {
            File file = this.getFile(mon.getSubtaskMonitor("getFile"));
            mon.started();
            try {
                NetcdfDataset dataset;
                if (this.sMyUrl.endsWith(".ncml")) {
                    dataset = NcMLReader.readNcML((String)file.toURI().toURL().toString(), null);
                } else {
                    String location = file.toString();
                    NetCDFDataSourceFactory.checkMatlab(location);
                    logger.log(Level.FINE, "NetcdfFile.open( {0} )", location);
                    NetcdfFile f = NetcdfFile.open((String)location);
                    dataset = new NetcdfDataset(f);
                }
                this.ncfile = dataset;
                logger.log(Level.FINER, "dataset.getVariables()");
                List variables = dataset.getVariables();
                if (this.svariable == null) {
                    for (Variable v : variables) {
                        if (v.getDimension(0).getName().equals(v.getName())) continue;
                        this.variable = v;
                        break;
                    }
                    if (this.variable == null) {
                        throw new IllegalArgumentException("Unable to identify dependent variable");
                    }
                } else {
                    for (Variable v : variables) {
                        if (v instanceof Structure) {
                            for (Variable v2 : ((Structure)v).getVariables()) {
                                if (!v2.getDataType().isNumeric() || !v2.getName().replaceAll(" ", "+").equals(this.svariable)) continue;
                                this.variable = v2;
                            }
                            continue;
                        }
                        if (!v.getName().replaceAll(" ", "+").equals(this.svariable)) continue;
                        this.variable = v;
                    }
                    if (this.variable == null) {
                        throw new IllegalArgumentException("No such variable: " + this.svariable);
                    }
                }
                if (this.swhereVariable != null) {
                    int i = this.swhereVariable.lastIndexOf("(");
                    i = this.swhereVariable.lastIndexOf(".", i);
                    String swv = this.swhereVariable.substring(0, i);
                    for (Variable v : variables) {
                        if (v instanceof Structure) {
                            for (Variable v2 : ((Structure)v).getVariables()) {
                                if (!v2.getDataType().isNumeric() || !v2.getName().replaceAll(" ", "+").equals(swv)) continue;
                                this.whereVariable = v2;
                            }
                            continue;
                        }
                        if (!v.getName().replaceAll(" ", "+").equals(swv)) continue;
                        this.whereVariable = v;
                    }
                    if (this.whereVariable == null) {
                        throw new IllegalArgumentException("where refers to unresolved variable: " + swv);
                    }
                }
                if (this.sxVariable != null) {
                    for (Variable v : variables) {
                        if (v instanceof Structure) {
                            for (Variable v2 : ((Structure)v).getVariables()) {
                                if (!v2.getDataType().isNumeric() || !v2.getName().replaceAll(" ", "+").equals(this.sxVariable)) continue;
                                this.xVariable = v2;
                            }
                            continue;
                        }
                        if (!v.getName().replaceAll(" ", "+").equals(this.sxVariable)) continue;
                        this.xVariable = v;
                    }
                    if (this.xVariable == null) {
                        throw new IllegalArgumentException("x refers to unresolved variable: " + this.sxVariable);
                    }
                }
                if (this.syVariable == null) break block27;
                for (Variable v : variables) {
                    if (v instanceof Structure) {
                        for (Variable v2 : ((Structure)v).getVariables()) {
                            if (!v2.getDataType().isNumeric() || !v2.getName().replaceAll(" ", "+").equals(this.syVariable)) continue;
                            this.yVariable = v2;
                        }
                        continue;
                    }
                    if (!v.getName().replaceAll(" ", "+").equals(this.syVariable)) continue;
                    this.yVariable = v;
                }
                if (this.yVariable == null) {
                    throw new IllegalArgumentException("y refers to unresolved variable: " + this.syVariable);
                }
            }
            finally {
                mon.finished();
            }
        }
    }

    public static DataSourceFactory getFactory() {
        return new NetCDFDataSourceFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> getMetadata(ProgressMonitor mon) throws Exception {
        logger.entering("org.autoplot.netCDF.NetCDFDataSource", "getMetadata");
        mon.started();
        try {
            mon.setProgressMessage("reading metadata");
            this.readData(mon.getSubtaskMonitor("readData"));
            logger.finer("variable.getAttributes()");
            List attr = this.variable.getAttributes();
            if (attr == null) {
                logger.finer("attr was null");
                Map<String, Object> map = null;
                return map;
            }
            LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
            for (Object attr1 : attr) {
                Attribute at = (Attribute)attr1;
                result.put(at.getName(), at.getStringValue());
            }
            try {
                if (this.ncfile != null) {
                    logger.finer("ncfile.close()");
                    this.ncfile.close();
                    this.ncfile = null;
                }
            }
            catch (IOException ex) {
                logger.log(Level.WARNING, null, ex);
            }
            LinkedHashMap<String, String> linkedHashMap = result;
            return linkedHashMap;
        }
        finally {
            mon.finished();
            logger.exiting("org.autoplot.netCDF.NetCDFDataSource", "getMetadata");
        }
    }

    @Override
    public MetadataModel getMetadataModel() {
        return MetadataModel.createNullModel();
    }
}

