/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.netCDF;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.autoplot.datasource.AbstractDataSourceFormatEditorPanel;
import org.autoplot.datasource.URISplit;
import org.jdesktop.layout.GroupLayout;

public class HDF5DataSourceFormatEditorPanel
extends AbstractDataSourceFormatEditorPanel {
    String file;
    private JCheckBox istpMetadata;
    private JLabel jLabel1;
    private JCheckBox justDataCB;
    private JComboBox typeComboBox;

    public HDF5DataSourceFormatEditorPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.typeComboBox = new JComboBox();
        this.istpMetadata = new JCheckBox();
        this.justDataCB = new JCheckBox();
        this.jLabel1.setText("Type:");
        this.typeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"double", "float", "byte"}));
        this.istpMetadata.setText("Use ISTP Metadata Conventions");
        this.istpMetadata.setToolTipText("Use ISTP metadata conventions for the data, like LABLAXIS, UNITS and VALIDMIN");
        this.justDataCB.setText("Just Data, don't format timetags and other dependencies");
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.typeComboBox, -2, 123, -2).addContainerGap()).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.istpMetadata, -1, -1, Short.MAX_VALUE).add(24, 24, 24)))).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.justDataCB).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.typeComboBox, -2, -1, -2)).addPreferredGap(0).add((Component)this.istpMetadata).addPreferredGap(0).add((Component)this.justDataCB).addContainerGap(203, Short.MAX_VALUE)));
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    private String getParam(Map<String, String> args, String name, String defl) {
        String s = args.get(name);
        if (s == null) {
            return defl;
        }
        return s;
    }

    @Override
    public void setURI(String uri) {
        super.setURI(uri);
        URISplit split = URISplit.parse(uri);
        LinkedHashMap<String, String> args = URISplit.parseParams(split.params);
        String s = this.getParam(args, "type", "double");
        this.typeComboBox.setSelectedItem(s);
        s = this.getParam(args, "metadata", "");
        this.istpMetadata.setSelected(s.equals("istp"));
        this.justDataCB.setSelected(!this.getBooleanParam("doDep", false));
        this.file = split.file;
    }

    @Override
    public String getURI() {
        String result = this.file;
        HashMap<String, String> args = new HashMap<String, String>();
        String s = (String)this.typeComboBox.getSelectedItem();
        if (!s.equals("double")) {
            args.put("type", s);
        }
        if (this.istpMetadata.isSelected()) {
            args.put("metadata", "istp");
        }
        if (this.justDataCB.isSelected()) {
            args.put("doDep", "F");
        }
        String params = URISplit.formatParams(args);
        if (result == null) {
            result = "file:///";
        }
        URISplit ss = URISplit.parse(result);
        if (params.length() > 0) {
            ss.params = params;
        }
        return URISplit.format(ss);
    }
}

