/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.netCDF;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.autoplot.datasource.AbstractDataSourceFormat;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.qds.ArrayDataSet;
import org.das2.qds.DDataSet;
import org.das2.qds.DataSetOps;
import org.das2.qds.DataSetUtil;
import org.das2.qds.MutablePropertyDataSet;
import org.das2.qds.QDataSet;
import org.das2.qds.QubeDataSetIterator;
import org.das2.qds.SemanticOps;
import org.das2.util.LoggerManager;
import org.das2.util.monitor.ProgressMonitor;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileWriteable;
import ucar.nc2.Variable;

public class HDF5DataSourceFormat
extends AbstractDataSourceFormat {
    Map<QDataSet, String> names = new HashMap<QDataSet, String>();
    private static final Logger logger = LoggerManager.getLogger("apdss.netcdf");

    private synchronized String nameFor(QDataSet dep0) {
        String name = this.names.get(dep0);
        if (name != null) {
            return name;
        }
        name = (String)dep0.property("NAME");
        Units units = (Units)dep0.property("UNITS");
        if (name == null) {
            name = units != null && UnitsUtil.isTimeLocation(units) ? "Epoch" : "Variable_" + this.names.size();
        }
        if (this.names.containsValue(name)) {
            name = name + "_" + this.names.size();
        }
        this.names.put(dep0, name);
        return name;
    }

    private synchronized DataType typeFor(QDataSet dep0, String suggest) {
        Units units = (Units)dep0.property("UNITS");
        if (units != null && UnitsUtil.isTimeLocation(units)) {
            return DataType.DOUBLE;
        }
        if (suggest.equals("double")) {
            return DataType.DOUBLE;
        }
        if (suggest.equals("float")) {
            return DataType.FLOAT;
        }
        if (suggest.equals("long")) {
            return DataType.LONG;
        }
        if (suggest.equals("int")) {
            return DataType.INT;
        }
        if (suggest.equals("short")) {
            return DataType.SHORT;
        }
        return DataType.DOUBLE;
    }

    private static Object getProperty(QDataSet src, String name, Object deft) {
        Object o = src.property(name);
        if (o == null) {
            return deft;
        }
        return o;
    }

    private void copy(NetcdfFile in, NetcdfFileWriteable out) {
        for (Dimension d : in.getDimensions()) {
            logger.log(Level.FINER, "out.addDimension({0})", d.getName());
            out.addDimension(out.getRootGroup(), d);
        }
        for (Variable v : in.getVariables()) {
            logger.log(Level.FINER, "out.addVariable({0})", v.getShortName());
            out.addVariable(out.getRootGroup(), v);
            this.names.put(DDataSet.create(new int[0]), v.getShortName());
        }
    }

    private Dimension getDimension(NetcdfFile ncfile, String name) {
        try {
            logger.log(Level.FINER, "ncfile.getDimensions() (looking for {0})", name);
            for (Dimension d : ncfile.getDimensions()) {
                if (!d.getName().equals(name)) continue;
                return d;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void formatData(String uri, QDataSet data, ProgressMonitor mon) throws Exception {
        String typeSuggest1;
        Units u;
        QDataSet depi;
        Iterator namei;
        int i;
        NetcdfFile oldfile;
        NetcdfFileWriteable ncfile;
        String doDep;
        this.setUri(uri);
        String typeSuggest = this.getParam("type", "double");
        File file = new File(this.getResourceURI().toURL().getFile());
        ArrayList<Dimension> dims = new ArrayList<Dimension>();
        HashMap<String, Dimension> dim = new HashMap<String, Dimension>();
        HashMap dimss = new HashMap();
        String name1 = this.getParam("arg_0", null);
        if (name1 != null) {
            this.names.put(data, name1);
        }
        if ((doDep = this.getParam("doDep", "")).length() > 0 && doDep.toUpperCase().charAt(0) == 'F') {
            MutablePropertyDataSet mpds = DataSetOps.makePropertiesMutable(data);
            mpds.putProperty("DEPEND_0", null);
            mpds.putProperty("DEPEND_1", null);
            mpds.putProperty("DEPEND_2", null);
            mpds.putProperty("DEPEND_3", null);
            mpds.putProperty("BUNDLE_1", null);
            data = mpds;
        }
        boolean append = "T".equals(this.getParam("append", "F"));
        String tempFileName = file.toString() + ".temp";
        if (!append) {
            if (file.exists() && !file.delete()) {
                throw new IllegalArgumentException("Unable to delete file" + file);
            }
            logger.log(Level.FINE, "create HDF5 file {0}", file);
            logger.log(Level.FINER, "NetcdfFileWriteable.createNew( {0}, true )", tempFileName);
            ncfile = NetcdfFileWriteable.createNew((String)tempFileName, (boolean)true);
            oldfile = null;
        } else {
            logger.log(Level.FINER, "oldfile= NetcdfFile.open( {0} );", file.toString());
            oldfile = NetcdfFile.open((String)file.toString());
            logger.log(Level.FINER, "ncfile=NetcdfFileWriteable.createNew( {0}, true )", tempFileName);
            ncfile = NetcdfFileWriteable.createNew((String)tempFileName, (boolean)true);
            this.copy(oldfile, ncfile);
            for (Dimension d : oldfile.getDimensions()) {
                dim.put(d.getName(), d);
            }
            dims.addAll(oldfile.getDimensions());
        }
        int[] qube = DataSetUtil.qubeDims(data);
        if (qube == null) {
            throw new IllegalArgumentException("data is not a qube");
        }
        for (i = 0; i < data.rank(); ++i) {
            namei = "dim" + i;
            depi = (QDataSet)data.property("DEPEND_" + i);
            if (depi != null) {
                namei = this.nameFor(depi);
            }
            if (append) continue;
            Dimension d = (Dimension)dim.get(namei);
            if (d == null) {
                logger.log(Level.FINER, "ncfile.addDimension({0},{1})", new Object[]{namei, DataSetUtil.toString(qube)});
                d = ncfile.addDimension(namei, qube[i]);
            }
            dim.put(d.getName(), d);
            dims.add(d);
            if (depi == null) continue;
            if (depi.rank() == 2) {
                dimss.put(namei, new Dimension[]{(Dimension)dims.get(0), d});
                continue;
            }
            dimss.put(namei, new Dimension[]{d});
        }
        for (i = 0; i < data.rank(); ++i) {
            depi = (QDataSet)data.property("DEPEND_" + i);
            if (depi == null || depi == data) continue;
            namei = this.nameFor(depi);
            u = SemanticOps.getUnits(depi);
            typeSuggest1 = UnitsUtil.isTimeLocation(u) ? "double" : typeSuggest;
            this.defineVariableOne(ncfile, depi, typeSuggest1, (Dimension[])dimss.get(namei));
        }
        this.defineVariableOne(ncfile, data, typeSuggest, dims.toArray(new Dimension[dims.size()]));
        LinkedHashMap<String, Array> dataStore = new LinkedHashMap<String, Array>();
        if (append) {
            assert (oldfile != null);
            logger.log(Level.FINER, "oldFile.getVariables()");
            for (Variable v : oldfile.getVariables()) {
                logger.log(Level.FINER, "v.getShape()");
                v.getShape();
                logger.log(Level.FINER, "v.read()");
                Array a = v.read();
                logger.log(Level.FINE, "a={0}", a);
                dataStore.put(v.getName(), a);
            }
            oldfile.close();
            ncfile.create();
            for (Map.Entry var : dataStore.entrySet()) {
                ncfile.write((String)var.getKey(), (Array)var.getValue());
            }
        } else {
            ncfile.create();
        }
        for (int i2 = 0; i2 < data.rank(); ++i2) {
            depi = (QDataSet)data.property("DEPEND_" + i2);
            if (depi == null) continue;
            this.nameFor(depi);
            u = SemanticOps.getUnits(depi);
            typeSuggest1 = UnitsUtil.isTimeLocation(u) ? "double" : typeSuggest;
            this.formatDataOne(ncfile, depi, typeSuggest1);
        }
        this.formatDataOne(ncfile, data, typeSuggest);
        logger.log(Level.FINER, "ncfile.finish()");
        ncfile.finish();
        logger.log(Level.FINER, "ncfile.close()");
        ncfile.close();
        if (!new File(tempFileName).renameTo(file)) {
            throw new IOException("unable to rename file " + tempFileName);
        }
    }

    private void defineVariableOne(NetcdfFileWriteable ncfile, QDataSet data, String typeSuggest, Dimension[] dims) {
        String varName = this.nameFor(data);
        DataType t = this.typeFor(data, typeSuggest);
        logger.log(Level.FINER, "ncfile.addVariable({0},{1},<dims>)", new Object[]{varName, t});
        Variable var = ncfile.addVariable(varName, t, dims);
        Number nfill = (Number)data.property("FILL_VALUE");
        double fill = nfill == null ? -1.0E38 : nfill.doubleValue();
        String meta = this.getParam("metadata", "");
        if (meta.equals("istp")) {
            logger.finer("adding ISTP metadata");
            var.addAttribute(new Attribute("FIELDNAM", varName));
            var.addAttribute(new Attribute("UNITS", SemanticOps.getUnits(data).toString()));
            var.addAttribute(new Attribute("VAR_TYPE", "data"));
            var.addAttribute(new Attribute("FILLVAL", (Number)fill));
            var.addAttribute(new Attribute("VALIDMIN", (Number)((Double)HDF5DataSourceFormat.getProperty(data, "VALID_MIN", -1.0E38))));
            var.addAttribute(new Attribute("VALIDMAX", (Number)((Double)HDF5DataSourceFormat.getProperty(data, "VALID_MAX", 1.0E38))));
            if (data.property("TYPICAL_MIN") != null) {
                var.addAttribute(new Attribute("SCALEMIN", (Number)((Double)HDF5DataSourceFormat.getProperty(data, "TYPICAL_MIN", -1.0E38))));
            }
            if (data.property("TYPICAL_MAX") != null) {
                var.addAttribute(new Attribute("SCALEMAX", (Number)((Double)HDF5DataSourceFormat.getProperty(data, "TYPICAL_MAX", 1.0E38))));
            }
            if (data.property("SCALE_TYPE") != null) {
                var.addAttribute(new Attribute("SCALETYP", (String)HDF5DataSourceFormat.getProperty(data, "SCALE_TYPE", "linear")));
            }
            if (data.property("TITLE") != null) {
                var.addAttribute(new Attribute("CATDESC", (String)HDF5DataSourceFormat.getProperty(data, "TITLE", "")));
            }
            if (data.property("LABEL") != null) {
                var.addAttribute(new Attribute("LABLAXIS", (String)HDF5DataSourceFormat.getProperty(data, "LABEL", "")));
            }
        } else {
            var.addAttribute(new Attribute("_FillValue", (Number)fill));
            if (UnitsUtil.isTimeLocation(SemanticOps.getUnits(data))) {
                Units u = SemanticOps.getUnits(data);
                String unitsStr = u.getOffsetUnits().toString() + " " + u.getBasis().getDescription();
                var.addAttribute(new Attribute("units", unitsStr));
            }
        }
    }

    private void formatDataOne(NetcdfFileWriteable ncfile, QDataSet data, String typeSuggest) throws IllegalArgumentException, InvalidRangeException, IOException {
        String varName = this.nameFor(data);
        int[] qube = DataSetUtil.qubeDims(data);
        if (qube == null) {
            throw new IllegalArgumentException("data is not a qube");
        }
        ArrayDataSet ads = ArrayDataSet.copy(data);
        DataType dataType = this.typeFor(data, typeSuggest);
        logger.log(Level.FINER, "ddata= Array.factory( {0}, qube );", dataType);
        Array ddata = Array.factory((DataType)dataType, (int[])qube);
        QubeDataSetIterator it = new QubeDataSetIterator(ads);
        int i = 0;
        while (it.hasNext()) {
            it.next();
            ddata.setDouble(i, it.getValue(ads));
            ++i;
        }
        logger.log(Level.FINER, "ncfile.write({0},ddata)", varName);
        ncfile.write(varName, ddata);
    }

    @Override
    public boolean canFormat(QDataSet ds) {
        int[] qube = DataSetUtil.qubeDims(ds);
        return qube != null;
    }

    @Override
    public String getDescription() {
        return "HDF5";
    }
}

