/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.netCDF;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;
import org.jdom.input.SAXBuilder;
import ucar.ma2.DataType;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.unidata.io.RandomAccessFile;

public abstract class AbstractIOSP {
    private Properties _properties;
    private String _iospParam;
    private Element _ncElement;
    private int _ntim;

    public boolean isValidFile(RandomAccessFile raf) throws IOException {
        return false;
    }

    public Object sendIospMessage(Object message) {
        String[] props;
        this._iospParam = (String)message;
        if (message == null) {
            return null;
        }
        this._properties = new Properties();
        for (String string : props = ((String)message).split("\\s")) {
            if (!string.contains("=")) continue;
            int i = string.indexOf("=");
            this._properties.put(string.substring(0, i), string.substring(i + 1));
        }
        return null;
    }

    protected String getIospParam() {
        return this._iospParam;
    }

    protected String getProperty(String name) {
        if (this._properties == null) {
            return null;
        }
        return this._properties.getProperty(name);
    }

    protected Element readNcmlElement(String ncmlLocation) throws IOException {
        Element ncElement;
        block3: {
            String ncml_file = ncmlLocation;
            String link = this.getIospParam();
            ncElement = null;
            try {
                SAXBuilder builder = new SAXBuilder();
                Document doc = builder.build(ncml_file);
                ncElement = doc.getRootElement();
                if (link == null) break block3;
                ElementFilter filter = new ElementFilter("netcdf");
                Iterator it = ncElement.getDescendants((Filter)filter);
                while (it.hasNext()) {
                    Element e = (Element)it.next();
                    String id = e.getAttributeValue("iospParam");
                    if (!link.equals(id)) continue;
                    ncElement = e;
                    break;
                }
            }
            catch (JDOMException e) {
                throw new IOException(e.getMessage());
            }
        }
        this._ncElement = ncElement;
        return ncElement;
    }

    protected Element getNetcdfElement() {
        return this._ncElement;
    }

    protected Dimension makeDimension(Element element) {
        Dimension dim = null;
        String name = element.getAttributeValue("name");
        String length = element.getAttributeValue("length");
        int n = 0;
        if (length != null) {
            n = Integer.parseInt(length);
        }
        if (name.equals("time")) {
            this._ntim = n;
        }
        dim = new Dimension(name, n, true, true, false);
        return dim;
    }

    protected int getLength() {
        return this._ntim;
    }

    protected Variable makeVariable(NetcdfFile ncfile, Element element) throws IOException {
        Variable var = null;
        String name = this.getVariableName(element);
        String shape = element.getAttributeValue("shape");
        String type = element.getAttributeValue("type");
        if ("Structure".equals(type)) {
            Structure struct = new Structure(ncfile, null, null, name);
            struct.setDimensions(shape);
            List vars = element.getChildren("variable", element.getNamespace());
            for (Element e : vars) {
                Variable v = this.makeVariable(ncfile, e);
                v.setParentStructure(struct);
                struct.addMemberVariable(v);
            }
            var = struct;
        } else {
            var = new Variable(ncfile, null, null, name);
            var.setDataType(DataType.getType((String)type));
            var.setDimensions(shape);
        }
        return var;
    }

    protected String getTimeVarName() {
        String vname = "time";
        Element ncElement = this.getNetcdfElement();
        List vars = ncElement.getChildren("variable", ncElement.getNamespace());
        for (Element element : vars) {
            if (!vname.equals(element.getAttributeValue("name"))) continue;
            vname = this.getVariableName(element);
            break;
        }
        return vname;
    }

    protected String getVariableName(Element varElement) {
        String name = varElement.getAttributeValue("orgName");
        if (name == null) {
            name = varElement.getAttributeValue("name");
        }
        return name;
    }
}

